/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler;

import com.fluxtion.compiler.RootNodeConfig;
import com.fluxtion.compiler.builder.callback.CallBackDispatcherFactory;
import com.fluxtion.compiler.builder.callback.CallbackNodeFactory;
import com.fluxtion.compiler.builder.callback.DirtyStateMonitorFactory;
import com.fluxtion.compiler.builder.callback.EventDispatcherFactory;
import com.fluxtion.compiler.builder.callback.EventProcessorCallbackInternalFactory;
import com.fluxtion.compiler.builder.context.EventProcessorContextFactory;
import com.fluxtion.compiler.builder.context.InstanceSupplierFactory;
import com.fluxtion.compiler.builder.factory.NodeFactory;
import com.fluxtion.compiler.builder.factory.NodeFactoryRegistration;
import com.fluxtion.compiler.builder.factory.NodeNameLookupFactory;
import com.fluxtion.compiler.builder.factory.SingletonNodeFactory;
import com.fluxtion.compiler.builder.filter.EventHandlerFilterOverride;
import com.fluxtion.compiler.builder.input.SubscriptionManagerFactory;
import com.fluxtion.compiler.builder.output.SinkPublisherFactory;
import com.fluxtion.compiler.builder.time.ClockFactory;
import com.fluxtion.compiler.generation.serialiser.BasicTypeSerializer;
import com.fluxtion.compiler.generation.serialiser.CollectionSerializer;
import com.fluxtion.compiler.generation.serialiser.FieldContext;
import com.fluxtion.compiler.generation.serialiser.FormatSerializer;
import com.fluxtion.compiler.generation.serialiser.IoSerializer;
import com.fluxtion.compiler.generation.serialiser.MetaSerializer;
import com.fluxtion.compiler.generation.serialiser.TimeSerializer;
import com.fluxtion.runtime.audit.Auditor;
import com.fluxtion.runtime.audit.EventLogControlEvent;
import com.fluxtion.runtime.audit.EventLogManager;
import com.fluxtion.runtime.dataflow.function.MergeProperty;
import com.fluxtion.runtime.partition.LambdaReflection;
import com.fluxtion.runtime.time.Clock;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class EventProcessorConfig {
    private final Set<Class<?>> interfaces = new HashSet();
    private final Clock clock = Clock.DEFAULT_CLOCK;
    private final Map<String, String> class2replace = new HashMap<String, String>();
    private final Map<Object, Integer> filterMap = new HashMap<Object, Integer>();
    private final Map<Class<?>, Function<FieldContext, String>> classSerializerMap = new HashMap();
    private String templateFile;
    private List<Object> nodeList;
    private HashMap<Object, String> publicNodes;
    private HashMap<String, Auditor> auditorMap;
    private NodeFactoryRegistration nodeFactoryRegistration;
    private RootNodeConfig rootNodeConfig;
    private boolean inlineEventHandling = false;
    private boolean supportDirtyFiltering = true;
    private boolean assignPrivateMembers = false;
    private boolean instanceOfDispatch = true;
    private DISPATCH_STRATEGY dispatchStrategy = DISPATCH_STRATEGY.INSTANCE_OF;
    private List<String> compilerOptions = new ArrayList<String>();

    public EventProcessorConfig() {
        this.clock();
        this.nodeFactoryRegistration = new NodeFactoryRegistration(NodeFactoryConfig.required.getFactoryClasses());
        this.classSerializerMap.put(String.class, BasicTypeSerializer::stringToSource);
        this.classSerializerMap.put(Character.class, BasicTypeSerializer::charToSource);
        this.classSerializerMap.put(Character.TYPE, BasicTypeSerializer::charToSource);
        this.classSerializerMap.put(Long.class, BasicTypeSerializer::longToSource);
        this.classSerializerMap.put(Long.TYPE, BasicTypeSerializer::longToSource);
        this.classSerializerMap.put(Integer.TYPE, BasicTypeSerializer::intToSource);
        this.classSerializerMap.put(Integer.class, BasicTypeSerializer::intToSource);
        this.classSerializerMap.put(Short.class, BasicTypeSerializer::shortToSource);
        this.classSerializerMap.put(Short.TYPE, BasicTypeSerializer::shortToSource);
        this.classSerializerMap.put(Byte.class, BasicTypeSerializer::byteToSource);
        this.classSerializerMap.put(Byte.TYPE, BasicTypeSerializer::byteToSource);
        this.classSerializerMap.put(Double.class, BasicTypeSerializer::doubleToSource);
        this.classSerializerMap.put(Double.TYPE, BasicTypeSerializer::doubleToSource);
        this.classSerializerMap.put(Float.class, BasicTypeSerializer::floatToSource);
        this.classSerializerMap.put(Float.TYPE, BasicTypeSerializer::floatToSource);
        this.classSerializerMap.put(Boolean.class, BasicTypeSerializer::booleanToSource);
        this.classSerializerMap.put(Boolean.TYPE, BasicTypeSerializer::booleanToSource);
        this.classSerializerMap.put(Map.class, CollectionSerializer::mapToSource);
        this.classSerializerMap.put(List.class, CollectionSerializer::listToSource);
        this.classSerializerMap.put(Set.class, CollectionSerializer::setToSource);
        this.classSerializerMap.put(Duration.class, TimeSerializer::durationToSource);
        this.classSerializerMap.put(Instant.class, TimeSerializer::instantToSource);
        this.classSerializerMap.put(LocalDate.class, TimeSerializer::localDateToSource);
        this.classSerializerMap.put(LocalTime.class, TimeSerializer::localTimeToSource);
        this.classSerializerMap.put(LocalDateTime.class, TimeSerializer::localDateTimeToSource);
        this.classSerializerMap.put(Period.class, TimeSerializer::periodToSource);
        this.classSerializerMap.put(ZoneId.class, TimeSerializer::zoneIdToSource);
        this.classSerializerMap.put(ZonedDateTime.class, TimeSerializer::zoneDateTimeToSource);
        this.classSerializerMap.put(Date.class, TimeSerializer::dateToSource);
        this.classSerializerMap.put(File.class, IoSerializer::fileToSource);
        this.classSerializerMap.put(URI.class, IoSerializer::uriToSource);
        this.classSerializerMap.put(URL.class, IoSerializer::urlToSource);
        this.classSerializerMap.put(InetSocketAddress.class, IoSerializer::inetSocketAddressToSource);
        this.classSerializerMap.put(SimpleDateFormat.class, FormatSerializer::simpleDataFormatToSource);
        this.classSerializerMap.put(DateFormat.class, FormatSerializer::simpleDataFormatToSource);
        this.classSerializerMap.put(DecimalFormat.class, FormatSerializer::decimalFormatToSource);
        this.classSerializerMap.put(NumberFormat.class, FormatSerializer::decimalFormatToSource);
        this.classSerializerMap.put(Class.class, MetaSerializer::classToSource);
        this.classSerializerMap.put(MergeProperty.class, MetaSerializer::mergePropertyToSource);
        this.classSerializerMap.put(LambdaReflection.MethodReferenceReflection.class, MetaSerializer::methodReferenceToSource);
    }

    public <T> T addNode(T node) {
        if (this.getNodeList() == null) {
            this.setNodeList(new ArrayList<Object>());
        }
        if (!this.getNodeList().contains(node)) {
            this.getNodeList().add(node);
            return node;
        }
        return (T)this.getNodeList().get(this.getNodeList().indexOf(node));
    }

    public void addNode(Object node, Object ... nodeList) {
        this.addNode(node);
        Arrays.asList(nodeList).forEach(this::addNode);
    }

    public <T> T addNode(T node, String name) {
        this.addNode(node);
        this.addPublicNode(node, name);
        return (T)this.getNodeList().get(this.getNodeList().indexOf(node));
    }

    public <T> T addPublicNode(T node, String name) {
        if (this.getPublicNodes() == null) {
            this.setPublicNodes(new HashMap<Object, String>());
        }
        this.getPublicNodes().put(node, name);
        return node;
    }

    public <T extends Auditor> T addAuditor(T listener, String name) {
        if (this.getAuditorMap() == null) {
            this.setAuditorMap(new HashMap<String, Auditor>());
        }
        this.getAuditorMap().put(name, listener);
        return listener;
    }

    public void mapClass(String originalFqn, String mappedFqn) {
        this.getClass2replace().put(originalFqn, mappedFqn);
    }

    public Clock clock() {
        this.addAuditor(this.clock, "clock");
        return this.clock;
    }

    public void addEventAudit(EventLogControlEvent.LogLevel tracingLogLevel) {
        if (tracingLogLevel != null) {
            this.addAuditor(new EventLogManager().tracingOn(tracingLogLevel), "eventLogger");
        }
    }

    public void addEventAudit() {
        this.addAuditor(new EventLogManager().tracingOff(), "eventLogger");
    }

    public void addEventAudit(EventLogControlEvent.LogLevel tracingLogLevel, boolean printEventToString) {
        this.addEventAudit(tracingLogLevel, printEventToString, true);
    }

    public void addEventAudit(EventLogControlEvent.LogLevel tracingLogLevel, boolean printEventToString, boolean printThreadName) {
        this.addAuditor(new EventLogManager().tracingOn(tracingLogLevel).printEventToString(printEventToString).printThreadName(printThreadName), "eventLogger");
    }

    public void addInterfaceImplementation(Class<?> clazz) {
        this.interfaces.add(clazz);
    }

    public Set<Class<?>> interfacesToImplement() {
        return this.interfaces;
    }

    public void buildConfig() {
    }

    public String getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(String templateFile) {
        this.templateFile = templateFile;
    }

    public List<Object> getNodeList() {
        return this.nodeList;
    }

    public void setNodeList(List<Object> nodeList) {
        this.nodeList = nodeList;
    }

    public HashMap<Object, String> getPublicNodes() {
        return this.publicNodes;
    }

    public <T> T getNode(String name) {
        Object[] obj = new Object[1];
        this.publicNodes.entrySet().stream().filter(e -> ((String)e.getValue()).equals(name)).findFirst().ifPresent(e -> {
            obj[0] = e.getKey();
        });
        return (T)obj[0];
    }

    public void setPublicNodes(HashMap<Object, String> publicNodes) {
        this.publicNodes = publicNodes;
    }

    public HashMap<String, Auditor> getAuditorMap() {
        return this.auditorMap;
    }

    public void setAuditorMap(HashMap<String, Auditor> auditorMap) {
        this.auditorMap = auditorMap;
    }

    public NodeFactoryRegistration getNodeFactoryRegistration() {
        return this.nodeFactoryRegistration;
    }

    public void setNodeFactoryRegistration(NodeFactoryRegistration nodeFactoryRegistration) {
        nodeFactoryRegistration.factoryClassSet.addAll(NodeFactoryConfig.required.getFactoryClasses());
        this.nodeFactoryRegistration = nodeFactoryRegistration;
    }

    public <T, S extends T> EventProcessorConfig registerInjectable(String factoryName, Class<T> injectionType, S injectableInstance) {
        this.nodeFactoryRegistration.factorySet.add(new SingletonNodeFactory<T>(injectableInstance, injectionType, factoryName));
        return this;
    }

    public <T> EventProcessorConfig registerInjectable(String factoryName, T injectableInstance) {
        this.registerInjectable(factoryName, injectableInstance.getClass(), injectableInstance);
        return this;
    }

    public RootNodeConfig getRootNodeConfig() {
        return this.rootNodeConfig;
    }

    public void setRootNodeConfig(RootNodeConfig rootNodeConfig) {
        this.rootNodeConfig = rootNodeConfig;
    }

    public Map<Object, Integer> getFilterMap() {
        return this.filterMap;
    }

    public void setFilterMap(Map<Object, Integer> filterMap) {
        this.filterMap.clear();
        this.filterMap.putAll(filterMap);
    }

    public void overrideOnEventHandlerFilterId(Object eventHandler, int newFilterId) {
        this.getFilterMap().put(eventHandler, newFilterId);
    }

    public void overrideOnEventHandlerFilterId(Object eventHandler, Class<?> eventClass, int newFilterId) {
        this.getFilterMap().put(new EventHandlerFilterOverride(eventHandler, eventClass, newFilterId), newFilterId);
    }

    public <T> EventProcessorConfig addClassSerializer(Class<T> classToSerialize, Function<FieldContext<T>, String> serializationFunction) {
        this.classSerializerMap.put(classToSerialize, serializationFunction);
        return this;
    }

    public Map<Class<?>, Function<FieldContext, String>> getClassSerializerMap() {
        return this.classSerializerMap;
    }

    public boolean isInlineEventHandling() {
        return this.inlineEventHandling;
    }

    public void setInlineEventHandling(boolean inlineEventHandling) {
        this.inlineEventHandling = inlineEventHandling;
    }

    public boolean isSupportDirtyFiltering() {
        return this.supportDirtyFiltering;
    }

    public void setSupportDirtyFiltering(boolean supportDirtyFiltering) {
        this.supportDirtyFiltering = supportDirtyFiltering;
    }

    public boolean isAssignPrivateMembers() {
        return this.assignPrivateMembers;
    }

    public void setAssignPrivateMembers(boolean assignPrivateMembers) {
        this.assignPrivateMembers = assignPrivateMembers;
    }

    public Map<String, String> getClass2replace() {
        return this.class2replace;
    }

    public boolean isInstanceOfDispatch() {
        return this.instanceOfDispatch;
    }

    public void setInstanceOfDispatch(boolean instanceOfDispatch) {
        this.instanceOfDispatch = instanceOfDispatch;
    }

    public DISPATCH_STRATEGY getDispatchStrategy() {
        return this.dispatchStrategy;
    }

    public void setDispatchStrategy(DISPATCH_STRATEGY dispatchStrategy) {
        Objects.requireNonNull(dispatchStrategy, "Dispatch strategy must be non null");
        if (dispatchStrategy == DISPATCH_STRATEGY.PATTERN_MATCH) {
            this.enablePreviewFeatures();
            this.javaTargetRelease("19");
        }
        this.dispatchStrategy = dispatchStrategy;
    }

    public List<String> getCompilerOptions() {
        return this.compilerOptions;
    }

    public void setCompilerOptions(List<String> compilerOptions) {
        Objects.requireNonNull(compilerOptions);
        this.compilerOptions = compilerOptions;
    }

    public EventProcessorConfig enablePreviewFeatures() {
        this.compilerOptions.add("--enable-preview");
        return this;
    }

    public EventProcessorConfig javaTargetRelease(String release) {
        Objects.requireNonNull(release);
        this.compilerOptions.add("--release");
        this.compilerOptions.add(release);
        return this;
    }

    public String toString() {
        return "EventProcessorConfig(interfaces=" + this.interfaces + ", clock=" + this.clock + ", class2replace=" + this.getClass2replace() + ", filterMap=" + this.getFilterMap() + ", classSerializerMap=" + this.getClassSerializerMap() + ", templateFile=" + this.getTemplateFile() + ", nodeList=" + this.getNodeList() + ", publicNodes=" + this.getPublicNodes() + ", auditorMap=" + this.getAuditorMap() + ", nodeFactoryRegistration=" + this.getNodeFactoryRegistration() + ", rootNodeConfig=" + this.getRootNodeConfig() + ", inlineEventHandling=" + this.isInlineEventHandling() + ", supportDirtyFiltering=" + this.isSupportDirtyFiltering() + ", assignPrivateMembers=" + this.isAssignPrivateMembers() + ", instanceOfDispatch=" + this.isInstanceOfDispatch() + ", dispatchStrategy=" + (Object)((Object)this.getDispatchStrategy()) + ", compilerOptions=" + this.getCompilerOptions() + ")";
    }

    static enum NodeFactoryConfig {
        required(CallBackDispatcherFactory.class, CallbackNodeFactory.class, ClockFactory.class, InstanceSupplierFactory.class, DirtyStateMonitorFactory.class, EventDispatcherFactory.class, EventProcessorCallbackInternalFactory.class, EventProcessorContextFactory.class, NodeNameLookupFactory.class, SubscriptionManagerFactory.class, SinkPublisherFactory.class);

        private final HashSet<Class<? extends NodeFactory<?>>> defaultFactories = new HashSet();

        private NodeFactoryConfig(Class<? extends NodeFactory<?>> ... factoryClasses) {
            Arrays.asList(factoryClasses).forEach(this.defaultFactories::add);
        }

        public Set<Class<? extends NodeFactory<?>>> getFactoryClasses() {
            return new HashSet(this.defaultFactories);
        }
    }

    public static enum DISPATCH_STRATEGY {
        CLASS_NAME,
        INSTANCE_OF,
        PATTERN_MATCH;

    }
}

