/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler;

import com.fluxtion.compiler.DataDrivenGenerationConfig;
import com.fluxtion.compiler.EventProcessorConfig;
import com.fluxtion.compiler.FluxtionCompilerConfig;
import com.fluxtion.compiler.FluxtionGraphBuilder;
import com.fluxtion.compiler.RootNodeConfig;
import com.fluxtion.compiler.generation.EventProcessorFactory;
import com.fluxtion.runtime.EventProcessor;
import com.fluxtion.runtime.annotations.builder.Disabled;
import com.fluxtion.runtime.partition.LambdaReflection;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.yaml.snakeyaml.Yaml;

public interface Fluxtion {
    public static EventProcessor compile(LambdaReflection.SerializableConsumer<EventProcessorConfig> sepConfig) {
        return EventProcessorFactory.compile(sepConfig);
    }

    public static EventProcessor compile(Object ... nodes) {
        return Fluxtion.compile((LambdaReflection.SerializableConsumer<EventProcessorConfig>)(LambdaReflection.SerializableConsumer & Serializable)c -> {
            for (int i = 0; i < nodes.length; ++i) {
                c.addNode(nodes[i]);
            }
        });
    }

    public static EventProcessor compile(LambdaReflection.SerializableConsumer<EventProcessorConfig> sepConfig, Writer sourceWriter) {
        return EventProcessorFactory.compile(sepConfig, (LambdaReflection.SerializableConsumer<FluxtionCompilerConfig>)(LambdaReflection.SerializableConsumer & Serializable)c -> {
            c.setSourceWriter(sourceWriter);
            c.setWriteSourceToFile(false);
            c.setGenerateDescription(false);
            c.setFormatSource(true);
        });
    }

    public static EventProcessor compile(LambdaReflection.SerializableConsumer<EventProcessorConfig> sepConfig, LambdaReflection.SerializableConsumer<FluxtionCompilerConfig> cfgBuilder) {
        return EventProcessorFactory.compile(sepConfig, cfgBuilder);
    }

    public static EventProcessor compileAot(LambdaReflection.SerializableConsumer<EventProcessorConfig> cfgBuilder) {
        String packageName = (cfgBuilder.getContainingClass().getCanonicalName() + "." + cfgBuilder.method().getName()).toLowerCase();
        return Fluxtion.compile(cfgBuilder, (LambdaReflection.SerializableConsumer<FluxtionCompilerConfig>)(LambdaReflection.SerializableConsumer & Serializable)compilerCfg -> compilerCfg.setPackageName(packageName));
    }

    public static EventProcessor compileAot(String packageName, String className, Object ... nodes) {
        return Fluxtion.compileAot((LambdaReflection.SerializableConsumer<EventProcessorConfig>)(LambdaReflection.SerializableConsumer & Serializable)c -> {
            for (int i = 0; i < nodes.length; ++i) {
                c.addNode(nodes[i]);
            }
        }, packageName, className);
    }

    public static EventProcessor compileAot(Object ... nodes) {
        return Fluxtion.compileAot((LambdaReflection.SerializableConsumer<EventProcessorConfig>)(LambdaReflection.SerializableConsumer & Serializable)c -> {
            for (int i = 0; i < nodes.length; ++i) {
                c.addNode(nodes[i]);
            }
        });
    }

    public static EventProcessor compileAot(LambdaReflection.SerializableConsumer<EventProcessorConfig> cfgBuilder, String packageName, String className) {
        return Fluxtion.compile(cfgBuilder, (LambdaReflection.SerializableConsumer<FluxtionCompilerConfig>)(LambdaReflection.SerializableConsumer & Serializable)compilerCfg -> {
            compilerCfg.setPackageName(packageName.trim());
            compilerCfg.setClassName(className.trim());
        });
    }

    public static EventProcessor interpret(LambdaReflection.SerializableConsumer<EventProcessorConfig> sepConfig) {
        return EventProcessorFactory.interpreted(sepConfig);
    }

    public static EventProcessor interpret(LambdaReflection.SerializableConsumer<EventProcessorConfig> sepConfig, boolean generateDescription) {
        return EventProcessorFactory.interpreted(sepConfig, generateDescription);
    }

    public static EventProcessor interpret(Object ... nodes) {
        return Fluxtion.interpret((LambdaReflection.SerializableConsumer<EventProcessorConfig>)(LambdaReflection.SerializableConsumer & Serializable)c -> {
            for (int i = 0; i < nodes.length; ++i) {
                c.addNode(nodes[i]);
            }
        });
    }

    public static EventProcessor compile(RootNodeConfig rootNode) {
        return EventProcessorFactory.compile(rootNode);
    }

    public static EventProcessor compile(RootNodeConfig rootNode, LambdaReflection.SerializableConsumer<FluxtionCompilerConfig> cfgBuilder) {
        return EventProcessorFactory.compile(rootNode, cfgBuilder);
    }

    public static EventProcessor compileAot(RootNodeConfig rootNode) {
        String pkg = (rootNode.getRootClass().getCanonicalName() + "." + rootNode.getName()).toLowerCase();
        return EventProcessorFactory.compile(rootNode, (LambdaReflection.SerializableConsumer<FluxtionCompilerConfig>)(LambdaReflection.SerializableConsumer & Serializable)compilerCfg -> compilerCfg.setPackageName(pkg));
    }

    public static EventProcessor compileAot(RootNodeConfig rootNode, String packagePrefix) {
        String pkg = (packagePrefix + "." + rootNode.getName()).toLowerCase();
        return EventProcessorFactory.compile(rootNode, (LambdaReflection.SerializableConsumer<FluxtionCompilerConfig>)(LambdaReflection.SerializableConsumer & Serializable)compilerCfg -> compilerCfg.setPackageName(pkg));
    }

    public static EventProcessor compileFromReader(Reader reader) {
        String overrideResourceDirectory;
        Yaml yaml = new Yaml();
        DataDrivenGenerationConfig rootInjectedConfig = (DataDrivenGenerationConfig)yaml.loadAs(reader, DataDrivenGenerationConfig.class);
        String overrideOutputDirectory = System.getProperty("FLUXTION.OUTPUT.DIRECTORY");
        if (overrideOutputDirectory != null && !overrideOutputDirectory.isEmpty()) {
            rootInjectedConfig.getCompilerConfig().setOutputDirectory(overrideOutputDirectory);
        }
        if ((overrideResourceDirectory = System.getProperty("FLUXTION.RESOURCES.DIRECTORY")) != null && !overrideResourceDirectory.isEmpty()) {
            rootInjectedConfig.getCompilerConfig().setResourcesOutputDirectory(overrideResourceDirectory);
        }
        if (rootInjectedConfig.getCompilerConfig().isInterpreted()) {
            return Fluxtion.interpret(rootInjectedConfig.getRootNodeConfig());
        }
        return EventProcessorFactory.compile(rootInjectedConfig.getEventProcessorConfig(), rootInjectedConfig.getCompilerConfig());
    }

    public static EventProcessor interpret(RootNodeConfig rootNode) {
        return EventProcessorFactory.interpreted(rootNode);
    }

    public static EventProcessor interpret(RootNodeConfig rootNode, boolean generateDescription) {
        return EventProcessorFactory.interpreted(rootNode, generateDescription);
    }

    public static int scanAndCompileFluxtionBuilders(File ... files) {
        Objects.requireNonNull(files, "provide valid locations to search for fluxtion builders");
        LongAdder generationCount = new LongAdder();
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().overrideClasspath((Object[])files).scan();){
            ClassInfoList builderList = scanResult.getClassesImplementing(FluxtionGraphBuilder.class).exclude(scanResult.getClassesWithAnnotation(Disabled.class.getCanonicalName()));
            builderList.forEach(c -> {
                generationCount.increment();
                System.out.println(generationCount.intValue() + ": invoking builder " + c.getName());
                try {
                    FluxtionGraphBuilder newInstance = (FluxtionGraphBuilder)c.loadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Fluxtion.compile((LambdaReflection.SerializableConsumer<EventProcessorConfig>)((LambdaReflection.SerializableConsumer & Serializable)newInstance::buildGraph), (LambdaReflection.SerializableConsumer<FluxtionCompilerConfig>)((LambdaReflection.SerializableConsumer & Serializable)newInstance::configureGeneration));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("cannot instantiate FluxtionGraphBuilder", e);
                }
            });
        }
        return generationCount.intValue();
    }

    public static int scanAndGenerateFluxtionBuilders(ClassLoader classLoader, File ... files) {
        Objects.requireNonNull(files, "provide valid locations to search for fluxtion builders");
        System.setProperty("FLUXTION.NO_COMPILE", "true");
        LongAdder generationCount = new LongAdder();
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().overrideClasspath((Object[])files).scan();){
            ClassInfoList builderList = scanResult.getClassesImplementing(FluxtionGraphBuilder.class).exclude(scanResult.getClassesWithAnnotation(Disabled.class.getCanonicalName()));
            builderList.forEach(c -> {
                generationCount.increment();
                System.out.println(generationCount.intValue() + ": invoking builder " + c.getName());
                try {
                    FluxtionGraphBuilder newInstance = (FluxtionGraphBuilder)classLoader.loadClass(c.getName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    FluxtionCompilerConfigOverride override = new FluxtionCompilerConfigOverride(newInstance);
                    Fluxtion.compile((LambdaReflection.SerializableConsumer<EventProcessorConfig>)((LambdaReflection.SerializableConsumer & Serializable)newInstance::buildGraph), (LambdaReflection.SerializableConsumer<FluxtionCompilerConfig>)((LambdaReflection.SerializableConsumer & Serializable)override::overrideClassPath));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("cannot instantiate FluxtionGraphBuilder", e);
                }
            });
        }
        return generationCount.intValue();
    }

    public static class FluxtionCompilerConfigOverride {
        private final FluxtionGraphBuilder newInstance;

        public FluxtionCompilerConfigOverride(FluxtionGraphBuilder newInstance) {
            this.newInstance = newInstance;
        }

        public void overrideClassPath(FluxtionCompilerConfig cfgBuilder) {
            String overrideResourceDirectory;
            this.newInstance.configureGeneration(cfgBuilder);
            String overrideOutputDirectory = System.getProperty("FLUXTION.OUTPUT.DIRECTORY");
            if (overrideOutputDirectory != null && !overrideOutputDirectory.isEmpty()) {
                cfgBuilder.setOutputDirectory(overrideOutputDirectory);
            }
            if ((overrideResourceDirectory = System.getProperty("FLUXTION.RESOURCES.DIRECTORY")) != null && !overrideResourceDirectory.isEmpty()) {
                cfgBuilder.setResourcesOutputDirectory(overrideResourceDirectory);
            }
        }
    }
}

