/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler;

import java.io.StringWriter;
import java.io.Writer;

public class FluxtionCompilerConfig {
    private String packageName;
    private String className;
    private String outputDirectory = "src/main/java/";
    private String buildOutputDirectory;
    private boolean compileSource = true;
    private boolean interpreted = false;
    private boolean formatSource = true;
    private String resourcesOutputDirectory = "src/main/resources/";
    private String templateSep = "template/base/javaTemplate.vsl";
    private boolean generateDescription = false;
    private boolean writeSourceToFile = false;
    private Writer sourceWriter;
    private boolean addBuildTime = false;
    private transient ClassLoader classLoader = FluxtionCompilerConfig.class.getClassLoader();

    public FluxtionCompilerConfig() {
        this.sourceWriter = new StringWriter();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getBuildOutputDirectory() {
        return this.buildOutputDirectory;
    }

    public String getResourcesOutputDirectory() {
        return this.resourcesOutputDirectory;
    }

    public String getTemplateSep() {
        return this.templateSep;
    }

    public boolean isGenerateDescription() {
        return this.generateDescription;
    }

    public boolean isCompileSource() {
        return this.compileSource;
    }

    public boolean isFormatSource() {
        return this.formatSource;
    }

    public String getFqn() {
        return this.getPackageName() + "." + this.getClassName();
    }

    public boolean isWriteSourceToFile() {
        return this.writeSourceToFile;
    }

    public void setWriteSourceToFile(boolean writeSourceToFile) {
        this.writeSourceToFile = writeSourceToFile;
    }

    public boolean isAddBuildTime() {
        return this.addBuildTime;
    }

    public void setAddBuildTime(boolean addBuildTime) {
        this.addBuildTime = addBuildTime;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setBuildOutputDirectory(String buildOutputDirectory) {
        this.buildOutputDirectory = buildOutputDirectory;
    }

    public void setResourcesOutputDirectory(String resourcesOutputDirectory) {
        this.resourcesOutputDirectory = resourcesOutputDirectory;
    }

    public void setTemplateSep(String templateSep) {
        this.templateSep = templateSep;
    }

    public void setGenerateDescription(boolean generateDescription) {
        this.generateDescription = generateDescription;
    }

    public void setCompileSource(boolean compileSource) {
        this.compileSource = compileSource;
    }

    public void setFormatSource(boolean formatSource) {
        this.formatSource = formatSource;
    }

    public Writer getSourceWriter() {
        return this.sourceWriter;
    }

    public void setSourceWriter(Writer sourceWriter) {
        this.setFormatSource(true);
        this.setWriteSourceToFile(false);
        this.sourceWriter = sourceWriter;
    }

    public String toString() {
        return "SepCompilerConfig{packageName=" + this.packageName + ", className=" + this.className + ", resourcesOutputDirectory=" + this.resourcesOutputDirectory + ", outputDirectory=" + this.outputDirectory + ", buildOutputdirectory=" + this.buildOutputDirectory + ", writeSourceToFile=" + this.writeSourceToFile + ", compileSource=" + this.compileSource + ", interpreted=" + this.interpreted + ", formatSource=" + this.formatSource + ", templateSep=" + this.templateSep + ", generateDescription=" + this.generateDescription + '}';
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean isInterpreted() {
        return this.interpreted;
    }

    public void setInterpreted(boolean interpreted) {
        this.interpreted = interpreted;
    }
}

