/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.builder;

import com.fluxtion.compiler.generation.GenerationContext;
import com.fluxtion.runtime.EventProcessorBuilderService;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

@AutoService(value={EventProcessorBuilderService.class})
public class EventProcessorBuilderServiceImpl
implements EventProcessorBuilderService {
    public <T> T add(T node) {
        GenerationContext.SINGLETON.getNodeList().add(node);
        return node;
    }

    @SafeVarargs
    public final <T> T[] add(T ... nodes) {
        ArrayList<T> out = new ArrayList<T>();
        for (T node : nodes) {
            out.add(this.add(node));
        }
        return out.toArray(nodes);
    }

    public <T> T addPublic(T node, String publicId) {
        GenerationContext.SINGLETON.getPublicNodes().put(node, publicId);
        return node;
    }

    public <T> T add(T node, String privateId) {
        GenerationContext.SINGLETON.getNodeList().add(node);
        GenerationContext.SINGLETON.nameNode(node, privateId);
        return node;
    }

    public <T> T addOrReuse(T node) {
        return GenerationContext.SINGLETON.addOrUseExistingNode(node);
    }

    @SafeVarargs
    public final <T> T[] addOrReuse(T ... nodes) {
        ArrayList<T> out = new ArrayList<T>();
        for (T node : nodes) {
            out.add(this.addOrReuse(node));
        }
        return out.toArray(nodes);
    }

    public <T> T addOrReuse(T node, String privateId) {
        node = GenerationContext.SINGLETON.addOrUseExistingNode(node);
        GenerationContext.SINGLETON.nameNode(node, privateId);
        return node;
    }

    public <T> T addPublicOrReuse(T node, String publicId) {
        node = GenerationContext.SINGLETON.addOrUseExistingNode(node);
        GenerationContext.SINGLETON.getPublicNodes().put(node, publicId);
        return node;
    }

    public <T> T getNodeById(String id) {
        Optional<Object> optional = GenerationContext.SINGLETON.getPublicNodes().entrySet().stream().filter(e -> ((String)e.getValue()).equals(id)).findFirst().map(Map.Entry::getKey);
        return optional.orElse(null);
    }

    public boolean buildTime() {
        return GenerationContext.SINGLETON != null;
    }
}

