/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.builder.dataflow;

import com.fluxtion.compiler.builder.dataflow.DoubleFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.FlowBuilder;
import com.fluxtion.compiler.builder.dataflow.IntFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.LongFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.StreamHelper;
import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.dataflow.function.FilterByPropertyDynamicFlowFunction;
import com.fluxtion.runtime.dataflow.function.FilterByPropertyFlowFunction;
import com.fluxtion.runtime.dataflow.function.FilterDynamicFlowFunction;
import com.fluxtion.runtime.dataflow.function.FilterFlowFunction;
import com.fluxtion.runtime.dataflow.function.MapFlowFunction;
import com.fluxtion.runtime.dataflow.function.MapOnNotifyFlowFunction;
import com.fluxtion.runtime.dataflow.function.NotifyFlowFunction;
import com.fluxtion.runtime.dataflow.function.PeekFlowFunction;
import com.fluxtion.runtime.dataflow.function.PushFlowFunction;
import com.fluxtion.runtime.dataflow.helpers.InternalEventDispatcher;
import com.fluxtion.runtime.dataflow.helpers.Peekers;
import com.fluxtion.runtime.dataflow.helpers.Predicates;
import com.fluxtion.runtime.output.SinkPublisher;
import com.fluxtion.runtime.partition.LambdaReflection;

public abstract class AbstractFlowBuilder<T, B extends AbstractFlowBuilder<T, B>> {
    final TriggeredFlowFunction<T> eventStream;

    public AbstractFlowBuilder(TriggeredFlowFunction<T> eventStream) {
        this.eventStream = eventStream;
    }

    protected abstract B connect(TriggeredFlowFunction<T> var1);

    public B parallel() {
        this.eventStream.parallel();
        return this.identity();
    }

    protected abstract <R> AbstractFlowBuilder<R, ?> connectMap(TriggeredFlowFunction<R> var1);

    protected abstract B identity();

    public B updateTrigger(Object updateTrigger) {
        this.eventStream.setUpdateTriggerNode(StreamHelper.getSource(updateTrigger));
        return this.identity();
    }

    public B publishTrigger(Object publishTrigger) {
        this.eventStream.setPublishTriggerNode(StreamHelper.getSource(publishTrigger));
        return this.identity();
    }

    public B publishTriggerOverride(Object publishTrigger) {
        this.eventStream.setPublishTriggerOverrideNode(StreamHelper.getSource(publishTrigger));
        return this.identity();
    }

    public B resetTrigger(Object resetTrigger) {
        this.eventStream.setResetTriggerNode(StreamHelper.getSource(resetTrigger));
        return this.identity();
    }

    public B filter(LambdaReflection.SerializableFunction<T, Boolean> filterFunction) {
        return this.connect((TriggeredFlowFunction<T>)new FilterFlowFunction(this.eventStream, filterFunction));
    }

    public B filter(LambdaReflection.SerializableSupplier<Boolean> filterFunction) {
        return this.filter(arg_0 -> ((Predicates.PredicateWrapper)new Predicates.PredicateWrapper(filterFunction)).test(arg_0));
    }

    public <P> B filterByProperty(LambdaReflection.SerializableFunction<T, P> accessor, LambdaReflection.SerializableFunction<P, Boolean> filterFunction) {
        return this.connect((TriggeredFlowFunction<T>)new FilterByPropertyFlowFunction(this.eventStream, accessor, filterFunction));
    }

    public <S> B filter(LambdaReflection.SerializableBiFunction<T, S, Boolean> predicate, FlowBuilder<S> secondArgument) {
        return this.connect((TriggeredFlowFunction<T>)new FilterDynamicFlowFunction(this.eventStream, (FlowFunction)secondArgument.eventStream, predicate));
    }

    public <S> B filter(LambdaReflection.SerializableBiFunction<T, Integer, Boolean> predicate, IntFlowBuilder secondArgument) {
        return this.connect((TriggeredFlowFunction<T>)new FilterDynamicFlowFunction(this.eventStream, (FlowFunction)secondArgument.eventStream, predicate));
    }

    public <S> B filter(LambdaReflection.SerializableBiFunction<T, Double, Boolean> predicate, DoubleFlowBuilder secondArgument) {
        return this.connect((TriggeredFlowFunction<T>)new FilterDynamicFlowFunction(this.eventStream, (FlowFunction)secondArgument.eventStream, predicate));
    }

    public <S> B filter(LambdaReflection.SerializableBiFunction<T, Long, Boolean> predicate, LongFlowBuilder secondArgument) {
        return this.connect((TriggeredFlowFunction<T>)new FilterDynamicFlowFunction(this.eventStream, (FlowFunction)secondArgument.eventStream, predicate));
    }

    public <P, S> B filterByProperty(LambdaReflection.SerializableBiFunction<P, S, Boolean> predicate, LambdaReflection.SerializableFunction<T, P> accessor, FlowBuilder<S> secondArgument) {
        return this.connect((TriggeredFlowFunction<T>)new FilterByPropertyDynamicFlowFunction(this.eventStream, accessor, (FlowFunction)secondArgument.eventStream, predicate));
    }

    public <P, S> B filterByProperty(LambdaReflection.SerializableBiFunction<P, Integer, Boolean> predicate, LambdaReflection.SerializableFunction<T, P> accessor, IntFlowBuilder secondArgument) {
        return this.connect((TriggeredFlowFunction<T>)new FilterByPropertyDynamicFlowFunction(this.eventStream, accessor, (FlowFunction)secondArgument.eventStream, predicate));
    }

    public <P, S> B filterByProperty(LambdaReflection.SerializableBiFunction<P, Double, Boolean> predicate, LambdaReflection.SerializableFunction<T, P> accessor, DoubleFlowBuilder secondArgument) {
        return this.connect((TriggeredFlowFunction<T>)new FilterByPropertyDynamicFlowFunction(this.eventStream, accessor, (FlowFunction)secondArgument.eventStream, predicate));
    }

    public <P, S> B filterByProperty(LambdaReflection.SerializableBiFunction<P, Long, Boolean> predicate, LambdaReflection.SerializableFunction<T, P> accessor, LongFlowBuilder secondArgument) {
        return this.connect((TriggeredFlowFunction<T>)new FilterByPropertyDynamicFlowFunction(this.eventStream, accessor, (FlowFunction)secondArgument.eventStream, predicate));
    }

    protected <R, E> E mapOnNotifyBase(R target) {
        return (E)this.connectMap((TriggeredFlowFunction<R>)new MapOnNotifyFlowFunction(this.eventStream, target));
    }

    protected <R, E> E mapBase(LambdaReflection.SerializableFunction<T, R> mapFunction) {
        return (E)this.connectMap((TriggeredFlowFunction<R>)new MapFlowFunction.MapRef2RefFlowFunction(this.eventStream, mapFunction));
    }

    public B push(LambdaReflection.SerializableConsumer<T> pushFunction) {
        return this.connect((TriggeredFlowFunction<T>)new PushFlowFunction(this.eventStream, pushFunction));
    }

    public B sink(String sinkId) {
        return this.push(arg_0 -> ((SinkPublisher)new SinkPublisher(sinkId)).publish(arg_0));
    }

    public B notify(Object target) {
        EventProcessorBuilderService.service().add(target);
        return this.connect((TriggeredFlowFunction<T>)new NotifyFlowFunction(this.eventStream, target));
    }

    public B processAsNewGraphEvent() {
        return this.connect((TriggeredFlowFunction<T>)new PeekFlowFunction(this.eventStream, arg_0 -> ((InternalEventDispatcher)new InternalEventDispatcher()).dispatchToGraph(arg_0)));
    }

    public B peek(LambdaReflection.SerializableConsumer<T> peekFunction) {
        return this.connect((TriggeredFlowFunction<T>)new PeekFlowFunction(this.eventStream, peekFunction));
    }

    public <R> B console(String in, LambdaReflection.SerializableFunction<T, R> transformFunction) {
        this.peek(Peekers.console((String)in, transformFunction));
        return this.identity();
    }

    public B console(String in) {
        return this.console(in, null);
    }

    public B console() {
        return this.console("{}");
    }

    public IntFlowBuilder mapToInt(LambdaReflection.SerializableToIntFunction<T> mapFunction) {
        return new IntFlowBuilder((IntFlowFunction)new MapFlowFunction.MapRef2ToIntFlowFunction(this.eventStream, mapFunction));
    }

    public DoubleFlowBuilder mapToDouble(LambdaReflection.SerializableToDoubleFunction<T> mapFunction) {
        return new DoubleFlowBuilder((DoubleFlowFunction)new MapFlowFunction.MapRef2ToDoubleFlowFunction(this.eventStream, mapFunction));
    }

    public LongFlowBuilder mapToLong(LambdaReflection.SerializableToLongFunction<T> mapFunction) {
        return new LongFlowBuilder((LongFlowFunction)new MapFlowFunction.MapRef2ToLongFlowFunction(this.eventStream, mapFunction));
    }

    public B id(String nodeId) {
        EventProcessorBuilderService.service().add(this.eventStream, nodeId);
        return this.identity();
    }
}

