/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.builder.dataflow;

import com.fluxtion.compiler.builder.dataflow.DoubleFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.FlowBuilder;
import com.fluxtion.compiler.builder.dataflow.GroupByFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.IntFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.LongFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.MergeAndMapFlowBuilder;
import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateFlowFunction;
import com.fluxtion.runtime.dataflow.function.MergeMapFlowFunction;
import com.fluxtion.runtime.dataflow.function.NodePropertyToFlowFunction;
import com.fluxtion.runtime.dataflow.function.NodeToFlowFunction;
import com.fluxtion.runtime.event.Event;
import com.fluxtion.runtime.event.Signal;
import com.fluxtion.runtime.node.DefaultEventHandlerNode;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;

public interface DataFlow {
    public static <T> FlowBuilder<T> subscribe(Class<T> classSubscription) {
        return new FlowBuilder((TriggeredFlowFunction)EventProcessorBuilderService.service().addOrReuse((Object)new DefaultEventHandlerNode(classSubscription)));
    }

    public static <T extends Event> FlowBuilder<T> subscribe(Class<T> classSubscription, String filter) {
        return new FlowBuilder((TriggeredFlowFunction)EventProcessorBuilderService.service().addOrReuse((Object)new DefaultEventHandlerNode(filter, classSubscription)));
    }

    public static <T extends Event> FlowBuilder<T> subscribe(Class<T> classSubscription, int filter) {
        return new FlowBuilder((TriggeredFlowFunction)EventProcessorBuilderService.service().addOrReuse((Object)new DefaultEventHandlerNode(filter, classSubscription)));
    }

    public static <T> FlowBuilder<T> subscribeToNode(T source) {
        return new FlowBuilder(new NodeToFlowFunction(source));
    }

    public static <T, R> FlowBuilder<R> subscribeToNodeProperty(LambdaReflection.SerializableFunction<T, R> sourceProperty) {
        Object source;
        if (sourceProperty.captured().length == 0) {
            try {
                source = sourceProperty.getContainingClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("no default constructor found for class:" + sourceProperty.getContainingClass() + " either add default constructor or pass in a node instance");
            }
        } else {
            source = sourceProperty.captured()[0];
        }
        return DataFlow.subscribeToNode(source).map(sourceProperty);
    }

    public static <R> FlowBuilder<R> subscribeToNodeProperty(LambdaReflection.SerializableSupplier<R> propertySupplier) {
        EventProcessorBuilderService.service().addOrReuse(propertySupplier.captured()[0]);
        return new FlowBuilder(new NodePropertyToFlowFunction(propertySupplier));
    }

    public static FlowBuilder<Signal> subscribeToSignal(String filterId) {
        return DataFlow.subscribe(Signal.class, filterId);
    }

    public static <T> FlowBuilder<T> subscribeToSignal(String filterId, Class<T> signalType) {
        return DataFlow.subscribe(Signal.class, filterId).map(Signal::getValue);
    }

    public static <T> FlowBuilder<T> subscribeToSignal(String filterId, Class<T> signalType, T defaultValue) {
        return DataFlow.subscribe(Signal.class, filterId).map(Signal::getValue).defaultValue(defaultValue);
    }

    public static IntFlowBuilder subscribeToIntSignal(String filterId) {
        return DataFlow.subscribe(Signal.IntSignal.class, filterId).mapToInt(Signal.IntSignal::getValue);
    }

    public static IntFlowBuilder subscribeToIntSignal(String filterId, int defaultValue) {
        return DataFlow.subscribe(Signal.IntSignal.class, filterId).mapToInt(Signal.IntSignal::getValue).defaultValue(defaultValue);
    }

    public static DoubleFlowBuilder subscribeToDoubleSignal(String filterId) {
        return DataFlow.subscribe(Signal.DoubleSignal.class, filterId).mapToDouble(Signal.DoubleSignal::getValue);
    }

    public static DoubleFlowBuilder subscribeToDoubleSignal(String filterId, double defaultValue) {
        return DataFlow.subscribe(Signal.DoubleSignal.class, filterId).mapToDouble(Signal.DoubleSignal::getValue).defaultValue(defaultValue);
    }

    public static LongFlowBuilder subscribeToLongSignal(String filterId) {
        return DataFlow.subscribe(Signal.LongSignal.class, filterId).mapToLong(Signal.LongSignal::getValue);
    }

    public static LongFlowBuilder subscribeToLongSignal(String filterId, long defaultValue) {
        return DataFlow.subscribe(Signal.LongSignal.class, filterId).mapToLong(Signal.LongSignal::getValue).defaultValue(defaultValue);
    }

    public static <T> FlowBuilder<T> mergeMap(MergeAndMapFlowBuilder<T> builder) {
        MergeMapFlowFunction<T> build = builder.build();
        return new FlowBuilder<T>(build);
    }

    public static <T, S extends T> FlowBuilder<T> merge(FlowBuilder<T> streamAToMerge, FlowBuilder<S> streamBToMerge) {
        return streamAToMerge.merge(streamBToMerge);
    }

    public static <T, S extends T> FlowBuilder<T> merge(FlowBuilder<T> streamAToMerge, FlowBuilder<S> streamBToMerge, FlowBuilder<? extends T> ... streamsToMerge) {
        return streamAToMerge.merge(streamBToMerge, streamsToMerge);
    }

    public static <T, S, R> FlowBuilder<R> mapBiFunction(LambdaReflection.SerializableBiFunction<T, S, R> biFunction, FlowBuilder<T> streamArg1, FlowBuilder<S> streamArg2) {
        return streamArg1.mapBiFunction(biFunction, streamArg2);
    }

    public static <T, K> GroupByFlowBuilder<K, T> groupBy(LambdaReflection.SerializableFunction<T, K> keyFunction) {
        Class<?> classSubscription = keyFunction.method().getDeclaringClass();
        return DataFlow.subscribe(classSubscription).groupBy(keyFunction);
    }

    public static <T, K, O, F extends AggregateFlowFunction<T, O, F>> GroupByFlowBuilder<K, O> groupBy(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier) {
        Class<?> classSubscription = keyFunction.method().getDeclaringClass();
        return DataFlow.subscribe(classSubscription).groupBy(keyFunction, aggregateFunctionSupplier);
    }

    public static <T, K> GroupByFlowBuilder<K, List<T>> groupByToList(LambdaReflection.SerializableFunction<T, K> keyFunction) {
        Class<?> classSubscription = keyFunction.method().getDeclaringClass();
        return DataFlow.subscribe(classSubscription).groupByToList(keyFunction);
    }

    public static <T, K> GroupByFlowBuilder<K, Set<T>> groupByToSet(LambdaReflection.SerializableFunction<T, K> keyFunction) {
        Class<?> classSubscription = keyFunction.method().getDeclaringClass();
        return DataFlow.subscribe(classSubscription).groupByToSet(keyFunction);
    }

    public static <T, K, V> GroupByFlowBuilder<K, V> groupBy(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction) {
        Class<?> classSubscription = keyFunction.method().getDeclaringClass();
        return DataFlow.subscribe(classSubscription).groupBy(keyFunction, valueFunction);
    }

    public static <T, V, K1, A, F extends AggregateFlowFunction<V, A, F>> GroupByFlowBuilder<K1, A> groupBy(LambdaReflection.SerializableFunction<T, K1> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier) {
        Class<?> classSubscription = keyFunction.method().getDeclaringClass();
        return DataFlow.subscribe(classSubscription).groupBy(keyFunction, valueFunction, aggregateFunctionSupplier);
    }
}

