/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.builder.dataflow;

import com.fluxtion.compiler.builder.dataflow.FlowBuilder;
import com.fluxtion.compiler.builder.dataflow.FlowDataSupplier;
import com.fluxtion.compiler.builder.dataflow.IntFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.LongFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.StreamHelper;
import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.DoubleFlowSupplier;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateDoubleFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.TimedSlidingWindow;
import com.fluxtion.runtime.dataflow.aggregate.function.TumblingWindow;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.AggregateDoubleFlowFunctionWrapper;
import com.fluxtion.runtime.dataflow.function.BinaryMapFlowFunction;
import com.fluxtion.runtime.dataflow.function.FilterDynamicFlowFunction;
import com.fluxtion.runtime.dataflow.function.FilterFlowFunction;
import com.fluxtion.runtime.dataflow.function.MapFlowFunction;
import com.fluxtion.runtime.dataflow.function.MapOnNotifyFlowFunction;
import com.fluxtion.runtime.dataflow.function.NotifyFlowFunction;
import com.fluxtion.runtime.dataflow.function.PeekFlowFunction;
import com.fluxtion.runtime.dataflow.function.PushFlowFunction;
import com.fluxtion.runtime.dataflow.helpers.DefaultValue;
import com.fluxtion.runtime.dataflow.helpers.Peekers;
import com.fluxtion.runtime.output.SinkPublisher;
import com.fluxtion.runtime.partition.LambdaReflection;

public class DoubleFlowBuilder
implements FlowDataSupplier<DoubleFlowSupplier> {
    final DoubleFlowFunction eventStream;

    DoubleFlowBuilder(DoubleFlowFunction eventStream) {
        EventProcessorBuilderService.service().add((Object)eventStream);
        this.eventStream = eventStream;
    }

    @Override
    public DoubleFlowSupplier flowSupplier() {
        return this.eventStream;
    }

    public DoubleFlowBuilder parallel() {
        this.eventStream.parallel();
        return this;
    }

    public DoubleFlowBuilder updateTrigger(Object updateTrigger) {
        Object source = StreamHelper.getSource(updateTrigger);
        if (this.eventStream instanceof TriggeredFlowFunction) {
            TriggeredFlowFunction triggeredEventStream = (TriggeredFlowFunction)this.eventStream;
            triggeredEventStream.setUpdateTriggerNode(source);
        }
        return this;
    }

    public DoubleFlowBuilder publishTrigger(Object publishTrigger) {
        Object source = StreamHelper.getSource(publishTrigger);
        if (this.eventStream instanceof TriggeredFlowFunction) {
            TriggeredFlowFunction triggeredEventStream = (TriggeredFlowFunction)this.eventStream;
            triggeredEventStream.setPublishTriggerNode(source);
        }
        return this;
    }

    public DoubleFlowBuilder publishTriggerOverride(Object publishTrigger) {
        Object source = StreamHelper.getSource(publishTrigger);
        if (this.eventStream instanceof TriggeredFlowFunction) {
            TriggeredFlowFunction triggeredEventStream = (TriggeredFlowFunction)this.eventStream;
            triggeredEventStream.setPublishTriggerOverrideNode(source);
        }
        return this;
    }

    public DoubleFlowBuilder resetTrigger(Object resetTrigger) {
        Object source = StreamHelper.getSource(resetTrigger);
        if (this.eventStream instanceof TriggeredFlowFunction) {
            TriggeredFlowFunction triggeredEventStream = (TriggeredFlowFunction)this.eventStream;
            triggeredEventStream.setResetTriggerNode(source);
        }
        return this;
    }

    public DoubleFlowBuilder filter(LambdaReflection.SerializableDoubleFunction<Boolean> filterFunction) {
        return new DoubleFlowBuilder((DoubleFlowFunction)new FilterFlowFunction.DoubleFilterFlowFunction(this.eventStream, filterFunction));
    }

    public <S> DoubleFlowBuilder filter(LambdaReflection.SerializableBiDoublePredicate predicate, DoubleFlowBuilder secondArgument) {
        return new DoubleFlowBuilder((DoubleFlowFunction)new FilterDynamicFlowFunction.DoubleFilterDynamicFlowFunction(this.eventStream, secondArgument.eventStream, predicate));
    }

    public DoubleFlowBuilder defaultValue(double defaultValue) {
        return this.map(arg_0 -> ((DefaultValue.DefaultDouble)new DefaultValue.DefaultDouble(defaultValue)).getOrDefault(arg_0));
    }

    public DoubleFlowBuilder map(LambdaReflection.SerializableDoubleUnaryOperator int2IntFunction) {
        return new DoubleFlowBuilder((DoubleFlowFunction)new MapFlowFunction.MapDouble2ToDoubleFlowFunction(this.eventStream, int2IntFunction));
    }

    public DoubleFlowBuilder mapBiFunction(LambdaReflection.SerializableBiDoubleFunction int2IntFunction, DoubleFlowBuilder stream2Builder) {
        return new DoubleFlowBuilder((DoubleFlowFunction)new BinaryMapFlowFunction.BinaryMapToDoubleFlowFunction(this.eventStream, stream2Builder.eventStream, int2IntFunction));
    }

    public <F extends AggregateDoubleFlowFunction<F>> DoubleFlowBuilder aggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction) {
        return new DoubleFlowBuilder((DoubleFlowFunction)new AggregateDoubleFlowFunctionWrapper(this.eventStream, aggregateFunction));
    }

    public <F extends AggregateDoubleFlowFunction<F>> DoubleFlowBuilder tumblingAggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction, int bucketSizeMillis) {
        return new DoubleFlowBuilder((DoubleFlowFunction)new TumblingWindow.TumblingDoubleWindowStream(this.eventStream, aggregateFunction, bucketSizeMillis));
    }

    public <F extends AggregateDoubleFlowFunction<F>> DoubleFlowBuilder slidingAggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction, int bucketSizeMillis, int numberOfBuckets) {
        return new DoubleFlowBuilder((DoubleFlowFunction)new TimedSlidingWindow.TimedSlidingWindowDoubleStream(this.eventStream, aggregateFunction, bucketSizeMillis, numberOfBuckets));
    }

    public <T> FlowBuilder<T> mapOnNotify(T target) {
        return new FlowBuilder(new MapOnNotifyFlowFunction((FlowFunction)this.eventStream, target));
    }

    public FlowBuilder<Double> box() {
        return this.mapToObj(Double::valueOf);
    }

    public <R> FlowBuilder<R> mapToObj(LambdaReflection.SerializableDoubleFunction<R> int2IntFunction) {
        return new FlowBuilder(new MapFlowFunction.MapDouble2RefFlowFunction(this.eventStream, int2IntFunction));
    }

    public IntFlowBuilder mapToInt(LambdaReflection.SerializableDoubleToIntFunction int2IntFunction) {
        return new IntFlowBuilder((IntFlowFunction)new MapFlowFunction.MapDouble2ToIntFlowFunction(this.eventStream, int2IntFunction));
    }

    public LongFlowBuilder mapToLong(LambdaReflection.SerializableDoubleToLongFunction int2IntFunction) {
        return new LongFlowBuilder((LongFlowFunction)new MapFlowFunction.MapDouble2ToLongFlowFunction(this.eventStream, int2IntFunction));
    }

    public DoubleFlowBuilder notify(Object target) {
        EventProcessorBuilderService.service().add(target);
        return new DoubleFlowBuilder((DoubleFlowFunction)new NotifyFlowFunction.DoubleNotifyFlowFunction(this.eventStream, target));
    }

    public DoubleFlowBuilder sink(String sinkId) {
        return this.push(arg_0 -> ((SinkPublisher)new SinkPublisher(sinkId)).publishDouble(arg_0));
    }

    public DoubleFlowBuilder push(LambdaReflection.SerializableDoubleConsumer pushFunction) {
        return new DoubleFlowBuilder((DoubleFlowFunction)new PushFlowFunction.DoublePushFlowFunction(this.eventStream, pushFunction));
    }

    public DoubleFlowBuilder peek(LambdaReflection.SerializableConsumer<Double> peekFunction) {
        return new DoubleFlowBuilder((DoubleFlowFunction)new PeekFlowFunction.DoublePeekFlowFunction(this.eventStream, peekFunction));
    }

    public DoubleFlowBuilder console(String in) {
        this.peek((LambdaReflection.SerializableConsumer<Double>)Peekers.console((String)in));
        return this;
    }

    public DoubleFlowBuilder console() {
        return this.console("{}");
    }

    public DoubleFlowBuilder id(String nodeId) {
        EventProcessorBuilderService.service().add((Object)this.eventStream, nodeId);
        return this;
    }
}

