/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.builder.dataflow;

import com.fluxtion.compiler.builder.dataflow.AbstractFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.FlowDataSupplier;
import com.fluxtion.compiler.builder.dataflow.GroupByFlowBuilder;
import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.FlowSupplier;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.AggregateFlowFunctionWrapper;
import com.fluxtion.runtime.dataflow.aggregate.function.TimedSlidingWindow;
import com.fluxtion.runtime.dataflow.aggregate.function.TumblingWindow;
import com.fluxtion.runtime.dataflow.function.BinaryMapFlowFunction;
import com.fluxtion.runtime.dataflow.function.FlatMapArrayFlowFunction;
import com.fluxtion.runtime.dataflow.function.FlatMapFlowFunction;
import com.fluxtion.runtime.dataflow.function.LookupFlowFunction;
import com.fluxtion.runtime.dataflow.function.MapFlowFunction;
import com.fluxtion.runtime.dataflow.function.MergeFlowFunction;
import com.fluxtion.runtime.dataflow.groupby.GroupByFlowFunctionWrapper;
import com.fluxtion.runtime.dataflow.groupby.GroupByKey;
import com.fluxtion.runtime.dataflow.groupby.GroupByTimedSlidingWindow;
import com.fluxtion.runtime.dataflow.groupby.GroupByTumblingWindow;
import com.fluxtion.runtime.dataflow.helpers.Aggregates;
import com.fluxtion.runtime.dataflow.helpers.Collectors;
import com.fluxtion.runtime.dataflow.helpers.DefaultValue;
import com.fluxtion.runtime.dataflow.helpers.Mappers;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FlowBuilder<T>
extends AbstractFlowBuilder<T, FlowBuilder<T>>
implements FlowDataSupplier<FlowSupplier<T>> {
    FlowBuilder(TriggeredFlowFunction<T> eventStream) {
        super(eventStream);
        EventProcessorBuilderService.service().add(eventStream);
    }

    @Override
    protected FlowBuilder<T> connect(TriggeredFlowFunction<T> stream) {
        return new FlowBuilder<T>(stream);
    }

    protected <R> FlowBuilder<R> connectMap(TriggeredFlowFunction<R> stream) {
        return new FlowBuilder<R>(stream);
    }

    @Override
    protected FlowBuilder<T> identity() {
        return this;
    }

    @Override
    public FlowSupplier<T> flowSupplier() {
        return this.eventStream;
    }

    public FlowBuilder<T> defaultValue(T defaultValue) {
        return this.map(arg_0 -> ((DefaultValue)new DefaultValue(defaultValue)).getOrDefault(arg_0));
    }

    public FlowBuilder<T> defaultValue(LambdaReflection.SerializableSupplier<T> defaultValue) {
        return this.map(arg_0 -> ((DefaultValue.DefaultValueFromSupplier)new DefaultValue.DefaultValueFromSupplier(defaultValue)).getOrDefault(arg_0));
    }

    public <R, I, L> FlowBuilder<R> lookup(LambdaReflection.SerializableFunction<T, I> lookupKeyFunction, LambdaReflection.SerializableFunction<I, L> lookupFunction, LambdaReflection.SerializableBiFunction<T, L, R> enrichFunction) {
        return new FlowBuilder<T>(new LookupFlowFunction((FlowFunction)this.eventStream, lookupKeyFunction, lookupFunction, enrichFunction));
    }

    public <R> FlowBuilder<R> map(LambdaReflection.SerializableFunction<T, R> mapFunction) {
        return (FlowBuilder)super.mapBase(mapFunction);
    }

    public FlowBuilder<Set<T>> mapToSet() {
        return this.map(Collectors.toSet());
    }

    public <R> FlowBuilder<Set<R>> mapToSet(LambdaReflection.SerializableFunction<T, R> mapFunction) {
        return this.map(mapFunction).map(Collectors.toSet());
    }

    public FlowBuilder<List<T>> mapToList() {
        return this.map(Collectors.toList());
    }

    public <R> FlowBuilder<List<R>> mapToList(LambdaReflection.SerializableFunction<T, R> mapFunction) {
        return this.map(mapFunction).map(Collectors.toList());
    }

    public FlowBuilder<List<T>> mapToList(int maxElements) {
        return this.map(Collectors.toList((int)maxElements));
    }

    public <R> FlowBuilder<List<R>> mapToList(LambdaReflection.SerializableFunction<T, R> mapFunction, int maxElements) {
        return this.map(mapFunction).map(Collectors.toList((int)maxElements));
    }

    public <S, R> FlowBuilder<R> mapBiFunction(LambdaReflection.SerializableBiFunction<T, S, R> int2IntFunction, FlowBuilder<S> stream2Builder) {
        TriggeredFlowFunction e1 = this.eventStream;
        return new FlowBuilder<T>(new BinaryMapFlowFunction.BinaryMapToRefFlowFunction((FlowFunction)this.eventStream, (FlowFunction)stream2Builder.eventStream, int2IntFunction));
    }

    public FlowBuilder<T> merge(FlowBuilder<? extends T> streamToMerge) {
        return new FlowBuilder<T>(new MergeFlowFunction((FlowFunction)this.eventStream, (FlowFunction)streamToMerge.eventStream));
    }

    public FlowBuilder<T> merge(FlowBuilder<? extends T> streamToMerge, FlowBuilder<? extends T> ... streamsToMerge) {
        ArrayList<TriggeredFlowFunction> mergeList = new ArrayList<TriggeredFlowFunction>();
        mergeList.add(this.eventStream);
        mergeList.add(streamToMerge.eventStream);
        for (FlowBuilder<? extends T> flowBuilder : streamsToMerge) {
            mergeList.add(flowBuilder.eventStream);
        }
        return new FlowBuilder<T>(new MergeFlowFunction(mergeList));
    }

    public <R> FlowBuilder<R> flatMap(LambdaReflection.SerializableFunction<T, Iterable<R>> iterableFunction) {
        return new FlowBuilder<T>(new FlatMapFlowFunction((FlowFunction)this.eventStream, iterableFunction));
    }

    public <R> FlowBuilder<R> flatMapFromArray(LambdaReflection.SerializableFunction<T, R[]> iterableFunction) {
        return new FlowBuilder<T>(new FlatMapArrayFlowFunction((FlowFunction)this.eventStream, iterableFunction));
    }

    public <R, F extends AggregateFlowFunction<T, R, F>> FlowBuilder<R> aggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction) {
        return new FlowBuilder<T>(new AggregateFlowFunctionWrapper((FlowFunction)this.eventStream, aggregateFunction));
    }

    public <R, F extends AggregateFlowFunction<T, R, F>> FlowBuilder<R> tumblingAggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction, int bucketSizeMillis) {
        return new FlowBuilder<T>(new TumblingWindow((FlowFunction)this.eventStream, aggregateFunction, bucketSizeMillis));
    }

    public <R, F extends AggregateFlowFunction<T, R, F>> FlowBuilder<R> slidingAggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction, int bucketSizeMillis, int bucketsPerWindow) {
        return new FlowBuilder<T>(new TimedSlidingWindow((FlowFunction)this.eventStream, aggregateFunction, bucketSizeMillis, bucketsPerWindow));
    }

    public <V, K1, A, F extends AggregateFlowFunction<V, A, F>> GroupByFlowBuilder<K1, A> groupBy(LambdaReflection.SerializableFunction<T, K1> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier) {
        MapFlowFunction.MapRef2RefFlowFunction x = new MapFlowFunction.MapRef2RefFlowFunction((FlowFunction)this.eventStream, arg_0 -> ((GroupByFlowFunctionWrapper)new GroupByFlowFunctionWrapper(keyFunction, valueFunction, aggregateFunctionSupplier)).aggregate(arg_0));
        return new GroupByFlowBuilder(x);
    }

    public <K1, A, F extends AggregateFlowFunction<T, A, F>> GroupByFlowBuilder<K1, A> groupBy(LambdaReflection.SerializableFunction<T, K1> keyFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier) {
        return this.groupBy(keyFunction, Mappers::identity, aggregateFunctionSupplier);
    }

    public <V, K1> GroupByFlowBuilder<K1, V> groupBy(LambdaReflection.SerializableFunction<T, K1> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction) {
        return this.groupBy(keyFunction, valueFunction, Aggregates.identityFactory());
    }

    public <K> GroupByFlowBuilder<K, T> groupBy(LambdaReflection.SerializableFunction<T, K> keyFunction) {
        return this.groupBy(keyFunction, Mappers::identity);
    }

    @SafeVarargs
    public final GroupByFlowBuilder<GroupByKey<T>, T> groupByFields(LambdaReflection.SerializableFunction<T, ?> ... keyFunctions) {
        return this.groupBy(GroupByKey.build(keyFunctions));
    }

    @SafeVarargs
    public final <A, F extends AggregateFlowFunction<T, A, F>> GroupByFlowBuilder<GroupByKey<T>, A> groupByFieldsAggregate(LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier, LambdaReflection.SerializableFunction<T, ?> ... keyFunctions) {
        return this.groupBy(GroupByKey.build(keyFunctions), aggregateFunctionSupplier);
    }

    @SafeVarargs
    public final <V> GroupByFlowBuilder<GroupByKey<T>, V> groupByFieldsAndGet(LambdaReflection.SerializableFunction<T, V> valueFunction, LambdaReflection.SerializableFunction<T, ?> ... keyFunctions) {
        return this.groupBy(GroupByKey.build(keyFunctions), valueFunction);
    }

    @SafeVarargs
    public final <V, A, F extends AggregateFlowFunction<V, A, F>> GroupByFlowBuilder<GroupByKey<T>, A> groupByFieldsGetAndAggregate(LambdaReflection.SerializableFunction<T, V> valueFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier, LambdaReflection.SerializableFunction<T, ?> ... keyFunctions) {
        return this.groupBy(GroupByKey.build(keyFunctions), valueFunction, aggregateFunctionSupplier);
    }

    public <K> GroupByFlowBuilder<K, List<T>> groupByToList(LambdaReflection.SerializableFunction<T, K> keyFunction) {
        return this.groupBy(keyFunction, Mappers::identity, Collectors.listFactory());
    }

    public <K, V> GroupByFlowBuilder<K, List<V>> groupByToList(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction) {
        return this.groupBy(keyFunction, valueFunction, Collectors.listFactory());
    }

    public <K> GroupByFlowBuilder<K, Set<T>> groupByToSet(LambdaReflection.SerializableFunction<T, K> keyFunction) {
        return this.groupBy(keyFunction, Mappers::identity, Collectors.setFactory());
    }

    public <K, V> GroupByFlowBuilder<K, Set<V>> groupByToSet(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction) {
        return this.groupBy(keyFunction, valueFunction, Collectors.setFactory());
    }

    public <K> GroupByFlowBuilder<K, List<T>> groupByToList(LambdaReflection.SerializableFunction<T, K> keyFunction, int maxElementsInList) {
        return this.groupBy(keyFunction, Mappers::identity, Collectors.listFactory((int)maxElementsInList));
    }

    public <V, K, A, F extends AggregateFlowFunction<V, A, F>> GroupByFlowBuilder<K, A> groupByTumbling(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier, int bucketSizeMillis) {
        return new GroupByFlowBuilder(new GroupByTumblingWindow((FlowFunction)this.eventStream, aggregateFunctionSupplier, keyFunction, valueFunction, bucketSizeMillis));
    }

    public <V, K> GroupByFlowBuilder<K, V> groupByTumbling(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, int bucketSizeMillis) {
        return this.groupByTumbling(keyFunction, valueFunction, Aggregates.identityFactory(), bucketSizeMillis);
    }

    public <V, K, A, F extends AggregateFlowFunction<V, A, F>> GroupByFlowBuilder<K, A> groupBySliding(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier, int bucketSizeMillis, int numberOfBuckets) {
        return new GroupByFlowBuilder(new GroupByTimedSlidingWindow((FlowFunction)this.eventStream, aggregateFunctionSupplier, keyFunction, valueFunction, bucketSizeMillis, numberOfBuckets));
    }

    public <V, K> GroupByFlowBuilder<K, V> groupBySliding(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, int bucketSizeMillis, int numberOfBuckets) {
        return this.groupBySliding(keyFunction, valueFunction, Aggregates.identityFactory(), bucketSizeMillis, numberOfBuckets);
    }

    public <K, A, F extends AggregateFlowFunction<T, A, F>> GroupByFlowBuilder<K, A> groupBySliding(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier, int bucketSizeMillis, int numberOfBuckets) {
        return new GroupByFlowBuilder(new GroupByTimedSlidingWindow((FlowFunction)this.eventStream, aggregateFunctionSupplier, keyFunction, Mappers::identity, bucketSizeMillis, numberOfBuckets));
    }

    public <I, Z extends FlowBuilder<I>> Z mapOnNotify(I target) {
        return (Z)((FlowBuilder)super.mapOnNotifyBase(target));
    }
}

