/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.builder.dataflow;

import com.fluxtion.compiler.builder.dataflow.AbstractFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.FlowDataSupplier;
import com.fluxtion.compiler.builder.dataflow.GroupByFlowBuilder;
import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.FlowSupplier;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.AggregateFlowFunctionWrapper;
import com.fluxtion.runtime.dataflow.aggregate.function.TimedSlidingWindow;
import com.fluxtion.runtime.dataflow.aggregate.function.TumblingWindow;
import com.fluxtion.runtime.dataflow.function.BinaryMapFlowFunction;
import com.fluxtion.runtime.dataflow.function.MapFlowFunction;
import com.fluxtion.runtime.dataflow.function.MergeFlowFunction;
import com.fluxtion.runtime.dataflow.groupby.GroupByFlowFunctionWrapper;
import com.fluxtion.runtime.dataflow.groupby.GroupByTimedSlidingWindow;
import com.fluxtion.runtime.dataflow.groupby.GroupByTumblingWindow;
import com.fluxtion.runtime.dataflow.helpers.Aggregates;
import com.fluxtion.runtime.dataflow.helpers.Collectors;
import com.fluxtion.runtime.dataflow.helpers.DefaultValue;
import com.fluxtion.runtime.dataflow.helpers.Mappers;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.List;

public class FlowBuilderBase<T>
extends AbstractFlowBuilder<T, FlowBuilderBase<T>>
implements FlowDataSupplier<FlowSupplier<T>> {
    FlowBuilderBase(TriggeredFlowFunction<T> eventStream) {
        super(eventStream);
        EventProcessorBuilderService.service().add(eventStream);
    }

    @Override
    protected FlowBuilderBase<T> connect(TriggeredFlowFunction<T> stream) {
        return new FlowBuilderBase<T>(stream);
    }

    protected <R> FlowBuilderBase<R> connectMap(TriggeredFlowFunction<R> stream) {
        return new FlowBuilderBase<R>(stream);
    }

    @Override
    protected FlowBuilderBase<T> identity() {
        return this;
    }

    @Override
    public FlowSupplier<T> flowSupplier() {
        return (FlowSupplier)EventProcessorBuilderService.service().add((Object)this.eventStream);
    }

    public FlowBuilderBase<T> defaultValue(T defaultValue) {
        return this.map(arg_0 -> ((DefaultValue)new DefaultValue(defaultValue)).getOrDefault(arg_0));
    }

    public FlowBuilderBase<T> defaultValue(LambdaReflection.SerializableSupplier<T> defaultValue) {
        return this.map(arg_0 -> ((DefaultValue.DefaultValueFromSupplier)new DefaultValue.DefaultValueFromSupplier(defaultValue)).getOrDefault(arg_0));
    }

    public <R> FlowBuilderBase<R> map(LambdaReflection.SerializableFunction<T, R> mapFunction) {
        return (FlowBuilderBase)super.mapBase(mapFunction);
    }

    public <S, R> FlowBuilderBase<R> mapBiFunction(LambdaReflection.SerializableBiFunction<T, S, R> int2IntFunction, FlowBuilderBase<S> stream2Builder) {
        TriggeredFlowFunction e1 = this.eventStream;
        return new FlowBuilderBase<T>(new BinaryMapFlowFunction.BinaryMapToRefFlowFunction((FlowFunction)this.eventStream, (FlowFunction)stream2Builder.eventStream, int2IntFunction));
    }

    public FlowBuilderBase<T> merge(FlowBuilderBase<? extends T> streamToMerge) {
        return new FlowBuilderBase<T>(new MergeFlowFunction((FlowFunction)this.eventStream, (FlowFunction)streamToMerge.eventStream));
    }

    public <S, R, F extends AggregateFlowFunction<T, R, F>> FlowBuilderBase<R> aggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction) {
        return new FlowBuilderBase<T>(new AggregateFlowFunctionWrapper((FlowFunction)this.eventStream, aggregateFunction));
    }

    public <S, R, F extends AggregateFlowFunction<T, R, F>> FlowBuilderBase<R> tumblingAggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction, int bucketSizeMillis) {
        return new FlowBuilderBase<T>(new TumblingWindow((FlowFunction)this.eventStream, aggregateFunction, bucketSizeMillis));
    }

    public <S, R, F extends AggregateFlowFunction<T, R, F>> FlowBuilderBase<R> slidingAggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction, int bucketSizeMillis, int bucketsPerWindow) {
        return new FlowBuilderBase<T>(new TimedSlidingWindow((FlowFunction)this.eventStream, aggregateFunction, bucketSizeMillis, bucketsPerWindow));
    }

    public <V, K1, A, F extends AggregateFlowFunction<V, A, F>> GroupByFlowBuilder<K1, A> groupBy(LambdaReflection.SerializableFunction<T, K1> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier) {
        MapFlowFunction.MapRef2RefFlowFunction x = new MapFlowFunction.MapRef2RefFlowFunction((FlowFunction)this.eventStream, arg_0 -> ((GroupByFlowFunctionWrapper)new GroupByFlowFunctionWrapper(keyFunction, valueFunction, aggregateFunctionSupplier)).aggregate(arg_0));
        return new GroupByFlowBuilder(x);
    }

    public <V, K1> GroupByFlowBuilder<K1, V> groupBy(LambdaReflection.SerializableFunction<T, K1> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction) {
        return this.groupBy(keyFunction, valueFunction, Aggregates.identityFactory());
    }

    public <K> GroupByFlowBuilder<K, T> groupBy(LambdaReflection.SerializableFunction<T, K> keyFunction) {
        return this.groupBy(keyFunction, Mappers::identity);
    }

    public <V, K> GroupByFlowBuilder<K, List<T>> groupByAsList(LambdaReflection.SerializableFunction<T, K> keyFunction) {
        return this.groupBy(keyFunction, Mappers::identity, Collectors.listFactory());
    }

    public <V, K> GroupByFlowBuilder<K, List<T>> groupByAsList(LambdaReflection.SerializableFunction<T, K> keyFunction, int maxElementsInList) {
        return this.groupBy(keyFunction, Mappers::identity, Collectors.listFactory((int)maxElementsInList));
    }

    public <V, K, A, F extends AggregateFlowFunction<V, A, F>> GroupByFlowBuilder<K, A> groupByTumbling(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier, int bucketSizeMillis) {
        return new GroupByFlowBuilder(new GroupByTumblingWindow((FlowFunction)this.eventStream, aggregateFunctionSupplier, keyFunction, valueFunction, bucketSizeMillis));
    }

    public <V, K> GroupByFlowBuilder<K, V> groupByTumbling(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, int bucketSizeMillis) {
        return this.groupByTumbling(keyFunction, valueFunction, Aggregates.identityFactory(), bucketSizeMillis);
    }

    public <V, K, A, F extends AggregateFlowFunction<V, A, F>> GroupByFlowBuilder<K, A> groupBySliding(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier, int bucketSizeMillis, int numberOfBuckets) {
        return new GroupByFlowBuilder(new GroupByTimedSlidingWindow((FlowFunction)this.eventStream, aggregateFunctionSupplier, keyFunction, valueFunction, bucketSizeMillis, numberOfBuckets));
    }

    public <V, K> GroupByFlowBuilder<K, V> groupBySliding(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, int bucketSizeMillis, int numberOfBuckets) {
        return this.groupBySliding(keyFunction, valueFunction, Aggregates.identityFactory(), bucketSizeMillis, numberOfBuckets);
    }

    public <K, A, F extends AggregateFlowFunction<T, A, F>> GroupByFlowBuilder<K, A> groupBySliding(LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier, int bucketSizeMillis, int numberOfBuckets) {
        return new GroupByFlowBuilder(new GroupByTimedSlidingWindow((FlowFunction)this.eventStream, aggregateFunctionSupplier, keyFunction, Mappers::identity, bucketSizeMillis, numberOfBuckets));
    }

    public <I, Z extends FlowBuilderBase<I>> Z mapOnNotify(I target) {
        return (Z)((FlowBuilderBase)super.mapOnNotifyBase(target));
    }
}

