/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.builder.dataflow;

import com.fluxtion.compiler.builder.dataflow.DoubleFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.FlowBuilder;
import com.fluxtion.compiler.builder.dataflow.FlowDataSupplier;
import com.fluxtion.compiler.builder.dataflow.LongFlowBuilder;
import com.fluxtion.compiler.builder.dataflow.StreamHelper;
import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowSupplier;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateIntFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.TimedSlidingWindow;
import com.fluxtion.runtime.dataflow.aggregate.function.TumblingWindow;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.AggregateIntFlowFunctionWrapper;
import com.fluxtion.runtime.dataflow.function.BinaryMapFlowFunction;
import com.fluxtion.runtime.dataflow.function.FilterDynamicFlowFunction;
import com.fluxtion.runtime.dataflow.function.FilterFlowFunction;
import com.fluxtion.runtime.dataflow.function.MapFlowFunction;
import com.fluxtion.runtime.dataflow.function.MapOnNotifyFlowFunction;
import com.fluxtion.runtime.dataflow.function.NotifyFlowFunction;
import com.fluxtion.runtime.dataflow.function.PeekFlowFunction;
import com.fluxtion.runtime.dataflow.function.PushFlowFunction;
import com.fluxtion.runtime.dataflow.helpers.DefaultValue;
import com.fluxtion.runtime.dataflow.helpers.Peekers;
import com.fluxtion.runtime.output.SinkPublisher;
import com.fluxtion.runtime.partition.LambdaReflection;

public class IntFlowBuilder
implements FlowDataSupplier<IntFlowSupplier> {
    final IntFlowFunction eventStream;

    IntFlowBuilder(IntFlowFunction eventStream) {
        EventProcessorBuilderService.service().add((Object)eventStream);
        this.eventStream = eventStream;
    }

    @Override
    public IntFlowSupplier flowSupplier() {
        return this.eventStream;
    }

    public IntFlowBuilder parallel() {
        this.eventStream.parallel();
        return this;
    }

    public IntFlowBuilder updateTrigger(Object updateTrigger) {
        Object source = StreamHelper.getSource(updateTrigger);
        if (this.eventStream instanceof TriggeredFlowFunction) {
            TriggeredFlowFunction triggeredEventStream = (TriggeredFlowFunction)this.eventStream;
            triggeredEventStream.setUpdateTriggerNode(source);
        }
        return this;
    }

    public IntFlowBuilder publishTrigger(Object publishTrigger) {
        Object source = StreamHelper.getSource(publishTrigger);
        if (this.eventStream instanceof TriggeredFlowFunction) {
            TriggeredFlowFunction triggeredEventStream = (TriggeredFlowFunction)this.eventStream;
            triggeredEventStream.setPublishTriggerNode(source);
        }
        return this;
    }

    public IntFlowBuilder publishTriggerOverride(Object publishTrigger) {
        Object source = StreamHelper.getSource(publishTrigger);
        if (this.eventStream instanceof TriggeredFlowFunction) {
            TriggeredFlowFunction triggeredEventStream = (TriggeredFlowFunction)this.eventStream;
            triggeredEventStream.setPublishTriggerOverrideNode(source);
        }
        return this;
    }

    public IntFlowBuilder resetTrigger(Object resetTrigger) {
        Object source = StreamHelper.getSource(resetTrigger);
        if (this.eventStream instanceof TriggeredFlowFunction) {
            TriggeredFlowFunction triggeredEventStream = (TriggeredFlowFunction)this.eventStream;
            triggeredEventStream.setResetTriggerNode(source);
        }
        return this;
    }

    public IntFlowBuilder filter(LambdaReflection.SerializableIntFunction<Boolean> filterFunction) {
        return new IntFlowBuilder((IntFlowFunction)new FilterFlowFunction.IntFilterFlowFunction(this.eventStream, filterFunction));
    }

    public <S> IntFlowBuilder filter(LambdaReflection.SerializableBiIntPredicate predicate, IntFlowBuilder secondArgument) {
        return new IntFlowBuilder((IntFlowFunction)new FilterDynamicFlowFunction.IntFilterDynamicFlowFunction(this.eventStream, secondArgument.eventStream, predicate));
    }

    public IntFlowBuilder defaultValue(int defaultValue) {
        return this.map(arg_0 -> ((DefaultValue.DefaultInt)new DefaultValue.DefaultInt(defaultValue)).getOrDefault(arg_0));
    }

    public IntFlowBuilder map(LambdaReflection.SerializableIntUnaryOperator int2IntFunction) {
        return new IntFlowBuilder((IntFlowFunction)new MapFlowFunction.MapInt2ToIntFlowFunction(this.eventStream, int2IntFunction));
    }

    public IntFlowBuilder mapBiFunction(LambdaReflection.SerializableBiIntFunction int2IntFunction, IntFlowBuilder stream2Builder) {
        return new IntFlowBuilder((IntFlowFunction)new BinaryMapFlowFunction.BinaryMapToIntFlowFunction(this.eventStream, stream2Builder.eventStream, int2IntFunction));
    }

    public <F extends AggregateIntFlowFunction<F>> IntFlowBuilder aggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction) {
        return new IntFlowBuilder((IntFlowFunction)new AggregateIntFlowFunctionWrapper(this.eventStream, aggregateFunction));
    }

    public <F extends AggregateIntFlowFunction<F>> IntFlowBuilder tumblingAggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction, int bucketSizeMillis) {
        return new IntFlowBuilder((IntFlowFunction)new TumblingWindow.TumblingIntWindowStream(this.eventStream, aggregateFunction, bucketSizeMillis));
    }

    public <F extends AggregateIntFlowFunction<F>> IntFlowBuilder slidingAggregate(LambdaReflection.SerializableSupplier<F> aggregateFunction, int bucketSizeMillis, int numberOfBuckets) {
        return new IntFlowBuilder((IntFlowFunction)new TimedSlidingWindow.TimedSlidingWindowIntStream(this.eventStream, aggregateFunction, bucketSizeMillis, numberOfBuckets));
    }

    public <T> FlowBuilder<T> mapOnNotify(T target) {
        return new FlowBuilder(new MapOnNotifyFlowFunction((FlowFunction)this.eventStream, target));
    }

    public FlowBuilder<Integer> box() {
        return this.mapToObj(Integer::valueOf);
    }

    public <R> FlowBuilder<R> mapToObj(LambdaReflection.SerializableIntFunction<R> int2IntFunction) {
        return new FlowBuilder(new MapFlowFunction.MapInt2RefFlowFunction(this.eventStream, int2IntFunction));
    }

    public DoubleFlowBuilder mapToDouble(LambdaReflection.SerializableIntToDoubleFunction int2IntFunction) {
        return new DoubleFlowBuilder((DoubleFlowFunction)new MapFlowFunction.MapInt2ToDoubleFlowFunction(this.eventStream, int2IntFunction));
    }

    public LongFlowBuilder mapToLong(LambdaReflection.SerializableIntToLongFunction int2IntFunction) {
        return new LongFlowBuilder((LongFlowFunction)new MapFlowFunction.MapInt2ToLongFlowFunction(this.eventStream, int2IntFunction));
    }

    public IntFlowBuilder notify(Object target) {
        EventProcessorBuilderService.service().add(target);
        return new IntFlowBuilder((IntFlowFunction)new NotifyFlowFunction.IntNotifyFlowFunction(this.eventStream, target));
    }

    public IntFlowBuilder sink(String sinkId) {
        return this.push(arg_0 -> ((SinkPublisher)new SinkPublisher(sinkId)).publishInt(arg_0));
    }

    public IntFlowBuilder push(LambdaReflection.SerializableIntConsumer pushFunction) {
        if (pushFunction.captured().length > 0) {
            EventProcessorBuilderService.service().add(pushFunction.captured()[0]);
        }
        return new IntFlowBuilder((IntFlowFunction)new PushFlowFunction.IntPushFlowFunction(this.eventStream, pushFunction));
    }

    public IntFlowBuilder peek(LambdaReflection.SerializableConsumer<Integer> peekFunction) {
        return new IntFlowBuilder((IntFlowFunction)new PeekFlowFunction.IntPeekFlowFunction(this.eventStream, peekFunction));
    }

    public IntFlowBuilder console(String in) {
        this.peek((LambdaReflection.SerializableConsumer<Integer>)Peekers.console((String)in));
        return this;
    }

    public IntFlowBuilder console() {
        return this.console("{}");
    }

    public IntFlowBuilder id(String nodeId) {
        EventProcessorBuilderService.service().add((Object)this.eventStream, nodeId);
        return this;
    }
}

