/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.builder.factory;

import com.fluxtion.compiler.builder.factory.NodeFactory;
import com.fluxtion.compiler.generation.GenerationContext;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeFactoryLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeFactoryLocator.class);

    public static Set<Class<? extends NodeFactory<?>>> nodeFactorySet() {
        ServiceLoader<NodeFactory> loadServices;
        LOGGER.debug("NodeFactory locator");
        HashSet subTypes = new HashSet();
        Class<NodeFactory> clazz = NodeFactory.class;
        if (GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getClassLoader() != null) {
            LOGGER.debug("using custom class loader to search for factories");
            loadServices = ServiceLoader.load(clazz, GenerationContext.SINGLETON.getClassLoader());
        } else {
            loadServices = ServiceLoader.load(clazz);
        }
        loadServices.forEach(t -> subTypes.add(t.getClass()));
        LOGGER.debug("loaded NodeFactory services:{}", subTypes);
        return subTypes;
    }
}

