/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.builder.filter;

import com.fluxtion.compiler.builder.filter.FilterDescription;
import com.fluxtion.compiler.builder.filter.FilterDescriptionProducer;
import com.fluxtion.compiler.generation.GenerationContext;
import com.fluxtion.runtime.event.Event;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilterDescriptionProducer
implements FilterDescriptionProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFilterDescriptionProducer.class);
    private ArrayList<FilterDescriptionProducer> namingStrategies;

    public DefaultFilterDescriptionProducer() {
        this.loadServices();
    }

    public final void loadServices() {
        ServiceLoader<FilterDescriptionProducer> loadServices;
        LOGGER.debug("DefaultFilterDescriptionProducer (re)loading strategies");
        this.namingStrategies = new ArrayList();
        if (GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getClassLoader() != null) {
            LOGGER.debug("using custom class loader to search for NodeNameProducer");
            loadServices = ServiceLoader.load(FilterDescriptionProducer.class, GenerationContext.SINGLETON.getClassLoader());
        } else {
            loadServices = ServiceLoader.load(FilterDescriptionProducer.class);
        }
        loadServices.forEach(this.namingStrategies::add);
        LOGGER.debug("sorted FilterDescriptionProducer strategies : {}", this.namingStrategies);
    }

    @Override
    public FilterDescription getFilterDescription(Class<? extends Event> event, int filterId) {
        FilterDescription filterDescription = FilterDescriptionProducer.super.getFilterDescription(event, filterId);
        filterDescription.comment = "Event Class:[" + event.getCanonicalName() + "] filterId:[" + filterId + "]";
        for (FilterDescriptionProducer namingStrategy : this.namingStrategies) {
            String commnent = namingStrategy.getFilterDescription(event, (int)filterId).comment;
            if (commnent == null) continue;
            filterDescription.comment = commnent;
            break;
        }
        return filterDescription;
    }

    @Override
    public FilterDescription getFilterDescription(Class<? extends Event> event, String filterId) {
        FilterDescription filterDescription = FilterDescriptionProducer.super.getFilterDescription(event, filterId);
        filterDescription.comment = "Event Class:[" + event.getCanonicalName() + "] filterString:[" + filterId + "]";
        for (FilterDescriptionProducer namingStrategy : this.namingStrategies) {
            String commnent = namingStrategy.getFilterDescription(event, (String)filterId).comment;
            if (commnent == null) continue;
            filterDescription.comment = commnent;
            break;
        }
        return filterDescription;
    }
}

