/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.builder.filter;

import com.fluxtion.runtime.event.Event;
import java.lang.reflect.Method;
import java.util.Objects;

public class FilterDescription {
    public static final FilterDescription NO_FILTER = new FilterDescription("NO_FILTER");
    public static final FilterDescription INVERSE_FILTER = new FilterDescription("INVERSE_FILTER");
    public static final FilterDescription DEFAULT_FILTER = new FilterDescription("DEFAULT");
    public final int value;
    public final String stringValue;
    private final String nullId;
    public final boolean isIntFilter;
    public boolean isFiltered;
    public Class<? extends Event> eventClass;
    public String comment;
    public String variableName;
    private Method exportFunction;

    public static FilterDescription build(Object input) {
        FilterDescription result = DEFAULT_FILTER;
        if (input instanceof Event) {
            Event event = (Event)input;
            result = event.filterId() != Integer.MAX_VALUE ? new FilterDescription(event.getClass(), event.filterId()) : (event.filterString() != null && !event.filterString().isEmpty() ? new FilterDescription(event.getClass(), event.filterString()) : new FilterDescription(event.getClass()));
        }
        return result;
    }

    public FilterDescription(Class<? extends Event> eventClass) {
        this.value = 0;
        this.eventClass = eventClass;
        this.stringValue = "";
        this.isIntFilter = true;
        this.isFiltered = false;
        this.nullId = "";
    }

    public FilterDescription(Class<? extends Event> eventClass, int value) {
        this.value = value;
        this.eventClass = eventClass;
        this.stringValue = "";
        this.isIntFilter = true;
        this.isFiltered = true;
        this.nullId = "";
    }

    public FilterDescription(Class<? extends Event> eventClass, String value) {
        this.stringValue = value;
        this.eventClass = eventClass;
        this.isIntFilter = false;
        this.isFiltered = true;
        this.value = 0;
        this.nullId = "";
    }

    public FilterDescription changeClass(Class<? extends Event> newClass) {
        FilterDescription fd = new FilterDescription(newClass, this.stringValue);
        if (!this.isFiltered) {
            fd = new FilterDescription(newClass);
        } else if (this.isIntFilter) {
            fd = new FilterDescription(newClass, this.value);
        } else {
            if (this == NO_FILTER) {
                return NO_FILTER;
            }
            if (this == INVERSE_FILTER) {
                return INVERSE_FILTER;
            }
            if (this == DEFAULT_FILTER) {
                return DEFAULT_FILTER;
            }
        }
        return fd;
    }

    private FilterDescription(String value) {
        this.stringValue = "";
        this.eventClass = null;
        this.isIntFilter = false;
        this.isFiltered = true;
        this.value = 0;
        this.nullId = value;
    }

    public int getValue() {
        return this.value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String getNullId() {
        return this.nullId;
    }

    public boolean isIntFilter() {
        return this.isIntFilter;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public Class<? extends Event> getEventClass() {
        return this.eventClass;
    }

    public String getComment() {
        return this.comment;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setEventClass(Class<? extends Event> eventClass) {
        this.eventClass = eventClass;
    }

    public void setExportFunction(Method exportFunction) {
        this.exportFunction = exportFunction;
    }

    public Method getExportFunction() {
        return this.exportFunction;
    }

    public int hashCode() {
        int hash = 5;
        hash = this.isIntFilter ? 89 * hash + this.value : 89 * hash + Objects.hashCode(this.stringValue);
        hash = 89 * hash + (this.isIntFilter ? 1 : 0);
        hash = 89 * hash + Objects.hashCode(this.eventClass);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterDescription other = (FilterDescription)obj;
        if (this.isIntFilter && this.value != other.value) {
            return false;
        }
        if (!this.isIntFilter && !Objects.equals(this.stringValue, other.stringValue)) {
            return false;
        }
        if (this.isIntFilter != other.isIntFilter) {
            return false;
        }
        if (!Objects.equals(this.nullId, other.nullId)) {
            return false;
        }
        return Objects.equals(this.eventClass, other.eventClass);
    }

    public String toString() {
        return "FilterDescription(value=" + this.getValue() + ", stringValue=" + this.getStringValue() + ", nullId=" + this.getNullId() + ", isIntFilter=" + this.isIntFilter() + ", isFiltered=" + this.isFiltered() + ", eventClass=" + this.getEventClass() + ", comment=" + this.getComment() + ", variableName=" + this.getVariableName() + ", exportFunction=" + this.getExportFunction() + ")";
    }
}

