/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.extern.spring;

import com.fluxtion.compiler.EventProcessorConfig;
import com.fluxtion.compiler.Fluxtion;
import com.fluxtion.compiler.FluxtionCompilerConfig;
import com.fluxtion.compiler.extern.spring.FluxtionSpringConfig;
import com.fluxtion.runtime.EventProcessor;
import com.fluxtion.runtime.audit.Auditor;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.util.ClassUtils;

public class FluxtionSpring {
    private static final Logger LOGGER = LoggerFactory.getLogger(FluxtionSpring.class);
    private final ApplicationContext context;
    private Consumer<EventProcessorConfig> configCustomizer;

    public FluxtionSpring(String springFile) {
        this((ApplicationContext)new FileSystemXmlApplicationContext(springFile));
        LOGGER.debug("loading spring springFile:{}", (Object)springFile);
    }

    public FluxtionSpring(String springFile, Consumer<EventProcessorConfig> configCustomizer) {
        this((ApplicationContext)new FileSystemXmlApplicationContext(springFile), configCustomizer);
        LOGGER.debug("loading spring springFile:{}", (Object)springFile);
    }

    public FluxtionSpring(ApplicationContext context, Consumer<EventProcessorConfig> configCustomizer) {
        this.configCustomizer = c -> {};
        this.context = context;
        this.configCustomizer = configCustomizer;
    }

    public FluxtionSpring(ApplicationContext context) {
        this.configCustomizer = c -> {};
        this.context = context;
    }

    public static EventProcessor<?> compileAot(File springFile, String className, String packageName) {
        return new FluxtionSpring(springFile.toURI().toString())._compileAot((LambdaReflection.SerializableConsumer<FluxtionCompilerConfig>)(LambdaReflection.SerializableConsumer & Serializable)c -> {
            c.setClassName(className);
            c.setPackageName(packageName);
        });
    }

    public static EventProcessor<?> compileAot(ClassLoader classLoader, File springFile, String className, String packageName) {
        ClassUtils.overrideThreadContextClassLoader((ClassLoader)classLoader);
        return new FluxtionSpring(springFile.toURI().toString())._compileAot((LambdaReflection.SerializableConsumer<FluxtionCompilerConfig>)(LambdaReflection.SerializableConsumer & Serializable)c -> {
            String overrideResourceDirectory;
            c.setClassName(className);
            c.setPackageName(packageName);
            c.setCompileSource(false);
            String overrideOutputDirectory = System.getProperty("FLUXTION.OUTPUT.DIRECTORY");
            if (overrideOutputDirectory != null && !overrideOutputDirectory.isEmpty()) {
                c.setOutputDirectory(overrideOutputDirectory);
            }
            if ((overrideResourceDirectory = System.getProperty("FLUXTION.RESOURCES.DIRECTORY")) != null && !overrideResourceDirectory.isEmpty()) {
                c.setResourcesOutputDirectory(overrideResourceDirectory);
            }
        });
    }

    public static EventProcessor<?> compileAot(Path springFile, LambdaReflection.SerializableConsumer<FluxtionCompilerConfig> compilerConfig) {
        FluxtionSpring fluxtionSpring = new FluxtionSpring(springFile.toAbsolutePath().toUri().toString());
        return fluxtionSpring._compileAot(compilerConfig);
    }

    public static EventProcessor<?> compileAot(Path springFile, Consumer<EventProcessorConfig> configCustomizer, LambdaReflection.SerializableConsumer<FluxtionCompilerConfig> compilerConfig) {
        return new FluxtionSpring(springFile.toAbsolutePath().toUri().toString(), configCustomizer)._compileAot(compilerConfig);
    }

    public static EventProcessor<?> compileAot(ApplicationContext context, LambdaReflection.SerializableConsumer<FluxtionCompilerConfig> compilerConfig) {
        return new FluxtionSpring(context)._compileAot(compilerConfig);
    }

    public static EventProcessor<?> compileAot(ApplicationContext context, String className, String packageName) {
        return new FluxtionSpring(context)._compileAot((LambdaReflection.SerializableConsumer<FluxtionCompilerConfig>)(LambdaReflection.SerializableConsumer & Serializable)c -> {
            c.setClassName(className);
            c.setPackageName(packageName);
        });
    }

    public static EventProcessor<?> compileAot(ApplicationContext context, Consumer<EventProcessorConfig> configCustomizer, LambdaReflection.SerializableConsumer<FluxtionCompilerConfig> compilerConfig) {
        return new FluxtionSpring(context, configCustomizer)._compileAot(compilerConfig);
    }

    public static EventProcessor<?> compile(Path springFile) {
        FluxtionSpring fluxtionSpring = new FluxtionSpring(springFile.toAbsolutePath().toUri().toString());
        return fluxtionSpring._compile();
    }

    public static EventProcessor<?> compile(Path springFile, Consumer<EventProcessorConfig> configCustomizer) {
        return new FluxtionSpring(springFile.toAbsolutePath().toUri().toString(), configCustomizer)._compile();
    }

    public static EventProcessor<?> compile(ApplicationContext context) {
        return new FluxtionSpring(context)._compile();
    }

    public static EventProcessor<?> compile(ApplicationContext context, Consumer<EventProcessorConfig> configCustomizer) {
        return new FluxtionSpring(context, configCustomizer)._compile();
    }

    public static EventProcessor<?> interpret(Path springFile) {
        FluxtionSpring fluxtionSpring = new FluxtionSpring(springFile.toAbsolutePath().toUri().toString());
        return fluxtionSpring._interpret();
    }

    public static EventProcessor<?> interpret(Path springFile, Consumer<EventProcessorConfig> configCustomizer) {
        return new FluxtionSpring(springFile.toAbsolutePath().toUri().toString(), configCustomizer)._interpret();
    }

    public static EventProcessor<?> interpret(ApplicationContext context) {
        return new FluxtionSpring(context)._interpret();
    }

    public static EventProcessor<?> interpret(ApplicationContext context, Consumer<EventProcessorConfig> configCustomizer) {
        return new FluxtionSpring(context, configCustomizer)._interpret();
    }

    private EventProcessor<?> _compileAot(LambdaReflection.SerializableConsumer<FluxtionCompilerConfig> compilerConfig) {
        return Fluxtion.compile((LambdaReflection.SerializableConsumer<EventProcessorConfig>)((LambdaReflection.SerializableConsumer & Serializable)this::addNodes), compilerConfig);
    }

    private EventProcessor<?> _compile() {
        return Fluxtion.compile((LambdaReflection.SerializableConsumer<EventProcessorConfig>)((LambdaReflection.SerializableConsumer & Serializable)this::addNodes));
    }

    private EventProcessor<?> _interpret() {
        return Fluxtion.interpret((LambdaReflection.SerializableConsumer<EventProcessorConfig>)((LambdaReflection.SerializableConsumer & Serializable)this::addNodes));
    }

    private void addNodes(EventProcessorConfig config) {
        Object bean;
        LOGGER.debug("loading spring context:{}", (Object)this.context);
        ArrayList<Auditor> auditorMap = new ArrayList<Auditor>();
        for (String beanDefinitionName : this.context.getBeanDefinitionNames()) {
            bean = this.context.getBean(beanDefinitionName);
            if (!(bean instanceof FluxtionSpringConfig)) continue;
            FluxtionSpringConfig springConfig = (FluxtionSpringConfig)bean;
            auditorMap.addAll(springConfig.getAuditors());
            config.addEventAudit(springConfig.getLogLevel());
        }
        for (String beanDefinitionName : this.context.getBeanDefinitionNames()) {
            bean = this.context.getBean(beanDefinitionName);
            if (bean instanceof FluxtionSpringConfig) continue;
            if (bean instanceof Auditor && auditorMap.contains(bean)) {
                LOGGER.debug("adding auditor:{} to fluxtion", (Object)beanDefinitionName);
                config.addAuditor((Auditor)bean, beanDefinitionName);
                continue;
            }
            LOGGER.debug("adding bean:{} to fluxtion", (Object)beanDefinitionName);
            config.addNode(bean, beanDefinitionName);
        }
        this.configCustomizer.accept(config);
    }
}

