/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation;

import com.fluxtion.compiler.EventProcessorConfig;
import com.fluxtion.compiler.FluxtionCompilerConfig;
import com.fluxtion.compiler.RootNodeConfig;
import com.fluxtion.compiler.generation.GenerationContext;
import com.fluxtion.compiler.generation.compiler.EventProcessorCompilation;
import com.fluxtion.compiler.generation.compiler.EventProcessorGenerator;
import com.fluxtion.compiler.generation.targets.InMemoryEventProcessor;
import com.fluxtion.runtime.EventProcessor;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.io.File;
import java.io.Serializable;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(EventProcessorFactory.class);

    public static InMemoryEventProcessor interpreted(LambdaReflection.SerializableConsumer<EventProcessorConfig> cfgBuilder) {
        return EventProcessorFactory.interpreted(cfgBuilder, false);
    }

    public static InMemoryEventProcessor interpreted(LambdaReflection.SerializableConsumer<EventProcessorConfig> cfgBuilder, boolean generateDescription) {
        EventProcessorConfig cfg = new EventProcessorConfig();
        String pkg = (cfgBuilder.getContainingClass().getCanonicalName() + "." + cfgBuilder.method().getName()).toLowerCase();
        GenerationContext.setupStaticContext(pkg, "Processor", new File("target/generated-sources/fluxtion/"), new File("src/main/resources/"));
        cfgBuilder.accept((Object)cfg);
        return new EventProcessorGenerator().inMemoryProcessor(cfg, generateDescription);
    }

    public static InMemoryEventProcessor interpreted(RootNodeConfig rootNode) {
        return EventProcessorFactory.interpreted((LambdaReflection.SerializableConsumer<EventProcessorConfig>)(LambdaReflection.SerializableConsumer & Serializable)cfg -> cfg.setRootNodeConfig(rootNode));
    }

    public static InMemoryEventProcessor interpreted(RootNodeConfig rootNode, boolean generateDescription) {
        return EventProcessorFactory.interpreted((LambdaReflection.SerializableConsumer<EventProcessorConfig>)(LambdaReflection.SerializableConsumer & Serializable)cfg -> cfg.setRootNodeConfig(rootNode), generateDescription);
    }

    public static InMemoryEventProcessor interpretedTest(LambdaReflection.SerializableConsumer<EventProcessorConfig> cfgBuilder) {
        EventProcessorConfig cfg = new EventProcessorConfig();
        cfgBuilder.accept((Object)cfg);
        EventProcessorGenerator eventProcessorGenerator = new EventProcessorGenerator();
        String pkg = (cfgBuilder.getContainingClass().getCanonicalName() + "." + cfgBuilder.method().getName()).toLowerCase();
        GenerationContext.setupStaticContext(pkg, "Processor", new File("target/generated-test-sources/fluxtion/"), new File("target/generated-test-sources/resources/"));
        return eventProcessorGenerator.inMemoryProcessor(cfg, false);
    }

    public static EventProcessor compile(LambdaReflection.SerializableConsumer<EventProcessorConfig> builder) throws Exception {
        String name = "Processor";
        String pkg = (builder.getContainingClass().getCanonicalName() + "." + builder.method().getName()).toLowerCase();
        return EventProcessorFactory.compile(name, pkg, builder);
    }

    public static EventProcessor compile(RootNodeConfig rootNode) throws Exception {
        LambdaReflection.SerializableConsumer & Serializable builder = (LambdaReflection.SerializableConsumer & Serializable)cfg -> cfg.setRootNodeConfig(rootNode);
        String name = "Processor";
        String pkg = (rootNode.getClass().getCanonicalName() + "." + rootNode.getName()).toLowerCase();
        return EventProcessorFactory.compile(pkg, name, (Consumer<EventProcessorConfig>)builder);
    }

    public static EventProcessor compile(RootNodeConfig rootNode, LambdaReflection.SerializableConsumer<FluxtionCompilerConfig> cfgBuilder) {
        LambdaReflection.SerializableConsumer & Serializable builder = (LambdaReflection.SerializableConsumer & Serializable)cfg -> cfg.setRootNodeConfig(rootNode);
        return EventProcessorFactory.compile((LambdaReflection.SerializableConsumer<EventProcessorConfig>)builder, cfgBuilder);
    }

    public static EventProcessor compileTestInstance(Consumer<EventProcessorConfig> cfgBuilder, String pckg, String sepName, boolean writeSourceFile, boolean generateMetaInformation) throws Exception {
        return EventProcessorFactory.compile(cfgBuilder, pckg, sepName, "target/generated-test-sources/fluxtion/", "target/generated-test-sources/resources/", false, writeSourceFile, generateMetaInformation);
    }

    public static EventProcessor compile(String name, String pkg, Consumer<EventProcessorConfig> builder) throws Exception {
        return EventProcessorFactory.compile(builder, pkg, name, "src/main/java/", "src/main/resources/", false, false, false);
    }

    public static EventProcessor compile(Consumer<EventProcessorConfig> cfgBuilder, String packageName, String className, String srcGenDir, String resGenDir, boolean initialise, boolean writeSourceFile, boolean generateMetaInformation) throws InstantiationException, IllegalAccessException, Exception {
        EventProcessorCompilation compiler = new EventProcessorCompilation();
        FluxtionCompilerConfig compilerCfg = new FluxtionCompilerConfig();
        compilerCfg.setOutputDirectory(new File(srcGenDir).getCanonicalPath());
        compilerCfg.setResourcesOutputDirectory(new File(resGenDir).getCanonicalPath());
        compilerCfg.setPackageName(packageName);
        compilerCfg.setClassName(className);
        compilerCfg.setWriteSourceToFile(writeSourceFile);
        compilerCfg.setFormatSource(writeSourceFile);
        compilerCfg.setGenerateDescription(generateMetaInformation);
        Class sepClass = compiler.compile(compilerCfg, new InProcessEventProcessorConfig(cfgBuilder));
        EventProcessor sep = (EventProcessor)sepClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (initialise) {
            sep.init();
        }
        return sep;
    }

    public static EventProcessor compile(LambdaReflection.SerializableConsumer<EventProcessorConfig> sepConfig, LambdaReflection.SerializableConsumer<FluxtionCompilerConfig> cfgBuilder) throws Exception {
        String className = "Processor";
        String packageName = (cfgBuilder.getContainingClass().getCanonicalName() + "." + cfgBuilder.method().getName()).toLowerCase();
        FluxtionCompilerConfig fluxtionCompilerConfig = new FluxtionCompilerConfig();
        fluxtionCompilerConfig.setOutputDirectory(new File("src/main/java/").getCanonicalPath());
        fluxtionCompilerConfig.setResourcesOutputDirectory(new File("src/main/resources/").getCanonicalPath());
        fluxtionCompilerConfig.setPackageName(packageName);
        fluxtionCompilerConfig.setClassName(className);
        fluxtionCompilerConfig.setWriteSourceToFile(true);
        fluxtionCompilerConfig.setFormatSource(true);
        fluxtionCompilerConfig.setGenerateDescription(true);
        cfgBuilder.accept((Object)fluxtionCompilerConfig);
        EventProcessorCompilation compiler = new EventProcessorCompilation();
        Class sepClass = compiler.compile(fluxtionCompilerConfig, new InProcessEventProcessorConfig((Consumer<EventProcessorConfig>)sepConfig));
        return sepClass == null ? null : (EventProcessor)sepClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static EventProcessor compile(EventProcessorConfig eventProcessorConfig, FluxtionCompilerConfig fluxtionCompilerConfig) throws Exception {
        EventProcessorCompilation compiler = new EventProcessorCompilation();
        Class sepClass = compiler.compile(fluxtionCompilerConfig, eventProcessorConfig);
        return fluxtionCompilerConfig.isCompileSource() ? (EventProcessor)sepClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
    }

    private static class InProcessEventProcessorConfig
    extends EventProcessorConfig {
        private final Consumer<EventProcessorConfig> cfg;

        public InProcessEventProcessorConfig(Consumer<EventProcessorConfig> cfg) {
            this.cfg = cfg;
        }

        @Override
        public void buildConfig() {
            this.cfg.accept(this);
        }
    }
}

