/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation;

import com.fluxtion.runtime.callback.InstanceCallbackEvent;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerationContext {
    private static final Logger log = LoggerFactory.getLogger(GenerationContext.class);
    public static GenerationContext SINGLETON;
    public static ClassLoader DEFAULT_CLASSLOADER;
    private static final AtomicInteger COUNT;
    private final Map<? super Object, Map> cacheMap;
    private final Map<Object, String> proxyClassMap = new HashMap<Object, String>();
    private final List<Object> nodeList = new ArrayList<Object>();
    private final Map<Object, String> publicNodes = new HashMap<Object, String>();
    private final ClassLoader classLoader;
    private final String packageName;
    private final String sepClassName;
    private final File sourceRootDirectory;
    private File packageDirectory;
    public File resourcesRootDirectory;
    public File resourcesOutputDirectory;

    public static int nextId() {
        return COUNT.getAndIncrement();
    }

    public int nextId(String className) {
        Map classCount = this.cacheMap.computeIfAbsent(X.class, k -> new HashMap());
        String key = this.packageName + "." + className;
        return classCount.compute(key, (k, v) -> {
            int ret = 0;
            if (v != null) {
                ret = v + 1;
            }
            return ret;
        });
    }

    public static void setupStaticContext(String packageName, String className, File outputDirectory, File resourcesRootDirectory) {
        GenerationContext.setupStaticContext(packageName, className, outputDirectory, resourcesRootDirectory, false);
    }

    public static void setupStaticContext(String packageName, String className, File outputDirectory, File resourcesRootDirectory, boolean createResourceDirectory) {
        File buildDir = null;
        if (!System.getProperty("fluxtion.build.outputdirectory", "").isEmpty()) {
            buildDir = new File(System.getProperty("fluxtion.build.outputdirectory", ""));
        }
        SINGLETON = new GenerationContext(packageName, className, outputDirectory, resourcesRootDirectory, buildDir);
        SINGLETON.createDirectories();
        if (createResourceDirectory) {
            SINGLETON.createResourceDirectory();
        }
    }

    public static void setupStaticContext(ClassLoader classLoader, String packageName, String className, File outputDirectory, File resourcesRootDirectory, boolean createResourceDirectory, File buildOutputDirectory, boolean createBuildOutputDirectory) {
        SINGLETON = new GenerationContext(classLoader, packageName, className, outputDirectory, resourcesRootDirectory, buildOutputDirectory);
        SINGLETON.createDirectories();
        if (createResourceDirectory) {
            SINGLETON.createResourceDirectory();
        }
        if (createBuildOutputDirectory && buildOutputDirectory != null) {
            buildOutputDirectory.mkdirs();
        }
    }

    public GenerationContext(String packageName, String sepClassName, File outputDirectory, File resourcesRootDirectory) {
        this(packageName, sepClassName, outputDirectory, resourcesRootDirectory, null);
    }

    private GenerationContext(String packageName, String sepClassName, File outputDirectory, File resourcesRootDirectory, File buildOutputDirectory) {
        this.packageName = packageName;
        this.sepClassName = sepClassName;
        this.sourceRootDirectory = outputDirectory;
        this.resourcesRootDirectory = resourcesRootDirectory;
        if (DEFAULT_CLASSLOADER == null) {
            log.debug("DEFAULT_CLASSLOADER is null using this classloader");
            this.classLoader = this.getClass().getClassLoader();
        } else {
            log.debug("DEFAULT_CLASSLOADER is classloader");
            this.classLoader = DEFAULT_CLASSLOADER;
        }
        log.info("classloader:{}", (Object)this.classLoader);
        log.debug("built GenerationContext: {}", (Object)this);
        this.cacheMap = new HashMap<Object, Map>();
        InstanceCallbackEvent.reset();
    }

    private GenerationContext(ClassLoader classLoasder, String packageName, String sepClassName, File outputDirectory, File resourcesRootDirectory, File buildOutputDirectory) {
        this.packageName = packageName;
        this.sepClassName = sepClassName;
        this.sourceRootDirectory = outputDirectory;
        this.resourcesRootDirectory = resourcesRootDirectory;
        this.classLoader = classLoasder;
        this.cacheMap = new HashMap<Object, Map>();
        InstanceCallbackEvent.reset();
        log.debug("built GenerationContext: {}", (Object)this);
    }

    private void createDirectories() {
        this.packageDirectory = new File(GenerationContext.SINGLETON.sourceRootDirectory, this.packageName.replace(".", "/"));
        this.resourcesOutputDirectory = new File(this.resourcesRootDirectory, this.packageName.replace(".", "/"));
    }

    public void createResourceDirectory() {
        this.resourcesOutputDirectory = new File(this.resourcesRootDirectory, this.packageName.replace(".", "/"));
    }

    public List<Object> getNodeList() {
        return this.nodeList;
    }

    public <T> T addOrUseExistingNode(T node) {
        if (this.getNodeList().contains(node)) {
            return (T)this.getNodeList().get(this.getNodeList().indexOf(node));
        }
        this.getNodeList().add(node);
        return node;
    }

    public <K, V> Map<K, V> getCache(Object key) {
        return this.cacheMap.computeIfAbsent(key, k -> new HashMap());
    }

    public <T> T nameNode(T node, String name) {
        this.publicNodes.put(node, name);
        return node;
    }

    public <K, V> Map<K, V> removeCache(Object key) {
        return this.cacheMap.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(@NotNull String resourceName) throws IOException {
        StringWriter sw = new StringWriter();
        InputStreamReader isr = new InputStreamReader(GenerationContext.getInputStream(resourceName), StandardCharsets.UTF_8);
        try {
            int len;
            char[] chars = new char[8192];
            while ((len = isr.read(chars)) > 0) {
                sw.write(chars, 0, len);
            }
        }
        finally {
            GenerationContext.close(isr);
        }
        return sw.toString();
    }

    private static void close(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                System.err.println("Failed to close " + closeable + e.getMessage());
            }
        }
    }

    private static InputStream getInputStream(@NotNull String filename) throws IOException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            InputStream is = contextClassLoader.getResourceAsStream(filename);
            if (is != null) {
                return is;
            }
            InputStream is2 = contextClassLoader.getResourceAsStream('/' + filename);
            if (is2 != null) {
                return is2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
    }

    public Map<? super Object, Map> getCacheMap() {
        return this.cacheMap;
    }

    public Map<Object, String> getProxyClassMap() {
        return this.proxyClassMap;
    }

    public Map<Object, String> getPublicNodes() {
        return this.publicNodes;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSepClassName() {
        return this.sepClassName;
    }

    public File getSourceRootDirectory() {
        return this.sourceRootDirectory;
    }

    public File getPackageDirectory() {
        return this.packageDirectory;
    }

    public File getResourcesRootDirectory() {
        return this.resourcesRootDirectory;
    }

    public File getResourcesOutputDirectory() {
        return this.resourcesOutputDirectory;
    }

    public void setPackageDirectory(File packageDirectory) {
        this.packageDirectory = packageDirectory;
    }

    public void setResourcesRootDirectory(File resourcesRootDirectory) {
        this.resourcesRootDirectory = resourcesRootDirectory;
    }

    public void setResourcesOutputDirectory(File resourcesOutputDirectory) {
        this.resourcesOutputDirectory = resourcesOutputDirectory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenerationContext)) {
            return false;
        }
        GenerationContext other = (GenerationContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<? super Object, Map> this$cacheMap = this.getCacheMap();
        Map<? super Object, Map> other$cacheMap = other.getCacheMap();
        if (this$cacheMap == null ? other$cacheMap != null : !((Object)this$cacheMap).equals(other$cacheMap)) {
            return false;
        }
        Map<Object, String> this$proxyClassMap = this.getProxyClassMap();
        Map<Object, String> other$proxyClassMap = other.getProxyClassMap();
        if (this$proxyClassMap == null ? other$proxyClassMap != null : !((Object)this$proxyClassMap).equals(other$proxyClassMap)) {
            return false;
        }
        List<Object> this$nodeList = this.getNodeList();
        List<Object> other$nodeList = other.getNodeList();
        if (this$nodeList == null ? other$nodeList != null : !((Object)this$nodeList).equals(other$nodeList)) {
            return false;
        }
        Map<Object, String> this$publicNodes = this.getPublicNodes();
        Map<Object, String> other$publicNodes = other.getPublicNodes();
        if (this$publicNodes == null ? other$publicNodes != null : !((Object)this$publicNodes).equals(other$publicNodes)) {
            return false;
        }
        ClassLoader this$classLoader = this.getClassLoader();
        ClassLoader other$classLoader = other.getClassLoader();
        if (this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$sepClassName = this.getSepClassName();
        String other$sepClassName = other.getSepClassName();
        if (this$sepClassName == null ? other$sepClassName != null : !this$sepClassName.equals(other$sepClassName)) {
            return false;
        }
        File this$sourceRootDirectory = this.getSourceRootDirectory();
        File other$sourceRootDirectory = other.getSourceRootDirectory();
        if (this$sourceRootDirectory == null ? other$sourceRootDirectory != null : !((Object)this$sourceRootDirectory).equals(other$sourceRootDirectory)) {
            return false;
        }
        File this$packageDirectory = this.getPackageDirectory();
        File other$packageDirectory = other.getPackageDirectory();
        if (this$packageDirectory == null ? other$packageDirectory != null : !((Object)this$packageDirectory).equals(other$packageDirectory)) {
            return false;
        }
        File this$resourcesRootDirectory = this.getResourcesRootDirectory();
        File other$resourcesRootDirectory = other.getResourcesRootDirectory();
        if (this$resourcesRootDirectory == null ? other$resourcesRootDirectory != null : !((Object)this$resourcesRootDirectory).equals(other$resourcesRootDirectory)) {
            return false;
        }
        File this$resourcesOutputDirectory = this.getResourcesOutputDirectory();
        File other$resourcesOutputDirectory = other.getResourcesOutputDirectory();
        return !(this$resourcesOutputDirectory == null ? other$resourcesOutputDirectory != null : !((Object)this$resourcesOutputDirectory).equals(other$resourcesOutputDirectory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenerationContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<? super Object, Map> $cacheMap = this.getCacheMap();
        result = result * 59 + ($cacheMap == null ? 43 : ((Object)$cacheMap).hashCode());
        Map<Object, String> $proxyClassMap = this.getProxyClassMap();
        result = result * 59 + ($proxyClassMap == null ? 43 : ((Object)$proxyClassMap).hashCode());
        List<Object> $nodeList = this.getNodeList();
        result = result * 59 + ($nodeList == null ? 43 : ((Object)$nodeList).hashCode());
        Map<Object, String> $publicNodes = this.getPublicNodes();
        result = result * 59 + ($publicNodes == null ? 43 : ((Object)$publicNodes).hashCode());
        ClassLoader $classLoader = this.getClassLoader();
        result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $sepClassName = this.getSepClassName();
        result = result * 59 + ($sepClassName == null ? 43 : $sepClassName.hashCode());
        File $sourceRootDirectory = this.getSourceRootDirectory();
        result = result * 59 + ($sourceRootDirectory == null ? 43 : ((Object)$sourceRootDirectory).hashCode());
        File $packageDirectory = this.getPackageDirectory();
        result = result * 59 + ($packageDirectory == null ? 43 : ((Object)$packageDirectory).hashCode());
        File $resourcesRootDirectory = this.getResourcesRootDirectory();
        result = result * 59 + ($resourcesRootDirectory == null ? 43 : ((Object)$resourcesRootDirectory).hashCode());
        File $resourcesOutputDirectory = this.getResourcesOutputDirectory();
        result = result * 59 + ($resourcesOutputDirectory == null ? 43 : ((Object)$resourcesOutputDirectory).hashCode());
        return result;
    }

    public String toString() {
        return "GenerationContext(cacheMap=" + this.getCacheMap() + ", proxyClassMap=" + this.getProxyClassMap() + ", nodeList=" + this.getNodeList() + ", publicNodes=" + this.getPublicNodes() + ", classLoader=" + this.getClassLoader() + ", packageName=" + this.getPackageName() + ", sepClassName=" + this.getSepClassName() + ", sourceRootDirectory=" + this.getSourceRootDirectory() + ", packageDirectory=" + this.getPackageDirectory() + ", resourcesRootDirectory=" + this.getResourcesRootDirectory() + ", resourcesOutputDirectory=" + this.getResourcesOutputDirectory() + ")";
    }

    static {
        COUNT = new AtomicInteger();
    }

    private static class X {
        private X() {
        }
    }
}

