/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation;

import com.fluxtion.compiler.generation.DirOptions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class OutputRegistry {
    private static final Logger log = Logger.getLogger(OutputRegistry.class.getName());
    public static final OutputRegistry INSTANCE = new OutputRegistry();
    public static final String JAVA_GEN_DIR = "target/generated-sources/fluxtion/";
    public static final String JAVA_SRC_DIR = "src/main/java/";
    public static final String JAVA_TESTGEN_DIR = "target/generated-test-sources/fluxtion/";
    public static final String JAVA_TEST_SRC_DIR = "src/test/java/";
    public static final String RESOURCE_DIR = "src/main/resources/";
    public static final String RESOURCE_TEST_DIR = "src/test/resources/";
    public static final String RESOURCE_GENERATED_TEST_DIR = "target/generated-test-sources/resources/";
    private ClassLoader classLoader;
    private DirOptions dirOptions = DirOptions.JAVA_GENDIR_OUTPUT;
    private String genDir;
    private String resDir;
    private String classesDir;

    private OutputRegistry() {
        this.update();
    }

    public final void update() {
        String dir = System.getProperty("fluxtion.cacheDirectory");
        log.log(Level.INFO, "upate fluxtion.cacheDirectory:'" + dir + "'");
        this.genDir = JAVA_GEN_DIR;
        this.resDir = RESOURCE_DIR;
        this.classLoader = ClassLoader.getSystemClassLoader();
        this.classesDir = null;
        System.getProperties().remove("fluxtion.build.outputdirectory");
        if (dir != null) {
            this.dirOptions = null;
            this.genDir = dir + "/source/";
            this.resDir = dir + "/resources/";
            this.classesDir = dir + "/classes/";
            System.setProperty("fluxtion.build.outputdirectory", this.classesDir);
            try {
                URL classesDir = this.getClassesDirFile().toURI().toURL();
                URL reosurcesDir = this.getResDirFile().toURI().toURL();
                this.classLoader = new URLClassLoader(new URL[]{classesDir, reosurcesDir});
            }
            catch (Exception e) {
                log.log(Level.WARNING, "could not build classloader from cache directories", e);
            }
        } else {
            if (this.dirOptions == null) {
                this.dirOptions = DirOptions.JAVA_GENDIR_OUTPUT;
            }
            switch (this.dirOptions) {
                case JAVA_SRCDIR_OUTPUT: {
                    this.genDir = JAVA_SRC_DIR;
                    this.resDir = RESOURCE_DIR;
                    break;
                }
                case TEST_DIR_OUTPUT: {
                    this.genDir = JAVA_TESTGEN_DIR;
                    this.resDir = RESOURCE_GENERATED_TEST_DIR;
                }
            }
        }
        try {
            FileUtils.forceMkdir((File)this.getGenDirFile());
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "could not make generated output directory {0}", this.getGenDirFile());
        }
        try {
            if (this.getClassesDirFile() != null) {
                FileUtils.forceMkdir((File)this.getClassesDirFile());
            }
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "could not make classes output directory {0}", this.getClassesDirFile());
        }
        try {
            FileUtils.forceMkdir((File)this.getResDirFile());
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "could not make recources output directory {0}", this.getResDirFile());
        }
        log.log(Level.INFO, "updated resources registry : {0}", this.toString());
    }

    public DirOptions getDirOptions() {
        return this.dirOptions;
    }

    public void setDirOptions(DirOptions dirOptions) {
        this.dirOptions = dirOptions;
        this.update();
    }

    public String getGenDir() {
        return this.genDir;
    }

    public String getResDir() {
        return this.resDir;
    }

    public String getClassesDir() {
        return this.classesDir;
    }

    public File getGenDirFile() {
        return new File(this.genDir);
    }

    public File getResDirFile() {
        return new File(this.resDir);
    }

    public File getClassesDirFile() {
        return this.classesDir == null ? null : new File(this.classesDir);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String toString() {
        try {
            return "OutputRegistry{fluxtion.cacheDirectory=" + System.getProperty("fluxtion.cacheDirectory") + ", dirOptions=" + (Object)((Object)this.dirOptions) + ", genDir=" + this.getGenDirFile().getCanonicalPath() + ", resDir=" + this.getResDirFile().getCanonicalPath() + ", classesDir=" + this.getClassesDirFile().getCanonicalPath() + ", classLoader=" + this.classLoader + '}';
        }
        catch (Exception ex) {
            return "OutputRegistry{fluxtion.cacheDirectory=" + System.getProperty("fluxtion.cacheDirectory") + ", dirOptions=" + (Object)((Object)this.dirOptions) + ", genDir=" + this.genDir + ", resDir=" + this.resDir + ", classesDir=" + this.classesDir + ", classLoader=" + this.classLoader + '}';
        }
    }
}

