/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.annotationprocessor;

import com.google.auto.service.AutoService;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;

@AutoService(value={Processor.class})
public class ValidateExportFunctionAnnotations
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            Set<Element> typeElements = annotatedElements.stream().filter(element -> {
                TypeKind returnType = ((ExecutableType)element.asType()).getReturnType().getKind();
                boolean validReturn = returnType == TypeKind.BOOLEAN || returnType == TypeKind.VOID;
                return !validReturn || !element.getModifiers().contains((Object)Modifier.PUBLIC);
            }).collect(Collectors.toSet());
            typeElements.forEach(element -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "exported method should be public method and a boolean return type ", (Element)element));
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotations = new HashSet<String>();
        return supportedAnnotations;
    }
}

