/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.annotationprocessor;

import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.google.auto.service.AutoService;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.tools.Diagnostic;

@AutoService(value={Processor.class})
public class ValidateOnParentUpdateHandlerAnnotations
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            Set<Element> typeElements = annotatedElements.stream().filter(element -> ((ExecutableType)element.asType()).getParameterTypes().size() != 1 || !element.getModifiers().contains((Object)Modifier.PUBLIC)).collect(Collectors.toSet());
            typeElements.forEach(element -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "OnParentUpdate should be public method accepting a single parameter, failing method:" + element.getSimpleName(), (Element)element));
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotations = new HashSet<String>();
        supportedAnnotations.add(OnParentUpdate.class.getCanonicalName());
        return supportedAnnotations;
    }
}

