/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.compiler;

import com.fluxtion.compiler.EventProcessorConfig;
import com.fluxtion.compiler.FluxtionCompilerConfig;
import com.fluxtion.compiler.builder.factory.NodeFactoryLocator;
import com.fluxtion.compiler.builder.factory.NodeFactoryRegistration;
import com.fluxtion.compiler.generation.GenerationContext;
import com.fluxtion.compiler.generation.compiler.EventProcessorGenerator;
import com.fluxtion.compiler.generation.compiler.classcompiler.StringCompilation;
import com.google.googlejavaformat.java.Formatter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProcessorCompilation {
    private static final Logger LOG = LoggerFactory.getLogger(EventProcessorCompilation.class);
    private FluxtionCompilerConfig compilerConfig;
    private EventProcessorConfig builderConfig;

    public <T> Class<T> compile(FluxtionCompilerConfig compilerConfig, EventProcessorConfig configOverride) throws Exception {
        LOG.debug("starting SEP compiler");
        this.compilerConfig = compilerConfig;
        this.initialiseGenerator(configOverride);
        this.locateFactories();
        Class<?> returnClass = this.generateSep();
        LOG.debug("finished SEP compiler");
        return returnClass;
    }

    private void initialiseGenerator(EventProcessorConfig configOverride) {
        LOG.debug("initialiseGenerator");
        LOG.debug(this.compilerConfig.toString());
        File buildDir = this.compilerConfig.getBuildOutputDirectory() == null ? null : new File(this.compilerConfig.getBuildOutputDirectory());
        GenerationContext.setupStaticContext(this.compilerConfig.getClassLoader(), this.compilerConfig.getPackageName(), this.compilerConfig.getClassName(), new File(this.compilerConfig.getOutputDirectory()), new File(this.compilerConfig.getResourcesOutputDirectory()), this.compilerConfig.isGenerateDescription(), buildDir, true);
        this.builderConfig = configOverride;
        this.builderConfig.setTemplateFile(this.compilerConfig.getTemplateSep());
    }

    private void locateFactories() {
        LOG.debug("locateFactories");
        if (this.builderConfig.getNodeFactoryRegistration() == null) {
            this.builderConfig.setNodeFactoryRegistration(new NodeFactoryRegistration(NodeFactoryLocator.nodeFactorySet()));
        } else {
            this.builderConfig.getNodeFactoryRegistration().factoryClassSet.addAll(NodeFactoryLocator.nodeFactorySet());
        }
    }

    private Class<?> generateSep() throws Exception {
        File file;
        String fqn;
        Writer writer;
        boolean formatSuccess;
        File backupFile;
        Class returnClass;
        block18: {
            LOG.debug("generateSep");
            returnClass = null;
            backupFile = null;
            formatSuccess = true;
            if (this.compilerConfig.isWriteSourceToFile()) {
                File outFile = new File(GenerationContext.SINGLETON.getPackageDirectory(), GenerationContext.SINGLETON.getSepClassName() + ".java");
                outFile.getParentFile().mkdirs();
                if (outFile.exists()) {
                    backupFile = new File(outFile.getParentFile(), outFile.getName() + ".backup");
                    if (backupFile.exists()) {
                        throw new RuntimeException("Fluxtion generation problem backup file exists - please move or delete file:" + backupFile.getCanonicalPath());
                    }
                    FileUtils.moveFile((File)outFile, (File)backupFile);
                }
                writer = new FileWriter(outFile);
            } else {
                writer = new StringWriter();
            }
            EventProcessorGenerator eventProcessorGenerator = new EventProcessorGenerator();
            eventProcessorGenerator.templateSep(this.builderConfig, this.compilerConfig, writer);
            GenerationContext generationConfig = GenerationContext.SINGLETON;
            fqn = generationConfig.getPackageName() + "." + generationConfig.getSepClassName();
            file = new File(generationConfig.getPackageDirectory(), generationConfig.getSepClassName() + ".java");
            if (this.compilerConfig.isWriteSourceToFile()) {
                LOG.info("generated EventProcessor file: " + file.getCanonicalPath());
            } else {
                LOG.info("generated EventProcessor in memory");
                try {
                    if (this.compilerConfig.isFormatSource()) {
                        String formatSource = new Formatter().formatSource(writer.toString());
                        writer = new StringWriter();
                        writer.write(formatSource);
                    }
                    if (this.compilerConfig.getSourceWriter() != null) {
                        this.compilerConfig.getSourceWriter().write(writer.toString());
                        writer = this.compilerConfig.getSourceWriter();
                    }
                }
                catch (Throwable t) {
                    formatSuccess = false;
                    if (this.compilerConfig.getSourceWriter() == null) break block18;
                    this.compilerConfig.getSourceWriter().write(writer.toString());
                    writer = this.compilerConfig.getSourceWriter();
                }
            }
        }
        if (this.compilerConfig.isWriteSourceToFile() && this.compilerConfig.isFormatSource()) {
            LOG.debug("start formatting source");
            EventProcessorGenerator.formatSource(file);
            LOG.debug("completed formatting source");
        }
        if (this.compilerConfig.isCompileSource() && !Boolean.getBoolean("FLUXTION.NO_COMPILE")) {
            LOG.debug("start compiling source");
            if (this.compilerConfig.isWriteSourceToFile()) {
                this.builderConfig.getCompilerOptions();
                returnClass = StringCompilation.compile(fqn, EventProcessorCompilation.readText(file.getCanonicalPath()), this.builderConfig.getCompilerOptions());
            } else {
                returnClass = StringCompilation.compile(fqn, writer.toString(), this.builderConfig.getCompilerOptions());
            }
            LOG.debug("completed compiling source");
            if (backupFile != null) {
                FileUtils.delete((File)backupFile);
                backupFile = null;
            }
        } else if (backupFile != null && formatSuccess) {
            FileUtils.delete((File)backupFile);
        }
        if (backupFile != null && !formatSuccess) {
            FileUtils.delete((File)backupFile);
        }
        return returnClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readText(@NotNull String resourceName) throws IOException {
        LOG.debug("starting reading:" + resourceName);
        StringWriter sw = new StringWriter();
        InputStreamReader isr = new InputStreamReader(EventProcessorCompilation.getInputStream(resourceName), StandardCharsets.UTF_8);
        try {
            int len;
            char[] chars = new char[8192];
            while ((len = isr.read(chars)) > 0) {
                sw.write(chars, 0, len);
            }
        }
        finally {
            EventProcessorCompilation.close(isr);
        }
        LOG.debug("finished reading:" + resourceName);
        return sw.toString();
    }

    private static void close(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.trace("Failed to close {}", (Object)closeable, (Object)e);
            }
        }
    }

    private static InputStream getInputStream(@NotNull String filename) throws IOException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = contextClassLoader.getResourceAsStream(filename);
        if (is != null) {
            return is;
        }
        InputStream is2 = contextClassLoader.getResourceAsStream('/' + filename);
        if (is2 != null) {
            return is2;
        }
        return Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
    }
}

