/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.compiler;

import com.fluxtion.compiler.EventProcessorConfig;
import com.fluxtion.compiler.FluxtionCompilerConfig;
import com.fluxtion.compiler.builder.factory.NodeFactoryLocator;
import com.fluxtion.compiler.builder.factory.NodeFactoryRegistration;
import com.fluxtion.compiler.generation.GenerationContext;
import com.fluxtion.compiler.generation.exporter.PngGenerator;
import com.fluxtion.compiler.generation.model.SimpleEventProcessorModel;
import com.fluxtion.compiler.generation.model.TopologicallySortedDependencyGraph;
import com.fluxtion.compiler.generation.targets.InMemoryEventProcessor;
import com.fluxtion.compiler.generation.targets.JavaSourceGenerator;
import com.fluxtion.runtime.annotations.OnEventHandler;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class EventProcessorGenerator {
    private EventProcessorConfig config;
    private static final Logger LOG = LoggerFactory.getLogger(EventProcessorGenerator.class);
    private SimpleEventProcessorModel simpleEventProcessorModel;
    private FluxtionCompilerConfig compilerConfig;

    public InMemoryEventProcessor inMemoryProcessor(EventProcessorConfig config, boolean generateDescription) throws Exception {
        config.buildConfig();
        LOG.debug("locateFactories");
        if (config.getNodeFactoryRegistration() == null) {
            config.setNodeFactoryRegistration(new NodeFactoryRegistration(NodeFactoryLocator.nodeFactorySet()));
        } else {
            config.getNodeFactoryRegistration().factoryClassSet.addAll(NodeFactoryLocator.nodeFactorySet());
        }
        this.config = config;
        if (GenerationContext.SINGLETON == null) {
            GenerationContext.setupStaticContext("", "", null, null);
        }
        if (GenerationContext.SINGLETON == null) {
            throw new RuntimeException("could not initialise Generations.SINGLETON context");
        }
        TopologicallySortedDependencyGraph graph = new TopologicallySortedDependencyGraph(config.getNodeList(), config.getPublicNodes(), config.getNodeFactoryRegistration(), GenerationContext.SINGLETON, config.getAuditorMap(), config);
        this.simpleEventProcessorModel = new SimpleEventProcessorModel(graph, config.getFilterMap(), GenerationContext.SINGLETON.getProxyClassMap());
        this.simpleEventProcessorModel.generateMetaModelInMemory(config.isSupportDirtyFiltering());
        if (generateDescription && !GenerationContext.SINGLETON.getPackageName().isEmpty()) {
            this.exportGraphMl(graph);
        }
        return new InMemoryEventProcessor(this.simpleEventProcessorModel, config);
    }

    public void templateSep(EventProcessorConfig config, FluxtionCompilerConfig compilerConfig, Writer writer) throws Exception {
        ExecutorService execSvc = Executors.newCachedThreadPool();
        config.buildConfig();
        this.config = config;
        this.compilerConfig = compilerConfig;
        LOG.debug("init velocity");
        EventProcessorGenerator.initVelocity();
        LOG.debug("start graph calc");
        GenerationContext context = GenerationContext.SINGLETON;
        TopologicallySortedDependencyGraph graph = new TopologicallySortedDependencyGraph(config.getNodeList(), config.getPublicNodes(), config.getNodeFactoryRegistration(), context, config.getAuditorMap(), config);
        LOG.debug("start model gen");
        this.simpleEventProcessorModel = new SimpleEventProcessorModel(graph, config.getFilterMap(), context.getProxyClassMap());
        this.simpleEventProcessorModel.generateMetaModel(config.isSupportDirtyFiltering());
        if (compilerConfig.isGenerateDescription()) {
            execSvc.submit(() -> {
                LOG.debug("start exporting graphML/images");
                this.exportGraphMl(graph);
                LOG.debug("completed exporting graphML/images");
                LOG.debug("finished generating SEP");
            });
        }
        LOG.debug("start template output");
        this.templateJavaOutput(writer);
        LOG.debug("completed template output");
        execSvc.shutdown();
        execSvc.awaitTermination(2L, TimeUnit.SECONDS);
    }

    public SimpleEventProcessorModel getSimpleEventProcessorModel() {
        return this.simpleEventProcessorModel;
    }

    private static void initVelocity() {
        Velocity.setProperty((String)"resource.loaders", (Object)"classpath");
        Velocity.setProperty((String)"resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(GenerationContext.SINGLETON.getClassLoader());
        Velocity.init();
        Thread.currentThread().setContextClassLoader(originalClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void templateJavaOutput(Writer templateWriter) throws Exception {
        try {
            Template template;
            JavaSourceGenerator srcModel = new JavaSourceGenerator(this.simpleEventProcessorModel, this.config);
            srcModel.additionalInterfacesToImplement(this.config.interfacesToImplement());
            LOG.debug("building source model");
            srcModel.buildSourceModel();
            if (this.config.getTemplateFile() == null) {
                this.config.setTemplateFile("template/base/javaTemplate.vsl");
            }
            LOG.debug("templating output source - start");
            String templateFile = this.config.getTemplateFile();
            try {
                template = Velocity.getTemplate((String)templateFile);
            }
            catch (Exception e) {
                System.out.println("failed to load template, setting threadcontext class loader");
                ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(GenerationContext.SINGLETON.getClassLoader());
                    template = Velocity.getTemplate((String)templateFile);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
            VelocityContext ctx = new VelocityContext();
            this.addVersionInformation((Context)ctx);
            ctx.put("MODEL", (Object)srcModel);
            ctx.put("package", (Object)GenerationContext.SINGLETON.getPackageName());
            ctx.put("className", (Object)GenerationContext.SINGLETON.getSepClassName());
            template.merge((Context)ctx, templateWriter);
            templateWriter.flush();
            LOG.debug("templating output source - finish");
        }
        finally {
            templateWriter.close();
        }
    }

    private void addVersionInformation(Context ctx) {
        ctx.put("generator_version_information", (Object)this.getClass().getPackage().getImplementationVersion());
        ctx.put("api_version_information", (Object)OnEventHandler.class.getPackage().getImplementationVersion());
        if (this.compilerConfig.isAddBuildTime()) {
            ctx.put("build_time", (Object)LocalDateTime.now());
        } else {
            ctx.put("build_time", (Object)"Not available");
        }
    }

    public static void formatSource(File outFile) {
        try {
            LOG.debug("Reading source:'{}'", (Object)outFile.getCanonicalPath());
            CharSource source = Files.asCharSource((File)outFile, (Charset)Charset.defaultCharset());
            CharSink output = Files.asCharSink((File)outFile, (Charset)Charset.defaultCharset(), (FileWriteMode[])new FileWriteMode[0]);
            LOG.debug("formatting source - start");
            new Formatter().formatSource(source, output);
            LOG.debug("formatting source - finish");
        }
        catch (FormatterException | IOException ex) {
            LOG.error("problem formatting source file", ex);
        }
    }

    private void exportGraphMl(TopologicallySortedDependencyGraph graph) {
        try {
            LOG.debug("generating event images and graphml");
            File graphMl = new File(GenerationContext.SINGLETON.getResourcesOutputDirectory(), GenerationContext.SINGLETON.getSepClassName() + ".graphml");
            File pngFile = new File(GenerationContext.SINGLETON.getResourcesOutputDirectory(), GenerationContext.SINGLETON.getSepClassName() + ".png");
            if (graphMl.getParentFile() != null) {
                graphMl.getParentFile().mkdirs();
            }
            try (FileWriter graphMlWriter = new FileWriter(graphMl);){
                graph.exportAsGraphMl(graphMlWriter, true);
            }
            PngGenerator.generatePNG(graphMl, pngFile);
        }
        catch (IOException | TransformerConfigurationException | SAXException iOException) {
            LOG.error("error writing png and graphml:", (Throwable)iOException);
        }
    }
}

