/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.compiler.classcompiler;

import com.fluxtion.compiler.generation.annotationprocessor.ValidateEventHandlerAnnotations;
import com.fluxtion.compiler.generation.annotationprocessor.ValidateExportFunctionAnnotations;
import com.fluxtion.compiler.generation.annotationprocessor.ValidateLifecycleAnnotations;
import com.fluxtion.compiler.generation.annotationprocessor.ValidateOnParentUpdateHandlerAnnotations;
import com.fluxtion.compiler.generation.annotationprocessor.ValidateOnTriggerAnnotations;
import com.fluxtion.compiler.generation.compiler.classcompiler.JavaByteObject;
import com.fluxtion.compiler.generation.compiler.classcompiler.JavaStringObject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public interface StringCompilation {
    public static <T> Class<T> compile(String className, String source, String ... options) throws URISyntaxException, IOException, ClassNotFoundException {
        ArrayList<String> optionList = new ArrayList<String>();
        Collections.addAll(optionList, options);
        return StringCompilation.compile(className, source, optionList);
    }

    public static <T> Class<T> compile(String className, String source, List<String> optionList) throws URISyntaxException, IOException, ClassNotFoundException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaByteObject byteObject = new JavaByteObject(className);
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnostics, null, null);
        JavaFileManager fileManager = StringCompilation.createFileManager(standardFileManager, byteObject);
        String cp = System.getProperty("FLUXTION.GENERATION.CLASSPATH");
        if (cp != null) {
            optionList.add("-classpath");
            optionList.add(cp);
        }
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, optionList, null, Collections.singletonList(new JavaStringObject(className, source)));
        task.setProcessors(Arrays.asList(new ValidateEventHandlerAnnotations(), new ValidateLifecycleAnnotations(), new ValidateOnTriggerAnnotations(), new ValidateOnParentUpdateHandlerAnnotations(), new ValidateExportFunctionAnnotations()));
        if (!task.call().booleanValue()) {
            diagnostics.getDiagnostics().forEach(System.out::println);
            throw new RuntimeException("unable to compile source file to class:'" + className + "'");
        }
        fileManager.close();
        ClassLoader inMemoryClassLoader = StringCompilation.createClassLoader(byteObject);
        return inMemoryClassLoader.loadClass(className);
    }

    public static JavaFileManager createFileManager(StandardJavaFileManager fileManager, final JavaByteObject byteObject) {
        return new ForwardingJavaFileManager(fileManager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                return byteObject;
            }
        };
    }

    public static ClassLoader createClassLoader(final JavaByteObject byteObject) {
        return new ClassLoader(){

            @Override
            public Class<?> findClass(String name) throws ClassNotFoundException {
                byte[] bytes = byteObject.getBytes();
                return this.defineClass(name, bytes, 0, bytes.length);
            }
        };
    }
}

