/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.exporter;

import com.fluxtion.runtime.annotations.OnEventHandler;
import com.fluxtion.runtime.node.EventHandlerNode;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.jgrapht.Graph;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerEdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.SimpleGraph;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JgraphGraphMLExporter<V, E> {
    private final VertexNameProvider<V> vertexIDProvider;
    private final VertexNameProvider<V> vertexLabelProvider;
    private final EdgeNameProvider<E> edgeIDProvider;
    private final EdgeNameProvider<E> edgeLabelProvider;

    public JgraphGraphMLExporter() {
        this((VertexNameProvider<V>)new IntegerNameProvider(), null, (EdgeNameProvider<E>)new IntegerEdgeNameProvider(), null);
    }

    public JgraphGraphMLExporter(VertexNameProvider<V> vertexIDProvider, VertexNameProvider<V> vertexLabelProvider, EdgeNameProvider<E> edgeIDProvider, EdgeNameProvider<E> edgeLabelProvider) {
        this.vertexIDProvider = vertexIDProvider;
        this.vertexLabelProvider = vertexLabelProvider;
        this.edgeIDProvider = edgeIDProvider;
        this.edgeLabelProvider = edgeLabelProvider;
    }

    public void export(Writer writer, Graph<V, E> g, Set<Class<?>> exportServiceSet) throws SAXException, TransformerConfigurationException {
        PrintWriter out = new PrintWriter(writer);
        StreamResult streamResult = new StreamResult(out);
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        Transformer serializer = handler.getTransformer();
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("indent", "yes");
        handler.setResult(streamResult);
        handler.startDocument();
        AttributesImpl attr = new AttributesImpl();
        handler.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        attr.addAttribute("", "", "xsi:schemaLocation", "CDATA", "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
        attr.addAttribute("", "", "xmlns:jGraph", "CDATA", "http://www.jgraph.com/");
        handler.startElement("http://graphml.graphdrawing.org/xmlns", "", "graphml", attr);
        handler.endPrefixMapping("xsi");
        if (this.vertexLabelProvider != null) {
            attr.clear();
            attr.addAttribute("", "", "id", "CDATA", "vertex_label");
            attr.addAttribute("", "", "for", "CDATA", "node");
            attr.addAttribute("", "", "attr.name", "CDATA", "nodeData");
            attr.addAttribute("", "", "attr.type", "CDATA", "string");
            handler.startElement("", "", "key", attr);
            handler.endElement("", "", "key");
        }
        if (this.edgeLabelProvider != null) {
            attr.clear();
            attr.addAttribute("", "", "id", "CDATA", "edge_label");
            attr.addAttribute("", "", "for", "CDATA", "edge");
            attr.addAttribute("", "", "attr.name", "CDATA", "edgeData");
            attr.addAttribute("", "", "attr.type", "CDATA", "string");
            handler.startElement("", "", "key", attr);
            handler.endElement("", "", "key");
        }
        attr.clear();
        attr.addAttribute("", "", "edgedefault", "CDATA", g instanceof SimpleGraph ? "directed" : "undirected");
        handler.startElement("", "", "graph", attr);
        for (Object v : g.vertexSet()) {
            boolean isHandler = v instanceof EventHandlerNode;
            boolean isServiceClass = v instanceof Class && exportServiceSet.contains(v);
            boolean isEventClass = v instanceof Class;
            if (!isHandler) {
                Method[] methodList;
                for (Method method : methodList = v.getClass().getMethods()) {
                    if (method.getAnnotation(OnEventHandler.class) == null) continue;
                    isHandler = true;
                    break;
                }
            }
            attr.clear();
            attr.addAttribute("", "", "id", "CDATA", this.vertexIDProvider.getVertexName(v));
            handler.startElement("", "", "node", attr);
            if (this.vertexLabelProvider != null) {
                attr.clear();
                attr.addAttribute("", "", "key", "CDATA", "vertex_label");
                handler.startElement("", "", "data", attr);
                handler.startElement("", "", "jGraph:ShapeNode", null);
                String vertexLabel = this.vertexLabelProvider.getVertexName(v);
                attr.clear();
                attr.addAttribute("", "", "height", "CDATA", "70");
                attr.addAttribute("", "", "width", "CDATA", "160");
                attr.addAttribute("", "", "x", "CDATA", "20");
                attr.addAttribute("", "", "y", "CDATA", "20");
                handler.startElement("", "", "jGraph:Geometry", attr);
                handler.endElement("", "", "jGraph:Geometry");
                attr.clear();
                if (isHandler) {
                    attr.addAttribute("", "", "text", "CDATA", "<<EventHandle>>\nid:" + vertexLabel + "\nclass:" + v.getClass().getSimpleName());
                } else if (isServiceClass) {
                    attr.addAttribute("", "", "text", "CDATA", "<<ExportService>>\nclass:" + ((Class)v).getSimpleName() + "\n");
                } else if (isEventClass) {
                    attr.addAttribute("", "", "text", "CDATA", "<<Event>>\n" + vertexLabel);
                } else {
                    attr.addAttribute("", "", "text", "CDATA", "id:" + vertexLabel + "\nclass:" + v.getClass().getSimpleName());
                }
                handler.startElement("", "", "jGraph:label", attr);
                handler.endElement("", "", "jGraph:label");
                attr.clear();
                if (isHandler) {
                    attr.addAttribute("", "", "properties", "CDATA", "EVENTHANDLER");
                } else if (isServiceClass) {
                    attr.addAttribute("", "", "properties", "CDATA", "EXPORTSERVICE");
                } else if (isEventClass) {
                    attr.addAttribute("", "", "properties", "CDATA", "EVENT");
                } else {
                    attr.addAttribute("", "", "properties", "CDATA", "NODE");
                }
                handler.startElement("", "", "jGraph:Style", attr);
                handler.endElement("", "", "jGraph:label");
                handler.endElement("", "", "jGraph:ShapeNode");
                handler.endElement("", "", "data");
            }
            handler.endElement("", "", "node");
        }
        for (Object e : g.edgeSet()) {
            attr.clear();
            attr.addAttribute("", "", "id", "CDATA", this.edgeIDProvider.getEdgeName(e));
            attr.addAttribute("", "", "source", "CDATA", this.vertexIDProvider.getVertexName(g.getEdgeSource(e)));
            attr.addAttribute("", "", "target", "CDATA", this.vertexIDProvider.getVertexName(g.getEdgeTarget(e)));
            handler.startElement("", "", "edge", attr);
            if (this.edgeLabelProvider != null) {
                attr.clear();
                attr.addAttribute("", "", "key", "CDATA", "edge_label");
                handler.startElement("", "", "data", attr);
                handler.startElement("", "", "jGraph:ShapeEdge", null);
                handler.endElement("", "", "jGraph:ShapeEdge");
                handler.endElement("", "", "data");
            }
            handler.endElement("", "", "edge");
        }
        handler.endElement("", "", "graph");
        handler.endElement("", "", "graphml");
        handler.endDocument();
        out.flush();
    }
}

