/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.model;

import com.fluxtion.runtime.annotations.AfterTrigger;
import com.fluxtion.runtime.annotations.NoPropagateFunction;
import com.fluxtion.runtime.annotations.OnEventHandler;
import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.dataflow.ParallelFunction;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class CbMethodHandle {
    public final Method method;
    public final Object instance;
    public final String variableName;
    public final Class<?> parameterClass;
    public final boolean isEventHandler;
    private final boolean exportedHandler;
    public final boolean isPostEventHandler;
    public final boolean isInvertedDirtyHandler;
    private final boolean isGuardedParent;
    private final boolean isNoPropagateEventHandler;
    private final boolean failBuildOnUnguardedTrigger;
    private final boolean forkExecution;
    private final boolean isNoPropagateFunction;

    public CbMethodHandle(Method method, Object instance, String variableName) {
        this(method, instance, variableName, null, false, false);
    }

    public CbMethodHandle(Method method, Object instance, String variableName, Class<?> parameterClass, boolean isEventHandler, boolean exportedHandler) {
        this.method = method;
        this.instance = instance;
        this.variableName = variableName;
        this.parameterClass = parameterClass;
        this.isEventHandler = isEventHandler;
        this.isPostEventHandler = method.getAnnotation(AfterTrigger.class) != null;
        OnTrigger onTriggerAnnotation = method.getAnnotation(OnTrigger.class);
        OnParentUpdate onParentUpdateAnnotation = method.getAnnotation(OnParentUpdate.class);
        OnEventHandler onEventHandlerAnnotation = method.getAnnotation(OnEventHandler.class);
        NoPropagateFunction noPropagateFunction = method.getAnnotation(NoPropagateFunction.class);
        this.exportedHandler = exportedHandler;
        this.isInvertedDirtyHandler = onTriggerAnnotation != null && !onTriggerAnnotation.dirty();
        boolean parallel = instance instanceof ParallelFunction ? ((ParallelFunction)instance).parallelCandidate() : false;
        this.forkExecution = parallel || onTriggerAnnotation != null && onTriggerAnnotation.parallelExecution();
        this.failBuildOnUnguardedTrigger = onTriggerAnnotation != null && onTriggerAnnotation.failBuildIfNotGuarded();
        this.isGuardedParent = onParentUpdateAnnotation != null && onParentUpdateAnnotation.guarded();
        this.isNoPropagateEventHandler = onEventHandlerAnnotation != null && !onEventHandlerAnnotation.propagate();
        this.isNoPropagateFunction = noPropagateFunction != null;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getInstance() {
        return this.instance;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public Class<?> getParameterClass() {
        return this.parameterClass;
    }

    public boolean isEventHandler() {
        return this.isEventHandler;
    }

    public boolean isNoPropagateEventHandler() {
        return this.isNoPropagateEventHandler;
    }

    public boolean isPostEventHandler() {
        return this.isPostEventHandler;
    }

    public boolean isInvertedDirtyHandler() {
        return this.isInvertedDirtyHandler;
    }

    public boolean isGuardedParent() {
        return this.isGuardedParent;
    }

    public boolean isForkExecution() {
        return this.forkExecution;
    }

    public boolean isNoPropagateFunction() {
        return this.isNoPropagateFunction;
    }

    public boolean isExportedHandler() {
        return this.exportedHandler;
    }

    public String getMethodTarget() {
        if (Modifier.isStatic(this.getMethod().getModifiers())) {
            return this.instance.getClass().getSimpleName();
        }
        return this.variableName;
    }

    public String invokeLambdaString() {
        return this.getMethodTarget() + "::" + this.getMethod().getName();
    }

    public String forkVariableName() {
        return "fork_" + this.getVariableName();
    }

    public String toString() {
        return "CbMethodHandle{method=" + this.method + ", instance=" + this.instance + ", variableName='" + this.variableName + '\'' + ", parameterClass=" + this.parameterClass + ", isEventHandler=" + this.isEventHandler + ", isExportHandler=" + this.exportedHandler + ", isPostEventHandler=" + this.isPostEventHandler + ", isInvertedDirtyHandler=" + this.isInvertedDirtyHandler + ", isGuardedParent=" + this.isGuardedParent + ", isNoPropagateEventHandler=" + this.isNoPropagateEventHandler + ", failBuildOnUnguardedTrigger=" + this.failBuildOnUnguardedTrigger + ", forkExecution=" + this.forkExecution + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.method);
        hash = 23 * hash + Objects.hashCode(this.instance);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CbMethodHandle other = (CbMethodHandle)obj;
        if (!Objects.equals(this.method, other.method)) {
            return false;
        }
        return Objects.equals(this.instance, other.instance);
    }

    public boolean failBuildOnUnguardedTrigger() {
        return this.failBuildOnUnguardedTrigger;
    }

    public static enum CallBackType {
        TRIGGER,
        EVENT_HANDLER,
        EXPORT_FUNCTION;

    }
}

