/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.model;

import com.fluxtion.compiler.generation.model.Field;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.google.common.base.Predicate;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConstructorMatcherPredicate
implements Predicate<Constructor> {
    private final Logger LOGGER = LoggerFactory.getLogger(ConstructorMatcherPredicate.class);
    private final Field.MappedField[] cstrArgList;
    private final HashSet<Field.MappedField> privateFields;
    private final boolean nameAndType;

    public static Predicate<Constructor> matchConstructorNameAndType(Field.MappedField[] cstrArgList, HashSet<Field.MappedField> privateFields) {
        return new ConstructorMatcherPredicate(cstrArgList, privateFields);
    }

    public static Predicate<Constructor> matchConstructorType(Field.MappedField[] cstrArgList, HashSet<Field.MappedField> privateFields) {
        return new ConstructorMatcherPredicate(cstrArgList, privateFields, false);
    }

    public ConstructorMatcherPredicate(Field.MappedField[] cstrArgList, HashSet<Field.MappedField> privateFields) {
        this.cstrArgList = cstrArgList;
        this.privateFields = privateFields;
        this.nameAndType = true;
    }

    public ConstructorMatcherPredicate(Field.MappedField[] cstrArgList, HashSet<Field.MappedField> privateFields, boolean nameAndType) {
        this.cstrArgList = cstrArgList;
        this.privateFields = privateFields;
        this.nameAndType = nameAndType;
    }

    public boolean apply(Constructor input) {
        boolean match;
        boolean bl = match = this.cstrArgList[0] != null;
        if (match) {
            this.LOGGER.debug("already matched constructor, ignoring");
            return false;
        }
        this.LOGGER.debug("unmatched constructor, reset constructorArgs");
        Arrays.fill(this.cstrArgList, null);
        Parameter[] parameters = input.getParameters();
        int parameterCount = parameters.length;
        if (parameterCount == 0 || parameterCount != this.privateFields.size()) {
            this.LOGGER.debug("parameterCount:{} privateFieldsCount:{} mismatch reject constructor", (Object)parameterCount, (Object)this.privateFields.size());
        } else {
            int matchCount = 0;
            for (Field.MappedField mappedInstance : this.privateFields) {
                String paramName;
                int i;
                String varName = mappedInstance.mappedName;
                Class<?> parentClass = mappedInstance.parentClass();
                Class<?> realClass = mappedInstance.realClass();
                this.LOGGER.debug("match field var:{}, type:{}", (Object)varName, parentClass);
                boolean matchOnName = false;
                this.LOGGER.debug("matching constructor by type and name");
                for (i = 0; i < parameters.length; ++i) {
                    if (parameters[i] == null) continue;
                    Parameter parameter = parameters[i];
                    paramName = parameter.getName();
                    if (parameter.getAnnotation(AssignToField.class) != null) {
                        paramName = parameter.getAnnotation(AssignToField.class).value();
                        this.LOGGER.debug("assigning parameter name from annotation AssignToField fieldName:'{}' overriding:'{}'", (Object)paramName, (Object)parameter.getName());
                    }
                    Class<?> parameterType = parameters[i].getType();
                    this.LOGGER.debug("constructor parameter type:{}, paramName:{}, varName:{}", new Object[]{parameterType, paramName, varName});
                    if (parameterType == null || !parameterType.isAssignableFrom(parentClass) && !parameterType.isAssignableFrom(realClass) || !paramName.equals(varName)) continue;
                    ++matchCount;
                    parameters[i] = null;
                    this.cstrArgList[i] = mappedInstance;
                    matchOnName = true;
                    this.LOGGER.debug("matched constructor arg:{}, by type and name", (Object)paramName);
                    break;
                }
                if (matchOnName || this.nameAndType) continue;
                this.LOGGER.debug("no match, matching constructor by type only");
                for (i = 0; i < parameters.length; ++i) {
                    if (parameters[i] == null) continue;
                    Class<?> parameterType = parameters[i].getType();
                    paramName = parameters[i].getName();
                    this.LOGGER.debug("constructor parameter type:{}, paramName:{}, varName:{}", new Object[]{parameterType, paramName, varName});
                    if (parameterType == null || !parameterType.isAssignableFrom(parentClass) && !parameterType.isAssignableFrom(realClass)) continue;
                    ++matchCount;
                    parameters[i] = null;
                    this.cstrArgList[i] = mappedInstance;
                    matchOnName = true;
                    this.LOGGER.debug("matched constructor arg:{}, by type only", (Object)paramName);
                    break;
                }
                if (matchOnName) continue;
                this.LOGGER.debug("no match for varName:{}", (Object)varName);
                break;
            }
            if (matchCount == parameterCount) {
                this.LOGGER.debug("matched constructor:{}", (Object)input);
                match = true;
            } else {
                this.LOGGER.debug("unmatched constructor:{}", (Object)input);
                Arrays.fill(this.cstrArgList, null);
            }
        }
        return match;
    }

    public static List<String> validateNoTypeClash(Set<Field.MappedField> privateFields, Constructor constructor) {
        Set mappedNames = Arrays.stream(constructor.getParameters()).filter(p -> p.getAnnotation(AssignToField.class) != null).map(p -> p.getAnnotation(AssignToField.class)).map(AssignToField::value).collect(Collectors.toSet());
        Set filteredFields = privateFields.stream().filter(m -> !mappedNames.contains(m.mappedName)).collect(Collectors.toSet());
        List<String> output = filteredFields.stream().filter(m -> {
            Class<?> classToTest = m.parentClass();
            HashSet setToTest = new HashSet(filteredFields);
            setToTest.remove(m);
            return setToTest.stream().map(Field.MappedField::parentClass).anyMatch(c -> {
                boolean val = c.isAssignableFrom(classToTest) || classToTest.isAssignableFrom((Class<?>)c);
                return val;
            });
        }).map(Field.MappedField::getMappedName).collect(Collectors.toList());
        return output;
    }
}

