/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.model;

import com.fluxtion.compiler.generation.model.Field;
import java.util.Objects;

public class DirtyFlag {
    public final Field node;
    public final String name;
    public boolean alwaysDirty;
    public boolean requiresInvert = false;

    public DirtyFlag(Field node, String name) {
        this.node = node;
        this.name = name;
        this.alwaysDirty = false;
        this.requiresInvert = false;
    }

    public DirtyFlag(Field node, String name, boolean alwaysDirty) {
        this.node = node;
        this.name = name;
        this.alwaysDirty = alwaysDirty;
    }

    public DirtyFlag clone() {
        DirtyFlag df = new DirtyFlag(this.node, this.name, this.alwaysDirty);
        df.requiresInvert = this.requiresInvert;
        return df;
    }

    public Field getNode() {
        return this.node;
    }

    public String getName() {
        return this.name;
    }

    public String getForkedName() {
        return "fork_" + this.node.getName();
    }

    public boolean isAlwaysDirty() {
        return this.alwaysDirty;
    }

    public boolean isRequiresInvert() {
        return this.requiresInvert;
    }

    public String toString() {
        return "DirtyFlag{node=" + this.node + ", name=" + this.name + ", defaultVal=" + this.alwaysDirty + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.node);
        hash = 53 * hash + Objects.hashCode(this.name);
        hash = 53 * hash + (this.alwaysDirty ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirtyFlag other = (DirtyFlag)obj;
        if (this.alwaysDirty != other.alwaysDirty) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.node, other.node);
    }
}

