/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.model;

import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;

public class Field {
    public final String name;
    public final String fqn;
    public final boolean publicAccess;
    public final Object instance;

    public Field(String fqn, String name, Object instance, boolean publicAccess) {
        this.fqn = fqn;
        this.name = name;
        this.instance = instance;
        this.publicAccess = publicAccess;
    }

    public boolean isGeneric() {
        TypeVariable<Class<?>>[] typeParameters = this.instance.getClass().getTypeParameters();
        return typeParameters.length > 0;
    }

    public String toString() {
        return "Field{name=" + this.name + ", fqn=" + this.fqn + ", publicAccess=" + this.publicAccess + ", instance=" + this.instance + '}';
    }

    public String getName() {
        return this.name;
    }

    public String getFqn() {
        return this.fqn;
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public Object getInstance() {
        return this.instance;
    }

    public static class MappedField
    extends Field {
        public final String mappedName;
        public boolean collection;
        public boolean primitive = false;
        public Object primitiveVal;
        public ArrayList<Field> elements;
        public String derivedVal;
        private Class<?> collectionClass;

        public MappedField(String mappedName, Field f) {
            super(f.fqn, f.name, f.instance, f.publicAccess);
            this.mappedName = mappedName;
            Class<?> aClass = f.instance.getClass();
            this.collection = List.class.isAssignableFrom(aClass);
            this.elements = new ArrayList();
        }

        public MappedField(String mappedName, Class<?> collectionClass) {
            super(collectionClass.getName(), null, null, false);
            this.collectionClass = collectionClass;
            this.mappedName = mappedName;
            this.collection = true;
            this.elements = new ArrayList();
        }

        public MappedField(String mappedName, Object primitiveValue) {
            super(null, null, null, false);
            this.mappedName = mappedName;
            this.collection = false;
            this.primitive = true;
            this.primitiveVal = primitiveValue;
        }

        public Class<?> parentClass() {
            if (this.collection) {
                return this.collectionClass;
            }
            if (this.primitive) {
                if (this.primitiveVal.getClass() == Integer.class) {
                    return Integer.TYPE;
                }
                if (this.primitiveVal.getClass() == Double.class) {
                    return Double.TYPE;
                }
                if (this.primitiveVal.getClass() == Float.class) {
                    return Float.TYPE;
                }
                if (this.primitiveVal.getClass() == Byte.class) {
                    return Byte.TYPE;
                }
                if (this.primitiveVal.getClass() == Short.class) {
                    return Short.TYPE;
                }
                if (this.primitiveVal.getClass() == Long.class) {
                    return Long.TYPE;
                }
                if (this.primitiveVal.getClass() == Boolean.class) {
                    return Boolean.TYPE;
                }
                if (this.primitiveVal.getClass() == Character.class) {
                    return Character.TYPE;
                }
                return this.primitiveVal.getClass();
            }
            return this.instance.getClass();
        }

        public Class<?> realClass() {
            if (this.collection) {
                return this.collectionClass;
            }
            if (this.primitive) {
                return this.primitiveVal.getClass();
            }
            return this.instance.getClass();
        }

        public String value() {
            return this.derivedVal;
        }

        public void addField(Field field) {
            if (field != null) {
                this.elements.add(field);
            }
        }

        public String getMappedName() {
            return this.mappedName;
        }

        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public String toString() {
            return "MappedField{mappedName=" + this.mappedName + ", name=" + this.name + ", collection=" + this.collection + ", fqn=" + this.fqn + ", publicAccess=" + this.publicAccess + ", instance=" + this.instance + '}';
        }
    }
}

