/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.model;

import com.fluxtion.compiler.builder.factory.NodeNameProducer;
import com.fluxtion.compiler.generation.GenerationContext;
import com.fluxtion.runtime.node.NamedNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NamingStrategy
implements NodeNameProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamingStrategy.class);
    private ArrayList<NodeNameProducer> namingStrategies;
    private int count;

    public NamingStrategy() {
        this.loadServices();
    }

    public final void loadServices() {
        ServiceLoader<NodeNameProducer> loadServices;
        LOGGER.debug("NamingStrategy (re)loading naming strategies");
        this.namingStrategies = new ArrayList();
        if (GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getClassLoader() != null) {
            LOGGER.debug("using custom class loader to search for NodeNameProducer");
            loadServices = ServiceLoader.load(NodeNameProducer.class, GenerationContext.SINGLETON.getClassLoader());
        } else {
            loadServices = ServiceLoader.load(NodeNameProducer.class);
        }
        loadServices.forEach(this.namingStrategies::add);
        Collections.sort(this.namingStrategies);
        LOGGER.debug("sorted naming strategies : {}", this.namingStrategies);
    }

    @Override
    public String mappedNodeName(Object nodeToMap) {
        NodeNameProducer namingStrategy;
        String mappedName = null;
        Iterator<NodeNameProducer> iterator = this.namingStrategies.iterator();
        while (iterator.hasNext() && (mappedName = (namingStrategy = iterator.next()).mappedNodeName(nodeToMap)) == null) {
        }
        if (mappedName == null && nodeToMap instanceof NamedNode) {
            mappedName = ((NamedNode)nodeToMap).getName();
        }
        if (mappedName == null) {
            mappedName = nodeToMap.getClass().getSimpleName() + "_" + this.count++;
            mappedName = Character.toLowerCase(mappedName.charAt(0)) + (mappedName.length() > 1 ? mappedName.substring(1) : "");
        }
        return mappedName;
    }
}

