/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.model;

import com.fluxtion.compiler.builder.filter.DefaultFilterDescriptionProducer;
import com.fluxtion.compiler.builder.filter.EventHandlerFilterOverride;
import com.fluxtion.compiler.builder.filter.FilterDescription;
import com.fluxtion.compiler.builder.filter.FilterDescriptionProducer;
import com.fluxtion.compiler.generation.model.CbMethodHandle;
import com.fluxtion.compiler.generation.model.ConstructorMatcherPredicate;
import com.fluxtion.compiler.generation.model.DirtyFlag;
import com.fluxtion.compiler.generation.model.ExportFunctionData;
import com.fluxtion.compiler.generation.model.ExportFunctionMarker;
import com.fluxtion.compiler.generation.model.Field;
import com.fluxtion.compiler.generation.model.ParentFilter;
import com.fluxtion.compiler.generation.model.TopologicallySortedDependencyGraph;
import com.fluxtion.compiler.generation.serialiser.FieldSerializer;
import com.fluxtion.compiler.generation.util.ClassUtils;
import com.fluxtion.compiler.generation.util.NaturalOrderComparator;
import com.fluxtion.compiler.generation.util.SuperMethodAnnotationScanner;
import com.fluxtion.runtime.annotations.AfterEvent;
import com.fluxtion.runtime.annotations.AfterTrigger;
import com.fluxtion.runtime.annotations.ExportService;
import com.fluxtion.runtime.annotations.FilterId;
import com.fluxtion.runtime.annotations.FilterType;
import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.NoPropagateFunction;
import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnBatchEnd;
import com.fluxtion.runtime.annotations.OnBatchPause;
import com.fluxtion.runtime.annotations.OnEventHandler;
import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.PushReference;
import com.fluxtion.runtime.annotations.Start;
import com.fluxtion.runtime.annotations.Stop;
import com.fluxtion.runtime.annotations.TearDown;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.annotations.builder.ConstructorArg;
import com.fluxtion.runtime.node.EventHandlerNode;
import com.fluxtion.runtime.time.Clock;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.jodah.typetools.TypeResolver;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEventProcessorModel {
    private static final Logger log = LoggerFactory.getLogger(SimpleEventProcessorModel.class);
    private final Logger LOGGER = LoggerFactory.getLogger(SimpleEventProcessorModel.class);
    private List<Field> nodeFields;
    private List<Field> nodeFieldsSortedTopologically;
    private List<Field> registrationListenerFields;
    private final ArrayList<CbMethodHandle> initialiseMethods;
    private final ArrayList<CbMethodHandle> startMethods;
    private final ArrayList<CbMethodHandle> stopMethods;
    private final ArrayList<CbMethodHandle> eventEndMethods;
    private final ArrayList<CbMethodHandle> batchEndMethods;
    private final ArrayList<CbMethodHandle> batchPauseMethods;
    private final ArrayList<CbMethodHandle> tearDownMethods;
    private final TopologicallySortedDependencyGraph dependencyGraph;
    private final Map<Object, List<Field.MappedField>> constructorArgumentMap;
    private final Map<Object, List<String>> beanPropertyMap;
    private final Set<Class<?>> importClasses;
    private List<CbMethodHandle> allEventCallBacks;
    private List<CbMethodHandle> allPostEventCallBacks;
    private final Map<Class<?>, Map<FilterDescription, List<CbMethodHandle>>> dispatchMap;
    private final Map<Class<?>, Map<FilterDescription, List<CbMethodHandle>>> postDispatchMap;
    private Map<Class<?>, Map<FilterDescription, List<CbMethodHandle>>> handlerOnlyDispatchMap;
    private final Map<Object, List<CbMethodHandle>> parentUpdateListenerMethodMap;
    private final Map<Object, CbMethodHandle> node2UpdateMethodMap;
    private final ArrayList<FilterDescription> filterDescriptionList;
    private final FilterDescriptionProducer filterProducer;
    private final Map<Field, DirtyFlag> dirtyFieldMap;
    private final Multimap<Object, DirtyFlag> nodeGuardMap;
    private final Map<Object, Integer> filterMap;
    private final Map<Object, String> nodeClassMap;
    private final NaturalOrderComparator<?> comparator;
    private boolean supportDirtyFiltering;
    private final FieldSerializer fieldSerializer;
    private List<CbMethodHandle> triggerOnlyCallBacks;
    private Set<Object> forkedTriggerInstances;

    public SimpleEventProcessorModel(TopologicallySortedDependencyGraph dependencyGraph) throws Exception {
        this(dependencyGraph, new HashMap<Object, Integer>());
    }

    public SimpleEventProcessorModel(TopologicallySortedDependencyGraph dependencyGraph, Map<Object, Integer> filterMap) throws Exception {
        this(dependencyGraph, filterMap, null);
    }

    public SimpleEventProcessorModel(TopologicallySortedDependencyGraph dependencyGraph, Map<Object, Integer> filterMap, Map<Object, String> nodeClassMap) throws Exception {
        this.dependencyGraph = dependencyGraph;
        this.dependencyGraph.generateDependencyTree();
        this.filterMap = filterMap == null ? new HashMap() : filterMap;
        this.filterProducer = new DefaultFilterDescriptionProducer();
        this.nodeClassMap = nodeClassMap == null ? Collections.emptyMap() : nodeClassMap;
        this.constructorArgumentMap = new HashMap<Object, List<Field.MappedField>>();
        this.beanPropertyMap = new HashMap<Object, List<String>>();
        this.initialiseMethods = new ArrayList();
        this.startMethods = new ArrayList();
        this.stopMethods = new ArrayList();
        this.tearDownMethods = new ArrayList();
        this.batchEndMethods = new ArrayList();
        this.batchPauseMethods = new ArrayList();
        this.eventEndMethods = new ArrayList();
        this.dispatchMap = new HashMap();
        this.postDispatchMap = new HashMap();
        this.filterDescriptionList = new ArrayList();
        this.parentUpdateListenerMethodMap = new HashMap<Object, List<CbMethodHandle>>();
        this.comparator = new NaturalOrderComparator();
        this.dirtyFieldMap = new HashMap<Field, DirtyFlag>();
        this.nodeGuardMap = HashMultimap.create();
        this.node2UpdateMethodMap = new HashMap<Object, CbMethodHandle>();
        this.importClasses = new HashSet();
        this.fieldSerializer = new FieldSerializer(dependencyGraph.getConfig());
    }

    public void generateMetaModel() throws Exception {
        this.generateMetaModel(false);
    }

    public void generateMetaModel(boolean supportDirtyFiltering) throws Exception {
        this.LOGGER.debug("start model");
        this.nodeFields = new ArrayList<Field>();
        this.nodeFieldsSortedTopologically = new ArrayList<Field>();
        this.registrationListenerFields = new ArrayList<Field>();
        this.supportDirtyFiltering = supportDirtyFiltering;
        this.generateDependentFields();
        this.generateComplexConstructors();
        this.generatePropertyAssignments();
        this.lifeCycleHandlers();
        this.eventHandlers();
        this.buildDirtySupport();
        this.filterList();
        this.LOGGER.debug("complete model");
    }

    public void generateMetaModelInMemory(boolean supportDirtyFiltering) throws Exception {
        this.LOGGER.debug("start model");
        this.nodeFields = new ArrayList<Field>();
        this.nodeFieldsSortedTopologically = new ArrayList<Field>();
        this.registrationListenerFields = new ArrayList<Field>();
        this.supportDirtyFiltering = supportDirtyFiltering;
        this.generateDependentFields();
        this.lifeCycleHandlers();
        this.eventHandlers();
        this.buildDirtySupport();
        this.filterList();
        this.LOGGER.debug("complete model");
    }

    private void generateDependentFields() throws Exception {
        for (Object object : this.dependencyGraph.getObjectSortedDependents()) {
            String name2 = this.dependencyGraph.variableName(object);
            String classNameOverride = this.nodeClassMap.get(object);
            String defaultClassName = object.getClass().getCanonicalName();
            String className = classNameOverride == null ? defaultClassName : classNameOverride;
            boolean isPublic = this.dependencyGraph.isPublicNode(object);
            this.nodeFields.add(new Field(className, name2, object, isPublic));
            this.nodeFieldsSortedTopologically.add(new Field(className, name2, object, isPublic));
        }
        this.dependencyGraph.getRegistrationListenerMap().forEach((name, value) -> this.registrationListenerFields.add(new Field(value.getClass().getCanonicalName(), (String)name, value, true)));
        this.nodeFields.sort((o1, o2) -> this.comparator.compare(o1.fqn + o1.name, o2.fqn + o2.name));
        this.registrationListenerFields.sort((o1, o2) -> {
            int idx1 = this.nodeFieldsSortedTopologically.indexOf(o1);
            int idx2 = this.nodeFieldsSortedTopologically.indexOf(o2);
            if (o1.instance instanceof Clock) {
                return -1;
            }
            if (o2.instance instanceof Clock) {
                return 1;
            }
            if (idx1 > -1 || idx2 > -1) {
                return idx2 - idx1;
            }
            return this.comparator.compare(o1.fqn + o1.name, o2.fqn + o2.name);
        });
    }

    private void generatePropertyAssignments() {
        this.nodeFields.forEach(f -> {
            try {
                Object field = f.instance;
                this.LOGGER.debug("mapping property mutators for var:{}", (Object)f.name);
                List properties = Arrays.stream(Introspector.getBeanInfo(f.instance.getClass()).getPropertyDescriptors()).filter(p -> p.getWriteMethod() != null).filter(p -> this.fieldSerializer.propertySupported((PropertyDescriptor)p, (Field)f, this.nodeFields)).filter(p -> {
                    boolean isConstructorArg = false;
                    try {
                        isConstructorArg = null != ClassUtils.getReflectField(field.getClass(), p.getName()).getAnnotation(ConstructorArg.class);
                    }
                    catch (NoSuchFieldException ex) {
                        this.LOGGER.warn("cannot process field for ConstructorArg annotation", (Throwable)ex);
                    }
                    return !isConstructorArg;
                }).map(p -> this.fieldSerializer.mapPropertyToJavaSource((PropertyDescriptor)p, (Field)f, this.nodeFields, this.importClasses)).filter(Objects::nonNull).collect(Collectors.toList());
                this.LOGGER.debug("{} properties:{}", (Object)f.name, properties);
                this.beanPropertyMap.put(field, properties);
            }
            catch (IntrospectionException ex) {
                this.LOGGER.warn("could not process bean properties", (Throwable)ex);
            }
        });
    }

    private void generateComplexConstructors() {
        this.nodeFields.forEach(f -> {
            HashSet<Field.MappedField> privateFields = new HashSet<Field.MappedField>();
            Object field = f.instance;
            this.LOGGER.debug("mapping constructor for var:{} {}", (Object)f.name, f);
            List<?> directParents = this.dependencyGraph.getDirectParents(field);
            Field.MappedField[] cstrArgList = new Field.MappedField[directParents.size() + 200];
            Class<?> fieldClass = field.getClass();
            boolean[] hasCstrAnnotations = new boolean[]{false};
            Set assignedFieldNames = ReflectionUtils.getConstructors(fieldClass, (Predicate[])new Predicate[0]).stream().map(Executable::getParameters).flatMap(Arrays::stream).filter(p -> p.getAnnotation(AssignToField.class) != null).map(p -> p.getAnnotation(AssignToField.class).value()).collect(Collectors.toSet());
            ReflectionUtils.getAllFields(fieldClass, (Predicate[])new Predicate[]{input -> {
                boolean isCstrArg = Objects.requireNonNull(input).getAnnotation(ConstructorArg.class) != null;
                String fieldName = input.getName();
                if ((isCstrArg || assignedFieldNames.contains(fieldName)) && !Modifier.isStatic(input.getModifiers())) {
                    hasCstrAnnotations[0] = true;
                    this.LOGGER.debug("field marked as constructor arg: {}", (Object)fieldName);
                    this.LOGGER.debug("hasCstrAnnotations:" + hasCstrAnnotations[0]);
                } else if (Modifier.isStatic(input.getModifiers()) || !Modifier.isFinal(input.getModifiers()) || Modifier.isTransient(input.getModifiers())) {
                    this.LOGGER.debug("ignoring field:{} public:{} final:{} transient:{} static:{}", new Object[]{fieldName, Modifier.isPublic(input.getModifiers()), Modifier.isFinal(input.getModifiers()), Modifier.isTransient(input.getModifiers()), Modifier.isStatic(input.getModifiers())});
                    return false;
                }
                try {
                    if (!TopologicallySortedDependencyGraph.trySetAccessible(input)) {
                        return false;
                    }
                    Object parent = input.get(field);
                    if (parent == null) {
                        return false;
                    }
                    if (directParents.contains(parent)) {
                        Field.MappedField mappedField = new Field.MappedField(fieldName, this.getFieldForInstance(parent));
                        mappedField.derivedVal = this.fieldSerializer.mapToJavaSource(input.get(field), this.nodeFields, this.importClasses);
                        privateFields.add(mappedField);
                    } else if (List.class.isAssignableFrom(parent.getClass()) || Set.class.isAssignableFrom(parent.getClass())) {
                        Class collectionClass = List.class.isAssignableFrom(parent.getClass()) ? List.class : Set.class;
                        Field.MappedField collectionField = new Field.MappedField(fieldName, collectionClass);
                        Collection collection = (Collection)parent;
                        for (Object element : collection) {
                            collectionField.addField(this.getFieldForInstance(element));
                        }
                        collectionField.derivedVal = this.fieldSerializer.mapToJavaSource(parent, this.nodeFields, this.importClasses);
                        if (!collectionField.isEmpty() || collectionField.derivedVal.length() > 1) {
                            privateFields.add(collectionField);
                            this.LOGGER.debug("collection field:{}, val:{}", (Object)fieldName, input.get(field));
                        }
                    } else if (this.fieldSerializer.typeSupported(input.getType())) {
                        this.LOGGER.debug("primitive field:{}, val:{}", (Object)fieldName, input.get(field));
                        Field.MappedField primitiveField = new Field.MappedField(fieldName, input.get(field));
                        primitiveField.derivedVal = this.fieldSerializer.mapToJavaSource(input.get(field), this.nodeFields, this.importClasses);
                        privateFields.add(primitiveField);
                    } else if (this.fieldSerializer.typeSupported(input.get(field).getClass())) {
                        this.LOGGER.debug("primitive field:{}, val:{}", (Object)fieldName, input.get(field));
                        Field.MappedField primitiveField = new Field.MappedField(fieldName, input.get(field));
                        primitiveField.derivedVal = this.fieldSerializer.mapToJavaSource(input.get(field), this.nodeFields, this.importClasses);
                        privateFields.add(primitiveField);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    java.util.logging.Logger.getLogger(SimpleEventProcessorModel.class.getName()).log(Level.SEVERE, null, ex);
                }
                return false;
            }});
            if (privateFields.isEmpty() & !hasCstrAnnotations[0]) {
                this.LOGGER.debug("{}:default constructor applicable", (Object)f.name);
            } else {
                this.LOGGER.debug("{}:match complex constructor private fields:{}", (Object)f.name, privateFields);
                if (ReflectionUtils.getConstructors(fieldClass, (Predicate[])new Predicate[]{ConstructorMatcherPredicate.matchConstructorNameAndType(cstrArgList, privateFields)}).isEmpty()) {
                    Set constructors = ReflectionUtils.getConstructors(fieldClass, (Predicate[])new Predicate[]{ConstructorMatcherPredicate.matchConstructorType(cstrArgList, privateFields)});
                    if (constructors.isEmpty()) {
                        throw new RuntimeException("cannot find matching constructor for:" + f + " failed to match for these fields:" + privateFields.stream().map(Field.MappedField::getMappedName).collect(Collectors.joining(", ", "[", "]")));
                    }
                    List<String> fieldsThatClash = ConstructorMatcherPredicate.validateNoTypeClash(privateFields, (Constructor)constructors.iterator().next());
                    if (!fieldsThatClash.isEmpty()) {
                        throw new RuntimeException("cannot find matching constructor for:" + f + " use @" + AssignToField.class.getSimpleName() + " to resolve clashing types these fields:" + fieldsThatClash.stream().collect(Collectors.joining(", ", "[", "]")));
                    }
                }
                List collect = Arrays.stream(cstrArgList).filter(Objects::nonNull).collect(Collectors.toList());
                this.constructorArgumentMap.put(field, collect);
            }
        });
    }

    public List<Field.MappedField> constructorArgs(Object field) {
        List<Field.MappedField> args = this.constructorArgumentMap.get(field);
        return args == null ? Collections.emptyList() : args;
    }

    public List<String> beanProperties(Object field) {
        List<String> args = this.beanPropertyMap.get(field);
        return args == null ? Collections.emptyList() : args;
    }

    private void lifeCycleHandlers() throws Exception {
        String validCb;
        Method[] methodList;
        String name;
        Map<Object, String> inst2Name = this.dependencyGraph.getInstanceMap();
        List<Object> topologicalHandlers = this.dependencyGraph.getSortedDependents();
        List<Object> objectTopologicalHandler = this.dependencyGraph.getObjectSortedDependents();
        HashMultimap parentListenerMultiMap = HashMultimap.create();
        HashMultimap parentListenerMultiMapUnmatched = HashMultimap.create();
        for (Object object : objectTopologicalHandler) {
            name = inst2Name.get(object);
            for (Method method : methodList = object.getClass().getMethods()) {
                if (SuperMethodAnnotationScanner.annotationInHierarchy(method, Initialise.class)) {
                    this.initialiseMethods.add(new CbMethodHandle(method, object, name));
                    if (this.LOGGER.isDebugEnabled()) {
                        validCb = name + "." + method.getName() + "()";
                        this.LOGGER.debug("initialise call back : " + validCb);
                    }
                }
                if (SuperMethodAnnotationScanner.annotationInHierarchy(method, Start.class)) {
                    this.startMethods.add(new CbMethodHandle(method, object, name));
                    if (this.LOGGER.isDebugEnabled()) {
                        validCb = name + "." + method.getName() + "()";
                        this.LOGGER.debug("start call back : " + validCb);
                    }
                }
                if (SuperMethodAnnotationScanner.annotationInHierarchy(method, TearDown.class)) {
                    this.tearDownMethods.add(0, new CbMethodHandle(method, object, name));
                    if (this.LOGGER.isDebugEnabled()) {
                        validCb = name + "." + method.getName() + "()";
                        this.LOGGER.debug("tear down call back : " + validCb);
                    }
                }
                if (!SuperMethodAnnotationScanner.annotationInHierarchy(method, Stop.class)) continue;
                this.stopMethods.add(0, new CbMethodHandle(method, object, name));
                if (!this.LOGGER.isDebugEnabled()) continue;
                validCb = name + "." + method.getName() + "()";
                this.LOGGER.debug("stop call back : " + validCb);
            }
        }
        for (Object object : topologicalHandlers) {
            name = inst2Name.get(object);
            for (Method method : methodList = object.getClass().getMethods()) {
                if (SuperMethodAnnotationScanner.annotationInHierarchy(method, OnBatchEnd.class)) {
                    this.batchEndMethods.add(0, new CbMethodHandle(method, object, name));
                    if (this.LOGGER.isDebugEnabled()) {
                        validCb = name + "." + method.getName() + "()";
                        this.LOGGER.debug("batch end call back : " + validCb);
                    }
                }
                if (SuperMethodAnnotationScanner.annotationInHierarchy(method, OnBatchPause.class)) {
                    this.batchPauseMethods.add(0, new CbMethodHandle(method, object, name));
                    if (this.LOGGER.isDebugEnabled()) {
                        validCb = name + "." + method.getName() + "()";
                        this.LOGGER.debug("batch pause call back : " + validCb);
                    }
                }
                if (SuperMethodAnnotationScanner.annotationInHierarchy(method, AfterEvent.class)) {
                    this.eventEndMethods.add(0, new CbMethodHandle(method, object, name));
                    if (this.LOGGER.isDebugEnabled()) {
                        validCb = name + "." + method.getName() + "()";
                        this.LOGGER.debug("event end call back : " + validCb);
                    }
                }
                if (SuperMethodAnnotationScanner.annotationInHierarchy(method, OnTrigger.class)) {
                    this.node2UpdateMethodMap.put(object, new CbMethodHandle(method, object, name));
                }
                if (method.getAnnotation(OnEventHandler.class) != null) {
                    this.node2UpdateMethodMap.put(object, new CbMethodHandle(method, object, name));
                }
                if (method.getAnnotation(OnParentUpdate.class) == null) continue;
                CbMethodHandle cbMethodHandle = new CbMethodHandle(method, object, name);
                String val = method.getAnnotation(OnParentUpdate.class).value();
                if (method.getParameterTypes().length != 1) {
                    String errorMsg = "Cannot create OnParentUpdate callback method must have a single parameter " + cbMethodHandle;
                    this.LOGGER.error(errorMsg);
                    throw new RuntimeException(errorMsg);
                }
                ParentFilter filter = new ParentFilter(method.getParameterTypes()[0], val, cbMethodHandle);
                if (val != null && val.length() > 0) {
                    java.lang.reflect.Field field = ClassUtils.getReflectField(object.getClass(), val);
                    field.setAccessible(true);
                    if (field.getAnnotation(NoTriggerReference.class) != null || field.getAnnotation(PushReference.class) != null) {
                        this.LOGGER.debug("IGNORING NoEventReference for parentUpdate");
                    }
                    if (field.get(object) != null) {
                        ParentFilter testFilter;
                        Object parent = field.get(object);
                        if (field.getType().isArray()) {
                            Class<?> classType = field.getType().getComponentType();
                            int length = Array.getLength(parent);
                            for (int i = 0; i < length; ++i) {
                                ParentFilter testFilter2 = new ParentFilter(classType, val, null);
                                if (!testFilter2.match(filter)) continue;
                                parentListenerMultiMap.put(Array.get(parent, i), (Object)cbMethodHandle);
                            }
                        }
                        if (Collection.class.isAssignableFrom(field.getType())) {
                            ParameterizedType integerListType = (ParameterizedType)field.getGenericType();
                            Class classTypeX = Object.class;
                            if (integerListType.getActualTypeArguments()[0] instanceof Class) {
                                classTypeX = (Class)integerListType.getActualTypeArguments()[0];
                            }
                            Class classType = classTypeX;
                            Collection list = (Collection)field.get(object);
                            list.forEach(arg_0 -> SimpleEventProcessorModel.lambda$lifeCycleHandlers$12(classType, val, filter, (Multimap)parentListenerMultiMap, cbMethodHandle, arg_0));
                        }
                        if ((testFilter = new ParentFilter(parent.getClass(), val, null)).exactmatch(filter)) {
                            parentListenerMultiMap.put(parent, (Object)cbMethodHandle);
                            continue;
                        }
                        if (!testFilter.match(filter)) continue;
                        parentListenerMultiMap.put(parent, (Object)cbMethodHandle);
                        continue;
                    }
                    this.LOGGER.debug("Cannot create OnParentUpdate callback" + cbMethodHandle + " no parent field matches:'" + val + "'");
                    continue;
                }
                parentListenerMultiMapUnmatched.put(object, (Object)cbMethodHandle);
            }
        }
        this.createParentCallBacks((Multimap<Object, CbMethodHandle>)parentListenerMultiMap, (Multimap<Object, CbMethodHandle>)parentListenerMultiMapUnmatched);
    }

    private void createParentCallBacks(Multimap<Object, CbMethodHandle> parentListenerMultiMap, Multimap<Object, CbMethodHandle> parentListenerMultiMapUnmatched) throws Exception {
        List<Object> topologicalHandlers = this.dependencyGraph.getSortedDependents();
        for (Object parent2 : topologicalHandlers) {
            this.parentUpdateListenerMethodMap.put(parent2, new ArrayList());
            List<?> directChildren = this.dependencyGraph.getDirectChildren(parent2);
            Collection childCbList = parentListenerMultiMap.get(parent2);
            Set mappedCbs = childCbList.stream().map(cb -> cb.instance).collect(Collectors.toSet());
            directChildren.stream().filter(child -> !mappedCbs.contains(child)).map(arg_0 -> parentListenerMultiMapUnmatched.get(arg_0)).map(cbs -> ClassUtils.findBestParentCB(parent2, cbs)).filter(Objects::nonNull).forEach(bestParentCB -> parentListenerMultiMap.put(parent2, bestParentCB));
        }
        parentListenerMultiMap.keySet().forEach(parent -> {
            List cfr_ignored_0 = this.parentUpdateListenerMethodMap.put(parent, new ArrayList(parentListenerMultiMap.get(parent)));
        });
        this.parentUpdateListenerMethodMap.values().forEach(this.dependencyGraph::sortNodeList);
    }

    private void eventHandlers() throws Exception {
        Map<FilterDescription, List<CbMethodHandle>> handlerMap;
        List<Object> topologicalHandlers = this.dependencyGraph.getSortedDependents();
        ArrayList<EventCallList> eventCbList = new ArrayList<EventCallList>();
        for (Object object : topologicalHandlers) {
            Method[] methodList;
            String name = this.dependencyGraph.getInstanceMap().get(object);
            if (object instanceof EventHandlerNode) {
                eventCbList.add(new EventCallList((EventHandlerNode)object));
            }
            for (Method method : methodList = object.getClass().getMethods()) {
                if (method.getAnnotation(OnEventHandler.class) == null) continue;
                eventCbList.add(new EventCallList(object, method));
            }
            Class<?> clazz = object.getClass();
            for (AnnotatedType annotatedInterface : ClassUtils.getAllAnnotatedAnnotationTypes(clazz, ExportService.class)) {
                if (!annotatedInterface.isAnnotationPresent(ExportService.class)) continue;
                Class interfaceType = (Class)annotatedInterface.getType();
                this.dependencyGraph.getConfig().addInterfaceImplementation(interfaceType);
                for (Method method : interfaceType.getMethods()) {
                    String exportMethodName = method.getName();
                    try {
                        Method method2 = object.getClass().getMethod(exportMethodName, method.getParameterTypes());
                        LongAdder argNumber = new LongAdder();
                        boolean booleanReturn = method2.getReturnType() == Boolean.TYPE;
                        StringBuilder signature = booleanReturn ? new StringBuilder("@Override\npublic boolean " + exportMethodName) : new StringBuilder("@Override\npublic void " + exportMethodName);
                        signature.append('(');
                        StringJoiner sj = new StringJoiner(", ");
                        Type[] params = method2.getGenericParameterTypes();
                        for (int j = 0; j < params.length; ++j) {
                            String param = params[j].getTypeName().replace("$", ".").replace("java.lang.", "");
                            if (method2.isVarArgs() && j == params.length - 1) {
                                param = param.replaceFirst("\\[\\]$", "...");
                            }
                            param = param + " arg" + argNumber.intValue();
                            sj.add(param);
                            argNumber.increment();
                        }
                        signature.append(sj);
                        signature.append(")");
                        eventCbList.add(new EventCallList(object, method2, signature.toString()));
                        if (method2.getAnnotation(NoPropagateFunction.class) != null) continue;
                        this.node2UpdateMethodMap.put(object, new CbMethodHandle(method2, object, name));
                    }
                    catch (NoSuchMethodException argNumber) {
                        // empty catch block
                    }
                }
            }
        }
        for (EventCallList eventCb : eventCbList) {
            if (eventCb.isFiltered) continue;
            Class<?> eventClass = eventCb.eventTypeClass;
            handlerMap = this.getHandlerMap(eventClass);
            ArrayList callList = new ArrayList(eventCb.dispatchMethods);
            if (!eventCb.isInverseFiltered) {
                if (handlerMap.get(FilterDescription.NO_FILTER) == null) {
                    handlerMap.put(FilterDescription.NO_FILTER, callList);
                } else {
                    handlerMap.get(FilterDescription.NO_FILTER).addAll(callList);
                }
            } else if (handlerMap.get(FilterDescription.INVERSE_FILTER) == null) {
                handlerMap.put(FilterDescription.INVERSE_FILTER, callList);
            } else {
                handlerMap.get(FilterDescription.INVERSE_FILTER).addAll(callList);
            }
            handlerMap = this.getPostHandlerMap(eventClass);
            callList = new ArrayList(eventCb.postDispatchMethods);
            if (!eventCb.isInverseFiltered) {
                if (handlerMap.get(FilterDescription.NO_FILTER) == null) {
                    handlerMap.put(FilterDescription.NO_FILTER, callList);
                    continue;
                }
                handlerMap.get(FilterDescription.NO_FILTER).addAll(callList);
                continue;
            }
            if (handlerMap.get(FilterDescription.INVERSE_FILTER) == null) {
                handlerMap.put(FilterDescription.INVERSE_FILTER, callList);
                continue;
            }
            handlerMap.get(FilterDescription.INVERSE_FILTER).addAll(callList);
        }
        Set<Class<?>> eventClassSet = this.dispatchMap.keySet();
        for (Class<?> eventClass : eventClassSet) {
            ArrayList<CbMethodHandle> callList;
            handlerMap = this.getHandlerMap(eventClass);
            List noFilterList = handlerMap.get(FilterDescription.NO_FILTER) == null ? Collections.emptyList() : handlerMap.get(FilterDescription.NO_FILTER);
            List inverseList = handlerMap.get(FilterDescription.INVERSE_FILTER) == null ? Collections.emptyList() : handlerMap.get(FilterDescription.INVERSE_FILTER);
            HashSet set = new HashSet(inverseList);
            set.addAll(noFilterList);
            if (set.size() > 0) {
                callList = new ArrayList<CbMethodHandle>(set);
                this.dependencyGraph.sortNodeList(callList);
                handlerMap.put(FilterDescription.DEFAULT_FILTER, callList);
            }
            noFilterList = (handlerMap = this.getPostHandlerMap(eventClass)).get(FilterDescription.NO_FILTER) == null ? Collections.emptyList() : handlerMap.get(FilterDescription.NO_FILTER);
            inverseList = handlerMap.get(FilterDescription.INVERSE_FILTER) == null ? Collections.emptyList() : handlerMap.get(FilterDescription.INVERSE_FILTER);
            set = new HashSet(inverseList);
            set.addAll(noFilterList);
            if (set.size() <= 0) continue;
            callList = new ArrayList(set);
            this.dependencyGraph.sortNodeList(callList);
            Collections.reverse(callList);
            handlerMap.put(FilterDescription.DEFAULT_FILTER, callList);
        }
        for (EventCallList eventCb : eventCbList) {
            Map<FilterDescription, List<CbMethodHandle>> postHandlerMap;
            List<CbMethodHandle> postCallList;
            FilterDescription filterDescription;
            int filterId = eventCb.filterId;
            String filterString = eventCb.filterString;
            boolean isIntFilter = eventCb.isIntFilter;
            boolean isFiltering = eventCb.isFiltered;
            Class<?> eventClass = eventCb.eventTypeClass;
            if (isIntFilter && isFiltering) {
                filterDescription = this.filterProducer.getFilterDescription(eventClass, filterId);
            } else {
                if (!isFiltering) continue;
                filterDescription = this.filterProducer.getFilterDescription(eventClass, filterString);
            }
            filterDescription.setExportFunction(eventCb.exportMethod);
            Map<FilterDescription, List<CbMethodHandle>> handlerMap2 = this.getHandlerMap(eventClass);
            List<CbMethodHandle> callList = handlerMap2.get(filterDescription);
            if (callList == null) {
                callList = new ArrayList<CbMethodHandle>();
                handlerMap2.put(filterDescription, callList);
                callList.addAll(eventCb.dispatchMethods);
            } else {
                for (Object newCbMethod : eventCb.dispatchMethods) {
                    if (callList.contains(newCbMethod)) continue;
                    callList.add((CbMethodHandle)newCbMethod);
                }
            }
            List<CbMethodHandle> list = handlerMap2.get(FilterDescription.NO_FILTER);
            if (list != null) {
                Object newCbMethod;
                newCbMethod = list.iterator();
                while (newCbMethod.hasNext()) {
                    CbMethodHandle nonFilterCb = (CbMethodHandle)newCbMethod.next();
                    if (callList.contains(nonFilterCb)) continue;
                    callList.add(nonFilterCb);
                }
            }
            if ((postCallList = (postHandlerMap = this.getPostHandlerMap(eventClass)).get(filterDescription)) == null) {
                postCallList = new ArrayList<CbMethodHandle>();
                postHandlerMap.put(filterDescription, postCallList);
                postCallList.addAll(eventCb.postDispatchMethods);
            } else {
                for (CbMethodHandle newCbMethod : eventCb.postDispatchMethods) {
                    if (postCallList.contains(newCbMethod)) continue;
                    postCallList.add(newCbMethod);
                }
            }
            List<CbMethodHandle> nonFilterPoistCbList = postHandlerMap.get(FilterDescription.NO_FILTER);
            if (nonFilterPoistCbList != null) {
                for (CbMethodHandle nonFilterCb : nonFilterPoistCbList) {
                    if (postCallList.contains(nonFilterCb)) continue;
                    postCallList.add(nonFilterCb);
                }
            }
            this.dependencyGraph.sortNodeList(callList);
            this.dependencyGraph.sortNodeList(postCallList);
            Collections.reverse(postCallList);
        }
        this.buildSubClassHandlers();
        this.buildGlobalDispatchList();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug(this.dispatchMapToString());
        }
    }

    private void buildGlobalDispatchList() {
        this.allEventCallBacks = this.dispatchMap.values().stream().map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        this.dependencyGraph.sortNodeList(this.allEventCallBacks);
        this.allPostEventCallBacks = this.postDispatchMap.values().stream().map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        this.dependencyGraph.sortNodeList(this.allPostEventCallBacks);
        Collections.reverse(this.allPostEventCallBacks);
        this.handlerOnlyDispatchMap = new HashMap();
        Set<Class<?>> keySet = this.dispatchMap.keySet();
        HashSet classSet = new HashSet(keySet);
        ArrayList clazzList = new ArrayList(classSet);
        clazzList.sort(Comparator.comparing(Class::getName));
        for (Class<?> evenClazz : clazzList) {
            Map<FilterDescription, List<CbMethodHandle>> originalFilterMap = this.dispatchMap.get(evenClazz);
            HashMap filterDispatchMap = new HashMap();
            this.handlerOnlyDispatchMap.put(evenClazz, filterDispatchMap);
            originalFilterMap.forEach((filter, cbList) -> filterDispatchMap.put(filter, cbList.stream().filter(cb -> cb.isEventHandler() || cb.isNoPropagateEventHandler()).collect(Collectors.toList())));
        }
    }

    public List<?> getDirectChildrenListeningForEvent(Object parent) {
        return this.dependencyGraph.getDirectChildrenListeningForEvent(parent);
    }

    private void buildSubClassHandlers() {
        Set<Class<?>> eventClassSet = this.dispatchMap.keySet();
        for (Class<?> eventClass : eventClassSet) {
            this.LOGGER.debug("------- START superclass merge Class:" + eventClass.getSimpleName() + " START -----------");
            Map<FilterDescription, List<CbMethodHandle>> targetHandlerMap = this.getHandlerMap(eventClass);
            this.LOGGER.debug("targetHandlerMap before merge:{}", targetHandlerMap);
            this.dispatchMap.entrySet().stream().filter(e -> {
                boolean match;
                Class key = (Class)e.getKey();
                boolean bl = match = key.isAssignableFrom(eventClass) && eventClass != key;
                if (match) {
                    this.LOGGER.debug(key.getSimpleName() + " IS superclass of:" + eventClass.getSimpleName());
                } else {
                    this.LOGGER.debug(key.getSimpleName() + " NOT superclass of:" + eventClass.getSimpleName());
                }
                return match;
            }).map(Map.Entry::getValue).map(e -> {
                HashMap newMap = new HashMap();
                e.forEach((key, value) -> newMap.put(key.changeClass(eventClass), value));
                return newMap;
            }).forEach(fd -> fd.forEach((key, callList) -> targetHandlerMap.merge((FilterDescription)key, (List<CbMethodHandle>)callList, (t, u) -> {
                this.LOGGER.debug("merging:{}", u);
                t.removeAll((Collection<?>)u);
                t.addAll(u);
                this.dependencyGraph.sortNodeList((List<CbMethodHandle>)t);
                return t;
            })));
            this.LOGGER.debug("targetHandlerMap after merge:{}", targetHandlerMap);
            this.LOGGER.debug("------- END superclass merge Class:" + eventClass.getSimpleName() + " END -----------\n");
        }
    }

    private Map<FilterDescription, List<CbMethodHandle>> getHandlerMap(Class<?> eventClass) {
        return this.dispatchMap.computeIfAbsent(eventClass, k -> new HashMap());
    }

    private Map<FilterDescription, List<CbMethodHandle>> getPostHandlerMap(Class<?> eventClass) {
        return this.postDispatchMap.computeIfAbsent(eventClass, k -> new HashMap());
    }

    private boolean noDirtyFlagNeeded(Field node) {
        Method[] methodList;
        boolean notRequired = this.dependencyGraph.getDirectChildrenListeningForEvent(node.instance).isEmpty() && this.parentUpdateListenerMethodMap.get(node.instance).isEmpty();
        for (Method method : methodList = node.instance.getClass().getDeclaredMethods()) {
            if (!SuperMethodAnnotationScanner.annotationInHierarchy(method, AfterTrigger.class)) continue;
            notRequired = false;
        }
        return notRequired;
    }

    private void buildDirtySupport() throws Exception {
        if (this.supportDirtyFiltering()) {
            for (Field field : this.nodeFields) {
                DirtyFlag flag;
                if (this.noDirtyFlagNeeded(field)) continue;
                CbMethodHandle cbHandle = this.node2UpdateMethodMap.get(field.instance);
                if (cbHandle != null && cbHandle.method.getReturnType() == Boolean.TYPE) {
                    flag = new DirtyFlag(field, "isDirty_" + field.name);
                    this.dirtyFieldMap.put(field, flag);
                    continue;
                }
                if (cbHandle == null || cbHandle.method.getReturnType() != Void.TYPE) continue;
                flag = new DirtyFlag(field, "isDirty_" + field.name, true);
                this.dirtyFieldMap.put(field, flag);
            }
            for (Object object : this.dependencyGraph.getSortedDependents()) {
                List<?> directParents = this.dependencyGraph.getDirectParentsListeningForEvent(object);
                if (directParents.isEmpty()) continue;
                CbMethodHandle cb = this.node2UpdateMethodMap.get(object);
                boolean invertedDirtyHandler = cb != null && cb.isInvertedDirtyHandler;
                boolean failIfNotGuarded = cb != null && cb.failBuildOnUnguardedTrigger();
                HashSet<DirtyFlag> guardSet = new HashSet<DirtyFlag>();
                for (Object parent : directParents) {
                    DirtyFlag parentDirtyFlag = this.getDirtyFlagForUpdateCb(this.node2UpdateMethodMap.get(parent));
                    DirtyFlag methodFlag = null;
                    if (parentDirtyFlag != null) {
                        parentDirtyFlag.requiresInvert |= invertedDirtyHandler;
                        methodFlag = parentDirtyFlag.clone();
                        methodFlag.requiresInvert = invertedDirtyHandler;
                    }
                    Collection parentDirtyFlags = this.nodeGuardMap.get(parent);
                    if (methodFlag != null) {
                        guardSet.add(methodFlag);
                        continue;
                    }
                    if (!parentDirtyFlags.isEmpty()) {
                        guardSet.addAll(parentDirtyFlags);
                        continue;
                    }
                    guardSet.clear();
                    break;
                }
                if (failIfNotGuarded && guardSet.isEmpty()) {
                    String failMessage = "Failed guard check for trigger method:" + cb;
                    throw new RuntimeException(failMessage);
                }
                this.nodeGuardMap.putAll(object, guardSet);
            }
        }
    }

    private void filterList() {
        HashSet<FilterDescription> uniqueFilterSet = new HashSet<FilterDescription>();
        for (Map<FilterDescription, List<CbMethodHandle>> value : this.dispatchMap.values()) {
            uniqueFilterSet.addAll(value.keySet());
        }
        for (Map<FilterDescription, List<CbMethodHandle>> value : this.postDispatchMap.values()) {
            uniqueFilterSet.addAll(value.keySet());
        }
        this.filterDescriptionList.addAll(uniqueFilterSet);
        this.filterDescriptionList.remove(FilterDescription.NO_FILTER);
        this.LOGGER.debug("filterList:" + this.filterDescriptionList);
    }

    public DirtyFlag getDirtyFlagForNode(Object node) {
        return this.dirtyFieldMap.get(this.getFieldForInstance(node));
    }

    public Collection<DirtyFlag> getNodeGuardConditions(Object node) {
        ArrayList<DirtyFlag> guards = new ArrayList<DirtyFlag>(this.nodeGuardMap.get(node));
        guards.sort((o1, o2) -> this.comparator.compare(o1.name, o2.name));
        return guards;
    }

    public Collection<DirtyFlag> getNodeGuardConditions(CbMethodHandle cb) {
        if (cb.isPostEventHandler && this.dependencyGraph.getDirectParents(cb.instance).isEmpty()) {
            return this.getDirtyFlagForNode(cb.instance) == null ? Collections.emptyList() : Collections.singletonList(this.getDirtyFlagForNode(cb.instance));
        }
        return cb.isEventHandler ? Collections.emptySet() : this.getNodeGuardConditions(cb.instance);
    }

    public DirtyFlag getDirtyFlagForUpdateCb(CbMethodHandle cbHandle) {
        DirtyFlag flag = null;
        if (this.supportDirtyFiltering() && cbHandle != null) {
            flag = this.dirtyFieldMap.get(this.getFieldForInstance(cbHandle.instance));
            if (cbHandle.method.getReturnType() != Boolean.TYPE && flag != null) {
                flag.alwaysDirty = true;
            }
        }
        return flag;
    }

    public Field getFieldForInstance(Object object) {
        Field ret = null;
        for (Field nodeField : this.nodeFields) {
            if (nodeField.instance != object) continue;
            ret = nodeField;
            break;
        }
        return ret;
    }

    public Field getFieldForName(String name) {
        return this.nodeFields.stream().filter(f -> f.name.equals(name)).findFirst().orElse(null);
    }

    public Set<Object> getOnTriggerDependenciesForNode(CbMethodHandle callSource) {
        if (callSource.isNoPropagateEventHandler()) {
            return Collections.emptySet();
        }
        return this.getOnTriggerDependenciesForNode(callSource.getInstance());
    }

    public Set<Object> getOnTriggerDependenciesForNode(Object instance) {
        return this.getDirectChildrenListeningForEvent(instance).stream().peek(o -> log.debug("checking for OnEvent instance:{}", o)).filter(object -> !ReflectionUtils.getAllMethods(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(OnTrigger.class)}).isEmpty()).collect(Collectors.toSet());
    }

    public String getMappedClass(String className) {
        if (this.dependencyGraph == null || this.dependencyGraph.getConfig() == null) {
            return className;
        }
        return this.dependencyGraph.getConfig().getClass2replace().getOrDefault(className, className);
    }

    private boolean supportDirtyFiltering() {
        return this.supportDirtyFiltering;
    }

    public List<Field> getNodeFields() {
        return Collections.unmodifiableList(this.nodeFields);
    }

    public List<Field> getTopologicallySortedNodeFields() {
        return Collections.unmodifiableList(this.nodeFieldsSortedTopologically);
    }

    public List<Field> getNodeRegistrationListenerFields() {
        return Collections.unmodifiableList(this.registrationListenerFields);
    }

    public List<CbMethodHandle> getInitialiseMethods() {
        return Collections.unmodifiableList(this.initialiseMethods);
    }

    public List<CbMethodHandle> getStartMethods() {
        return Collections.unmodifiableList(this.startMethods);
    }

    public List<CbMethodHandle> getStopMethods() {
        return Collections.unmodifiableList(this.stopMethods);
    }

    public List<CbMethodHandle> getTearDownMethods() {
        return Collections.unmodifiableList(this.tearDownMethods);
    }

    public List<CbMethodHandle> getBatchEndMethods() {
        return Collections.unmodifiableList(this.batchEndMethods);
    }

    public List<CbMethodHandle> getBatchPauseMethods() {
        return Collections.unmodifiableList(this.batchPauseMethods);
    }

    public List<CbMethodHandle> getEventEndMethods() {
        return Collections.unmodifiableList(this.eventEndMethods);
    }

    public List<CbMethodHandle> getDispatchMapForGraph() {
        return Collections.unmodifiableList(this.allEventCallBacks);
    }

    public List<CbMethodHandle> getAllPostEventCallBacks() {
        return Collections.unmodifiableList(this.allPostEventCallBacks);
    }

    public List<CbMethodHandle> getTriggerOnlyCallBacks() {
        if (this.triggerOnlyCallBacks == null) {
            this.triggerOnlyCallBacks = Collections.unmodifiableList(this.allEventCallBacks.stream().filter(cb -> !cb.isEventHandler() && !cb.isNoPropagateEventHandler()).collect(Collectors.toList()));
        }
        return this.triggerOnlyCallBacks;
    }

    public Set<Object> getForkedTriggerInstances() {
        if (this.forkedTriggerInstances == null) {
            this.forkedTriggerInstances = Collections.unmodifiableSet(this.getTriggerOnlyCallBacks().stream().filter(CbMethodHandle::isForkExecution).map(CbMethodHandle::getInstance).collect(Collectors.toSet()));
        }
        return this.forkedTriggerInstances;
    }

    public Map<Class<?>, Map<FilterDescription, List<CbMethodHandle>>> getDispatchMap() {
        return Collections.unmodifiableMap(this.dispatchMap);
    }

    public Map<Class<?>, Map<FilterDescription, List<CbMethodHandle>>> getPostDispatchMap() {
        return Collections.unmodifiableMap(this.postDispatchMap);
    }

    public Map<Class<?>, Map<FilterDescription, List<CbMethodHandle>>> getHandlerOnlyDispatchMap() {
        return Collections.unmodifiableMap(this.handlerOnlyDispatchMap);
    }

    public Map<Method, ExportFunctionData> getExportedFunctionMap() {
        return Collections.unmodifiableMap(this.dependencyGraph.getExportedFunctionMap());
    }

    public Map<Object, List<CbMethodHandle>> getParentUpdateListenerMethodMap() {
        return Collections.unmodifiableMap(this.parentUpdateListenerMethodMap);
    }

    public Map<Field, DirtyFlag> getDirtyFieldMap() {
        return Collections.unmodifiableMap(this.dirtyFieldMap);
    }

    public List<FilterDescription> getFilterDescriptionList() {
        return Collections.unmodifiableList(this.filterDescriptionList);
    }

    public FieldSerializer getFieldSerializer() {
        return this.fieldSerializer;
    }

    public Set<Class<?>> getImportClasses() {
        return Collections.unmodifiableSet(this.importClasses);
    }

    private String dispatchMapToString() {
        List<CbMethodHandle> cbList;
        int filterId;
        Set<FilterDescription> filterIdSet;
        Map<FilterDescription, List<CbMethodHandle>> cbMap;
        StringBuilder result = new StringBuilder("DispatchMap[\n");
        Set<Class<?>> keySet = this.dispatchMap.keySet();
        for (Class<?> eventId : keySet) {
            result.append("\tEvent Id:").append(eventId).append("\n");
            cbMap = this.dispatchMap.get(eventId);
            filterIdSet = cbMap.keySet();
            for (FilterDescription filterDescription : filterIdSet) {
                filterId = filterDescription.value;
                result.append("\t\tFilter Id:").append(filterId).append("\n");
                cbList = cbMap.get(filterDescription);
                for (CbMethodHandle cbMethod : cbList) {
                    result.append("\t\t\t").append(cbMethod).append("\n");
                }
            }
        }
        result.append("]\n");
        result.append("PostDispatchMap[\n");
        keySet = this.postDispatchMap.keySet();
        for (Class<?> eventId : keySet) {
            result.append("\tEvent Id:").append(eventId).append("\n");
            cbMap = this.dispatchMap.get(eventId);
            filterIdSet = cbMap.keySet();
            for (FilterDescription filterDescription : filterIdSet) {
                filterId = filterDescription.value;
                result.append("\t\tFilter Id:").append(filterId).append("\n");
                cbList = cbMap.get(filterDescription);
                for (CbMethodHandle cbMethod : cbList) {
                    result.append("\t\t\t").append(cbMethod).append("\n");
                }
            }
        }
        result.append("]");
        return result.toString();
    }

    private static /* synthetic */ void lambda$lifeCycleHandlers$12(Class classType, String val, ParentFilter filter, Multimap parentListenerMultiMap, CbMethodHandle cbMethodHandle, Object parent1) {
        ParentFilter testFilter = new ParentFilter(classType, val, null);
        if (testFilter.match(filter)) {
            parentListenerMultiMap.put(parent1, (Object)cbMethodHandle);
        }
    }

    private class EventCallList {
        final int filterId;
        final String filterString;
        final boolean isIntFilter;
        final boolean isFiltered;
        final boolean isInverseFiltered;
        final Class<?> eventTypeClass;
        final Method exportMethod;
        private final List<?> sortedDependents;
        private final List<CbMethodHandle> dispatchMethods;
        private final List<CbMethodHandle> postDispatchMethods;

        EventCallList(EventHandlerNode<?> eh) throws Exception {
            this.filterId = SimpleEventProcessorModel.this.filterMap.containsKey(eh) ? ((Integer)SimpleEventProcessorModel.this.filterMap.get(eh)).intValue() : eh.filterId();
            this.sortedDependents = SimpleEventProcessorModel.this.dependencyGraph.getEventSortedDependents(eh);
            this.dispatchMethods = new ArrayList<CbMethodHandle>();
            this.postDispatchMethods = new ArrayList<CbMethodHandle>();
            this.exportMethod = null;
            this.eventTypeClass = eh.eventClass() == null ? TypeResolver.resolveRawArguments(EventHandlerNode.class, eh.getClass())[0] : eh.eventClass();
            Set ehMethodList = ReflectionUtils.getAllMethods(eh.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withModifier((int)1).and(ReflectionUtils.withName((String)"onEvent")).and(ReflectionUtils.withParametersCount((int)1))});
            Method onEventMethod = (Method)ehMethodList.iterator().next();
            String name = SimpleEventProcessorModel.this.dependencyGraph.variableName(eh);
            CbMethodHandle cbMethodHandle = new CbMethodHandle(onEventMethod, eh, name, this.eventTypeClass, true, false);
            this.dispatchMethods.add(cbMethodHandle);
            SimpleEventProcessorModel.this.node2UpdateMethodMap.put(eh, cbMethodHandle);
            for (int i = 1; i < this.sortedDependents.size(); ++i) {
                Method[] methodList;
                Object object = this.sortedDependents.get(i);
                if (object == eh) continue;
                name = SimpleEventProcessorModel.this.dependencyGraph.variableName(object);
                for (Method method : methodList = object.getClass().getMethods()) {
                    if (SuperMethodAnnotationScanner.annotationInHierarchy(method, OnTrigger.class)) {
                        this.dispatchMethods.add(new CbMethodHandle(method, object, name));
                    }
                    if (!SuperMethodAnnotationScanner.annotationInHierarchy(method, AfterTrigger.class)) continue;
                    this.postDispatchMethods.add(new CbMethodHandle(method, object, name));
                }
            }
            this.filterString = eh.filterString();
            boolean isStrFilter = this.filterString != null && !this.filterString.isEmpty();
            this.isIntFilter = this.filterId != Integer.MAX_VALUE;
            this.isFiltered = this.filterId != Integer.MAX_VALUE || isStrFilter;
            this.isInverseFiltered = false;
        }

        EventCallList(Object instance, Method onEventMethod, String exportedMethodName) throws Exception {
            Method[] methodList;
            this.sortedDependents = onEventMethod.getAnnotation(NoPropagateFunction.class) == null ? SimpleEventProcessorModel.this.dependencyGraph.getEventSortedDependents(instance) : Collections.EMPTY_LIST;
            this.exportMethod = onEventMethod;
            this.dispatchMethods = new ArrayList<CbMethodHandle>();
            this.postDispatchMethods = new ArrayList<CbMethodHandle>();
            this.eventTypeClass = ExportFunctionMarker.class;
            this.filterId = 0;
            this.filterString = exportedMethodName;
            this.isIntFilter = false;
            this.isFiltered = true;
            this.isInverseFiltered = false;
            String name = SimpleEventProcessorModel.this.dependencyGraph.variableName(instance);
            this.dispatchMethods.add(new CbMethodHandle(onEventMethod, instance, name, this.eventTypeClass, true, true));
            for (Method method : methodList = instance.getClass().getMethods()) {
                if (!SuperMethodAnnotationScanner.annotationInHierarchy(method, AfterTrigger.class)) continue;
                this.postDispatchMethods.add(new CbMethodHandle(method, instance, name));
            }
            for (int i = 0; i < this.sortedDependents.size(); ++i) {
                Object object = this.sortedDependents.get(i);
                if (object == instance) continue;
                name = SimpleEventProcessorModel.this.dependencyGraph.variableName(object);
                for (Method method : methodList = object.getClass().getMethods()) {
                    if (SuperMethodAnnotationScanner.annotationInHierarchy(method, OnTrigger.class)) {
                        this.dispatchMethods.add(new CbMethodHandle(method, object, name));
                    }
                    if (!SuperMethodAnnotationScanner.annotationInHierarchy(method, AfterTrigger.class) || i <= 0) continue;
                    this.postDispatchMethods.add(new CbMethodHandle(method, object, name));
                }
            }
        }

        EventCallList(Object instance, Method onEventMethod) throws Exception {
            Method[] methodList;
            String tmpFilterString = null;
            int tmpFilterId = 0;
            boolean tmpIsIntFilter = true;
            boolean tmpIsFiltered = true;
            boolean tmpIsInverseFiltered = false;
            this.exportMethod = null;
            Set fields = ReflectionUtils.getAllFields(instance.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(FilterId.class)});
            OnEventHandler annotation = onEventMethod.getAnnotation(OnEventHandler.class);
            int filterIdOverride = annotation.filterId();
            String filterStringOverride = annotation.filterStringFromClass() != Void.TYPE ? annotation.filterStringFromClass().getCanonicalName() : annotation.filterString();
            Set s = ReflectionUtils.getAllFields(instance.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)annotation.filterVariable())});
            if (annotation.filterVariable().length() > 0 && s.size() > 0) {
                java.lang.reflect.Field f = (java.lang.reflect.Field)s.iterator().next();
                f.setAccessible(true);
                if (f.get(instance) != null) {
                    if (f.getType().equals(String.class)) {
                        filterStringOverride = (String)f.get(instance);
                    } else if (f.getType().equals(Integer.TYPE)) {
                        filterIdOverride = f.getInt(instance);
                    } else if (f.getType().equals(Character.TYPE)) {
                        filterIdOverride = f.getChar(instance);
                    } else if (f.getType().equals(Byte.TYPE)) {
                        filterIdOverride = f.getByte(instance);
                    } else if (f.getType().equals(Short.TYPE)) {
                        filterIdOverride = f.getShort(instance);
                    } else {
                        filterStringOverride = f.get(instance).toString();
                    }
                }
            }
            boolean overrideFilter = filterIdOverride != Integer.MAX_VALUE;
            boolean overideStringFilter = filterStringOverride != null && !filterStringOverride.isEmpty();
            OptionalInt overrideMethodFilter = SimpleEventProcessorModel.this.filterMap.entrySet().stream().filter(e -> e.getKey() instanceof EventHandlerFilterOverride).filter(e -> {
                EventHandlerFilterOverride override = (EventHandlerFilterOverride)e.getKey();
                return override.getEventHandlerInstance() == instance && override.getEventType() == onEventMethod.getParameterTypes()[0];
            }).mapToInt(Map.Entry::getValue).findFirst();
            if (overrideMethodFilter.isPresent()) {
                tmpFilterId = overrideMethodFilter.getAsInt();
            } else if (SimpleEventProcessorModel.this.filterMap.containsKey(instance)) {
                tmpFilterId = (Integer)SimpleEventProcessorModel.this.filterMap.get(instance);
            } else if (fields.isEmpty() && overrideFilter) {
                tmpFilterId = filterIdOverride;
            } else if (fields.isEmpty() && overideStringFilter) {
                tmpFilterString = filterStringOverride;
                tmpIsIntFilter = false;
            } else if (fields.isEmpty()) {
                tmpIsFiltered = false;
                tmpIsIntFilter = false;
                tmpIsInverseFiltered = annotation.value() == FilterType.defaultCase;
            } else {
                java.lang.reflect.Field field = (java.lang.reflect.Field)fields.iterator().next();
                field.setAccessible(true);
                Class<?> type = field.getType();
                if (type == Integer.TYPE) {
                    tmpFilterId = field.getInt(instance);
                    tmpIsFiltered = tmpFilterId != Integer.MAX_VALUE;
                } else if (type == String.class) {
                    tmpFilterString = (String)field.get(instance);
                    tmpIsIntFilter = false;
                    if (tmpFilterString == null || tmpFilterString.isEmpty()) {
                        tmpIsFiltered = false;
                    }
                } else {
                    throw new IllegalArgumentException("the annotation filter can only annotate int or String fields");
                }
            }
            this.sortedDependents = annotation.propagate() ? SimpleEventProcessorModel.this.dependencyGraph.getEventSortedDependents(instance) : Collections.EMPTY_LIST;
            this.dispatchMethods = new ArrayList<CbMethodHandle>();
            this.postDispatchMethods = new ArrayList<CbMethodHandle>();
            this.eventTypeClass = annotation.ofType() == Void.TYPE ? onEventMethod.getParameterTypes()[0] : annotation.ofType();
            String name = SimpleEventProcessorModel.this.dependencyGraph.variableName(instance);
            this.dispatchMethods.add(new CbMethodHandle(onEventMethod, instance, name, this.eventTypeClass, true, false));
            for (Method method : methodList = instance.getClass().getMethods()) {
                if (!SuperMethodAnnotationScanner.annotationInHierarchy(method, AfterTrigger.class)) continue;
                this.postDispatchMethods.add(new CbMethodHandle(method, instance, name));
            }
            for (int i = 0; i < this.sortedDependents.size(); ++i) {
                Object object = this.sortedDependents.get(i);
                if (object == instance) continue;
                name = SimpleEventProcessorModel.this.dependencyGraph.variableName(object);
                for (Method method : methodList = object.getClass().getMethods()) {
                    if (SuperMethodAnnotationScanner.annotationInHierarchy(method, OnTrigger.class)) {
                        this.dispatchMethods.add(new CbMethodHandle(method, object, name));
                    }
                    if (!SuperMethodAnnotationScanner.annotationInHierarchy(method, AfterTrigger.class) || i <= 0) continue;
                    this.postDispatchMethods.add(new CbMethodHandle(method, object, name));
                }
            }
            this.filterId = tmpFilterId;
            this.filterString = tmpFilterString;
            this.isIntFilter = tmpIsIntFilter;
            this.isFiltered = tmpIsFiltered;
            this.isInverseFiltered = tmpIsInverseFiltered;
        }
    }
}

