/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.model;

import com.fluxtion.compiler.EventProcessorConfig;
import com.fluxtion.compiler.RootNodeConfig;
import com.fluxtion.compiler.builder.factory.NodeFactory;
import com.fluxtion.compiler.builder.factory.NodeFactoryRegistration;
import com.fluxtion.compiler.builder.factory.NodeNameProducer;
import com.fluxtion.compiler.builder.factory.NodeRegistry;
import com.fluxtion.compiler.generation.GenerationContext;
import com.fluxtion.compiler.generation.exporter.JgraphGraphMLExporter;
import com.fluxtion.compiler.generation.model.CbMethodHandle;
import com.fluxtion.compiler.generation.model.ExportFunctionData;
import com.fluxtion.compiler.generation.model.NamingStrategy;
import com.fluxtion.compiler.generation.util.ClassUtils;
import com.fluxtion.compiler.generation.util.NaturalOrderComparator;
import com.fluxtion.runtime.annotations.AfterEvent;
import com.fluxtion.runtime.annotations.AfterTrigger;
import com.fluxtion.runtime.annotations.ExportService;
import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnBatchEnd;
import com.fluxtion.runtime.annotations.OnBatchPause;
import com.fluxtion.runtime.annotations.OnEventHandler;
import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.PushReference;
import com.fluxtion.runtime.annotations.TearDown;
import com.fluxtion.runtime.annotations.TriggerEventOverride;
import com.fluxtion.runtime.annotations.builder.Config;
import com.fluxtion.runtime.annotations.builder.ConfigVariable;
import com.fluxtion.runtime.annotations.builder.ExcludeNode;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.annotations.builder.SepNode;
import com.fluxtion.runtime.audit.Auditor;
import com.fluxtion.runtime.node.Anchor;
import com.fluxtion.runtime.node.EventHandlerNode;
import com.fluxtion.runtime.partition.LambdaReflection;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.googlecode.gentyref.GenericTypeReflector;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerConfigurationException;
import net.vidageek.mirror.dsl.AccessorsController;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.reflect.dsl.ReflectionHandler;
import org.apache.commons.lang3.StringUtils;
import org.jgrapht.Graph;
import org.jgrapht.ext.IntegerEdgeNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.DepthFirstIterator;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TopologicallySortedDependencyGraph
implements NodeRegistry {
    private final Logger LOGGER = LoggerFactory.getLogger(TopologicallySortedDependencyGraph.class);
    private final BiMap<Object, String> inst2NameTemp;
    private final SimpleDirectedGraph<Object, DefaultEdge> graph = new SimpleDirectedGraph(DefaultEdge.class);
    private final SimpleDirectedGraph<Object, DefaultEdge> eventGraph = new SimpleDirectedGraph(DefaultEdge.class);
    private final Set<DefaultEdge> pushEdges = new HashSet<DefaultEdge>();
    private final List<Object> topologicalHandlers = new ArrayList<Object>();
    private final List<Object> noPushTopologicalHandlers = new ArrayList<Object>();
    private final Map<Method, ExportFunctionData> exportedFunctionMap;
    private final NodeFactoryRegistration nodeFactoryRegistration;
    private final HashMap<Class<?>, CbMethodHandle> class2FactoryMethod;
    private final HashMap<String, CbMethodHandle> name2FactoryMethod;
    private final List<Object> publicNodeList;
    private final GenerationContext generationContext;
    private final NodeNameProducer nameStrategy;
    private final EventProcessorConfig config;
    private Map<String, Auditor> registrationListenerMap;
    private BiMap<Object, String> inst2Name;
    private boolean processed = false;

    public TopologicallySortedDependencyGraph(Object ... obj) {
        this(Arrays.asList(obj));
    }

    public TopologicallySortedDependencyGraph(List<?> nodes) {
        this(nodes, null, null, null, null, null);
    }

    public TopologicallySortedDependencyGraph(Map<Object, String> publicNodes) {
        this(null, publicNodes, null, null, null, null);
    }

    public TopologicallySortedDependencyGraph(EventProcessorConfig config) {
        this(config.getNodeList(), config.getPublicNodes(), config.getNodeFactoryRegistration(), GenerationContext.SINGLETON, config.getAuditorMap(), config);
    }

    public TopologicallySortedDependencyGraph(List<?> nodes, Map<Object, String> publicNodes, NodeFactoryRegistration nodeFactoryRegistration, GenerationContext context, Map<String, Auditor> auditorMap, EventProcessorConfig config) {
        this.config = config;
        this.nameStrategy = new NamingStrategy();
        this.inst2Name = HashBiMap.create();
        this.inst2NameTemp = HashBiMap.create();
        this.class2FactoryMethod = new HashMap();
        this.name2FactoryMethod = new HashMap();
        this.exportedFunctionMap = new HashMap<Method, ExportFunctionData>();
        if (nodes == null) {
            nodes = Collections.EMPTY_LIST;
        }
        for (Object e : nodes) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("adding:'" + e + "' name:'" + this.nameNode(e) + "'");
            }
            this.inst2Name.put(e, (Object)this.nameNode(e));
        }
        nodes = Collections.EMPTY_LIST;
        if (context != null && context.getNodeList() != null) {
            nodes = context.getNodeList();
        }
        this.addNodeList(nodes);
        if (config != null && config.getRootNodeConfig() != null) {
            this.addNodeList(config.getRootNodeConfig().getNodes());
        }
        this.publicNodeList = new ArrayList<Object>();
        if (context != null && context.getPublicNodes() != null) {
            this.inst2Name.putAll(context.getPublicNodes());
            this.publicNodeList.addAll(context.getPublicNodes().keySet());
        }
        if (publicNodes != null) {
            this.inst2Name.putAll(publicNodes);
            this.publicNodeList.addAll(publicNodes.keySet());
        }
        if (auditorMap == null) {
            auditorMap = new HashMap<String, Auditor>();
        }
        this.registrationListenerMap = auditorMap;
        this.registrationListenerMap.forEach((key, value) -> {
            this.inst2Name.put(value, key);
            this.publicNodeList.add(value);
        });
        this.nodeFactoryRegistration = nodeFactoryRegistration;
        this.generationContext = context;
    }

    public static boolean trySetAccessible(Field field) {
        try {
            field.setAccessible(true);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private void addNodeList(List<?> nodes) {
        if (nodes != null) {
            for (Object node : nodes) {
                if (this.inst2Name.containsKey(node)) continue;
                String name = this.nameNode(node);
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("from context adding:'" + node + "' name:'" + name + "'");
                }
                this.inst2Name.put(node, (Object)name);
            }
        }
    }

    public String variableName(Object node) {
        return (String)this.inst2Name.get(node);
    }

    public Map<Object, String> getInstanceMap() {
        return Collections.unmodifiableMap(this.inst2Name);
    }

    public List<Object> getSortedDependents() throws Exception {
        this.generateDependencyTree();
        return Collections.unmodifiableList(this.topologicalHandlers);
    }

    public List<Object> getObjectSortedDependents() throws Exception {
        this.generateDependencyTree();
        return Collections.unmodifiableList(this.noPushTopologicalHandlers);
    }

    public Map<Method, ExportFunctionData> getExportedFunctionMap() {
        return Collections.unmodifiableMap(this.exportedFunctionMap);
    }

    public Map<String, Auditor> getRegistrationListenerMap() {
        if (this.registrationListenerMap == null) {
            this.registrationListenerMap = new HashMap<String, Auditor>();
        }
        return Collections.unmodifiableMap(this.registrationListenerMap);
    }

    public List<Object> getSortedDependents(Object obj) throws Exception {
        this.generateDependencyTree();
        ArrayList<Integer> lst = new ArrayList<Integer>();
        if (this.graph.containsVertex(obj)) {
            DepthFirstIterator iterator = new DepthFirstIterator(this.graph, obj);
            while (iterator.hasNext()) {
                int idx = this.topologicalHandlers.indexOf(iterator.next());
                lst.add(idx);
            }
        }
        Collections.sort(lst);
        ArrayList<Object> cbList = new ArrayList<Object>();
        for (Integer idx : lst) {
            cbList.add(this.topologicalHandlers.get(idx));
        }
        return cbList;
    }

    public List<Object> getEventSortedDependents(Object obj) throws Exception {
        this.generateDependencyTree();
        ArrayList<Integer> lst = new ArrayList<Integer>();
        if (this.eventGraph.containsVertex(obj)) {
            DepthFirstIterator iter = new DepthFirstIterator(this.eventGraph, obj);
            while (iter.hasNext()) {
                int idx = this.topologicalHandlers.indexOf(iter.next());
                lst.add(idx);
            }
        }
        Collections.sort(lst);
        ArrayList<Object> cbList = new ArrayList<Object>();
        for (Integer idx : lst) {
            cbList.add(this.topologicalHandlers.get(idx));
        }
        return cbList;
    }

    public List<?> getDirectChildren(Object parent) {
        ArrayList<Object> lst = new ArrayList<Object>();
        if (this.graph.containsVertex(parent)) {
            Set outgoingEdgeSet = this.graph.outgoingEdgesOf(parent);
            for (DefaultEdge childEdge : outgoingEdgeSet) {
                lst.add(this.graph.getEdgeTarget((Object)childEdge));
            }
        }
        return lst;
    }

    public List<?> getDirectChildrenListeningForEvent(Object parent) {
        ArrayList<Object> lst = new ArrayList<Object>();
        if (this.eventGraph.containsVertex(parent)) {
            Set outgoingEdgeSet = this.eventGraph.outgoingEdgesOf(parent);
            for (DefaultEdge childEdge : outgoingEdgeSet) {
                lst.add(this.eventGraph.getEdgeTarget((Object)childEdge));
            }
        }
        return lst;
    }

    public List<?> getDirectParents(Object child) {
        ArrayList<Object> lst = new ArrayList<Object>();
        if (this.graph.containsVertex(child)) {
            Set outgoingEdgeSet = this.graph.incomingEdgesOf(child);
            for (DefaultEdge parentEdge : outgoingEdgeSet) {
                lst.add(this.graph.getEdgeSource((Object)parentEdge));
            }
        }
        return lst;
    }

    public List<?> getDirectParentsListeningForEvent(Object child) {
        ArrayList<Object> lst = new ArrayList<Object>();
        if (this.eventGraph.containsVertex(child)) {
            Set outgoingEdgeSet = this.eventGraph.incomingEdgesOf(child);
            for (DefaultEdge parentEdge : outgoingEdgeSet) {
                lst.add(this.eventGraph.getEdgeSource((Object)parentEdge));
            }
        }
        return lst;
    }

    @Override
    public <T> T registerPublicNode(T node, String variableName) {
        return this.registerNode(node, variableName, true);
    }

    @Override
    public <T extends Auditor> T registerAuditor(T node, String auditorName) {
        T registerNode = this.registerNode(node, auditorName, true);
        this.registrationListenerMap.put(auditorName, registerNode);
        return registerNode;
    }

    public <T> T registerNode(T node, String variableName, boolean isPublic) {
        if (variableName == null && this.inst2Name.containsKey(node)) {
            return (T)this.inst2Name.get(node);
        }
        if (variableName == null) {
            variableName = this.nameNode(node);
        }
        if (this.inst2Name.containsValue((Object)variableName) && !variableName.equals(this.inst2Name.get(node))) {
            throw new RuntimeException("Variable name:'" + variableName + "' already used for another node:'" + this.inst2Name.inverse().get((Object)variableName) + "', cannot add node:" + node);
        }
        if (this.inst2Name.containsKey(node) && !variableName.equals(this.inst2Name.get(node))) {
            throw new RuntimeException("Cannot remap node:" + node + " to new variable name:'" + variableName + "'  existing variable name:'" + (String)this.inst2Name.get(node) + "'");
        }
        this.inst2Name.put(node, (Object)variableName);
        if (isPublic) {
            this.publicNodeList.add(node);
        }
        return node;
    }

    @Override
    public <T> T registerNode(T node, String variableName) {
        return this.registerNode(node, variableName, false);
    }

    @Override
    public <T> T findOrCreatePublicNode(Class<T> clazz, Map<String, Object> config, String variableName) {
        return this.findOrCreateNode(clazz, config, variableName, true);
    }

    @Override
    public <T> T findOrCreateNode(Class<T> clazz, Map<String, Object> config, String variableName) {
        return this.findOrCreateNode(clazz, config, variableName, false);
    }

    public <T> T findOrCreateNode(Class<T> clazz, Map<String, Object> config, String variableName, boolean isPublic) {
        return this.findOrCreateNode(clazz, config, variableName, isPublic, false, null);
    }

    private <T> T findOrCreateNode(Class<T> clazz, Map<String, Object> config, String variableName, boolean isPublic, boolean useTempMap, String factoryName) {
        try {
            String name;
            Object newNode;
            CbMethodHandle handle;
            if (factoryName == null || factoryName.isEmpty()) {
                handle = this.class2FactoryMethod.get(clazz);
            } else {
                handle = this.name2FactoryMethod.get(factoryName);
                if (handle == null) {
                    throw new RuntimeException("No registered NodeFactory with name:'" + factoryName + "' type:'" + clazz.getCanonicalName() + "'");
                }
            }
            if (handle != null) {
                newNode = handle.method.invoke(handle.instance, config, this);
                if (newNode == null) {
                    return null;
                }
            } else {
                try {
                    newNode = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                    this.LOGGER.debug("missing default constructor - attempting construction bypass");
                    Mirror constructor = new Mirror();
                    newNode = constructor.on(clazz).invoke().constructor().bypasser();
                }
                AccessorsController mirror = new Mirror().on(newNode);
                ReflectionHandler reflect = new Mirror().on(clazz).reflect();
                Set entrySet = config == null ? Collections.EMPTY_SET : config.entrySet().stream().filter(keyValue -> reflect.field((String)keyValue.getKey()) != null).collect(Collectors.toSet());
                ReflectionUtils.getFields(clazz, (Predicate[])new Predicate[0]).forEach(TopologicallySortedDependencyGraph::trySetAccessible);
                entrySet.stream().filter(keyValue -> {
                    Field field = reflect.field((String)keyValue.getKey());
                    return field.getType() != String.class && keyValue.getValue().getClass() != String.class;
                }).forEach(map -> mirror.set().field((String)map.getKey()).withValue(map.getValue()));
                entrySet.stream().filter(map -> reflect.field((String)map.getKey()).getType() == String.class && map.getValue().getClass() == String.class).forEach(map -> mirror.set().field((String)map.getKey()).withValue(map.getValue()));
                entrySet.stream().filter(map -> reflect.field((String)map.getKey()).getType() != String.class && map.getValue().getClass() == String.class).forEach(map -> {
                    Class<?> clazz1 = mirror.get().field((String)map.getKey()).getClass();
                    switch (clazz1.getSimpleName()) {
                        case "Integer": {
                            mirror.set().field((String)map.getKey()).withValue((Object)Integer.valueOf((String)map.getValue()));
                            break;
                        }
                        case "Double": {
                            mirror.set().field((String)map.getKey()).withValue((Object)Double.valueOf((String)map.getValue()));
                            break;
                        }
                        case "Float": {
                            mirror.set().field((String)map.getKey()).withValue((Object)Float.valueOf((String)map.getValue()));
                            break;
                        }
                        case "Short": {
                            mirror.set().field((String)map.getKey()).withValue((Object)Short.valueOf((String)map.getValue()));
                            break;
                        }
                        case "Byte": {
                            mirror.set().field((String)map.getKey()).withValue((Object)Byte.valueOf((String)map.getValue()));
                            break;
                        }
                        case "Long": {
                            mirror.set().field((String)map.getKey()).withValue((Object)Long.valueOf((String)map.getValue()));
                            break;
                        }
                        case "Character": {
                            mirror.set().field((String)map.getKey()).withValue((Object)Character.valueOf(((String)map.getValue()).charAt(0)));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Type not supported in default factory ");
                        }
                    }
                });
            }
            if (!this.inst2Name.containsKey(newNode)) {
                name = this.nameNode(newNode);
                if (useTempMap) {
                    this.inst2NameTemp.put(newNode, (Object)(variableName == null || StringUtils.isBlank((CharSequence)variableName) ? name : variableName));
                } else {
                    this.inst2Name.put(newNode, (Object)(variableName == null || StringUtils.isBlank((CharSequence)variableName) ? name : variableName));
                }
            } else {
                name = (String)this.inst2Name.get(newNode);
                newNode = this.inst2Name.inverse().get((Object)name);
            }
            if (handle != null) {
                NodeFactory factory = (NodeFactory)handle.instance;
                if (isPublic) {
                    this.publicNodeList.add(newNode);
                }
                factory.postInstanceRegistration(config, this, newNode);
            }
            return newNode;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            this.LOGGER.error("error creating node with factory", (Throwable)ex);
            throw new RuntimeException("error creating node with factory", ex);
        }
    }

    public synchronized void generateDependencyTree() throws Exception {
        Object object;
        if (this.processed) {
            return;
        }
        if (this.nodeFactoryRegistration != null) {
            for (Class<NodeFactory<?>> clazz : this.nodeFactoryRegistration.factoryClassSet) {
                NodeFactory<?> factory = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.registerNodeFactory(factory);
            }
            for (NodeFactory nodeFactory : this.nodeFactoryRegistration.factorySet) {
                this.registerNodeFactory(nodeFactory);
            }
            RootNodeConfig rootNodeConfig = this.config.getRootNodeConfig();
            if (rootNodeConfig != null && rootNodeConfig.getRootClass() != null) {
                Object obj = this.findOrCreateNode(rootNodeConfig.getRootClass(), rootNodeConfig.getConfig(), rootNodeConfig.getName());
                this.publicNodeList.add(obj);
            }
        }
        this.addNodesFromContext();
        for (Map.Entry entry : this.inst2Name.entrySet()) {
            object = entry.getKey();
            if (Anchor.class.isAssignableFrom(object.getClass())) {
                Anchor anchor = (Anchor)object;
                this.graph.addVertex(anchor.getAnchor());
                this.graph.addVertex(anchor.getAfterAnchor());
                this.pushEdges.add((DefaultEdge)this.graph.addEdge(anchor.getAnchor(), anchor.getAfterAnchor()));
                continue;
            }
            this.walkDependencies(object);
        }
        this.inst2Name.putAll(this.inst2NameTemp);
        this.inst2Name.entrySet().removeIf(o -> Anchor.class.isAssignableFrom(o.getKey().getClass()));
        this.inst2Name.entrySet().removeIf(o -> o.getKey().getClass().isAnnotationPresent(ExcludeNode.class));
        this.inst2Name.keySet().forEach(this::addExportedMethods);
        for (Map.Entry entry : this.inst2Name.entrySet()) {
            object = entry.getKey();
            this.walkDependencies(object);
        }
        TopologicalOrderIterator topologicalIter = new TopologicalOrderIterator(this.graph, new NaturalOrderComparator(Collections.unmodifiableMap(this.inst2Name)));
        while (topologicalIter.hasNext()) {
            Object e = topologicalIter.next();
            if (e.getClass().isAnnotationPresent(ExcludeNode.class)) {
                this.graph.removeVertex(e);
                this.eventGraph.removeVertex(e);
                continue;
            }
            this.topologicalHandlers.add(e);
        }
        for (Map.Entry entry : this.inst2Name.entrySet()) {
            Object node = entry.getKey();
            if (this.topologicalHandlers.contains(node)) continue;
            this.topologicalHandlers.add(node);
        }
        this.buildNonPushSortedHandlers();
        this.sortExportedServiceFunctionCallbacks();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("GRAPH:" + this.graph);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("SORTED LIST:" + this.topologicalHandlers);
        }
        this.processed = true;
    }

    private void sortExportedServiceFunctionCallbacks() {
        this.exportedFunctionMap.values().stream().map(ExportFunctionData::getFunctionCallBackList).forEach(this::sortNodeList);
    }

    private void buildNonPushSortedHandlers() {
        SimpleDirectedGraph cloneGraph = (SimpleDirectedGraph)this.graph.clone();
        this.pushEdges.stream().filter(Objects::nonNull).forEach(edge -> {
            Object edgeSource = this.graph.getEdgeSource(edge);
            Object edgeTarget = this.graph.getEdgeTarget(edge);
            cloneGraph.removeEdge(edgeSource, edgeTarget);
            cloneGraph.addEdge(edgeTarget, edgeSource);
        });
        TopologicalOrderIterator topologicalIter = new TopologicalOrderIterator((Graph)cloneGraph, new NaturalOrderComparator(Collections.unmodifiableMap(this.inst2Name)));
        while (topologicalIter.hasNext()) {
            Object value = topologicalIter.next();
            if (!this.topologicalHandlers.contains(value)) continue;
            this.noPushTopologicalHandlers.add(value);
        }
        for (Map.Entry entry : this.inst2Name.entrySet()) {
            Object node = entry.getKey();
            if (this.noPushTopologicalHandlers.contains(node) || !this.topologicalHandlers.contains(node)) continue;
            this.noPushTopologicalHandlers.add(node);
        }
    }

    private void addNodesFromContext() {
        if (this.generationContext != null) {
            this.addNodeList(this.generationContext.getNodeList());
        }
    }

    private void registerNodeFactory(NodeFactory<?> obj) throws NoSuchMethodException, SecurityException {
        Class targetClass;
        Class<?> clazz = obj.getClass();
        Method createMethod = clazz.getMethod("createNode", Map.class, NodeRegistry.class);
        if (obj.injectionType() != null) {
            targetClass = obj.injectionType();
        } else {
            ParameterizedType paramType = (ParameterizedType)GenericTypeReflector.getExactSuperType(clazz, NodeFactory.class);
            targetClass = (Class)paramType.getActualTypeArguments()[0];
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Registered factory:" + clazz.getCanonicalName() + " building:" + targetClass);
        }
        this.class2FactoryMethod.put(targetClass, new CbMethodHandle(createMethod, obj, "node_factory_" + targetClass.getName()));
        if (obj.factoryName() != null && !obj.factoryName().isEmpty()) {
            this.name2FactoryMethod.put(obj.factoryName(), new CbMethodHandle(createMethod, obj, "node_factory_" + targetClass.getName()));
        }
        HashMap<String, Auditor> auditorMap = new HashMap<String, Auditor>();
        obj.preSepGeneration(this.generationContext, auditorMap);
        auditorMap.forEach((key, value) -> this.registerAuditor((Auditor)value, (String)key));
    }

    private void walkDependenciesForEventHandling(Object object) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Set s = ReflectionUtils.getAllFields(clazz, (Predicate[])new Predicate[0]);
        Field[] fields = new Field[s.size()];
        boolean overrideEventTrigger = ReflectionUtils.getAllFields(clazz, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(TriggerEventOverride.class)}).stream().anyMatch(f -> {
            try {
                f.setAccessible(true);
                return f.get(object) != null;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
        });
        for (Field field : fields = s.toArray(fields)) {
            if (!TopologicallySortedDependencyGraph.trySetAccessible(field) || Modifier.isTransient(field.getModifiers())) continue;
            Object refField = field.get(object);
            String refName = (String)this.inst2Name.get(refField);
            if (refField != null && refField.equals(object)) break;
            if (field.getAnnotation(NoTriggerReference.class) != null || overrideEventTrigger && field.getAnnotation(TriggerEventOverride.class) == null) continue;
            if (field.getType().isArray()) {
                Object array = field.get(object);
                if (array == null) continue;
                int length = Array.getLength(array);
                for (int i = 0; i < length; ++i) {
                    refField = Array.get(array, i);
                    if (!this.inst2Name.containsKey(refField) || !this.handlesEvents(refField)) continue;
                    this.eventGraph.addVertex(object);
                    this.eventGraph.addVertex(refField);
                    this.eventGraph.addEdge(refField, object);
                    this.walkDependenciesForEventHandling(refField);
                }
                continue;
            }
            if (List.class.isAssignableFrom(field.getType()) || Set.class.isAssignableFrom(field.getType())) {
                Collection list = (Collection)field.get(object);
                if (list == null) continue;
                boolean pushCollection = field.getAnnotation(PushReference.class) != null;
                for (Object parent : list) {
                    if (!this.inst2Name.containsKey(parent) || !this.handlesEvents(parent)) continue;
                    this.eventGraph.addVertex(object);
                    this.eventGraph.addVertex(parent);
                    if (pushCollection) {
                        this.eventGraph.addEdge(object, parent);
                        continue;
                    }
                    this.eventGraph.addEdge(parent, object);
                    this.walkDependenciesForEventHandling(parent);
                }
                continue;
            }
            if (refName == null || !this.handlesEvents(refField)) continue;
            this.eventGraph.addVertex(object);
            this.eventGraph.addVertex(refField);
            if (field.getAnnotation(PushReference.class) != null) {
                this.eventGraph.addEdge(object, refField);
                continue;
            }
            this.eventGraph.addEdge(refField, object);
            this.walkDependenciesForEventHandling(refField);
        }
    }

    private void addExportedMethods(Object object) {
        Class<?> clazz = object.getClass();
        for (AnnotatedType annotatedInterface : ClassUtils.getAllAnnotatedAnnotationTypes(clazz, ExportService.class)) {
            if (!annotatedInterface.isAnnotationPresent(ExportService.class)) continue;
            Class interfaceType = (Class)annotatedInterface.getType();
            this.config.addInterfaceImplementation(interfaceType);
            for (Method method : interfaceType.getMethods()) {
                String exportMethodName = method.getName();
                Method cbMethod = method;
                try {
                    cbMethod = object.getClass().getMethod(exportMethodName, method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                ExportFunctionData exportFunctionData = this.exportedFunctionMap.computeIfAbsent(method, n -> new ExportFunctionData(method));
                this.registerNode(object, null);
                String name = (String)this.inst2Name.get(object);
                exportFunctionData.addCbMethodHandle(new CbMethodHandle(cbMethod, object, name));
            }
        }
    }

    private String getInstanceName(Field field, Object node) throws IllegalArgumentException, IllegalAccessException {
        boolean addNode;
        Object refField = field.get(node);
        String refName = (String)this.inst2Name.get(refField);
        boolean bl = addNode = field.getAnnotation(SepNode.class) != null && !field.getType().isArray() && !Collection.class.isAssignableFrom(field.getType());
        if (refField != null && field.getAnnotation(ExcludeNode.class) == null) {
            addNode |= !ReflectionUtils.getAllMethods(refField.getClass(), (Predicate[])new Predicate[]{this.annotationPredicate()}).isEmpty();
            addNode |= EventHandlerNode.class.isAssignableFrom(refField.getClass()) | refField.getClass().getAnnotation(SepNode.class) != null | !ClassUtils.getAllAnnotatedAnnotationTypes(refField.getClass(), ExportService.class).isEmpty();
        }
        if (refName == null && addNode && !this.inst2NameTemp.containsKey(refField) && refField != null) {
            this.LOGGER.debug("cannot find node in supplied list, but has SepNode annotation adding to managed node list");
            refName = this.nameNode(refField);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("from @SepNode adding:'" + refField + "' name:'" + refName + "'");
            }
            this.inst2NameTemp.put(refField, (Object)refName);
            this.walkDependencies(refField);
        }
        return refName;
    }

    private void implicitAddVectorMember(Object refField, Field collection) {
        if (refField != null && !this.inst2Name.containsKey(refField) && !this.inst2NameTemp.containsKey(refField)) {
            boolean addNode = !ReflectionUtils.getAllMethods(refField.getClass(), (Predicate[])new Predicate[]{this.annotationPredicate()}).isEmpty();
            if ((addNode |= EventHandlerNode.class.isAssignableFrom(refField.getClass()) | refField.getClass().getAnnotation(SepNode.class) != null | !ClassUtils.getAllAnnotatedAnnotationTypes(refField.getClass(), ExportService.class).isEmpty()) | collection.getAnnotation(SepNode.class) != null) {
                this.inst2NameTemp.put(refField, (Object)this.nameNode(refField));
            }
        }
    }

    private Predicate<AnnotatedElement> annotationPredicate() {
        return ReflectionUtils.withAnnotation(AfterEvent.class).or(ReflectionUtils.withAnnotation(OnEventHandler.class)).or(ReflectionUtils.withAnnotation(Inject.class)).or(ReflectionUtils.withAnnotation(OnBatchEnd.class)).or(ReflectionUtils.withAnnotation(OnBatchPause.class)).or(ReflectionUtils.withAnnotation(OnTrigger.class)).or(ReflectionUtils.withAnnotation(AfterTrigger.class)).or(ReflectionUtils.withAnnotation(OnParentUpdate.class)).or(ReflectionUtils.withAnnotation(TearDown.class)).or(ReflectionUtils.withAnnotation(Initialise.class)).or(ReflectionUtils.withAnnotation(TriggerEventOverride.class)).or(ReflectionUtils.withAnnotation(ExportService.class));
    }

    private Predicate<AnnotatedElement> eventHandlingAnnotationPredicate() {
        return ReflectionUtils.withAnnotation(OnEventHandler.class).or(ReflectionUtils.withAnnotation(OnTrigger.class)).or(ReflectionUtils.withAnnotation(TriggerEventOverride.class)).or(ReflectionUtils.withAnnotation(ExportService.class));
    }

    private boolean handlesEvents(Object obj) {
        return EventHandlerNode.class.isAssignableFrom(obj.getClass()) || !ReflectionUtils.getAllMethods(obj.getClass(), (Predicate[])new Predicate[]{this.eventHandlingAnnotationPredicate()}).isEmpty() || !ClassUtils.getAllAnnotatedAnnotationTypes(obj.getClass(), ExportService.class).isEmpty();
    }

    private void walkDependencies(Object object) throws IllegalArgumentException, IllegalAccessException {
        this.walkDependenciesForEventHandling(object);
        Set s = ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[0]);
        Field[] fields = new Field[s.size()];
        for (Field field : fields = s.toArray(fields)) {
            Config[] configArray;
            ConfigVariable[] overrideConfigs;
            if (!TopologicallySortedDependencyGraph.trySetAccessible(field) || Modifier.isTransient(field.getModifiers())) continue;
            Object refField = field.get(object);
            if (this.inst2Name.containsKey(refField) && refField != object) {
                refField = this.inst2Name.inverse().get(this.inst2Name.get(refField));
                try {
                    field.set(object, refField);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
            String refName = this.getInstanceName(field, object);
            if (refField != null && refField.equals(object)) break;
            if (field.getType().isArray()) {
                Object array = field.get(object);
                if (array == null) continue;
                int length = Array.getLength(array);
                for (int i = 0; i < length; ++i) {
                    refField = Array.get(array, i);
                    this.implicitAddVectorMember(refField, field);
                    if (this.inst2Name.containsKey(refField) || this.inst2NameTemp.containsKey(refField)) {
                        this.graph.addVertex(object);
                        this.graph.addVertex(refField);
                        this.graph.addEdge(refField, object);
                        this.walkDependencies(refField);
                        continue;
                    }
                    if (!this.LOGGER.isDebugEnabled()) continue;
                    this.LOGGER.debug("mismatch for:" + refField);
                    for (Object obj : this.inst2Name.keySet()) {
                        this.LOGGER.debug(obj + "==" + refField + " " + (obj == refField));
                        if (obj == refField) continue;
                        this.LOGGER.debug("obj.equals(refField)" + obj.equals(refField));
                        this.LOGGER.debug("match value from map refField:" + (String)this.inst2Name.get(refField));
                        this.LOGGER.debug("match value from map obj:" + (String)this.inst2Name.get(obj));
                    }
                }
            } else if (Collection.class.isAssignableFrom(field.getType())) {
                Collection list = (Collection)field.get(object);
                if (list == null) continue;
                boolean pushCollection = field.getAnnotation(PushReference.class) != null;
                for (Object parent : list) {
                    this.implicitAddVectorMember(parent, field);
                    if (!this.inst2Name.containsKey(parent) && !this.inst2NameTemp.containsKey(parent)) continue;
                    this.graph.addVertex(object);
                    this.graph.addVertex(parent);
                    if (pushCollection) {
                        this.pushEdges.add((DefaultEdge)this.graph.addEdge(object, parent));
                        continue;
                    }
                    this.graph.addEdge(parent, object);
                    this.walkDependencies(parent);
                }
            } else if (refName != null) {
                this.graph.addVertex(object);
                this.graph.addVertex(refField);
                if (field.getAnnotation(PushReference.class) != null) {
                    this.pushEdges.add((DefaultEdge)this.graph.addEdge(object, refField));
                } else if (Anchor.class.isAssignableFrom(refField.getClass())) {
                    System.out.println("ANCHOR!!!");
                } else {
                    this.graph.addEdge(refField, object);
                    this.walkDependencies(refField);
                }
            } else if (refName == null && refField != null && LambdaReflection.MethodReferenceReflection.class.isAssignableFrom(refField.getClass()) && ((LambdaReflection.MethodReferenceReflection)refField).captured().length > 0) {
                Object methodInstanceHolder = ((LambdaReflection.MethodReferenceReflection)refField).captured()[0];
                String instanceName = (String)this.inst2Name.getOrDefault(methodInstanceHolder, (Object)this.nameNode(methodInstanceHolder));
                this.inst2NameTemp.put(methodInstanceHolder, (Object)instanceName);
                this.graph.addVertex(methodInstanceHolder);
                this.graph.addVertex(object);
                if (field.getAnnotation(PushReference.class) != null) {
                    this.pushEdges.add((DefaultEdge)this.graph.addEdge(object, methodInstanceHolder));
                    if (field.getAnnotation(NoTriggerReference.class) == null) {
                        this.eventGraph.addVertex(methodInstanceHolder);
                        this.eventGraph.addVertex(object);
                        this.eventGraph.addEdge(object, methodInstanceHolder);
                    }
                } else {
                    this.graph.addEdge(methodInstanceHolder, object);
                    if (field.getAnnotation(NoTriggerReference.class) == null && this.handlesEvents(methodInstanceHolder)) {
                        this.eventGraph.addVertex(methodInstanceHolder);
                        this.eventGraph.addVertex(object);
                        this.eventGraph.addEdge(methodInstanceHolder, object);
                    }
                }
                this.walkDependencies(methodInstanceHolder);
            }
            Inject injecting = field.getAnnotation(Inject.class);
            if (!(injecting != null & refName == null & field.get(object) == null)) continue;
            String factoryVariableName = injecting.factoryVariableName();
            String factoryName = injecting.factoryName();
            Set fieldNames = ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)factoryVariableName)});
            if (factoryVariableName.length() > 0 && fieldNames.size() > 0) {
                Field f = (Field)fieldNames.iterator().next();
                f.setAccessible(true);
                if (f.get(object) != null) {
                    if (f.getType().equals(String.class)) {
                        factoryName = (String)f.get(object);
                    } else {
                        throw new IllegalArgumentException("Inject.factoryVariableName() should be the variable name of a String field: " + f);
                    }
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, Object> overrideMap = new HashMap<String, Object>();
            for (ConfigVariable overrideConfig : overrideConfigs = (ConfigVariable[])field.getAnnotationsByType(ConfigVariable.class)) {
                String fieldFilter = overrideConfig.field();
                String key = overrideConfig.key();
                Object value = new Mirror().on(object).get().field(fieldFilter);
                overrideMap.put(key, value);
            }
            for (Config config : configArray = (Config[])field.getAnnotationsByType(Config.class)) {
                map.put(config.key(), config.value());
            }
            Set entrySet = overrideMap.entrySet();
            entrySet.forEach(overrideEntry -> map.put((String)overrideEntry.getKey(), overrideEntry.getValue()));
            map.put("NodeFactory.InjectField.TypeInfo", field);
            String instanceName = injecting.instanceName();
            String instanceVariableName = injecting.instanceVariableName();
            fieldNames = ReflectionUtils.getAllFields(object.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)instanceVariableName)});
            if (instanceVariableName.length() > 0 && fieldNames.size() > 0) {
                Field f = (Field)fieldNames.iterator().next();
                f.setAccessible(true);
                if (f.get(object) != null) {
                    if (f.getType().equals(String.class)) {
                        instanceName = (String)f.get(object);
                    } else {
                        throw new IllegalArgumentException("Inject.instanceVariableName() should be the variable name of a String field: " + f);
                    }
                }
            }
            map.put("NodeFactory.InjectField.InstanceName", instanceName);
            BiMap<Object, String> oldMap = this.inst2Name;
            this.inst2Name = this.inst2NameTemp;
            Object newNode = null;
            if (injecting.singleton()) {
                newNode = this.inst2Name.keySet().stream().filter(o -> o.getClass() == field.getType()).findFirst().orElse(null);
            }
            if (newNode == null) {
                newNode = this.findOrCreateNode(field.getType(), map, injecting.singletonName(), false, true, factoryName);
            }
            this.inst2Name = oldMap;
            this.addNodesFromContext();
            field.set(object, newNode);
            this.walkDependencies(newNode);
        }
    }

    public boolean isPublicNode(Object node) {
        return this.publicNodeList.contains(node);
    }

    public EventProcessorConfig getConfig() {
        return this.config;
    }

    void sortNodeList(List<CbMethodHandle> dispatchMethods) {
        dispatchMethods.sort((handle0, handle1) -> {
            if (handle0.instance == handle1.instance) {
                if (handle0.isEventHandler && !handle1.isEventHandler) {
                    return -1;
                }
                if (!handle0.isEventHandler && handle1.isEventHandler) {
                    return 1;
                }
                return handle0.method.getName().compareTo(handle1.method.getName());
            }
            return this.topologicalHandlers.indexOf(handle0.instance) - this.topologicalHandlers.indexOf(handle1.instance);
        });
    }

    public void exportAsGraphMl(Writer writer, boolean addEvents) throws SAXException, TransformerConfigurationException {
        VertexNameProvider np = vertex -> {
            String name = this.variableName(vertex);
            if (name == null) {
                name = ((Class)vertex).getSimpleName();
            }
            return name;
        };
        JgraphGraphMLExporter mlExporter = new JgraphGraphMLExporter(np, np, new IntegerEdgeNameProvider(), new IntegerEdgeNameProvider());
        SimpleDirectedGraph exportGraph = (SimpleDirectedGraph)this.graph.clone();
        HashSet exportServiceSet = new HashSet();
        if (addEvents) {
            this.graph.vertexSet().forEach(t -> {
                EventHandlerNode eh;
                Class eventClass;
                Method[] methodList = t.getClass().getMethods();
                for (Method method : methodList) {
                    if (method.getAnnotation(OnEventHandler.class) == null) continue;
                    Class<?> eventTypeClass = method.getParameterTypes()[0];
                    exportGraph.addVertex(eventTypeClass);
                    exportGraph.addEdge(eventTypeClass, t);
                }
                if (t instanceof EventHandlerNode && (eventClass = (eh = (EventHandlerNode)t).eventClass()) != null) {
                    exportGraph.addVertex((Object)eventClass);
                    exportGraph.addEdge((Object)eventClass, t);
                }
                for (AnnotatedType annotatedInterface : ClassUtils.getAllAnnotatedAnnotationTypes(t.getClass(), ExportService.class)) {
                    if (!annotatedInterface.isAnnotationPresent(ExportService.class)) continue;
                    Class interfaceType = (Class)annotatedInterface.getType();
                    exportServiceSet.add(interfaceType);
                    exportGraph.addVertex((Object)interfaceType);
                    exportGraph.addEdge((Object)interfaceType, t);
                }
            });
        }
        mlExporter.export(writer, exportGraph, exportServiceSet);
    }

    private String nameNode(Object node) {
        return this.nameStrategy.mappedNodeName(node);
    }
}

