/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.serialiser;

import com.fluxtion.compiler.generation.serialiser.FieldContext;
import org.apache.commons.text.StringEscapeUtils;

public interface BasicTypeSerializer {
    public static String stringToSource(FieldContext<String> fieldContext) {
        return "\"" + StringEscapeUtils.escapeJava((String)fieldContext.getInstanceToMap()) + "\"";
    }

    public static String charToSource(FieldContext<Character> fieldContext) {
        return "'" + StringEscapeUtils.escapeJava((String)fieldContext.getInstanceToMap().toString()) + "'";
    }

    public static String longToSource(FieldContext<Long> fieldContext) {
        return fieldContext.getInstanceToMap().toString() + "L";
    }

    public static String intToSource(FieldContext<Integer> fieldContext) {
        return fieldContext.getInstanceToMap().toString();
    }

    public static String shortToSource(FieldContext<Short> fieldContext) {
        return "(short)" + fieldContext.getInstanceToMap().toString();
    }

    public static String byteToSource(FieldContext<Byte> fieldContext) {
        return "(byte)" + fieldContext.getInstanceToMap().toString();
    }

    public static String doubleToSource(FieldContext<Double> fieldContext) {
        Double doubleVal = fieldContext.getInstanceToMap();
        return doubleVal.isNaN() ? "Double.NaN" : doubleVal.toString();
    }

    public static String floatToSource(FieldContext<Float> fieldContext) {
        return fieldContext.getInstanceToMap().toString() + "f";
    }

    public static String booleanToSource(FieldContext<Boolean> fieldContext) {
        return fieldContext.getInstanceToMap().toString();
    }
}

