/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.serialiser;

import com.fluxtion.compiler.generation.model.Field;
import com.fluxtion.compiler.generation.serialiser.FieldContext;
import com.fluxtion.runtime.serializer.MapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface CollectionSerializer {
    public static String mapToSource(FieldContext<Map<?, ?>> fieldContext) {
        fieldContext.getImportList().add(MapBuilder.class);
        Map<?, ?> values = fieldContext.getInstanceToMap();
        HashMap newMap = new HashMap();
        values.entrySet().stream().forEach(item -> {
            Object key = item.getKey();
            Object value = item.getValue();
            for (Field nodeField : fieldContext.getNodeFields()) {
                if (!nodeField.instance.equals(key)) continue;
                key = nodeField.instance;
                break;
            }
            for (Field nodeField : fieldContext.getNodeFields()) {
                if (!nodeField.instance.equals(value)) continue;
                value = nodeField.instance;
                break;
            }
            newMap.put(key, value);
        });
        return newMap.entrySet().stream().sorted(Comparator.comparing(e -> e.getKey().toString())).map(entry -> {
            String keyString = fieldContext.mapToJavaSource(entry.getKey());
            String valueString = fieldContext.mapToJavaSource(entry.getValue());
            return "(" + keyString + ", " + valueString + ")";
        }).collect(Collectors.joining(".put", "MapBuilder.builder().put", ".build()"));
    }

    @NotNull
    public static String setToSource(FieldContext<Set<?>> fieldContext) {
        fieldContext.getImportList().add(Arrays.class);
        fieldContext.getImportList().add(HashSet.class);
        Set<?> values = fieldContext.getInstanceToMap();
        HashSet newList = new HashSet();
        values.stream().forEach(item -> {
            boolean foundMatch = false;
            for (Field nodeField : fieldContext.getNodeFields()) {
                if (!nodeField.instance.equals(item)) continue;
                newList.add(nodeField.instance);
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                newList.add(item);
            }
        });
        return newList.stream().map(f -> fieldContext.mapToJavaSource(f)).collect(Collectors.joining(", ", "new HashSet<>(Arrays.asList(", "))"));
    }

    @NotNull
    public static String listToSource(FieldContext<List<?>> fieldContext) {
        fieldContext.getImportList().add(Arrays.class);
        List<?> values = fieldContext.getInstanceToMap();
        ArrayList newList = new ArrayList();
        values.stream().forEach(item -> {
            boolean foundMatch = false;
            for (Field nodeField : fieldContext.getNodeFields()) {
                if (!nodeField.instance.equals(item)) continue;
                newList.add(nodeField.instance);
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                newList.add(item);
            }
        });
        return newList.stream().map(f -> fieldContext.mapToJavaSource(f)).collect(Collectors.joining(", ", "Arrays.asList(", ")"));
    }
}

