/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.serialiser;

import com.fluxtion.compiler.EventProcessorConfig;
import com.fluxtion.compiler.generation.GenerationContext;
import com.fluxtion.compiler.generation.model.Field;
import com.fluxtion.compiler.generation.serialiser.FieldContext;
import com.fluxtion.compiler.generation.serialiser.FieldToSourceSerializer;
import com.fluxtion.compiler.generation.serialiser.MapFieldToJavaSource;
import com.fluxtion.compiler.generation.util.ClassUtils;
import com.fluxtion.runtime.dataflow.groupby.GroupByKey;
import com.fluxtion.runtime.dataflow.helpers.GroupingFactory;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FieldSerializer
implements MapFieldToJavaSource {
    private final Map<Class<?>, Function<FieldContext, String>> classSerializerMap = new HashMap();
    private final List<FieldToSourceSerializer> serviceLoadedFieldSerializerList;

    public FieldSerializer(EventProcessorConfig config) {
        if (config != null) {
            this.classSerializerMap.putAll(config.getClassSerializerMap());
        }
        this.serviceLoadedFieldSerializerList = new ArrayList<FieldToSourceSerializer>();
        ServiceLoader<FieldToSourceSerializer> loadServices = GenerationContext.SINGLETON != null && GenerationContext.SINGLETON.getClassLoader() != null ? ServiceLoader.load(FieldToSourceSerializer.class, GenerationContext.SINGLETON.getClassLoader()) : ServiceLoader.load(FieldToSourceSerializer.class);
        loadServices.forEach(this.serviceLoadedFieldSerializerList::add);
    }

    private static boolean _nativeTypeSupported(Class<?> type) {
        return type.isEnum() || type.isArray();
    }

    public boolean typeSupported(Class<?> type) {
        return this.classSerializerMap.containsKey(type) || FieldSerializer._nativeTypeSupported(type) || Arrays.stream(type.getDeclaredConstructors()).anyMatch(c -> c.getParameterCount() == 0) || this.classSerializerMap.keySet().stream().anyMatch(c -> c.isAssignableFrom(type)) || this.serviceLoadedFieldSerializerList.stream().anyMatch(s -> s.typeSupported(type));
    }

    @Override
    public String mapToJavaSource(Object primitiveVal, List<Field> nodeFields, Set<Class<?>> importList) {
        Class<?> primitiveValClass = primitiveVal.getClass();
        FieldContext<Object> f = new FieldContext<Object>(primitiveVal, nodeFields, importList, this);
        Function<FieldContext, String> serializeFunction = this.classSerializerMap.get(primitiveValClass);
        if (serializeFunction != null) {
            return serializeFunction.apply(f);
        }
        Optional<Class> matchingClass = this.classSerializerMap.keySet().stream().filter(clazz -> clazz.isAssignableFrom(primitiveValClass)).findFirst();
        if (matchingClass.isPresent()) {
            return this.classSerializerMap.get(matchingClass.get()).apply(f);
        }
        if (FieldSerializer._nativeTypeSupported(primitiveValClass)) {
            return this._mapToJavaSource(primitiveVal, nodeFields, importList);
        }
        Optional<String> optionalSerialise = this.serviceLoadedFieldSerializerList.stream().filter(s -> s.typeSupported(primitiveValClass)).findFirst().map(m -> m.mapToSource(f));
        if (optionalSerialise.isPresent()) {
            return optionalSerialise.get();
        }
        return this._mapToJavaSource(primitiveVal, nodeFields, importList);
    }

    public boolean propertySupported(PropertyDescriptor property, Field field, List<Field> nodeFields) {
        return this._propertySupported(property, field, nodeFields);
    }

    public String mapPropertyToJavaSource(PropertyDescriptor property, Field field, List<Field> nodeFields, Set<Class<?>> importList) {
        return this._mapPropertyToJavaSource(property, field, nodeFields, importList);
    }

    private String _mapToJavaSource(Object primitiveVal, List<Field> nodeFields, Set<Class<?>> importList) {
        Class<?> clazz = primitiveVal.getClass();
        Object original = primitiveVal;
        boolean foundMatch = false;
        if (clazz.isArray()) {
            primitiveVal = this.serializeArray(primitiveVal, nodeFields, importList, clazz);
        } else if (clazz.isEnum()) {
            primitiveVal = clazz.getSimpleName() + "." + ((Enum)primitiveVal).name();
            importList.add(clazz);
        }
        for (Field nodeField : nodeFields) {
            if (nodeField.instance != primitiveVal) continue;
            primitiveVal = nodeField.name;
            foundMatch = true;
            break;
        }
        if (!foundMatch && original == primitiveVal && clazz.getCanonicalName() != null) {
            importList.add(clazz);
            primitiveVal = "new " + clazz.getSimpleName() + "()";
        }
        return primitiveVal.toString();
    }

    @NotNull
    private Object serializeArray(Object primitiveVal, List<Field> nodeFields, Set<Class<?>> importList, Class<?> clazz) {
        Class<?> arrayType = clazz.getComponentType();
        importList.add(arrayType);
        ArrayList<String> strings = new ArrayList<String>();
        int length = Array.getLength(primitiveVal);
        for (int i = 0; i < length; ++i) {
            Object arrayElement = Array.get(primitiveVal, i);
            for (Field nodeField : nodeFields) {
                if (!nodeField.instance.equals(arrayElement)) continue;
                arrayElement = nodeField.instance;
                break;
            }
            strings.add(this.mapToJavaSource(arrayElement, nodeFields, importList));
        }
        primitiveVal = strings.stream().collect(Collectors.joining(", ", "new " + arrayType.getSimpleName() + "[]{", "}"));
        return primitiveVal;
    }

    private String _mapPropertyToJavaSource(PropertyDescriptor property, Field field, List<Field> nodeFields, Set<Class<?>> importList) {
        String ret = null;
        if (!ClassUtils.isPropertyTransient(property, field)) {
            try {
                Object value = property.getReadMethod().invoke(field.instance, new Object[0]);
                String mappedValue = this.mapToJavaSource(value, nodeFields, importList);
                String writeMethod = property.getWriteMethod().getName();
                for (Field nodeField : nodeFields) {
                    if (nodeField.instance != value) continue;
                    mappedValue = nodeField.name;
                    break;
                }
                ret = writeMethod + "(" + mappedValue + ")";
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return ret;
    }

    private boolean _propertySupported(PropertyDescriptor property, Field field, List<Field> nodeFields) {
        try {
            boolean isTransient = ClassUtils.isPropertyTransient(property, field);
            boolean writeMethod = property.getWriteMethod() != null;
            boolean hasValue = property.getReadMethod() != null && property.getReadMethod().invoke(field.instance, new Object[0]) != null;
            boolean isNode = false;
            if (hasValue) {
                for (Field nodeField : nodeFields) {
                    if (nodeField.instance != property.getReadMethod().invoke(field.instance, new Object[0])) continue;
                    isNode = true;
                    break;
                }
            }
            return !isTransient && writeMethod && hasValue && (this.typeSupported(property.getPropertyType()) || isNode);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            return false;
        }
    }

    public String buildTypeDeclaration(Field field, Function<Class<?>, String> classNameConverter) {
        Object instance = field.instance;
        if (instance instanceof GroupingFactory) {
            GroupingFactory groupByKeyFactory = (GroupingFactory)instance;
            Method method = groupByKeyFactory.getKeyFunction().method();
            String returnType = classNameConverter.apply(method.getReturnType());
            String inputClass = classNameConverter.apply(method.getDeclaringClass());
            if (method.getParameterTypes().length == 1) {
                inputClass = classNameConverter.apply(method.getParameterTypes()[0]);
            }
            String genericDeclaration = "<" + inputClass + ", " + returnType + ", ?, ?>";
            return genericDeclaration;
        }
        if (instance instanceof GroupByKey) {
            GroupByKey groupByKey = (GroupByKey)instance;
            return "<" + classNameConverter.apply(groupByKey.getValueClass()) + ">";
        }
        return "";
    }
}

