/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.targets;

import com.fluxtion.compiler.EventProcessorConfig;
import com.fluxtion.compiler.builder.filter.FilterDescription;
import com.fluxtion.compiler.generation.compiler.classcompiler.StringCompilation;
import com.fluxtion.compiler.generation.model.CbMethodHandle;
import com.fluxtion.compiler.generation.model.ExportFunctionData;
import com.fluxtion.compiler.generation.model.Field;
import com.fluxtion.compiler.generation.model.SimpleEventProcessorModel;
import com.fluxtion.compiler.generation.targets.JavaGenHelper;
import com.fluxtion.compiler.generation.util.ClassUtils;
import com.fluxtion.runtime.EventProcessor;
import com.fluxtion.runtime.StaticEventProcessor;
import com.fluxtion.runtime.annotations.AfterTrigger;
import com.fluxtion.runtime.audit.Auditor;
import com.fluxtion.runtime.callback.EventProcessorCallbackInternal;
import com.fluxtion.runtime.callback.ExportFunctionAuditEvent;
import com.fluxtion.runtime.callback.InternalEventProcessor;
import com.fluxtion.runtime.dataflow.groupby.MutableTuple;
import com.fluxtion.runtime.event.Event;
import com.fluxtion.runtime.input.EventFeed;
import com.fluxtion.runtime.input.SubscriptionManagerNode;
import com.fluxtion.runtime.lifecycle.BatchHandler;
import com.fluxtion.runtime.lifecycle.Lifecycle;
import com.fluxtion.runtime.node.ForkedTriggerTask;
import com.fluxtion.runtime.node.MutableEventProcessorContext;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryEventProcessor
implements EventProcessor,
StaticEventProcessor,
InternalEventProcessor,
Lifecycle,
BatchHandler {
    private static final Logger log = LoggerFactory.getLogger(InMemoryEventProcessor.class);
    private final SimpleEventProcessorModel simpleEventProcessorModel;
    private final EventProcessorConfig config;
    private final MutableEventProcessorContext context;
    private final EventProcessorCallbackInternal callbackDispatcher;
    private final SubscriptionManagerNode subscriptionManager;
    private final BitSet dirtyBitset = new BitSet();
    private final BitSet eventOnlyBitset = new BitSet();
    private final BitSet postProcessBufferingBitset = new BitSet();
    private final BitSet forkedTaskBitset = new BitSet();
    private final List<Node> eventHandlers = new ArrayList<Node>();
    private final List<ForkTriggerTaskNode> forkTriggerTaskNodes = new ArrayList<ForkTriggerTaskNode>();
    private final Map<Class<?>, List<Integer>> noFilterEventHandlerToBitsetMap = new HashMap();
    private final Map<FilterDescription, List<Integer>> filteredEventHandlerToBitsetMap = new HashMap<FilterDescription, List<Integer>>();
    private final List<Auditor> auditors = new ArrayList<Auditor>();
    private final Set<MutableTuple<Object, Method>> eventCompleteInvokeSet = new HashSet<MutableTuple<Object, Method>>();
    public boolean buffering = false;
    private Object currentEvent;
    public boolean processing = false;
    private boolean isDefaultHandling;
    private boolean initCalled = false;
    private Object exportingWrapper;

    public InMemoryEventProcessor(SimpleEventProcessorModel simpleEventProcessorModel, EventProcessorConfig config) {
        this.simpleEventProcessorModel = simpleEventProcessorModel;
        this.config = config;
        try {
            this.context = (MutableEventProcessorContext)this.getNodeById("context");
            this.callbackDispatcher = (EventProcessorCallbackInternal)this.getNodeById("callbackDispatcher");
            this.subscriptionManager = (SubscriptionManagerNode)this.getNodeById("subscriptionManager");
            this.subscriptionManager.setSubscribingEventProcessor((StaticEventProcessor)this);
            this.context.setEventProcessorCallback((InternalEventProcessor)this);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot build InMemoryEventProcessor", e);
        }
    }

    public void onEvent(Object event) {
        if (this.buffering) {
            this.triggerCalculation();
        }
        if (this.processing) {
            this.callbackDispatcher.processReentrantEvent(event);
        } else {
            this.processing = true;
            this.onEventInternal(event);
            this.callbackDispatcher.dispatchQueuedCallbacks();
            this.processing = false;
        }
    }

    public void bufferEvent(Object event) {
        this.buffering = true;
        this.processEvent(event, true);
    }

    public void triggerCalculation() {
        log.debug("dirtyBitset, after:{}", (Object)this.dirtyBitset);
        log.debug("======== GRAPH CYCLE START TRIGGER ========");
        int i = this.dirtyBitset.nextSetBit(0);
        while (i >= 0) {
            log.debug("event dispatch bitset index[{}] handler[{}::{}]", new Object[]{i, this.eventHandlers.get((int)i).callbackHandle.getVariableName(), this.eventHandlers.get((int)i).callbackHandle.getMethod().getName()});
            this.eventHandlers.get(i).onEvent(null);
            i = this.dirtyBitset.nextSetBit(i + 1);
        }
        this.dirtyBitset.or(this.postProcessBufferingBitset);
        this.postProcessBufferingBitset.clear();
        this.postEventProcessing();
        this.buffering = false;
        log.debug("======== GRAPH CYCLE END TRIGGER ========");
    }

    public void postEventProcessing() {
        log.debug("======== eventComplete ========");
        this.eventCompleteInvokeSet.clear();
        int i = this.dirtyBitset.length();
        while ((i = this.dirtyBitset.previousSetBit(i - 1)) >= 0) {
            log.debug("check for postprocessing index[{}]", (Object)i);
            if (this.eventHandlers.get(i).willInvokeEventComplete()) {
                log.debug("event dispatch bitset index[{}] handler[{}::{}]", new Object[]{i, this.eventHandlers.get((int)i).callbackHandle.getVariableName(), this.eventHandlers.get((int)i).onEventCompleteMethod.getName()});
            }
            this.eventHandlers.get(i).eventComplete();
        }
        log.debug("======== GRAPH CYCLE END   EVENT:[{}] ========", this.currentEvent);
        this.auditors.stream().filter(a -> Auditor.FirstAfterEvent.class.isAssignableFrom(a.getClass())).forEach(Auditor::processingComplete);
        log.debug("After event");
        this.forkTriggerTaskNodes.forEach(ForkTriggerTaskNode::reinitialise);
        this.simpleEventProcessorModel.getEventEndMethods().forEach(this::invokeRunnable);
        this.auditors.stream().filter(a -> !Auditor.FirstAfterEvent.class.isAssignableFrom(a.getClass())).forEach(Auditor::processingComplete);
        this.dirtyBitset.clear();
        log.debug("dirtyBitset, afterClear:{}", (Object)this.dirtyBitset);
        this.forkedTaskBitset.clear();
        log.debug("forkedTaskBitset, afterClear:{}", (Object)this.dirtyBitset);
        this.currentEvent = null;
    }

    public void dispatchQueuedCallbacks() {
        this.callbackDispatcher.dispatchQueuedCallbacks();
    }

    private void subclassDispatchSearch(BitSet updateBitset) {
        if (updateBitset.isEmpty()) {
            HashSet eventClassSet = new HashSet();
            this.filteredEventHandlerToBitsetMap.keySet().stream().map(FilterDescription::getEventClass).forEach(eventClassSet::add);
            eventClassSet.addAll(this.noFilterEventHandlerToBitsetMap.keySet());
            List<Class<?>> sortedClasses = ClassUtils.sortClassHierarchy(eventClassSet);
            sortedClasses.stream().filter(c -> c.isInstance(this.currentEvent)).findFirst().ifPresent(c -> {
                if (Event.class.isAssignableFrom((Class<?>)c)) {
                    FilterDescription filterDescription = FilterDescription.build(this.currentEvent);
                    filterDescription.setEventClass((Class<? extends Event>)c);
                    this.filteredEventHandlerToBitsetMap.getOrDefault(filterDescription, Collections.emptyList()).forEach(updateBitset::set);
                }
                if (updateBitset.isEmpty()) {
                    this.noFilterEventHandlerToBitsetMap.getOrDefault(c, Collections.emptyList()).forEach(updateBitset::set);
                }
            });
        }
    }

    private void processEvent(Object event, boolean buffer) {
        this.currentEvent = event;
        Object defaultEvent = this.checkForDefaultEventHandling(event);
        log.debug("dirtyBitset, before:{}", (Object)this.dirtyBitset);
        this.auditNewEvent(event);
        BitSet updateBitset = buffer ? this.eventOnlyBitset : this.dirtyBitset;
        this.filteredEventHandlerToBitsetMap.getOrDefault(FilterDescription.build(defaultEvent), Collections.emptyList()).forEach(updateBitset::set);
        if (updateBitset.isEmpty()) {
            this.noFilterEventHandlerToBitsetMap.getOrDefault(defaultEvent.getClass(), Collections.emptyList()).forEach(updateBitset::set);
        }
        this.subclassDispatchSearch(updateBitset);
        this.postProcessBufferingBitset.or(updateBitset);
        log.debug("dirtyBitset, after:{}", (Object)updateBitset);
        log.debug("======== GRAPH CYCLE START EVENT:[{}] ========", event);
        log.debug("======== process event ========");
        int i = this.checkForForkedTask(-1, updateBitset);
        while (i >= 0) {
            log.debug("event dispatch bitset index[{}] handler[{}::{}]", new Object[]{i, this.eventHandlers.get((int)i).callbackHandle.getVariableName(), this.eventHandlers.get((int)i).callbackHandle.getMethod().getName()});
            this.eventHandlers.get(i).onEvent(event);
            i = this.checkForForkedTask(i, updateBitset);
        }
        this.postProcessBufferingBitset.or(updateBitset);
        if (!buffer) {
            this.dirtyBitset.or(updateBitset);
            log.debug("dirtyBitset, postProcessing:{}", (Object)this.dirtyBitset);
            this.postEventProcessing();
        }
        updateBitset.clear();
    }

    private int checkForForkedTask(int startIndex, BitSet updateBitset) {
        log.debug("checkForForkedTask startIndex:{}, updateBitset:{} forkedBitset:{}", new Object[]{startIndex, updateBitset, this.forkedTaskBitset});
        int nextDirtyIndex = updateBitset.nextSetBit(startIndex + 1);
        int endIndex = Math.max(nextDirtyIndex, updateBitset.length());
        int nextForkIndex = this.forkedTaskBitset.nextSetBit(startIndex + 1);
        log.debug("checkForForkedTask endIndex:{}, nextDirtyIndex:{} nextForkIndex:{}", new Object[]{endIndex, nextDirtyIndex, nextForkIndex});
        if (nextForkIndex > 0 & (nextForkIndex <= nextDirtyIndex | nextDirtyIndex < 0)) {
            log.debug("joining on parent forked task bitset index[{}] handler[{}::{}]", new Object[]{nextForkIndex, this.eventHandlers.get((int)nextForkIndex).callbackHandle.getMethod().getDeclaringClass().getSimpleName(), this.eventHandlers.get((int)nextForkIndex).callbackHandle.getMethod().getName()});
            this.eventHandlers.get(nextForkIndex).joinOnParentTask();
            updateBitset.set(nextForkIndex);
            return nextForkIndex;
        }
        return nextDirtyIndex;
    }

    public void onEventInternal(Object event) {
        this.processEvent(event, false);
    }

    public boolean isDirty(Object node) {
        return this.dirtySupplier(node).getAsBoolean();
    }

    public BooleanSupplier dirtySupplier(Object node) {
        return this.eventHandlers.stream().filter(n -> n.getCallbackHandle().getInstance() == node).map(n -> n::isDirty).findFirst().orElse(() -> false);
    }

    public void setDirty(Object node, boolean dirtyFlag) {
        if (dirtyFlag) {
            this.eventHandlers.stream().filter(n -> n.getCallbackHandle().getInstance() == node).forEach(rec$ -> ((Node)rec$).markDirty());
        }
    }

    private Object checkForDefaultEventHandling(Object event) {
        Object mapped = event;
        if (this.isDefaultHandling && !this.simpleEventProcessorModel.getDispatchMap().containsKey(event.getClass())) {
            mapped = new Object();
        }
        return mapped;
    }

    public void auditNewEvent(Object event) {
        if (Event.class.isAssignableFrom(event.getClass())) {
            this.auditors.stream().filter(a -> Auditor.FirstAfterEvent.class.isAssignableFrom(a.getClass())).forEach(a -> a.eventReceived((Event)event));
            this.auditors.stream().filter(a -> !Auditor.FirstAfterEvent.class.isAssignableFrom(a.getClass())).forEach(a -> a.eventReceived((Event)event));
        } else {
            this.auditors.stream().filter(a -> Auditor.FirstAfterEvent.class.isAssignableFrom(a.getClass())).forEach(a -> a.eventReceived(event));
            this.auditors.stream().filter(a -> !Auditor.FirstAfterEvent.class.isAssignableFrom(a.getClass())).forEach(a -> a.eventReceived(event));
        }
    }

    public void nodeInvoked(Object node, String nodeName, String methodName, Object event) {
        this.auditors.stream().filter(Auditor::auditInvocations).forEachOrdered(a -> a.nodeInvoked(node, nodeName, methodName, event));
    }

    public void batchPause() {
        this.processing = true;
        this.auditNewEvent(Lifecycle.LifecycleEvent.BatchPause);
        this.simpleEventProcessorModel.getBatchPauseMethods().forEach(this::invokeRunnable);
        this.postEventProcessing();
        this.callbackDispatcher.dispatchQueuedCallbacks();
        this.processing = false;
    }

    public void batchEnd() {
        this.processing = true;
        this.auditNewEvent(Lifecycle.LifecycleEvent.BatchEnd);
        this.simpleEventProcessorModel.getBatchEndMethods().forEach(this::invokeRunnable);
        this.postEventProcessing();
        this.callbackDispatcher.dispatchQueuedCallbacks();
        this.processing = false;
    }

    public void setContextParameterMap(Map<Object, Object> newContextMapping) {
        this.context.replaceMappings(newContextMapping);
    }

    public void addContextParameter(Object key, Object value) {
        this.context.addMapping(key, value);
    }

    public void addEventFeed(EventFeed eventProcessorFeed) {
        this.subscriptionManager.addEventProcessorFeed(eventProcessorFeed);
    }

    public void removeEventFeed(EventFeed eventProcessorFeed) {
        this.subscriptionManager.removeEventProcessorFeed(eventProcessorFeed);
    }

    public void init() {
        this.initCalled = true;
        this.buildDispatch();
        this.auditNewEvent(Lifecycle.LifecycleEvent.Init);
        this.simpleEventProcessorModel.getInitialiseMethods().forEach(this::invokeRunnable);
        this.postEventProcessing();
    }

    public void start() {
        if (!this.initCalled) {
            throw new RuntimeException("init() must be called before start()");
        }
        this.processing = true;
        this.auditNewEvent(Lifecycle.LifecycleEvent.Start);
        this.simpleEventProcessorModel.getStartMethods().forEach(this::invokeRunnable);
        this.postEventProcessing();
        this.callbackDispatcher.dispatchQueuedCallbacks();
        this.processing = false;
    }

    public void stop() {
        if (!this.initCalled) {
            throw new RuntimeException("init() must be called before start()");
        }
        this.processing = true;
        this.auditNewEvent(Lifecycle.LifecycleEvent.Stop);
        this.simpleEventProcessorModel.getStopMethods().forEach(this::invokeRunnable);
        this.postEventProcessing();
        this.callbackDispatcher.dispatchQueuedCallbacks();
        this.processing = false;
    }

    public void tearDown() {
        this.initCalled = false;
        this.auditNewEvent(Lifecycle.LifecycleEvent.TearDown);
        this.simpleEventProcessorModel.getTearDownMethods().forEach(this::invokeRunnable);
        this.postEventProcessing();
    }

    private void invokeRunnable(CbMethodHandle callBackHandle) {
        callBackHandle.method.setAccessible(true);
        if (this.currentEvent != null) {
            this.auditors.stream().filter(Auditor::auditInvocations).forEachOrdered(a -> a.nodeInvoked(callBackHandle.instance, callBackHandle.getVariableName(), callBackHandle.getMethod().getName(), this.currentEvent));
        }
        try {
            callBackHandle.method.invoke(callBackHandle.instance, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Field getFieldByName(String name) {
        return this.simpleEventProcessorModel.getFieldForName(name);
    }

    public <T> T getNodeById(String id) throws NoSuchFieldException {
        Field fieldByName = this.getFieldByName(id);
        if (fieldByName == null) {
            throw new NoSuchFieldException(id);
        }
        return (T)fieldByName.instance;
    }

    private void buildDispatch() {
        this.isDefaultHandling = this.simpleEventProcessorModel.getDispatchMap().containsKey(Object.class);
        ArrayList<CbMethodHandle> dispatchMapForGraph = new ArrayList<CbMethodHandle>(this.simpleEventProcessorModel.getDispatchMapForGraph());
        AtomicInteger counter = new AtomicInteger();
        if (log.isDebugEnabled()) {
            log.debug("======== callbacks for graph =============");
            dispatchMapForGraph.forEach(cb -> log.debug("index:{} [type:{}] {}::{}", new Object[]{counter.getAndIncrement(), cb.getMethod().getDeclaringClass().getSimpleName(), cb.getVariableName(), cb.getMethod().getName()}));
            log.debug("======== callbacks for graph =============");
        }
        this.dirtyBitset.clear(dispatchMapForGraph.size());
        this.dirtyBitset.clear();
        this.eventOnlyBitset.clear(dispatchMapForGraph.size());
        this.eventOnlyBitset.or(this.dirtyBitset);
        this.forkedTaskBitset.clear(dispatchMapForGraph.size());
        this.forkedTaskBitset.clear();
        Map<Object, List<CbMethodHandle>> parentUpdateListenerMethodMap = this.simpleEventProcessorModel.getParentUpdateListenerMethodMap();
        HashMap<Object, Node> instance2NodeMap = new HashMap<Object, Node>(dispatchMapForGraph.size());
        for (int i = 0; i < dispatchMapForGraph.size(); ++i) {
            Node node2;
            CbMethodHandle cbMethodHandle = (CbMethodHandle)dispatchMapForGraph.get(i);
            if (cbMethodHandle.isForkExecution()) {
                log.debug("Wrap with ForkJoinTask -> {}:{}", (Object)cbMethodHandle.getVariableName(), (Object)cbMethodHandle.getMethod().getName());
                node2 = new ForkTriggerTaskNode(i, cbMethodHandle, new ArrayList<CbMethodHandle>(parentUpdateListenerMethodMap.getOrDefault(cbMethodHandle.instance, Collections.emptyList())));
            } else {
                node2 = new Node(i, cbMethodHandle, new ArrayList<CbMethodHandle>(parentUpdateListenerMethodMap.getOrDefault(cbMethodHandle.instance, Collections.emptyList())));
            }
            this.eventHandlers.add(node2);
            instance2NodeMap.put(node2.callbackHandle.instance, node2);
        }
        for (Node handler : this.eventHandlers) {
            this.simpleEventProcessorModel.getOnTriggerDependenciesForNode(handler.getCallbackHandle()).stream().peek(o -> log.debug("child dependency:{}", o)).map(instance2NodeMap::get).filter(Objects::nonNull).forEach(x$0 -> handler.addDependent((Node)x$0));
        }
        for (Node handler : this.eventHandlers) {
            if (!(handler instanceof ForkTriggerTaskNode)) continue;
            ForkTriggerTaskNode forkedTriggerTask = (ForkTriggerTaskNode)handler;
            this.forkTriggerTaskNodes.add(forkedTriggerTask);
            this.simpleEventProcessorModel.getOnTriggerDependenciesForNode(handler.getCallbackHandle()).stream().peek(o -> log.debug("child dependency:{}", o)).map(instance2NodeMap::get).filter(Objects::nonNull).forEach(node -> node.forkJoinParents.add(forkedTriggerTask));
        }
        this.simpleEventProcessorModel.getDispatchMap().forEach((eventClass, filterDescriptionListMap) -> filterDescriptionListMap.forEach((filterDescription, cbMethodHandles) -> {
            if (!(filterDescription.equals(FilterDescription.NO_FILTER) || filterDescription.equals(FilterDescription.DEFAULT_FILTER) || filterDescription.equals(FilterDescription.INVERSE_FILTER))) {
                this.filteredEventHandlerToBitsetMap.put((FilterDescription)filterDescription, cbMethodHandles.stream().filter(CbMethodHandle::isEventHandler).map(this::nodeIndex).collect(Collectors.toList()));
            }
        }));
        this.simpleEventProcessorModel.getDispatchMap().forEach((key, value) -> this.noFilterEventHandlerToBitsetMap.put(JavaGenHelper.mapPrimitiveToWrapper(key), value.getOrDefault(FilterDescription.DEFAULT_FILTER, Collections.emptyList()).stream().filter(Objects::nonNull).filter(CbMethodHandle::isEventHandler).map(this::nodeIndex).collect(Collectors.toList())));
        this.eventHandlers.forEach(Node::init);
        this.registerAuditors();
    }

    public <T> T getExportedService() {
        if (this.exportingWrapper != null) {
            return (T)this.exportingWrapper;
        }
        String packageName = "com.fluxtion.compiler.generation.targets.temp";
        String className = "InMemoryExportWrapper_" + UUID.randomUUID().toString().replace("-", "_");
        String fqn = packageName + "." + className;
        String additionalInterfaces = "";
        if (!this.config.interfacesToImplement().isEmpty()) {
            additionalInterfaces = this.config.interfacesToImplement().stream().map(Class::getCanonicalName).collect(Collectors.joining(", ", " implements ", ""));
        }
        Map<Method, ExportFunctionData> exportedFunctionMap = this.simpleEventProcessorModel.getExportedFunctionMap();
        Set exportCbSet = exportedFunctionMap.values().stream().map(ExportFunctionData::getFunctionCallBackList).flatMap(Collection::stream).map(x$0 -> new CallbackInstance((CbMethodHandle)x$0)).collect(Collectors.toSet());
        String declarations = exportCbSet.stream().map(c -> c.getInstance().getClass().getCanonicalName() + " " + c.getVariableName()).collect(Collectors.joining(";\n\t", "\tInMemoryEventProcessor processor;\n\t", ";\n\tprivate ExportFunctionAuditEvent functionAudit = new ExportFunctionAuditEvent();\n"));
        String constructor = exportCbSet.stream().map(c -> c.getVariableName() + " = processor.getNodeById(\"" + c.getVariableName() + "\")").collect(Collectors.joining(";\n\t", "public " + className + "(InMemoryEventProcessor processor) throws java.lang.NoSuchFieldException {\n\tthis.processor = processor;\n\t", ";\n}\n"));
        String delegateOnEvent = "public void onEvent(Object o){\n\tprocessor.onEvent(o);\n}\n\npublic void init(){\n\tprocessor.init();\n}\n\npublic void start(){\n\tprocessor.start();\n}\n\npublic void stop(){\n\tprocessor.stop();\n}\n\npublic InMemoryEventProcessor processor(){\n\treturn processor;\n}\n\npublic void tearDown(){\n\tprocessor.tearDown();\n}";
        ArrayList<Method> keys = new ArrayList<Method>(exportedFunctionMap.keySet());
        keys.sort(Comparator.comparing(Method::toString));
        StringJoiner joiner = new StringJoiner("\n\n", "\n", "");
        joiner.setEmptyValue("");
        for (Method key : keys) {
            if (exportedFunctionMap.get(key).getFunctionCallBackList().isEmpty()) continue;
            joiner.add(ClassUtils.wrapExportedFunctionCall(key, exportedFunctionMap.get(key), true));
        }
        String exportedMethods = joiner.toString();
        StringBuilder sb = new StringBuilder("package " + packageName + ";\n\nimport " + this.getClass().getCanonicalName() + ";\nimport " + ExportFunctionAuditEvent.class.getCanonicalName() + ";\npublic class " + className + additionalInterfaces + " {\n" + declarations + "\n" + constructor + "\n" + delegateOnEvent + "\n" + exportedMethods + "\n}");
        Class clazz = StringCompilation.compile(fqn, sb.toString(), new String[0]);
        this.exportingWrapper = clazz.getConstructor(InMemoryEventProcessor.class).newInstance(this);
        return (T)this.exportingWrapper;
    }

    private void registerAuditors() {
        List auditorFields = this.simpleEventProcessorModel.getNodeRegistrationListenerFields().stream().map(Field::getInstance).collect(Collectors.toList());
        this.auditors.clear();
        this.auditors.addAll(this.simpleEventProcessorModel.getNodeRegistrationListenerFields().stream().map(Field::getInstance).map(Auditor.class::cast).collect(Collectors.toList()));
        this.auditors.forEach(Auditor::init);
        this.simpleEventProcessorModel.getNodeFields().stream().filter(f -> !auditorFields.contains(f.getInstance())).forEach(f -> this.auditors.forEach(a -> a.nodeRegistered(f.getInstance(), f.getName())));
        this.forkTriggerTaskNodes.stream().forEach(f -> this.auditors.forEach(a -> a.nodeRegistered((Object)((ForkTriggerTaskNode)f).forkedTriggerTask, f.callbackHandle.forkVariableName())));
    }

    private int nodeIndex(CbMethodHandle nodeInstance) {
        return this.eventHandlers.stream().filter(n -> n.sameCallback(nodeInstance)).findFirst().map(Node::getPosition).orElse(-1);
    }

    private class Node
    implements StaticEventProcessor,
    Lifecycle {
        final int position;
        final CbMethodHandle callbackHandle;
        final List<CbMethodHandle> parentListeners;
        final List<Node> dependents = new ArrayList<Node>();
        final List<ForkTriggerTaskNode> forkJoinParents = new ArrayList<ForkTriggerTaskNode>();
        Method onEventCompleteMethod;
        MutableTuple<Object, Method> onEventCompleteMethodPointer;
        boolean dirty;

        public void onEvent(Object e) {
            this.dirty = false;
            InMemoryEventProcessor.this.auditors.stream().filter(Auditor::auditInvocations).forEachOrdered(a -> a.nodeInvoked(this.callbackHandle.instance, this.callbackHandle.getVariableName(), this.callbackHandle.getMethod().getName(), e));
            Object result = this.callbackHandle.isEventHandler ? this.callbackHandle.method.invoke(this.callbackHandle.instance, e) : this.callbackHandle.method.invoke(this.callbackHandle.instance, new Object[0]);
            this.dirty = result == null || (Boolean)result != false;
            this.dependents.forEach(n -> n.parentUpdated(this.dirty));
            for (CbMethodHandle cb : this.parentListeners) {
                if (!(cb.isGuardedParent() & this.dirty) && cb.isGuardedParent()) continue;
                InMemoryEventProcessor.this.auditors.stream().filter(Auditor::auditInvocations).forEachOrdered(a -> a.nodeInvoked(cb.instance, cb.getVariableName(), cb.getMethod().getName(), e));
                cb.method.invoke(cb.instance, this.callbackHandle.instance);
            }
        }

        private void markDirty() {
            this.dirty = true;
            this.dependents.forEach(n -> n.parentUpdated(this.dirty));
        }

        public boolean willInvokeEventComplete() {
            return this.dirty && this.onEventCompleteMethod != null && !InMemoryEventProcessor.this.eventCompleteInvokeSet.contains(this.onEventCompleteMethodPointer);
        }

        public void eventComplete() {
            if (this.willInvokeEventComplete()) {
                InMemoryEventProcessor.this.auditors.stream().filter(Auditor::auditInvocations).forEachOrdered(a -> a.nodeInvoked(this.callbackHandle.instance, this.callbackHandle.getVariableName(), this.onEventCompleteMethod.getName(), InMemoryEventProcessor.this.currentEvent));
                this.onEventCompleteMethod.invoke(this.callbackHandle.getInstance(), new Object[0]);
                InMemoryEventProcessor.this.eventCompleteInvokeSet.add(this.onEventCompleteMethodPointer);
            }
            this.dirty = false;
        }

        private void addDependent(Node dependent) {
            log.debug("addDependent:{}", (Object)dependent);
            this.dependents.add(dependent);
        }

        private void parentUpdated(boolean parentDirty) {
            if (this.callbackHandle.isInvertedDirtyHandler) {
                boolean bl = parentDirty = !parentDirty;
            }
            if (parentDirty) {
                log.debug("mark dirty:{}", (Object)this.callbackHandle.getVariableName());
                InMemoryEventProcessor.this.dirtyBitset.set(this.position);
            } else {
                log.debug("mark clean:{}", (Object)this.callbackHandle.getVariableName());
            }
        }

        protected void markJoinOnParentTask() {
            InMemoryEventProcessor.this.forkedTaskBitset.set(this.position);
        }

        protected void joinOnParentTask() {
            this.forkJoinParents.forEach(ForkTriggerTaskNode::afterEvent);
        }

        public void init() {
            InMemoryEventProcessor.this.dirtyBitset.clear(this.position);
            this.dirty = false;
            this.callbackHandle.method.setAccessible(true);
            if (this.callbackHandle.isNoPropagateEventHandler()) {
                this.parentListeners.clear();
            } else {
                this.parentListeners.forEach(cb -> cb.method.setAccessible(true));
            }
            this.onEventCompleteMethod = ReflectionUtils.getAllMethods(this.callbackHandle.getInstance().getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(AfterTrigger.class)}).stream().findFirst().orElse(null);
            if (this.onEventCompleteMethod != null) {
                this.onEventCompleteMethod.setAccessible(true);
                this.onEventCompleteMethodPointer = new MutableTuple(this.callbackHandle.getInstance(), (Object)this.onEventCompleteMethod);
            }
        }

        public void tearDown() {
            InMemoryEventProcessor.this.dirtyBitset.clear(this.position);
            InMemoryEventProcessor.this.processing = false;
        }

        boolean sameCallback(CbMethodHandle other) {
            return Objects.equals(this.callbackHandle, other);
        }

        public int getPosition() {
            return this.position;
        }

        public String toString() {
            return "Node{callbackHandle=" + this.callbackHandle + '}';
        }

        public Node(int position, CbMethodHandle callbackHandle, List<CbMethodHandle> parentListeners) {
            this.position = position;
            this.callbackHandle = callbackHandle;
            this.parentListeners = parentListeners;
        }

        public CbMethodHandle getCallbackHandle() {
            return this.callbackHandle;
        }

        public List<CbMethodHandle> getParentListeners() {
            return this.parentListeners;
        }

        public List<Node> getDependents() {
            return this.dependents;
        }

        public List<ForkTriggerTaskNode> getForkJoinParents() {
            return this.forkJoinParents;
        }

        public Method getOnEventCompleteMethod() {
            return this.onEventCompleteMethod;
        }

        public MutableTuple<Object, Method> getOnEventCompleteMethodPointer() {
            return this.onEventCompleteMethodPointer;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setOnEventCompleteMethod(Method onEventCompleteMethod) {
            this.onEventCompleteMethod = onEventCompleteMethod;
        }

        public void setOnEventCompleteMethodPointer(MutableTuple<Object, Method> onEventCompleteMethodPointer) {
            this.onEventCompleteMethodPointer = onEventCompleteMethodPointer;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPosition() != other.getPosition()) {
                return false;
            }
            if (this.isDirty() != other.isDirty()) {
                return false;
            }
            CbMethodHandle this$callbackHandle = this.getCallbackHandle();
            CbMethodHandle other$callbackHandle = other.getCallbackHandle();
            if (this$callbackHandle == null ? other$callbackHandle != null : !((Object)this$callbackHandle).equals(other$callbackHandle)) {
                return false;
            }
            List<CbMethodHandle> this$parentListeners = this.getParentListeners();
            List<CbMethodHandle> other$parentListeners = other.getParentListeners();
            if (this$parentListeners == null ? other$parentListeners != null : !((Object)this$parentListeners).equals(other$parentListeners)) {
                return false;
            }
            List<Node> this$dependents = this.getDependents();
            List<Node> other$dependents = other.getDependents();
            if (this$dependents == null ? other$dependents != null : !((Object)this$dependents).equals(other$dependents)) {
                return false;
            }
            List<ForkTriggerTaskNode> this$forkJoinParents = this.getForkJoinParents();
            List<ForkTriggerTaskNode> other$forkJoinParents = other.getForkJoinParents();
            if (this$forkJoinParents == null ? other$forkJoinParents != null : !((Object)this$forkJoinParents).equals(other$forkJoinParents)) {
                return false;
            }
            Method this$onEventCompleteMethod = this.getOnEventCompleteMethod();
            Method other$onEventCompleteMethod = other.getOnEventCompleteMethod();
            if (this$onEventCompleteMethod == null ? other$onEventCompleteMethod != null : !((Object)this$onEventCompleteMethod).equals(other$onEventCompleteMethod)) {
                return false;
            }
            MutableTuple<Object, Method> this$onEventCompleteMethodPointer = this.getOnEventCompleteMethodPointer();
            MutableTuple<Object, Method> other$onEventCompleteMethodPointer = other.getOnEventCompleteMethodPointer();
            return !(this$onEventCompleteMethodPointer == null ? other$onEventCompleteMethodPointer != null : !this$onEventCompleteMethodPointer.equals(other$onEventCompleteMethodPointer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Node;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPosition();
            result = result * 59 + (this.isDirty() ? 79 : 97);
            CbMethodHandle $callbackHandle = this.getCallbackHandle();
            result = result * 59 + ($callbackHandle == null ? 43 : ((Object)$callbackHandle).hashCode());
            List<CbMethodHandle> $parentListeners = this.getParentListeners();
            result = result * 59 + ($parentListeners == null ? 43 : ((Object)$parentListeners).hashCode());
            List<Node> $dependents = this.getDependents();
            result = result * 59 + ($dependents == null ? 43 : ((Object)$dependents).hashCode());
            List<ForkTriggerTaskNode> $forkJoinParents = this.getForkJoinParents();
            result = result * 59 + ($forkJoinParents == null ? 43 : ((Object)$forkJoinParents).hashCode());
            Method $onEventCompleteMethod = this.getOnEventCompleteMethod();
            result = result * 59 + ($onEventCompleteMethod == null ? 43 : ((Object)$onEventCompleteMethod).hashCode());
            MutableTuple<Object, Method> $onEventCompleteMethodPointer = this.getOnEventCompleteMethodPointer();
            result = result * 59 + ($onEventCompleteMethodPointer == null ? 43 : $onEventCompleteMethodPointer.hashCode());
            return result;
        }
    }

    public class ForkTriggerTaskNode
    extends Node {
        private final ForkedTriggerTask forkedTriggerTask;
        private Object triggerEvent;

        public ForkTriggerTaskNode(int position, CbMethodHandle callbackHandle, List<CbMethodHandle> parentListeners) {
            super(position, callbackHandle, parentListeners);
            this.forkedTriggerTask = new ForkedTriggerTask((LambdaReflection.SerializableSupplier & Serializable)() -> {
                try {
                    return (Boolean)callbackHandle.method.invoke(callbackHandle.instance, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }, callbackHandle.variableName);
        }

        @Override
        public void onEvent(Object e) {
            this.dependents.forEach(Node::markJoinOnParentTask);
            this.triggerEvent = e;
            this.dirty = false;
            InMemoryEventProcessor.this.auditors.stream().filter(Auditor::auditInvocations).forEachOrdered(a -> a.nodeInvoked((Object)this.forkedTriggerTask, this.callbackHandle.getVariableName(), this.callbackHandle.getMethod().getName(), e));
            log.debug("forking task:{}", (Object)this.callbackHandle.getVariableName());
            this.forkedTriggerTask.onTrigger();
        }

        @Override
        public boolean willInvokeEventComplete() {
            this.afterEvent();
            return this.dirty && this.onEventCompleteMethod != null;
        }

        public void afterEvent() {
            if (this.triggerEvent != null) {
                log.debug("afterEvent processing:{}", (Object)this.callbackHandle.getVariableName());
                this.dirty = this.forkedTriggerTask.afterEvent();
                this.dependents.forEach(n -> ((Node)n).parentUpdated(this.dirty));
                for (CbMethodHandle cb : this.parentListeners) {
                    if (!(cb.isGuardedParent() & this.dirty) && cb.isGuardedParent()) continue;
                    InMemoryEventProcessor.this.auditors.stream().filter(Auditor::auditInvocations).forEachOrdered(a -> a.nodeInvoked(cb.instance, cb.getVariableName(), cb.getMethod().getName(), this.triggerEvent));
                    cb.method.invoke(cb.instance, this.callbackHandle.instance);
                }
            } else {
                log.debug("afterEvent NOT processing:{}", (Object)this.callbackHandle.getVariableName());
            }
            this.triggerEvent = null;
        }

        public void reinitialise() {
            log.debug("reinitialise:{}", (Object)this.callbackHandle.getVariableName());
            this.forkedTriggerTask.reinitialize();
        }
    }

    private static final class CallbackInstance {
        private final Object instance;
        private final String variableName;

        private CallbackInstance(CbMethodHandle cbMethodHandle) {
            this.instance = cbMethodHandle.getInstance();
            this.variableName = cbMethodHandle.getVariableName();
        }

        public Object getInstance() {
            return this.instance;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallbackInstance)) {
                return false;
            }
            CallbackInstance other = (CallbackInstance)o;
            Object this$instance = this.getInstance();
            Object other$instance = other.getInstance();
            if (this$instance == null ? other$instance != null : !this$instance.equals(other$instance)) {
                return false;
            }
            String this$variableName = this.getVariableName();
            String other$variableName = other.getVariableName();
            return !(this$variableName == null ? other$variableName != null : !this$variableName.equals(other$variableName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $instance = this.getInstance();
            result = result * 59 + ($instance == null ? 43 : $instance.hashCode());
            String $variableName = this.getVariableName();
            result = result * 59 + ($variableName == null ? 43 : $variableName.hashCode());
            return result;
        }

        public String toString() {
            return "InMemoryEventProcessor.CallbackInstance(instance=" + this.getInstance() + ", variableName=" + this.getVariableName() + ")";
        }
    }
}

