/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.targets;

import com.fluxtion.compiler.builder.filter.FilterDescription;
import org.apache.commons.lang3.StringUtils;

public interface JavaGenHelper {
    public static final StringBuilder builder = new StringBuilder(1000000);

    public static String generateFilteredDispatchMethodName(FilterDescription filter) {
        String filterName = filter.variableName;
        if (filterName == null) {
            filterName = (filter.isIntFilter ? Integer.valueOf(filter.value) : filter.stringValue) + "";
        }
        filterName = filter.isFiltered ? filterName : "NoFilter";
        String filterClass = "noFilterClass";
        if (filter.eventClass != null) {
            filterClass = filter.eventClass.getSimpleName();
        }
        return JavaGenHelper.getIdentifier("handle_" + filterClass + "_" + filterName);
    }

    public static String generateFilteredDispatchMap(FilterDescription filter) {
        String type = filter.isIntFilter ? "Int" : "String";
        String filterClass = "noFilterClass";
        if (filter.eventClass != null) {
            filterClass = filter.eventClass.getSimpleName();
        }
        return JavaGenHelper.getIdentifier("dispatch" + type + "Map" + filterClass);
    }

    public static String getIdentifier(String str) {
        StringBuilder sb = new StringBuilder();
        if (!Character.isJavaIdentifierStart((str = StringUtils.uncapitalize((String)str)).charAt(0))) {
            sb.append("_");
        }
        for (char c : str.toCharArray()) {
            if (!Character.isJavaIdentifierPart(c)) {
                sb.append("_");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Class<?> mapWrapperToPrimitive(Class<?> clazz) {
        Class<Object> retClass = Void.TYPE;
        switch (clazz.getSimpleName()) {
            case "Integer": {
                retClass = Integer.TYPE;
                break;
            }
            case "Double": {
                retClass = Double.TYPE;
                break;
            }
            case "Float": {
                retClass = Float.TYPE;
                break;
            }
            case "Short": {
                retClass = Short.TYPE;
                break;
            }
            case "Byte": {
                retClass = Byte.TYPE;
                break;
            }
            case "Long": {
                retClass = Long.TYPE;
                break;
            }
            case "Character": {
                retClass = Character.TYPE;
            }
        }
        return retClass;
    }

    public static Class<?> mapPrimitiveToWrapper(Class<?> clazz) {
        Class<Object> retClass = clazz;
        switch (clazz.getSimpleName()) {
            case "int": {
                retClass = Integer.class;
                break;
            }
            case "double": {
                retClass = Double.class;
                break;
            }
            case "float": {
                retClass = Float.class;
                break;
            }
            case "short": {
                retClass = Short.class;
                break;
            }
            case "byte": {
                retClass = Byte.class;
                break;
            }
            case "long": {
                retClass = Long.class;
                break;
            }
            case "char": {
                retClass = Character.class;
            }
        }
        return retClass;
    }
}

