/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.targets;

import com.fluxtion.compiler.EventProcessorConfig;
import com.fluxtion.compiler.builder.filter.FilterDescription;
import com.fluxtion.compiler.generation.GenerationContext;
import com.fluxtion.compiler.generation.model.CbMethodHandle;
import com.fluxtion.compiler.generation.model.DirtyFlag;
import com.fluxtion.compiler.generation.model.ExportFunctionMarker;
import com.fluxtion.compiler.generation.model.Field;
import com.fluxtion.compiler.generation.model.InvokerFilterTarget;
import com.fluxtion.compiler.generation.model.SimpleEventProcessorModel;
import com.fluxtion.compiler.generation.targets.JavaGenHelper;
import com.fluxtion.compiler.generation.util.ClassUtils;
import com.fluxtion.compiler.generation.util.NaturalOrderComparator;
import com.fluxtion.runtime.EventProcessorContext;
import com.fluxtion.runtime.annotations.OnEventHandler;
import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.audit.Auditor;
import com.fluxtion.runtime.audit.EventLogManager;
import com.fluxtion.runtime.callback.ExportFunctionAuditEvent;
import com.fluxtion.runtime.event.Event;
import com.fluxtion.runtime.input.EventFeed;
import com.fluxtion.runtime.node.ForkedTriggerTask;
import com.fluxtion.runtime.node.MutableEventProcessorContext;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.list.dsl.MirrorList;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class JavaSourceGenerator {
    private static final String s4 = "    ";
    private static final String s8 = "        ";
    private static final String s12 = "            ";
    private static final String s16 = "                ";
    private static final String s20 = "                    ";
    private static final String s24 = "                        ";
    private final ArrayList<String> initialiseMethodList;
    private final ArrayList<String> startMethodList;
    private final ArrayList<String> stopMethodList;
    private final ArrayList<String> batchEndMethodList;
    private final ArrayList<String> eventEndMethodList;
    private final ArrayList<String> batchPauseMethodList;
    private final ArrayList<String> tearDownMethodList;
    private final ArrayList<String> nodeDeclarationList;
    private final ArrayList<String> importList;
    private final ArrayList<String> nodeMemberAssignmentList;
    private final ArrayList<String> publicNodeIdentifierList;
    private final SimpleEventProcessorModel model;
    private final boolean assignPrivateMembers;
    private final StringBuilder nodeDecBuilder = new StringBuilder(5000000);
    private final HashMap<String, String> importMap = new HashMap();
    private final StringBuilder ct = new StringBuilder(5000000);
    private final StringBuilder switchF = new StringBuilder(5000000);
    private final boolean instanceOfDispatch;
    private final EventProcessorConfig eventProcessorConfig;
    private String initialiseMethods;
    private String startMethods;
    private String stopMethods;
    private String batchEndMethods;
    private String eventEndMethods;
    private String batchPauseMethods;
    private String tearDownMethods;
    private String nodeDeclarations;
    private String dirtyFlagDeclarations;
    private String dirtyFlagLookup;
    private String dirtyFlagUpdate;
    private String resetDirtyFlags;
    private String guardCheckMethods;
    private String filterConstantDeclarations;
    private String nodeMemberAssignments;
    private String eventDispatch;
    private String eventHandlers;
    private String exportedMethods;
    private boolean isInlineEventHandling;
    private String eventAuditDispatch;
    private boolean auditingEvent;
    private boolean auditingInvocations;
    private String auditMethodString;
    private String additionalInterfaces;
    private String javaDocEventClassList;
    private String forkDeclarations;
    private String resetForkTasks;

    public JavaSourceGenerator(SimpleEventProcessorModel model, EventProcessorConfig eventProcessorConfig) {
        this.isInlineEventHandling = eventProcessorConfig.isInlineEventHandling();
        this.assignPrivateMembers = eventProcessorConfig.isAssignPrivateMembers();
        this.instanceOfDispatch = eventProcessorConfig.getDispatchStrategy() == EventProcessorConfig.DISPATCH_STRATEGY.INSTANCE_OF;
        this.model = model;
        this.eventProcessorConfig = eventProcessorConfig;
        this.eventHandlers = "";
        this.initialiseMethodList = new ArrayList();
        this.startMethodList = new ArrayList();
        this.stopMethodList = new ArrayList();
        this.batchEndMethodList = new ArrayList();
        this.batchPauseMethodList = new ArrayList();
        this.eventEndMethodList = new ArrayList();
        this.tearDownMethodList = new ArrayList();
        this.nodeDeclarationList = new ArrayList();
        this.nodeMemberAssignmentList = new ArrayList();
        this.publicNodeIdentifierList = new ArrayList();
        this.importList = new ArrayList();
    }

    private static boolean hasIdField(Class e) {
        return false;
    }

    public void buildSourceModel() throws Exception {
        this.checkAuditInvocations();
        this.buildMethodSource(this.model.getInitialiseMethods(), this.initialiseMethodList);
        this.buildMethodSource(this.model.getStartMethods(), this.startMethodList);
        this.buildMethodSource(this.model.getStopMethods(), this.stopMethodList);
        this.buildMethodSource(this.model.getBatchPauseMethods(), this.batchPauseMethodList);
        this.buildForkAwareMethodSource(this.model.getEventEndMethods(), this.eventEndMethodList);
        this.buildMethodSource(this.model.getBatchEndMethods(), this.batchEndMethodList);
        this.buildMethodSource(this.model.getTearDownMethods(), this.tearDownMethodList);
        this.addDefaultImports();
        this.buildNodeDeclarations();
        this.buildDirtyFlags();
        this.buildForkDeclarations();
        this.buildFilterConstantDeclarations();
        this.buildMemberAssignments();
        this.buildNodeRegistrationListeners();
        this.buildEventDispatch();
        this.initialiseMethods = "";
        boolean firstLine = true;
        for (String initialiseMethod : this.initialiseMethodList) {
            this.initialiseMethods = this.initialiseMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.startMethods = String.join((CharSequence)"\n", this.startMethodList);
        this.stopMethods = String.join((CharSequence)"\n", this.stopMethodList);
        this.batchPauseMethods = "";
        firstLine = true;
        for (String initialiseMethod : this.batchPauseMethodList) {
            this.batchPauseMethods = this.batchPauseMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.batchEndMethods = "";
        firstLine = true;
        for (String initialiseMethod : this.batchEndMethodList) {
            this.batchEndMethods = this.batchEndMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.eventEndMethods = "";
        firstLine = true;
        for (String initialiseMethod : this.eventEndMethodList) {
            this.eventEndMethods = this.eventEndMethods + (firstLine ? "" : "\n") + initialiseMethod;
            firstLine = false;
        }
        this.tearDownMethods = "";
        for (String initialiseMethod : this.tearDownMethodList) {
            this.tearDownMethods = this.tearDownMethods + initialiseMethod + "\n";
        }
        this.tearDownMethods = StringUtils.chomp((String)this.tearDownMethods);
        this.nodeMemberAssignments = "";
        StringBuilder memberAssignments = new StringBuilder(200 * this.nodeMemberAssignmentList.size());
        firstLine = true;
        for (String initialiseMethod : this.nodeMemberAssignmentList) {
            memberAssignments.append(firstLine ? s4 : "\n    ").append(initialiseMethod);
            firstLine = false;
        }
        this.nodeMemberAssignments = memberAssignments.toString();
    }

    private void checkAuditInvocations() {
        List<com.fluxtion.compiler.generation.model.Field> listenerFields = this.model.getNodeRegistrationListenerFields();
        this.auditingInvocations = listenerFields.stream().map(com.fluxtion.compiler.generation.model.Field::getInstance).filter(Auditor.class::isInstance).map(Auditor.class::cast).anyMatch(Auditor::auditInvocations);
    }

    private void buildForkDeclarations() {
        String forkWrapperClass = this.getClassTypeName(ForkedTriggerTask.class);
        this.forkDeclarations = this.model.getTriggerOnlyCallBacks().stream().filter(CbMethodHandle::isForkExecution).map(c -> "private final " + forkWrapperClass + " " + c.forkVariableName() + " = new " + forkWrapperClass + "(" + c.invokeLambdaString() + ", \"" + c.variableName + "\" );").collect(Collectors.joining("\n", "//Forked declarations\n", "\n"));
        this.resetForkTasks = this.model.getTriggerOnlyCallBacks().stream().filter(CbMethodHandle::isForkExecution).map(c -> c.forkVariableName() + ".reinitialize();").collect(Collectors.joining("\n"));
    }

    private void buildMethodSource(List<CbMethodHandle> methodList, List<String> methodSourceList) {
        for (CbMethodHandle method : methodList) {
            String methodString = String.format("%8s%s.%s();", "", method.variableName, method.method.getName());
            methodSourceList.add(methodString);
        }
    }

    private void buildForkAwareMethodSource(List<CbMethodHandle> methodList, List<String> methodSourceList) {
        Set<Object> forkedTriggers = this.model.getForkedTriggerInstances();
        this.resetForkTasks = this.model.getTriggerOnlyCallBacks().stream().filter(CbMethodHandle::isForkExecution).map(c -> c.forkVariableName() + ".reinitialize();").collect(Collectors.joining("\n"));
        for (CbMethodHandle method : methodList) {
            String waitForJoin = "";
            if (forkedTriggers.contains(method.instance)) {
                waitForJoin = method.forkVariableName() + ".afterEvent();\n";
            }
            String methodString = String.format("%8s%s.%s();", "", method.variableName, method.method.getName());
            methodSourceList.add(waitForJoin + methodString);
        }
        methodSourceList.add(this.resetForkTasks);
    }

    private void buildDirtyFlags() {
        this.dirtyFlagDeclarations = "";
        this.resetDirtyFlags = "";
        this.dirtyFlagLookup = "";
        this.dirtyFlagUpdate = "";
        this.guardCheckMethods = "";
        ArrayList<DirtyFlag> values = new ArrayList<DirtyFlag>(this.model.getDirtyFieldMap().values());
        NaturalOrderComparator comparator = new NaturalOrderComparator();
        values.sort((o1, o2) -> comparator.compare(o1.name, o2.name));
        for (DirtyFlag flag : values) {
            this.dirtyFlagDeclarations = this.dirtyFlagDeclarations + String.format("%4sprivate boolean %s = false;%n", "", flag.name);
            this.resetDirtyFlags = this.resetDirtyFlags + String.format("%8s%s = false;%n", "", flag.name);
        }
        for (DirtyFlag flag : values) {
            if (!flag.requiresInvert) continue;
            this.dirtyFlagDeclarations = this.dirtyFlagDeclarations + String.format("%4sprivate boolean not%s = false;%n", "", flag.name);
            this.resetDirtyFlags = this.resetDirtyFlags + String.format("%8snot%s = false;%n", "", flag.name);
        }
        List<Map.Entry> sortedDirtyFlags = this.model.getDirtyFieldMap().entrySet().stream().sorted(Comparator.comparing(e -> ((com.fluxtion.compiler.generation.model.Field)e.getKey()).getName())).collect(Collectors.toList());
        sortedDirtyFlags.forEach(e -> {
            this.dirtyFlagLookup = this.dirtyFlagLookup + String.format("%12sdirtyFlagSupplierMap.put(%s, () -> %s);", "", ((com.fluxtion.compiler.generation.model.Field)e.getKey()).getName(), ((DirtyFlag)e.getValue()).name);
        });
        sortedDirtyFlags.forEach(e -> {
            this.dirtyFlagUpdate = this.dirtyFlagUpdate + String.format("%12sdirtyFlagUpdateMap.put(%s, (b) -> %s = b);", "", ((com.fluxtion.compiler.generation.model.Field)e.getKey()).getName(), ((DirtyFlag)e.getValue()).name);
        });
        Set<Object> forkedTriggers = this.model.getForkedTriggerInstances();
        this.model.getNodeFields().forEach(field -> {
            String guardConditions = this.model.getNodeGuardConditions(field.instance).stream().map(d -> (d.isRequiresInvert() ? "not" : "") + d.getName()).collect(Collectors.joining(" |\n"));
            String forkedReturn = this.model.getNodeGuardConditions(field.instance).stream().filter(f -> forkedTriggers.contains(f.node.getInstance())).map(d -> {
                List<CbMethodHandle> updateListenerCbList = this.model.getParentUpdateListenerMethodMap().get(d.getNode().getInstance());
                boolean unguarded = false;
                StringBuilder sbUnguarded = new StringBuilder();
                StringBuilder guarded = new StringBuilder();
                String parentVar = d.getNode().getName();
                for (CbMethodHandle cbMethod : updateListenerCbList) {
                    if (!cbMethod.method.getAnnotation(OnParentUpdate.class).guarded()) {
                        if (this.auditingInvocations) {
                            sbUnguarded.append(s24).append("auditInvocation(").append(cbMethod.variableName).append(", \"").append(cbMethod.variableName).append("\"").append(", \"").append(cbMethod.method.getName()).append("\"").append(", \"\"").append(");\n");
                        }
                        sbUnguarded.append(s20).append(cbMethod.variableName).append(".").append(cbMethod.method.getName()).append("(").append(parentVar).append(");\n");
                        continue;
                    }
                    if (this.auditingInvocations) {
                        guarded.append(s24).append("auditInvocation(").append(cbMethod.variableName).append(", \"").append(cbMethod.variableName).append("\"").append(", \"").append(cbMethod.method.getName()).append("\"").append(", \"\"").append(");\n");
                    }
                    guarded.append(s24).append(cbMethod.variableName).append(".").append(cbMethod.method.getName()).append("(").append(parentVar).append(");\n");
                }
                return d.getName() + " = " + d.getForkedName() + ".afterEvent();\nif(" + d.getName() + "){\n" + guarded + "\n}" + sbUnguarded;
            }).collect(Collectors.joining("\n"));
            if (!this.model.getNodeGuardConditions(field.instance).isEmpty()) {
                this.guardCheckMethods = this.guardCheckMethods + String.format("%1$4sprivate boolean guardCheck_%2$s() {%n" + forkedReturn + "%1$8sreturn %3$s;}%n", "", field.getName(), guardConditions);
            }
        });
        this.dirtyFlagDeclarations = StringUtils.chomp((String)this.dirtyFlagDeclarations);
        this.resetDirtyFlags = StringUtils.chomp((String)this.resetDirtyFlags);
    }

    private String getClassTypeName(Class<?> clazzName) {
        return this.getClassName(clazzName.getCanonicalName());
    }

    private String getClassName(String clazzName) {
        clazzName = this.model.getMappedClass(clazzName);
        String[] split = clazzName.split("\\.");
        String ret = clazzName;
        if (split.length > 1) {
            String simpleName = split[split.length - 1];
            String pkgName = clazzName.replace("." + simpleName, "");
            ret = simpleName;
            if (!clazzName.startsWith("java.lang") && !GenerationContext.SINGLETON.getPackageName().equals(pkgName)) {
                if (this.importMap.containsKey(simpleName)) {
                    if (!this.importMap.get(simpleName).equalsIgnoreCase(clazzName)) {
                        ret = clazzName;
                    }
                } else {
                    this.importMap.put(simpleName, clazzName);
                    this.importList.add(clazzName);
                }
            }
        }
        return ret;
    }

    private void buildNodeDeclarations() {
        this.nodeDeclarations = "";
        StringBuilder declarationBuilder = new StringBuilder(2000);
        StringBuilder fqnBuilder = new StringBuilder(500);
        boolean firstLine = true;
        if (this.assignPrivateMembers) {
            declarationBuilder.append(s4).append("final net.vidageek.mirror.dsl.Mirror constructor = new net.vidageek.mirror.dsl.Mirror();\n");
        }
        for (com.fluxtion.compiler.generation.model.Field field : this.model.getTopologicallySortedNodeFields()) {
            String access = field.publicAccess ? "public" : "private";
            fqnBuilder.append(this.getClassName(field.fqn));
            boolean syntheticConstructor = false;
            Class<?> fieldClass = field.instance.getClass();
            try {
                fieldClass.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                syntheticConstructor = true;
            }
            StringBuilder declarationRoot = declarationBuilder.append(s4).append(access).append(" final ").append((CharSequence)fqnBuilder).append(this.model.getFieldSerializer().buildTypeDeclaration(field, this::getClassTypeName)).append(" ").append(field.name);
            if (this.assignPrivateMembers && syntheticConstructor) {
                declarationRoot.append(" = constructor.on(").append((CharSequence)fqnBuilder).append(".class).invoke().constructor().bypasser();");
            } else {
                List<Field.MappedField> constructorArgs = this.model.constructorArgs(field.instance);
                if (String.class.isAssignableFrom(fieldClass)) {
                    declarationRoot.append(" = ").append("\"").append(StringEscapeUtils.escapeJava((String)((String)field.instance))).append("\";");
                } else if (Integer.class.isAssignableFrom(fieldClass)) {
                    declarationRoot.append(" = ").append(field.instance).append(";");
                } else if (Float.class.isAssignableFrom(fieldClass)) {
                    declarationRoot.append(" = ").append(field.instance).append("f;");
                } else if (Double.class.isAssignableFrom(fieldClass)) {
                    if (!Double.isNaN((Double)field.instance)) {
                        declarationRoot.append(" = ").append(field.instance).append("d;");
                    } else {
                        declarationRoot.append(" = Double.NaN;");
                    }
                } else if (Long.class.isAssignableFrom(fieldClass)) {
                    declarationRoot.append(" = ").append(field.instance).append("L;");
                } else if (Short.class.isAssignableFrom(fieldClass)) {
                    declarationRoot.append(" = (short)").append(field.instance).append(";");
                } else if (Byte.class.isAssignableFrom(fieldClass)) {
                    declarationRoot.append(" = (byte)").append(field.instance).append(";");
                } else if (Character.class.isAssignableFrom(fieldClass)) {
                    declarationRoot.append(" = '").append(field.instance).append("';");
                } else {
                    String generic = field.isGeneric() ? "<>" : "";
                    String args = constructorArgs.stream().map(Field.MappedField::value).collect(Collectors.joining(", "));
                    declarationRoot.append(" = new ").append((CharSequence)fqnBuilder).append(generic + "(" + args + ");");
                }
            }
            String declaration = declarationBuilder.toString();
            this.nodeDeclarationList.add(declaration);
            this.nodeDecBuilder.append(firstLine ? "" : "\n").append(declaration);
            firstLine = false;
            if (field.publicAccess) {
                this.publicNodeIdentifierList.add(field.name);
            }
            fqnBuilder.delete(0, fqnBuilder.length());
            declarationBuilder.delete(0, declarationBuilder.length());
        }
        this.nodeDeclarations = this.nodeDecBuilder.toString();
        this.nodeDecBuilder.delete(0, this.nodeDecBuilder.length());
    }

    private void buildFilterConstantDeclarations() {
        this.filterConstantDeclarations = "";
        boolean firstLine = true;
        ArrayList<FilterDescription> tmp = new ArrayList<FilterDescription>(this.model.getFilterDescriptionList());
        tmp.sort((o1, o2) -> o1.value - o2.value);
        HashMap<String, Integer> filterVariableMap = new HashMap<String, Integer>();
        for (FilterDescription filterDescription : tmp) {
            if (filterDescription.variableName == null) continue;
            int value = filterDescription.value;
            String variableName = filterDescription.variableName;
            if (filterVariableMap.containsKey(variableName)) {
                int mappedValue = (Integer)filterVariableMap.get(variableName);
                if (mappedValue == value) continue;
                throw new IllegalStateException("two mappings for the same filter constant '" + variableName + "'");
            }
            filterVariableMap.put(variableName, value);
            String declaration = String.format("    public static final int %s = %d;", variableName, value);
            this.filterConstantDeclarations = this.filterConstantDeclarations + (firstLine ? "" : "\n") + declaration;
            firstLine = false;
        }
    }

    private void buildEventDispatch() {
        this.generateClassBasedDispatcher();
        this.generateExportMethodDispatcher();
        this.generateEventBufferedDispatcher();
        this.addEventAsJavaDoc();
        if (this.auditingEvent) {
            this.eventHandlers = this.eventHandlers + this.auditMethodString;
        }
    }

    private void addEventAsJavaDoc() {
        this.javaDocEventClassList = ClassUtils.sortClassHierarchy(this.model.getHandlerOnlyDispatchMap().keySet()).stream().map(Class::getCanonicalName).collect(Collectors.joining("</li>\n*   <li>", "*   <li>", "</li>"));
    }

    private void generateEventBufferedDispatcher() {
        boolean patternSwitch = this.eventProcessorConfig.getDispatchStrategy() == EventProcessorConfig.DISPATCH_STRATEGY.PATTERN_MATCH;
        StringBuilder noTriggerDispatch = new StringBuilder("\n    public void bufferEvent(Object event){\n        buffering = true;\n");
        String bufferEvents = "";
        if (this.instanceOfDispatch) {
            bufferEvents = "";
        } else if (!patternSwitch) {
            noTriggerDispatch.append("        switch (event.getClass().getName()) {\n");
        } else if (patternSwitch) {
            noTriggerDispatch.append("        switch (event) {\n");
        }
        Map<Class<?>, Map<FilterDescription, List<CbMethodHandle>>> handlerOnlyDispatchMap = this.model.getHandlerOnlyDispatchMap();
        boolean prev = this.isInlineEventHandling;
        this.isInlineEventHandling = true;
        List<Class<?>> sortedClasses = ClassUtils.sortClassHierarchy(handlerOnlyDispatchMap.keySet());
        sortedClasses.remove(ExportFunctionMarker.class);
        String elsePrefix = "if";
        for (Class<?> eventId : sortedClasses) {
            Map<FilterDescription, List<CbMethodHandle>> m = handlerOnlyDispatchMap.get(eventId);
            String className = this.getClassName(eventId.getCanonicalName());
            if (this.instanceOfDispatch) {
                String eventClassName = JavaGenHelper.mapPrimitiveToWrapper(eventId).getName().replace("$", ".");
                noTriggerDispatch.append(String.format("%12s (event instanceof %s) {%n", elsePrefix, eventClassName));
                elsePrefix = "else if";
                noTriggerDispatch.append(String.format("%16s%s typedEvent = (%s)event;%n", "", className, className));
            } else if (patternSwitch) {
                noTriggerDispatch.append(String.format("%12scase %s typedEvent -> {", "", className));
            } else {
                noTriggerDispatch.append(String.format("%12scase (\"%s\"):{%n", "", eventId.getName()));
                noTriggerDispatch.append(String.format("%16s%s typedEvent = (%s)event;%n", "", className, className));
            }
            noTriggerDispatch.append(this.buildFilteredDispatch(m, Collections.emptyMap(), eventId));
            if (this.instanceOfDispatch) {
                noTriggerDispatch.append(String.format("%12s}%n", ""));
                continue;
            }
            if (patternSwitch) {
                noTriggerDispatch.append(String.format("%12s}%n", ""));
                continue;
            }
            noTriggerDispatch.append(String.format("%16sbreak;%n", ""));
            noTriggerDispatch.append(String.format("%12s}%n", ""));
        }
        if (!this.instanceOfDispatch) {
            if (!handlerOnlyDispatchMap.keySet().contains(Object.class) && patternSwitch) {
                noTriggerDispatch.append("default -> {}");
            }
            noTriggerDispatch.append(String.format("%8s}%n", ""));
        }
        noTriggerDispatch.append(String.format("%4s}%n", ""));
        bufferEvents = bufferEvents + noTriggerDispatch.toString();
        HashMap<FilterDescription, List<CbMethodHandle>> cbMap = new HashMap<FilterDescription, List<CbMethodHandle>>();
        List<CbMethodHandle> triggerOnlyCallBacks = this.model.getTriggerOnlyCallBacks();
        if (!triggerOnlyCallBacks.isEmpty()) {
            cbMap.put(FilterDescription.DEFAULT_FILTER, triggerOnlyCallBacks);
        }
        HashMap<FilterDescription, List<CbMethodHandle>> cbMapPostDispatch = new HashMap<FilterDescription, List<CbMethodHandle>>();
        cbMapPostDispatch.put(FilterDescription.DEFAULT_FILTER, this.model.getAllPostEventCallBacks());
        String dispatchString = this.buildFilteredSwitch(cbMap, cbMapPostDispatch, Object.class, false, true);
        String bufferedTrigger = "\n    public void triggerCalculation(){\n        buffering = false;\n        String typedEvent = \"No event information - buffered dispatch\";\n" + (dispatchString == null ? "" : dispatchString) + "        afterEvent();\n\n    }\n";
        this.isInlineEventHandling = prev;
        this.eventHandlers = this.eventHandlers + bufferEvents;
        this.eventHandlers = this.eventHandlers + bufferedTrigger;
    }

    private void generateClassBasedDispatcher() {
        boolean patternSwitch = this.eventProcessorConfig.getDispatchStrategy() == EventProcessorConfig.DISPATCH_STRATEGY.PATTERN_MATCH;
        String dispatchStringNoId = "        switch (event.getClass().getName()) {\n";
        if (this.instanceOfDispatch) {
            dispatchStringNoId = "";
        } else if (patternSwitch) {
            dispatchStringNoId = "        switch (event) {\n";
        }
        Map<Class<?>, Map<FilterDescription, List<CbMethodHandle>>> dispatchMap = this.model.getDispatchMap();
        Map<Class<?>, Map<FilterDescription, List<CbMethodHandle>>> postDispatchMap = this.model.getPostDispatchMap();
        Set<Class<?>> keySet = dispatchMap.keySet();
        HashSet classSet = new HashSet(keySet);
        classSet.addAll(postDispatchMap.keySet());
        classSet.remove(ExportFunctionMarker.class);
        List<Class<?>> clazzList = ClassUtils.sortClassHierarchy(classSet);
        String elsePrefix = "if";
        for (Class<?> eventId : clazzList) {
            String className = this.getClassName(eventId.getCanonicalName());
            if (this.instanceOfDispatch) {
                String eventClassName = JavaGenHelper.mapPrimitiveToWrapper(eventId).getName().replace("$", ".");
                dispatchStringNoId = dispatchStringNoId + String.format("%12s (event instanceof %s) {%n", elsePrefix, eventClassName);
                elsePrefix = "else if";
                dispatchStringNoId = dispatchStringNoId + String.format("%16s%s typedEvent = (%s)event;%n", "", className, className);
            } else if (patternSwitch) {
                dispatchStringNoId = dispatchStringNoId + String.format("%12scase %s typedEvent -> ", "", className);
            } else {
                dispatchStringNoId = dispatchStringNoId + String.format("%12scase (\"%s\"):{%n", "", eventId.getName());
                dispatchStringNoId = dispatchStringNoId + String.format("%16s%s typedEvent = (%s)event;%n", "", className, className);
            }
            Map<FilterDescription, List<CbMethodHandle>> cbMap = dispatchMap.get(eventId);
            Map<FilterDescription, List<CbMethodHandle>> cbMapPostEvent = postDispatchMap.get(eventId);
            dispatchStringNoId = dispatchStringNoId + this.buildFilteredDispatch(cbMap, cbMapPostEvent, eventId);
            if (this.instanceOfDispatch) {
                dispatchStringNoId = dispatchStringNoId + String.format("%12s}%n", "");
                continue;
            }
            if (patternSwitch) continue;
            dispatchStringNoId = dispatchStringNoId + String.format("%16sbreak;%n", "");
            dispatchStringNoId = dispatchStringNoId + String.format("%12s}%n", "");
        }
        if (!this.instanceOfDispatch) {
            if (keySet.contains(Object.class) && !patternSwitch) {
                dispatchStringNoId = dispatchStringNoId + String.format("%12sdefault :{%n", "");
                dispatchStringNoId = dispatchStringNoId + String.format("%16shandleEvent(event);%n", "");
                dispatchStringNoId = dispatchStringNoId + String.format("%12s}%n", "");
            } else if (!keySet.contains(Object.class) && patternSwitch) {
                dispatchStringNoId = dispatchStringNoId + "default -> {}";
            }
            dispatchStringNoId = dispatchStringNoId + String.format("%8s}%n", "");
        }
        if (this.isInlineEventHandling) {
            dispatchStringNoId = dispatchStringNoId + String.format("%8safterEvent();%n", "");
        }
        this.eventDispatch = dispatchStringNoId + "\n";
        this.eventHandlers = this.eventHandlers + "  //EVENT DISPATCH - END\n";
    }

    private void generateExportMethodDispatcher() {
        Map<FilterDescription, List<CbMethodHandle>> eventDispatch = this.model.getDispatchMap().get(ExportFunctionMarker.class);
        Map<FilterDescription, List<CbMethodHandle>> postDispatch = this.model.getPostDispatchMap().get(ExportFunctionMarker.class);
        List<com.fluxtion.compiler.generation.model.Field> listenerFields = this.model.getNodeRegistrationListenerFields();
        String audit = listenerFields != null && !listenerFields.isEmpty() ? "beforeServiceCall(\"&&FUNC&&\");\nExportFunctionAuditEvent typedEvent = functionAudit;\n" : "beforeServiceCall(\"&&FUNC&&\");\n";
        if (eventDispatch != null) {
            this.eventHandlers = this.eventHandlers + "\n//EXPORTED SERVICE FUNCTIONS - START\n";
            ArrayList<FilterDescription> list = new ArrayList<FilterDescription>(eventDispatch.keySet());
            list.sort(Comparator.comparing(FilterDescription::getStringValue));
            list.forEach(f -> {
                String exportAudit = "";
                if (f.getExportFunction() != null) {
                    exportAudit = f.getExportFunction().toGenericString();
                }
                StringBuilder sb = new StringBuilder(f.getStringValue() + "{\n").append(audit.replace("&&FUNC&&", exportAudit));
                this.buildDispatchForCbMethodHandles((List)eventDispatch.get(f), sb);
                this.buildPostDispatchForCbMethodHandles((List)postDispatch.get(f), sb);
                sb.append("afterServiceCall();\n");
                sb.append(f.getStringValue().contains("void") ? "}\n" : "return true;}\n");
                this.eventHandlers = this.eventHandlers + sb.toString();
            });
            this.eventHandlers = this.eventHandlers + "//EXPORTED SERVICE FUNCTIONS - END\n";
        }
    }

    private String buildFilteredSwitch(Map<FilterDescription, List<CbMethodHandle>> cbMap, Map<FilterDescription, List<CbMethodHandle>> cbMapPostEvent, Class eventClass, boolean intFilter, boolean noFilter) {
        HashSet<FilterDescription> filterIdSet = new HashSet<FilterDescription>(cbMap.keySet());
        filterIdSet.addAll(cbMapPostEvent.keySet());
        ArrayList<FilterDescription> clazzList = new ArrayList<FilterDescription>(filterIdSet);
        clazzList.sort((o1, o2) -> {
            int ret = o1.value - o2.value;
            if (!o1.isIntFilter && !o2.isIntFilter) {
                ret = o1.stringValue.compareTo(o2.stringValue);
            } else if (o1.isIntFilter && !o2.isIntFilter) {
                ret = 1;
            } else if (!o1.isIntFilter && o2.isIntFilter) {
                ret = -1;
            }
            return ret;
        });
        this.switchF.delete(0, this.switchF.length());
        for (FilterDescription filterDescription : clazzList) {
            InvokerFilterTarget invokerTarget = new InvokerFilterTarget();
            invokerTarget.methodName = JavaGenHelper.generateFilteredDispatchMethodName(filterDescription);
            invokerTarget.filterDescription = filterDescription;
            invokerTarget.stringMapName = JavaGenHelper.generateFilteredDispatchMap(filterDescription);
            invokerTarget.intMapName = JavaGenHelper.generateFilteredDispatchMap(filterDescription);
            if (intFilter != filterDescription.isIntFilter && !noFilter) continue;
            boolean isDefaultFilter = filterDescription == FilterDescription.DEFAULT_FILTER;
            boolean isNoFilter = filterDescription == FilterDescription.NO_FILTER || filterDescription == FilterDescription.INVERSE_FILTER;
            String filterValue = intFilter ? filterDescription.value + "" : "\"" + filterDescription.stringValue + "\"";
            String filterVariable = filterDescription.variableName;
            List<CbMethodHandle> cbList = cbMap.get(filterDescription);
            if (noFilter && isDefaultFilter) {
                invokerTarget.filterDescription = new FilterDescription(eventClass);
                invokerTarget.methodName = JavaGenHelper.generateFilteredDispatchMethodName(invokerTarget.filterDescription);
                invokerTarget.stringMapName = JavaGenHelper.generateFilteredDispatchMap(invokerTarget.filterDescription);
                invokerTarget.intMapName = JavaGenHelper.generateFilteredDispatchMap(invokerTarget.filterDescription);
            } else {
                if (noFilter || isNoFilter || isDefaultFilter) continue;
                if (filterDescription.comment != null) {
                    this.switchF.append(s20).append("//").append(filterDescription.comment).append("\n");
                }
                if (filterVariable == null) {
                    this.switchF.append(s20).append("case(").append(filterValue).append("):\n");
                } else {
                    this.switchF.append(s20).append("case(").append(filterVariable).append("):\n");
                }
            }
            this.ct.delete(0, this.ct.length());
            this.buildDispatchForCbMethodHandles(cbList, this.ct);
            this.buildPostDispatchForCbMethodHandles(cbMapPostEvent.get(filterDescription), this.ct);
            invokerTarget.methodBody = this.ct.toString();
            if (!noFilter) {
                this.ct.append("                        afterEvent();\n");
                this.ct.append("                        return;\n");
            }
            this.switchF.append((CharSequence)this.ct);
        }
        return this.switchF.length() == 0 ? null : this.switchF.toString();
    }

    private void buildDispatchForCbMethodHandles(List<CbMethodHandle> cbList, StringBuilder stringBuilder) {
        if (cbList == null || cbList.isEmpty()) {
            return;
        }
        for (CbMethodHandle method : cbList) {
            DirtyFlag dirtyFlagForUpdateCb = this.model.getDirtyFlagForUpdateCb(method);
            String dirtyAssignment = "";
            if (dirtyFlagForUpdateCb != null) {
                dirtyAssignment = dirtyFlagForUpdateCb.alwaysDirty ? dirtyFlagForUpdateCb.name + " = true;\n" + s24 : dirtyFlagForUpdateCb.name + " = ";
            }
            Collection<DirtyFlag> nodeGuardConditions = this.model.getNodeGuardConditions(method);
            String OR = "";
            if (nodeGuardConditions.size() > 0) {
                stringBuilder.append(s24).append("if(guardCheck_" + method.getVariableName() + "()) {\n");
            }
            if (this.auditingInvocations) {
                if (method.isForkExecution()) {
                    stringBuilder.append(s24).append("auditInvocation(").append(method.forkVariableName()).append(", \"").append(method.variableName).append("\"").append(", \"").append(method.method.getName()).append("\"").append(", typedEvent").append(");\n");
                } else {
                    stringBuilder.append(s24).append("auditInvocation(").append(method.variableName).append(", \"").append(method.variableName).append("\"").append(", \"").append(method.method.getName()).append("\"").append(", typedEvent").append(");\n");
                }
            }
            if (method.parameterClass == null) {
                if (method.isForkExecution()) {
                    stringBuilder.append(method.forkVariableName() + ".onTrigger();\n");
                } else {
                    stringBuilder.append(s24).append(dirtyAssignment).append(method.getMethodTarget()).append(".").append(method.method.getName()).append("();\n");
                }
            } else if (method.isExportedHandler()) {
                StringJoiner sjInvoker = new StringJoiner(", ", "(", ");\n\t");
                for (int i = 0; i < method.getMethod().getParameterCount(); ++i) {
                    sjInvoker.add("arg" + i);
                }
                if (dirtyFlagForUpdateCb != null && method.getMethod().getReturnType() == Boolean.TYPE) {
                    dirtyAssignment = dirtyFlagForUpdateCb.name + " = ";
                }
                stringBuilder.append(s24).append(dirtyAssignment).append(method.getMethodTarget()).append(".").append(method.method.getName()).append(sjInvoker);
            } else {
                stringBuilder.append(s24).append(dirtyAssignment).append(method.getMethodTarget()).append(".").append(method.method.getName()).append("(typedEvent);\n");
            }
            if (dirtyFlagForUpdateCb != null && dirtyFlagForUpdateCb.requiresInvert) {
                stringBuilder.append(s24).append("not" + dirtyFlagForUpdateCb.name + " = !" + dirtyFlagForUpdateCb.name + ";\n");
            }
            Map<Object, List<CbMethodHandle>> listenerMethodMap = this.model.getParentUpdateListenerMethodMap();
            Object parent = method.instance;
            String parentVar = method.variableName;
            DirtyFlag parentFlag = this.model.getDirtyFieldMap().get(this.model.getFieldForInstance(parent));
            List<CbMethodHandle> updateListenerCbList = listenerMethodMap.get(parent);
            OnEventHandler handlerAnnotation = method.method.getAnnotation(OnEventHandler.class);
            if (handlerAnnotation != null && !handlerAnnotation.propagate()) continue;
            if (this.model.getForkedTriggerInstances().contains(parent)) {
                if (nodeGuardConditions.size() <= 0) continue;
                stringBuilder.append("                }\n");
                continue;
            }
            if (parentFlag != null && updateListenerCbList.size() > 0) {
                stringBuilder.append("                    if(").append(parentFlag.name).append(") {\n");
            }
            boolean unguarded = false;
            StringBuilder sbUnguarded = new StringBuilder();
            for (CbMethodHandle cbMethod : updateListenerCbList) {
                if (!cbMethod.method.getAnnotation(OnParentUpdate.class).guarded()) {
                    unguarded = true;
                    sbUnguarded.append(s20).append(cbMethod.variableName).append(".").append(cbMethod.method.getName()).append("(").append(parentVar).append(");\n");
                    continue;
                }
                stringBuilder.append(s24).append(cbMethod.variableName).append(".").append(cbMethod.method.getName()).append("(").append(parentVar).append(");\n");
            }
            if (parentFlag != null && updateListenerCbList.size() > 0) {
                stringBuilder.append(s20).append("}\n");
                if (unguarded) {
                    stringBuilder.append((CharSequence)sbUnguarded);
                }
            }
            if (nodeGuardConditions.size() <= 0) continue;
            stringBuilder.append("                }\n");
        }
    }

    private void buildPostDispatchForCbMethodHandles(List<CbMethodHandle> cbList, StringBuilder stringBuilder) {
        if (cbList == null || cbList.isEmpty()) {
            return;
        }
        stringBuilder.append("                //event stack unwind callbacks\n");
        for (CbMethodHandle method : cbList) {
            Collection<DirtyFlag> nodeGuardConditions = this.model.getNodeGuardConditions(method);
            String OR = "";
            if (!nodeGuardConditions.isEmpty()) {
                Set<Object> forkedTriggers = this.model.getForkedTriggerInstances();
                if (forkedTriggers.contains(method.getInstance())) {
                    stringBuilder.append(method.forkVariableName()).append(".afterEvent();\n");
                }
                stringBuilder.append("                        if(");
                for (DirtyFlag nodeGuardCondition : nodeGuardConditions) {
                    stringBuilder.append(OR).append(nodeGuardCondition.name);
                    OR = " | ";
                }
                stringBuilder.append(") {\n");
            }
            stringBuilder.append(s24).append(method.variableName).append(".").append(method.method.getName()).append("();\n");
            if (nodeGuardConditions.isEmpty()) continue;
            stringBuilder.append("                }\n");
        }
    }

    private String buildFilteredDispatch(Map<FilterDescription, List<CbMethodHandle>> cbMap, Map<FilterDescription, List<CbMethodHandle>> cbMapPostEvent, Class eventClass) {
        String dispatchString = "";
        String eventHandlerString = "";
        String intFilterSwitch = this.buildFilteredSwitch(cbMap, cbMapPostEvent, eventClass, true, false);
        String stringFilterSwitch = this.buildFilteredSwitch(cbMap, cbMapPostEvent, eventClass, false, false);
        String noFilterDispatch = this.buildFilteredSwitch(cbMap, cbMapPostEvent, eventClass, false, true);
        if (!this.isInlineEventHandling) {
            dispatchString = dispatchString + String.format("%16shandleEvent(typedEvent);%n", "");
            eventHandlerString = eventHandlerString + String.format("%n%4spublic void handleEvent(%s typedEvent) {%n", "", this.getClassName(eventClass.getCanonicalName()));
            eventHandlerString = eventHandlerString + this.eventAuditDispatch;
            if (intFilterSwitch != null) {
                eventHandlerString = eventHandlerString + String.format("%8sswitch (typedEvent.filterId()) {%n", "");
                eventHandlerString = eventHandlerString + intFilterSwitch;
                eventHandlerString = eventHandlerString + String.format("%8s}%n", "");
            }
            if (stringFilterSwitch != null) {
                eventHandlerString = eventHandlerString + String.format("%8sswitch (typedEvent.filterString()) {%n", "");
                eventHandlerString = eventHandlerString + stringFilterSwitch;
                eventHandlerString = eventHandlerString + String.format("%8s}%n", "");
            }
            if (noFilterDispatch != null) {
                eventHandlerString = eventHandlerString + "        //Default, no filter methods\n";
                eventHandlerString = eventHandlerString + noFilterDispatch;
            }
            eventHandlerString = eventHandlerString + String.format("%8safterEvent();%n", "");
            eventHandlerString = eventHandlerString + String.format("%4s}%n", "");
        } else {
            dispatchString = dispatchString + this.eventAuditDispatch;
            if (intFilterSwitch != null) {
                dispatchString = dispatchString + String.format("%16sswitch (typedEvent.filterId()) {%n", "");
                dispatchString = dispatchString + intFilterSwitch;
                dispatchString = dispatchString + String.format("%16s}%n", "");
            }
            if (stringFilterSwitch != null) {
                dispatchString = dispatchString + String.format("%16sswitch (typedEvent.filterString()) {%n", "");
                dispatchString = dispatchString + stringFilterSwitch;
                dispatchString = dispatchString + String.format("%16s}%n", "");
            }
            if (noFilterDispatch != null) {
                dispatchString = dispatchString + noFilterDispatch;
            }
        }
        this.eventHandlers = this.eventHandlers + eventHandlerString;
        return dispatchString;
    }

    private void buildMemberAssignments() throws Exception {
        List<com.fluxtion.compiler.generation.model.Field> nodeFields = this.model.getNodeFields();
        if (this.assignPrivateMembers) {
            this.nodeMemberAssignmentList.add("    final net.vidageek.mirror.dsl.Mirror assigner = new net.vidageek.mirror.dsl.Mirror();");
        }
        for (com.fluxtion.compiler.generation.model.Field field : nodeFields) {
            Object object = field.instance;
            String varName = field.name;
            this.model.beanProperties(object).stream().forEach(s -> this.nodeMemberAssignmentList.add(varName + "." + s + ";"));
            Object[] fields = object.getClass().getFields();
            MirrorList fields1 = new Mirror().on(object.getClass()).reflectAll().fields();
            for (Object instanceField : fields = (Field[])fields1.toArray(fields)) {
                String joiner;
                Collection list;
                boolean useRefelction = false;
                if ((((Field)instanceField).getModifiers() & 0x88) != 0 || !this.assignPrivateMembers && (((Field)instanceField).getModifiers() & 0x16) != 0 || !this.assignPrivateMembers && ((Field)instanceField).getModifiers() == 0) continue;
                if (this.assignPrivateMembers && !Modifier.isPublic(((Field)instanceField).getModifiers())) {
                    useRefelction = true;
                }
                ((Field)instanceField).setAccessible(true);
                if (((Field)instanceField).getType().isArray()) {
                    String joiner2;
                    String value;
                    int i;
                    Object array = ((Field)instanceField).get(object);
                    if (array == null) continue;
                    int length = Array.getLength(array);
                    String className = this.getClassName(((Field)instanceField).getType().getComponentType().getCanonicalName());
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4s%s[] %s_%s = new %s[%d];", "", className, varName, ((Field)instanceField).getName(), className, length));
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue(%s_%s);", "", varName, ((Field)instanceField).getName(), varName, ((Field)instanceField).getName()));
                    } else {
                        this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = new %s[%d];", "", varName, ((Field)instanceField).getName(), className, length));
                    }
                    if (((Field)instanceField).getType().getComponentType().isPrimitive()) {
                        for (i = 0; i < length; ++i) {
                            value = Array.get(array, i).toString();
                            joiner2 = useRefelction ? "_" : ".";
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s[%d] = %s;", "", varName, joiner2, ((Field)instanceField).getName(), i, value));
                        }
                        continue;
                    }
                    if (((Field)instanceField).getType().getComponentType().equals(String.class)) {
                        for (i = 0; i < length; ++i) {
                            value = StringEscapeUtils.escapeJava((String)Array.get(array, i).toString());
                            joiner2 = useRefelction ? "_" : ".";
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s[%d] = \"%s\";", "", varName, joiner2, ((Field)instanceField).getName(), i, value));
                        }
                        continue;
                    }
                    for (i = 0; i < length; ++i) {
                        String joiner3;
                        Object refField = Array.get(array, i);
                        com.fluxtion.compiler.generation.model.Field nodeReference = this.model.getFieldForInstance(refField);
                        String string = joiner3 = useRefelction ? "_" : ".";
                        if (nodeReference == null) continue;
                        this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s[%d] = %s;", "", varName, joiner3, ((Field)instanceField).getName(), i, nodeReference.name));
                    }
                    continue;
                }
                if (((Field)instanceField).get(object) == null) continue;
                com.fluxtion.compiler.generation.model.Field nodeReference = this.model.getFieldForInstance(((Field)instanceField).get(object));
                if (((Field)instanceField).getType().equals(Character.TYPE)) {
                    String value = ((Field)instanceField).get(object).toString();
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue('%s');", "", varName, ((Field)instanceField).getName(), value));
                        continue;
                    }
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = '%s';", "", varName, ((Field)instanceField).getName(), value));
                    continue;
                }
                if (((Field)instanceField).getType().isPrimitive()) {
                    String value = ((Field)instanceField).get(object).toString();
                    value = value.equalsIgnoreCase("NaN") ? "Double.NaN" : value;
                    value = "(" + ((Field)instanceField).getType() + ")" + value;
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue(%s);", "", varName, ((Field)instanceField).getName(), value));
                        continue;
                    }
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = %s;", "", varName, ((Field)instanceField).getName(), value));
                    continue;
                }
                if (((Field)instanceField).getType().isEnum()) {
                    String value = ((Field)instanceField).get(object).toString();
                    String enumClass = ((Field)instanceField).getType().getCanonicalName();
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue(%s.%s);", "", varName, ((Field)instanceField).getName(), enumClass, value));
                        continue;
                    }
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = %s.%s;", "", varName, ((Field)instanceField).getName(), enumClass, value));
                    continue;
                }
                if (nodeReference != null) {
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue(%s);", "", varName, ((Field)instanceField).getName(), nodeReference.name));
                        continue;
                    }
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = %s;", "", varName, ((Field)instanceField).getName(), nodeReference.name));
                    continue;
                }
                if (((Field)instanceField).getType().equals(String.class)) {
                    String value = StringEscapeUtils.escapeJava((String)((Field)instanceField).get(object).toString());
                    if (useRefelction) {
                        this.nodeMemberAssignmentList.add(String.format("%4sassigner.on(%s).set().field(\"%s\").withValue(\"%s\");", "", varName, ((Field)instanceField).getName(), value));
                        continue;
                    }
                    this.nodeMemberAssignmentList.add(String.format("%4s%s.%s = \"%s\";", "", varName, ((Field)instanceField).getName(), value));
                    continue;
                }
                if (!Collection.class.isAssignableFrom(((Field)instanceField).getType()) || (list = (Collection)((Field)instanceField).get(object)) == null) continue;
                String string = joiner = useRefelction ? "_" : ".";
                if (useRefelction) {
                    String className = this.getClassName(Collection.class.getCanonicalName());
                    this.nodeMemberAssignmentList.add(String.format("%4sCollection %s_%s = (Collection)assigner.on(%s).get().field(\"%s\");", "", varName, ((Field)instanceField).getName(), varName, ((Field)instanceField).getName()));
                }
                for (Object parent : list) {
                    if (((Field)instanceField).getGenericType() instanceof ParameterizedType) {
                        String value;
                        com.fluxtion.compiler.generation.model.Field nodeParentReference;
                        ParameterizedType integerListType = (ParameterizedType)((Field)instanceField).getGenericType();
                        Class classType = Object.class;
                        if (integerListType.getActualTypeArguments()[0] instanceof Class) {
                            classType = (Class)integerListType.getActualTypeArguments()[0];
                        }
                        if ((nodeParentReference = this.model.getFieldForInstance(parent)) != null) {
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add(%s);", "", varName, joiner, ((Field)instanceField).getName(), nodeParentReference.name));
                            continue;
                        }
                        if (classType == String.class) {
                            value = StringEscapeUtils.escapeJava((String)parent.toString());
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add(\"%s\");", "", varName, joiner, ((Field)instanceField).getName(), value));
                            continue;
                        }
                        if (classType == Character.class) {
                            value = parent.toString();
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add('%s');", "", varName, joiner, ((Field)instanceField).getName(), parent));
                            continue;
                        }
                        if (Number.class.isAssignableFrom(classType)) {
                            value = parent.toString();
                            String cast = JavaGenHelper.mapWrapperToPrimitive(classType).getSimpleName();
                            this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add((%s)%s);", "", varName, joiner, ((Field)instanceField).getName(), cast, value));
                            continue;
                        }
                        if (!classType.isEnum()) continue;
                        String enumClass = this.getClassName(classType.getCanonicalName());
                        String value2 = parent.toString();
                        this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add(%s.%s);", "", varName, joiner, ((Field)instanceField).getName(), enumClass, value2));
                        continue;
                    }
                    com.fluxtion.compiler.generation.model.Field nodeParentReference = this.model.getFieldForInstance(parent);
                    if (nodeParentReference == null) continue;
                    this.nodeMemberAssignmentList.add(String.format("%4s%s%s%s.add(%s);", "", varName, joiner, ((Field)instanceField).getName(), nodeParentReference.name));
                }
            }
        }
    }

    public ArrayList<String> getInitialiseMethodList() {
        return this.initialiseMethodList;
    }

    public String getInitialiseMethods() {
        return this.initialiseMethods;
    }

    public String getStartMethods() {
        return this.startMethods;
    }

    public String getStopMethods() {
        return this.stopMethods;
    }

    public ArrayList<String> getBatchEndMethodList() {
        return this.batchEndMethodList;
    }

    public ArrayList<String> getBatchPauseMethodList() {
        return this.batchPauseMethodList;
    }

    public ArrayList<String> getEventEndMethodList() {
        return this.eventEndMethodList;
    }

    public ArrayList<String> getTearDownMethodList() {
        return this.tearDownMethodList;
    }

    public ArrayList<String> getNodeDeclarationList() {
        return this.nodeDeclarationList;
    }

    public ArrayList<String> getNodeMemberAssignmentList() {
        return this.nodeMemberAssignmentList;
    }

    public ArrayList<String> getPublicNodeList() {
        return this.publicNodeIdentifierList;
    }

    public String getNodeMemberAssignments() {
        return this.nodeMemberAssignments;
    }

    public String getFilterConstantDeclarations() {
        return this.filterConstantDeclarations;
    }

    public String getAdditionalInterfaces() {
        return this.additionalInterfaces == null ? "" : this.additionalInterfaces;
    }

    public String getEventDispatch() {
        return this.eventDispatch;
    }

    public String getEventHandlers() {
        return this.eventHandlers;
    }

    public String getExportedMethods() {
        return this.exportedMethods;
    }

    public String getNodeDeclarations() {
        return this.nodeDeclarations;
    }

    public String getDirtyFlagDeclarations() {
        return this.dirtyFlagDeclarations;
    }

    public String getResetDirtyFlags() {
        return this.resetDirtyFlags;
    }

    public String getDirtyFlagLookup() {
        return this.dirtyFlagLookup;
    }

    public String getDirtyFlagUpdate() {
        return this.dirtyFlagUpdate;
    }

    public String getGuardCheckMethods() {
        return this.guardCheckMethods;
    }

    public int getDirtyFlagCount() {
        return this.model.getDirtyFieldMap() == null ? 32 : this.model.getDirtyFieldMap().size();
    }

    public String getBatchEndMethods() {
        return this.batchEndMethods;
    }

    public String getEventEndMethods() {
        return this.eventEndMethods;
    }

    public String getBatchPauseMethods() {
        return this.batchPauseMethods;
    }

    public String getTearDownMethods() {
        return this.tearDownMethods;
    }

    public String getJavaDocEventClassList() {
        return this.javaDocEventClassList;
    }

    public String getForkDeclarations() {
        return this.forkDeclarations;
    }

    public String getResetForkTasks() {
        return this.resetForkTasks;
    }

    public String getImports() {
        ArrayList<String> dedupeList = new ArrayList<String>(new HashSet<String>(this.importList));
        Collections.sort(dedupeList);
        StringBuilder sb = new StringBuilder(2048);
        dedupeList.stream().forEach(s -> sb.append("import ").append((String)s).append(";\n"));
        return sb.toString();
    }

    public String toString() {
        return "SepJavaSourceModel{\ninitialiseMethods=" + this.initialiseMethodList + ", \nbatchEndMethods=" + this.batchEndMethodList + ", \nbatchPauseMethods=" + this.batchPauseMethodList + ", \neventEndMethods=" + this.eventEndMethodList + ", \ntearDownMethods=" + this.tearDownMethodList + ", \nnodeDeclarations=" + this.nodeDeclarationList + ", \neventDispatch=" + this.eventDispatch + ", \nnodeMemberAssignments=" + this.nodeMemberAssignmentList + ", \nmodel=" + this.model + "\n}";
    }

    private void buildNodeRegistrationListeners() {
        List<com.fluxtion.compiler.generation.model.Field> nodeFields = this.model.getNodeFields();
        this.auditingEvent = false;
        this.eventAuditDispatch = "";
        List<com.fluxtion.compiler.generation.model.Field> listenerFields = this.model.getNodeRegistrationListenerFields();
        if (listenerFields == null || listenerFields.isEmpty()) {
            return;
        }
        this.auditingEvent = true;
        this.auditingInvocations = false;
        String eventClassName = this.getClassTypeName(Event.class);
        this.importList.add(Event.class.getCanonicalName());
        this.importList.add(EventProcessorContext.class.getCanonicalName());
        this.importList.add(MutableEventProcessorContext.class.getCanonicalName());
        this.importList.add(Map.class.getCanonicalName());
        this.importList.add(EventFeed.class.getCanonicalName());
        this.importList.add(EventLogManager.class.getCanonicalName());
        this.importList.add(ExportFunctionAuditEvent.class.getCanonicalName());
        this.auditMethodString = "";
        String auditObjet = "private void auditEvent(Object typedEvent){\n";
        String auditEvent = String.format("private void auditEvent(%s typedEvent){\n", eventClassName);
        String auditInvocation = "private void auditInvocation(Object node, String nodeName, String methodName, Object typedEvent){\n";
        String initialiseAuditor = "private void initialiseAuditor(" + this.getClassName(Auditor.class.getName()) + " auditor){\n\tauditor.init();\n";
        for (com.fluxtion.compiler.generation.model.Field nodeField : nodeFields) {
            String nodeName = nodeField.name;
            if (listenerFields.stream().anyMatch(t -> t.name.equals(nodeName))) continue;
            initialiseAuditor = initialiseAuditor + String.format("auditor.nodeRegistered(%s, \"%s\");", nodeName, nodeName);
        }
        initialiseAuditor = initialiseAuditor + this.model.getTriggerOnlyCallBacks().stream().filter(CbMethodHandle::isForkExecution).map(CbMethodHandle::forkVariableName).map(s -> String.format("auditor.nodeRegistered(%s, \"%s\");", s, s)).collect(Collectors.joining());
        this.eventAuditDispatch = "";
        this.nodeMemberAssignmentList.add("\t//node auditors");
        for (com.fluxtion.compiler.generation.model.Field listenerField : listenerFields) {
            String listenerName = listenerField.name;
            this.nodeMemberAssignmentList.add("initialiseAuditor(" + listenerField.name + ");");
            this.tearDownMethodList.add(0, String.format("%8s%s.tearDown();", "", listenerName));
            this.eventEndMethodList.add(String.format("%8s%s.processingComplete();", "", listenerName));
            this.eventAuditDispatch = this.eventAuditDispatch + String.format("%8s%s.eventReceived(typedEvent);%n", "", listenerName);
            if (!((Auditor)listenerField.instance).auditInvocations()) continue;
            auditInvocation = auditInvocation + String.format("%8s%s.nodeInvoked(node, nodeName, methodName, typedEvent);%n", "", listenerName);
            this.auditingInvocations = true;
        }
        auditEvent = auditEvent + this.eventAuditDispatch + "}\n";
        auditObjet = auditObjet + this.eventAuditDispatch + "}\n";
        if (this.auditingInvocations) {
            auditEvent = auditEvent + auditInvocation + "}\n";
        }
        initialiseAuditor = initialiseAuditor + "}\n";
        this.eventAuditDispatch = "auditEvent(typedEvent);\n";
        this.auditMethodString = this.auditMethodString + auditObjet;
        this.auditMethodString = this.auditMethodString + auditEvent;
        this.auditMethodString = this.auditMethodString + initialiseAuditor;
    }

    private void addDefaultImports() {
        this.model.getImportClasses().stream().map(Class::getCanonicalName).peek(Objects::toString).sorted().forEach(this::getClassName);
    }

    public void additionalInterfacesToImplement(Set<Class<?>> interfacesToImplement) {
        if (!interfacesToImplement.isEmpty()) {
            this.additionalInterfaces = interfacesToImplement.stream().map(this::getClassTypeName).sorted().collect(Collectors.joining(", ", ", ", ""));
        }
    }
}

