/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.util;

import com.fluxtion.compiler.generation.model.CbMethodHandle;
import com.fluxtion.compiler.generation.model.ExportFunctionData;
import com.fluxtion.compiler.generation.model.SimpleEventProcessorModel;
import com.fluxtion.compiler.generation.util.NaturalOrderComparator;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.vidageek.mirror.dsl.Mirror;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClassUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(ClassUtils.class);

    public static CbMethodHandle findBestParentCB(Object parent, Collection<CbMethodHandle> cbs) {
        Set classList = cbs.stream().filter(cb -> cb.method.getParameterTypes()[0].isAssignableFrom(parent.getClass())).map(cb -> cb.method.getParameterTypes()[0]).collect(Collectors.toSet());
        if (classList.isEmpty()) {
            return null;
        }
        Optional bestMatch = classList.stream().sorted((c1, c2) -> {
            if (c1 == c2) {
                return 0;
            }
            if (c1.isAssignableFrom((Class<?>)c2)) {
                return 1;
            }
            return -1;
        }).findFirst();
        Optional<CbMethodHandle> findFirst = cbs.stream().filter(cb -> cb.method.getParameterTypes()[0] == bestMatch.orElse(null)).findFirst();
        return findFirst.orElse(null);
    }

    public static boolean isPropertyTransient(PropertyDescriptor property, com.fluxtion.compiler.generation.model.Field field) throws SecurityException {
        Class<?> fieldClass = field.instance.getClass();
        String name = property.getName();
        Set allFields = ReflectionUtils.getAllFields(fieldClass, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)name)});
        boolean isTransient = true;
        if (!allFields.isEmpty()) {
            Field fieldOfProperty = (Field)allFields.iterator().next();
            fieldOfProperty.setAccessible(true);
            isTransient = Modifier.isTransient(fieldOfProperty.getModifiers());
        }
        return isTransient;
    }

    public static <T> T getField(String name, Object instance) {
        return (T)new Mirror().on(instance).get().field(name);
    }

    public static Field getReflectField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return ClassUtils.getReflectField(superClass, fieldName);
        }
    }

    public static List<Class<?>> sortClassHierarchy(Set<Class<?>> classSet) {
        ArrayList clazzListAlpha = new ArrayList(classSet);
        ArrayList clazzSorted = new ArrayList();
        clazzListAlpha.sort(new NaturalOrderComparator());
        clazzListAlpha.forEach((Consumer<Class<?>>)((Consumer<Class>)clazz -> {
            boolean added = false;
            for (int i = 0; i < clazzSorted.size(); ++i) {
                Class sortedClazz = (Class)clazzSorted.get(i);
                if (!sortedClazz.isAssignableFrom((Class<?>)clazz)) continue;
                clazzSorted.add(i, (Class<?>)clazz);
                added = true;
                break;
            }
            if (!added) {
                clazzSorted.add((Class<?>)clazz);
            }
        }));
        return clazzSorted;
    }

    public static String wrapExportedFunctionCall(Method delegateMethod, String exportedMethodName, String instanceName) {
        LongAdder argNumber = new LongAdder();
        StringBuilder signature = new StringBuilder("public void " + exportedMethodName);
        signature.append('(');
        StringJoiner sj = new StringJoiner(", ");
        Type[] params = delegateMethod.getGenericParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            String param = params[j].getTypeName();
            if (delegateMethod.isVarArgs() && j == params.length - 1) {
                param = param.replaceFirst("\\[\\]$", "...");
            }
            param = param + " arg" + argNumber.intValue();
            sj.add(param);
            argNumber.increment();
        }
        signature.append(sj.toString());
        signature.append(", String identifer");
        signature.append("){");
        signature.append("try {\n            ExportingNode instance = getNodeById(identifer);");
        signature.append("\n  instance." + delegateMethod.getName() + "(");
        StringJoiner sjInvoker = new StringJoiner(", ");
        for (int i = 0; i < argNumber.intValue(); ++i) {
            sjInvoker.add("arg" + i);
        }
        signature.append(sjInvoker.toString());
        signature.append(");\n");
        signature.append("} catch (NoSuchFieldException e) {\n            throw new RuntimeException(e);\n        }    }");
        return signature.toString();
    }

    public static String wrapExportedFunctionCall(Method exportedMethod, List<CbMethodHandle> callBackList, SimpleEventProcessorModel model) {
        String exportedMethodName = exportedMethod.getName();
        LongAdder argNumber = new LongAdder();
        Method delegateMethod = callBackList.get(0).getMethod();
        StringBuilder signature = new StringBuilder("public void " + exportedMethodName);
        signature.append('(');
        StringJoiner sj = new StringJoiner(", ");
        Type[] params = delegateMethod.getGenericParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            String param = params[j].getTypeName();
            if (delegateMethod.isVarArgs() && j == params.length - 1) {
                param = param.replaceFirst("\\[\\]$", "...");
            }
            param = param + " arg" + argNumber.intValue();
            sj.add(param);
            argNumber.increment();
        }
        signature.append(sj);
        signature.append("){");
        StringJoiner sjInvoker = new StringJoiner(", ", "(", "));");
        for (int i = 0; i < argNumber.intValue(); ++i) {
            sjInvoker.add("arg" + i);
        }
        callBackList.forEach(cb -> signature.append("setDirty(").append(cb.getVariableName()).append(", ").append(cb.getVariableName()).append(".").append(cb.getMethod().getName()).append(sjInvoker));
        signature.append("  triggerCalculation();\n  }");
        return signature.toString();
    }

    public static String wrapExportedFunctionCall(Method exportedMethod, ExportFunctionData exportFunctionData, boolean onEventDispatch) {
        String exportedMethodName = exportedMethod.getName();
        LongAdder argNumber = new LongAdder();
        List<CbMethodHandle> callBackList = exportFunctionData.getFunctionCallBackList();
        Method delegateMethod = callBackList.get(0).getMethod();
        boolean booleanReturn = exportFunctionData.isBooleanReturn();
        StringBuilder signature = booleanReturn ? new StringBuilder("public boolean " + exportedMethodName) : new StringBuilder("public void " + exportedMethodName);
        signature.append('(');
        StringJoiner sj = new StringJoiner(", ");
        Type[] params = delegateMethod.getGenericParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            String param = params[j].getTypeName().replace("$", ".").replace("java.lang.", "");
            if (delegateMethod.isVarArgs() && j == params.length - 1) {
                param = param.replaceFirst("\\[\\]$", "...");
            }
            param = param + " arg" + argNumber.intValue();
            sj.add(param);
            argNumber.increment();
        }
        signature.append(sj);
        signature.append("){\n\t");
        signature.append("processor.auditNewEvent( functionAudit.setFunctionDescription(\"" + exportFunctionData.getExportedmethod().toGenericString() + "\"));\n    if(processor.buffering){\n      processor.triggerCalculation();\n    }\n    processor.processing = false;\n\t");
        StringJoiner sjInvoker = new StringJoiner(", ", "(", "));\n\t");
        for (int i = 0; i < argNumber.intValue(); ++i) {
            sjInvoker.add("arg" + i);
        }
        callBackList.forEach(cb -> {
            String variableName = cb.getVariableName();
            String methodName = cb.getMethod().getName();
            signature.append("processor.nodeInvoked(" + variableName + ", \"" + variableName + "\", \"" + methodName + "\", functionAudit);\n");
            if (cb.isNoPropagateFunction()) {
                signature.append(variableName).append(".").append(methodName).append(sjInvoker.toString().replace("));", ");"));
            } else if (cb.getMethod().getReturnType() == Void.TYPE) {
                signature.append(variableName).append(".").append(methodName).append(sjInvoker.toString().replace("));", ");"));
                signature.append("processor.setDirty(").append(variableName).append(", true);\n\t");
            } else {
                signature.append("processor.setDirty(").append(variableName).append(", ").append(variableName).append(".").append(methodName).append(sjInvoker);
            }
        });
        signature.append("processor.triggerCalculation();\n    processor.dispatchQueuedCallbacks();\n    processor.processing = false;\n");
        if (booleanReturn) {
            signature.append("    return true;\n");
        }
        signature.append("}");
        return signature.toString();
    }

    public static List<AnnotatedType> getAllAnnotatedAnnotationTypes(Class<?> clazz, Class<? extends Annotation> annotation) {
        ArrayList<AnnotatedType> interfaceList = new ArrayList<AnnotatedType>();
        while (clazz != null) {
            Arrays.asList(clazz.getAnnotatedInterfaces()).stream().filter(a -> a.isAnnotationPresent(annotation)).forEach(interfaceList::add);
            clazz = clazz.getSuperclass();
        }
        return interfaceList;
    }

    public static List<Type> getAllAnnotatedTypes(Class<?> clazz, Class<? extends Annotation> annotation) {
        return ClassUtils.getAllAnnotatedAnnotationTypes(clazz, annotation).stream().map(AnnotatedType::getType).collect(Collectors.toList());
    }
}

