/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.generation.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SuperMethodAnnotationScanner {
    private static final int ACCESS_MODIFIERS = 7;
    private static final List<Integer> ACCESS_ORDER = Arrays.asList(2, 0, 4, 1);

    private SuperMethodAnnotationScanner() {
    }

    public static <A extends Annotation> A getAnnotation(Method m, Class<A> t) {
        List<A> list = SuperMethodAnnotationScanner.getAnnotations(m, t);
        return (A)(list.isEmpty() ? null : (Annotation)list.get(0));
    }

    public static <A extends Annotation> List<A> getAnnotations(Method m, Class<A> t) {
        Class<?> decl;
        ArrayList list = new ArrayList();
        Collections.addAll(list, m.getAnnotationsByType(t));
        Class<?> supr = decl = m.getDeclaringClass();
        while ((supr = supr.getSuperclass()) != null) {
            SuperMethodAnnotationScanner.addAnnotations(list, m, t, supr);
        }
        for (Class<?> face : SuperMethodAnnotationScanner.getAllInterfaces(decl)) {
            SuperMethodAnnotationScanner.addAnnotations(list, m, t, face);
        }
        return list;
    }

    public static <A extends Annotation> boolean annotationInHierarchy(Method m, Class<A> t) {
        return SuperMethodAnnotationScanner.getAnnotations(m, t).size() > 0;
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> c) {
        LinkedHashSet set = new LinkedHashSet();
        do {
            SuperMethodAnnotationScanner.addAllInterfaces(set, c);
        } while ((c = c.getSuperclass()) != null);
        return set;
    }

    private static void addAllInterfaces(Set<Class<?>> set, Class<?> c) {
        for (Class<?> i : c.getInterfaces()) {
            if (!set.add(i)) continue;
            SuperMethodAnnotationScanner.addAllInterfaces(set, i);
        }
    }

    private static <A extends Annotation> void addAnnotations(List<A> list, Method m, Class<A> t, Class<?> decl) {
        try {
            Method n = decl.getDeclaredMethod(m.getName(), m.getParameterTypes());
            if (SuperMethodAnnotationScanner.overrides(m, n)) {
                Collections.addAll(list, n.getAnnotationsByType(t));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static boolean overrides(Method a, Method b) {
        Class<?>[] paramsB;
        Class<?> classB;
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        Class<?> classA = a.getDeclaringClass();
        if (classA.equals(classB = b.getDeclaringClass())) {
            return false;
        }
        if (!classB.isAssignableFrom(classA)) {
            return false;
        }
        int modsA = a.getModifiers();
        int modsB = b.getModifiers();
        if (Modifier.isPrivate(modsA) || Modifier.isPrivate(modsB)) {
            return false;
        }
        if (Modifier.isStatic(modsA) || Modifier.isStatic(modsB)) {
            return false;
        }
        if (Modifier.isFinal(modsB)) {
            return false;
        }
        if (SuperMethodAnnotationScanner.compareAccess(modsA, modsB) < 0) {
            return false;
        }
        if ((SuperMethodAnnotationScanner.isPackageAccess(modsA) || SuperMethodAnnotationScanner.isPackageAccess(modsB)) && !Objects.equals(classA.getPackage(), classB.getPackage())) {
            return false;
        }
        if (!b.getReturnType().isAssignableFrom(a.getReturnType())) {
            return false;
        }
        Class<?>[] paramsA = a.getParameterTypes();
        if (paramsA.length != (paramsB = b.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < paramsA.length; ++i) {
            if (paramsA[i].equals(paramsB[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isPackageAccess(int mods) {
        return (mods & 7) == 0;
    }

    public static int compareAccess(int lhs, int rhs) {
        return Integer.compare(ACCESS_ORDER.indexOf(lhs & 7), ACCESS_ORDER.indexOf(rhs & 7));
    }
}

