/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.replay;

import com.fluxtion.compiler.replay.NullWriter;
import com.fluxtion.compiler.replay.ReplayRecord;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.audit.Auditor;
import com.fluxtion.runtime.event.Event;
import com.fluxtion.runtime.time.Clock;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

public class YamlReplayRecordWriter
implements Auditor {
    public static final String DEFAULT_NAME = "yamlReplayRecordWriter";
    @Inject
    private final Clock clock;
    private final transient Yaml yaml = new Yaml();
    private final transient ReplayRecord replayRecord = new ReplayRecord();
    private transient Writer targetWriter = NullWriter.NULL_WRITER;
    private Set<Class<?>> classWhiteList = new HashSet();
    private Set<Class<?>> classBlackList = new HashSet();

    public YamlReplayRecordWriter(Clock clock) {
        this.clock = clock;
    }

    public YamlReplayRecordWriter() {
        this(null);
    }

    public Set<Class<?>> getClassWhiteList() {
        return this.classWhiteList;
    }

    public void setClassWhiteList(Set<Class<?>> classWhiteList) {
        this.classWhiteList.clear();
        this.classWhiteList.addAll(classWhiteList);
    }

    public YamlReplayRecordWriter classWhiteList(Class<?> ... classes) {
        this.setClassWhiteList(new HashSet(Arrays.asList(classes)));
        return this;
    }

    public Set<Class<?>> getClassBlackList() {
        return this.classBlackList;
    }

    public void setClassBlackList(Set<Class<?>> classBlackList) {
        this.classBlackList.clear();
        this.classBlackList.addAll(classBlackList);
    }

    public YamlReplayRecordWriter classBlackList(Class<?> ... classes) {
        this.setClassBlackList(new HashSet(Arrays.asList(classes)));
        return this;
    }

    public void nodeRegistered(Object node, String nodeName) {
    }

    public void eventReceived(Event event) {
        this.eventReceived((Object)event);
    }

    public void eventReceived(Object event) {
        boolean whitePass = this.classWhiteList.isEmpty() || this.classWhiteList.contains(event.getClass());
        boolean blackPass = !this.classBlackList.contains(event.getClass());
        if (whitePass & blackPass & this.targetWriter != NullWriter.NULL_WRITER) {
            this.replayRecord.setEvent(event);
            this.replayRecord.setWallClockTime(this.clock.getWallClockTime());
            this.targetWriter.append("---\n");
            this.yaml.dump((Object)this.replayRecord, this.targetWriter);
        }
    }

    public Writer getTargetWriter() {
        return this.targetWriter;
    }

    public void setTargetWriter(Writer targetWriter) {
        this.targetWriter = targetWriter;
    }
}

