/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.replay;

import com.fluxtion.compiler.replay.ReplayRecord;
import com.fluxtion.compiler.validation.BaseEventProcessorRowBasedTest;
import com.fluxtion.runtime.EventProcessor;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicLong;

public class YamlReplayRunner {
    private final Reader yamlReplayRecordSource;
    private final EventProcessor<?> eventProcessor;
    private long minimumTime = Long.MIN_VALUE;
    private long maximumTime = Long.MAX_VALUE;

    private YamlReplayRunner(Reader yamlReplayRecordSource, EventProcessor<?> eventProcessor) {
        this.yamlReplayRecordSource = yamlReplayRecordSource;
        this.eventProcessor = eventProcessor;
    }

    public static YamlReplayRunner newSession(Reader yamlReplayRecordSource, EventProcessor<?> eventProcessor) {
        return new YamlReplayRunner(yamlReplayRecordSource, eventProcessor);
    }

    public YamlReplayRunner callInit() {
        this.eventProcessor.init();
        return this;
    }

    public YamlReplayRunner callStart() {
        this.eventProcessor.start();
        return this;
    }

    public YamlReplayRunner afterTime(long startTime) {
        return this.betweenTimes(startTime, Long.MAX_VALUE);
    }

    public YamlReplayRunner beforeTime(long stopTime) {
        return this.betweenTimes(Long.MIN_VALUE, stopTime);
    }

    public YamlReplayRunner betweenTimes(long startTime, long stopTime) {
        this.minimumTime = startTime;
        this.maximumTime = stopTime;
        return this;
    }

    public void runReplay() {
        AtomicLong timeSupplier = new AtomicLong();
        this.eventProcessor.setClockStrategy(timeSupplier::get);
        BaseEventProcessorRowBasedTest.yamlToStream(this.yamlReplayRecordSource, ReplayRecord.class).forEachOrdered(t -> {
            long wallClockTime = t.getWallClockTime();
            if (wallClockTime < this.maximumTime && wallClockTime > this.minimumTime) {
                timeSupplier.set(wallClockTime);
                this.eventProcessor.onEvent(t.getEvent());
            }
        });
    }
}

