/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.validation;

import com.fluxtion.compiler.validation.EventProcessorValidatorDriver;
import com.fluxtion.compiler.validation.SinkValidatorDriver;
import com.fluxtion.compiler.validation.TestRowValidationRecord;
import com.fluxtion.extension.csvcompiler.RowMarshaller;
import com.fluxtion.runtime.EventProcessor;
import java.io.Reader;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.extensions.compactnotation.CompactConstructor;

public class BaseEventProcessorRowBasedTest {
    protected boolean useSyntheticTime = false;

    protected void useSyntheticTime() {
        this.useSyntheticTime = true;
    }

    protected void useWallClockTime() {
        this.useSyntheticTime = false;
    }

    protected <O, S extends Supplier<TestRowValidationRecord<O>>> void validateSinkOutput(EventProcessor processor, String sinkId, Class<S> validationRowClass, String data) {
        this.validateSinkOutput(processor, sinkId, validationRowClass, null, data);
    }

    protected <O, S extends Supplier<TestRowValidationRecord<O>>> void validateSinkOutput(EventProcessor processor, String sinkId, Class<S> validationRowClass, BiPredicate<O, O> validator, String data) {
        Stream streamIn = RowMarshaller.load(validationRowClass).stream(data);
        new SinkValidatorDriver<O>(processor, sinkId, streamIn, validator).useSyntheticTime(this.useSyntheticTime).validate();
    }

    protected <O, S extends Supplier<TestRowValidationRecord<O>>> void validateSinkOutput(EventProcessor processor, String sinkId, Stream<S> streamIn) {
        this.validateSinkOutput(processor, sinkId, streamIn, null);
    }

    protected <O, S extends Supplier<TestRowValidationRecord<O>>> void validateSinkOutput(EventProcessor processor, String sinkId, Stream<S> streamIn, BiPredicate<O, O> validator) {
        new SinkValidatorDriver<O>(processor, sinkId, streamIn, validator).useSyntheticTime(this.useSyntheticTime).validate();
    }

    protected <O, S extends Supplier<TestRowValidationRecord<O>>> void validateEventProcessor(EventProcessor processor, Stream<S> streamIn, BiPredicate<EventProcessor, O> validator) {
        new EventProcessorValidatorDriver<O>(processor, streamIn, validator).useSyntheticTime(this.useSyntheticTime).validate();
    }

    public static <T> Stream<T> yamlToStream(String doc, String packagePrefix) {
        Stream stream;
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(packagePrefix));
        Stream castStream = stream = StreamSupport.stream(yaml.loadAll(doc).spliterator(), false);
        return castStream;
    }

    public static <T> Stream<T> yamlToStream(String doc, Class<T> targetClass) {
        Stream stream;
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(targetClass));
        Stream castStream = stream = StreamSupport.stream(yaml.loadAll(doc).spliterator(), false);
        return castStream;
    }

    public static <T> Stream<T> yamlToStream(Reader reader, Class<T> targetClass) {
        Stream stream;
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(targetClass));
        Stream castStream = stream = StreamSupport.stream(yaml.loadAll(reader).spliterator(), false);
        return castStream;
    }

    public static <T> Stream<T> yamlToStream(String doc) {
        Stream stream;
        Yaml yaml = new Yaml((BaseConstructor)new CompactConstructor());
        Stream castStream = stream = StreamSupport.stream(yaml.loadAll(doc).spliterator(), false);
        return castStream;
    }
}

