/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.compiler.validation;

import com.fluxtion.compiler.validation.TestRowValidationRecord;
import com.fluxtion.runtime.EventProcessor;
import com.fluxtion.runtime.dataflow.MutableNumber;
import com.fluxtion.runtime.time.ClockStrategy;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class SinkValidatorDriver<EXPECTED> {
    private final EventProcessor eventProcessor;
    private final String sinkName;
    private final Stream<? extends Supplier<TestRowValidationRecord<EXPECTED>>> validationStream;
    private final BiPredicate<EXPECTED, EXPECTED> sinkValidator;
    private final MutableNumber syntheticTime = new MutableNumber();
    private final LongAdder rowCount = new LongAdder();
    private boolean useSyntheticTime;
    private boolean stopOnFirstFailure = true;
    private EXPECTED actualOutput;

    public SinkValidatorDriver(EventProcessor eventProcessor, String sinkName, Stream<? extends Supplier<TestRowValidationRecord<EXPECTED>>> validationStream, BiPredicate<EXPECTED, EXPECTED> sinkValidator) {
        this(eventProcessor, sinkName, validationStream, sinkValidator, false);
    }

    public SinkValidatorDriver(EventProcessor eventProcessor, String sinkName, Stream<? extends Supplier<TestRowValidationRecord<EXPECTED>>> validationStream, BiPredicate<EXPECTED, EXPECTED> sinkValidator, boolean useSyntheticTime) {
        this.eventProcessor = eventProcessor;
        this.sinkName = sinkName;
        this.validationStream = validationStream;
        this.sinkValidator = sinkValidator;
        this.useSyntheticTime = useSyntheticTime;
        this.syntheticTime.setLongValue(0L);
        this.rowCount.reset();
    }

    static boolean objectsAreEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    public boolean useSyntheticTime() {
        return this.useSyntheticTime;
    }

    public SinkValidatorDriver<EXPECTED> useSyntheticTime(boolean useSyntheticTime) {
        this.useSyntheticTime = useSyntheticTime;
        return this;
    }

    public boolean stopOnFirstFailure() {
        return this.stopOnFirstFailure;
    }

    public SinkValidatorDriver<EXPECTED> stopOnFirstFailure(boolean stopOnFirstFailure) {
        this.stopOnFirstFailure = stopOnFirstFailure;
        return this;
    }

    public void validate() {
        this.eventProcessor.init();
        this.eventProcessor.addSink(this.sinkName, e -> {
            this.actualOutput = e;
        });
        if (this.useSyntheticTime) {
            this.eventProcessor.onEvent((Object)ClockStrategy.registerClockEvent(() -> ((MutableNumber)this.syntheticTime).longValue()));
        }
        this.validationStream.map(Supplier::get).forEach(this::validateRow);
    }

    private void validateRow(TestRowValidationRecord<EXPECTED> row) {
        if (this.useSyntheticTime) {
            this.syntheticTime.setLongValue(row.timeMillis());
        }
        this.eventProcessor.onEvent(row.inputEvent());
        EXPECTED expectedOutput = row.expected();
        if (expectedOutput != null && this.sinkValidator == null) {
            if (!SinkValidatorDriver.objectsAreEqual(this.actualOutput, expectedOutput)) {
                throw new AssertionError((Object)("validation error on row:" + this.rowCount.longValue() + " objects not equal [" + expectedOutput + " ==> " + this.actualOutput + "]"));
            }
        } else {
            if (expectedOutput != null && !this.sinkValidator.test(expectedOutput, this.actualOutput)) {
                throw new AssertionError((Object)("validation error on row:" + this.rowCount.longValue() + " objects failed vaildation[" + expectedOutput + "  ==> " + this.actualOutput + "]"));
            }
            if (row.expectNull() && expectedOutput != null) {
                throw new AssertionError((Object)("validation error on row:" + this.rowCount.longValue() + " objects failed vaildation[NULL  ==> " + this.actualOutput + "]"));
            }
        }
        this.rowCount.increment();
        this.actualOutput = null;
    }
}

