/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.audit;

import com.fluxtion.runtime.annotations.OnEventHandler;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.audit.Auditor;
import com.fluxtion.runtime.audit.EventLogControlEvent;
import com.fluxtion.runtime.audit.EventLogSource;
import com.fluxtion.runtime.audit.EventLogger;
import com.fluxtion.runtime.audit.JULLogRecordListener;
import com.fluxtion.runtime.audit.LogRecord;
import com.fluxtion.runtime.audit.LogRecordListener;
import com.fluxtion.runtime.audit.NullEventLogger;
import com.fluxtion.runtime.event.Event;
import com.fluxtion.runtime.node.ForkedTriggerTask;
import com.fluxtion.runtime.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventLogManager
implements Auditor {
    public static final String NODE_NAME = "eventLogger";
    private LogRecordListener sink;
    private LogRecord logRecord;
    private Map<String, EventLogger> node2Logger;
    private Map<String, EventLogSource> name2LogSourceMap;
    private boolean clearAfterPublish;
    private static final Logger LOGGER = Logger.getLogger(EventLogManager.class.getName());
    public boolean trace = false;
    public boolean printEventToString = true;
    public boolean printThreadName = true;
    public EventLogControlEvent.LogLevel traceLevel;
    @Inject
    public Clock clock;
    private boolean canTrace = false;

    public EventLogManager() {
        this(new JULLogRecordListener());
    }

    public EventLogManager(LogRecordListener sink) {
        this.sink = sink == null ? l -> {} : sink;
    }

    public EventLogManager tracingOff() {
        this.trace = false;
        this.traceLevel = EventLogControlEvent.LogLevel.NONE;
        return this;
    }

    public EventLogManager tracingOn(EventLogControlEvent.LogLevel level) {
        this.trace = level != EventLogControlEvent.LogLevel.NONE;
        this.traceLevel = level;
        return this;
    }

    public EventLogManager printEventToString(boolean printEventToString) {
        this.printEventToString = printEventToString;
        return this;
    }

    public EventLogManager printThreadName(boolean printThreadName) {
        this.printThreadName = printThreadName;
        return this;
    }

    @Override
    public void nodeRegistered(Object node, String nodeName) {
        EventLogger logger = new EventLogger(this.logRecord, nodeName);
        if (node instanceof EventLogSource) {
            EventLogSource calcSource = (EventLogSource)node;
            calcSource.setLogger(logger);
            this.name2LogSourceMap.put(nodeName, calcSource);
        }
        this.node2Logger.put(nodeName, logger);
        this.canTrace = this.trace && this.node2Logger.values().stream().filter(e -> e.canLog(this.traceLevel)).findAny().isPresent();
    }

    private void updateLogRecord() {
        for (Map.Entry<String, EventLogSource> stringEventLogSourceEntry : this.name2LogSourceMap.entrySet()) {
            String nodeName = stringEventLogSourceEntry.getKey();
            EventLogSource calcSource = stringEventLogSourceEntry.getValue();
            EventLogger logger = new EventLogger(this.logRecord, nodeName);
            calcSource.setLogger(logger);
            this.name2LogSourceMap.put(nodeName, calcSource);
            this.node2Logger.put(nodeName, logger);
        }
    }

    @Override
    public boolean auditInvocations() {
        return this.trace;
    }

    @Override
    public void nodeInvoked(Object node, String nodeName, String methodName, Object event) {
        EventLogger logger = this.node2Logger.getOrDefault(nodeName, NullEventLogger.INSTANCE);
        logger.logNodeInvocation(this.traceLevel);
        if (this.printThreadName) {
            logger.log("thread", Thread.currentThread().getName(), this.traceLevel);
        }
        if (node instanceof ForkedTriggerTask) {
            logger.log("forkedExecution", "true", this.traceLevel);
            logger.log("asyncMethod", methodName, this.traceLevel);
        } else {
            logger.log("method", methodName, this.traceLevel);
        }
    }

    @OnEventHandler(propagate=false)
    public void calculationLogConfig(EventLogControlEvent newConfig) {
        EventLogControlEvent.LogLevel level;
        if (newConfig.getLogRecordProcessor() != null) {
            this.sink = newConfig.getLogRecordProcessor();
        }
        if (newConfig.getLogRecord() != null) {
            this.logRecord = newConfig.getLogRecord();
            this.logRecord.setClock(this.clock);
            this.updateLogRecord();
        }
        if ((level = newConfig.getLevel()) != null && (this.logRecord.groupingId == null || this.logRecord.groupingId.equals(newConfig.getGroupId()))) {
            LOGGER.log(Level.INFO, "updating event log config:{0}", newConfig);
            this.node2Logger.computeIfPresent(newConfig.getSourceId(), (t, u) -> {
                u.setLevel(level);
                return u;
            });
            if (newConfig.getSourceId() == null) {
                this.node2Logger.values().forEach(t -> t.setLevel(newConfig.getLevel()));
            }
        }
        this.canTrace = this.trace && this.node2Logger.values().stream().filter(e -> e.canLog(this.traceLevel)).findAny().isPresent();
    }

    public void setLogSink(LogRecordListener sink) {
        this.sink = sink;
    }

    public void setLogGroupId(String groupId) {
        this.logRecord.groupingId = groupId;
    }

    public void setClearAfterPublish(boolean clearAfterPublish) {
        this.clearAfterPublish = clearAfterPublish;
    }

    public void publishLastRecord() {
        this.logRecord.terminateRecord();
        this.sink.processLogRecord(this.logRecord);
        this.logRecord.clear();
    }

    public String lastRecordAsString() {
        return this.logRecord.toString();
    }

    @Override
    public void processingComplete() {
        if (this.canTrace | this.logRecord.terminateRecord()) {
            this.sink.processLogRecord(this.logRecord);
        }
        if (this.clearAfterPublish) {
            this.logRecord.clear();
        }
    }

    @Override
    public void init() {
        this.logRecord = new LogRecord(this.clock);
        this.logRecord.printEventToString(this.printEventToString);
        this.logRecord.setPrintThreadName(this.printThreadName);
        this.node2Logger = new HashMap<String, EventLogger>();
        this.name2LogSourceMap = new HashMap<String, EventLogSource>();
        this.clearAfterPublish = true;
    }

    @Override
    public void eventReceived(Event triggerEvent) {
        this.logRecord.triggerEvent(triggerEvent);
    }

    @Override
    public void eventReceived(Object triggerEvent) {
        this.logRecord.triggerObject(triggerEvent);
    }
}

