/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.audit;

import com.fluxtion.runtime.event.Event;
import com.fluxtion.runtime.time.Clock;

public class LogRecord {
    public String groupingId;
    public long eventId;
    private final StringBuilder sb = new StringBuilder();
    private String sourceId;
    private boolean firstProp = true;
    private Clock clock;
    private boolean printEventToString = false;
    private boolean printThreadName = false;

    public LogRecord(Clock clock) {
        this.clock = clock;
    }

    public void addRecord(String sourceId, String propertyKey, double value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addRecord(String sourceId, String propertyKey, long value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addRecord(String sourceId, String propertyKey, int value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addRecord(String sourceId, String propertyKey, char value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addRecord(String sourceId, String propertyKey, CharSequence value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addRecord(String sourceId, String propertyKey, Object value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value == null ? "NULL" : value);
    }

    public void addRecord(String sourceId, String propertyKey, boolean value) {
        this.addSourceId(sourceId, propertyKey);
        this.sb.append(value);
    }

    public void addTrace(String sourceId) {
        if (this.sourceId != null) {
            this.sb.append("}");
        }
        this.firstProp = true;
        this.sourceId = null;
        this.addSourceId(sourceId, null);
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void printEventToString(boolean printEventToString) {
        this.printEventToString = printEventToString;
    }

    public void setPrintThreadName(boolean printThreadName) {
        this.printThreadName = printThreadName;
    }

    private void addSourceId(String sourceId, String propertyKey) {
        if (this.sourceId == null) {
            this.sb.append("\n        - ").append(sourceId).append(": {");
            this.sourceId = sourceId;
        } else if (!this.sourceId.equals(sourceId)) {
            this.sb.append("}\n        - ").append(sourceId).append(": {");
            this.sourceId = sourceId;
            this.firstProp = true;
        }
        if (!this.firstProp) {
            this.sb.append(",");
        }
        if (propertyKey != null) {
            this.firstProp = false;
            this.sb.append(" ").append(propertyKey).append(": ");
        }
    }

    public void clear() {
        this.firstProp = true;
        this.sourceId = null;
        this.sb.setLength(0);
    }

    public CharSequence asCharSequence() {
        return this.sb;
    }

    public void triggerEvent(Event event) {
        Class<?> aClass = event.getClass();
        this.sb.append("eventLogRecord: ");
        this.sb.append("\n    eventTime: ").append(this.clock.getEventTime());
        this.sb.append("\n    logTime: ").append(this.clock.getWallClockTime());
        this.sb.append("\n    groupingId: ").append(this.groupingId);
        this.sb.append("\n    event: ").append(aClass.getSimpleName());
        if (this.printEventToString) {
            this.sb.append("\n    eventToString: ").append(event.toString());
        }
        if (this.printThreadName) {
            this.sb.append("\n    thread: ").append(Thread.currentThread().getName());
        }
        if (event.filterString() != null && !event.filterString().isEmpty()) {
            this.sb.append("\n    eventFilter: ").append(event.filterString());
        }
        this.sb.append("\n    nodeLogs: ");
    }

    public void triggerObject(Object event) {
        if (event instanceof Event) {
            this.triggerEvent((Event)event);
        } else {
            Class<?> aClass = event.getClass();
            this.sb.append("eventLogRecord: ");
            this.sb.append("\n    eventTime: ").append(this.clock.getEventTime());
            this.sb.append("\n    logTime: ").append(this.clock.getWallClockTime());
            this.sb.append("\n    groupingId: ").append(this.groupingId);
            this.sb.append("\n    event: ").append(aClass.getSimpleName());
            if (this.printEventToString) {
                this.sb.append("\n    eventToString: ").append(event.toString());
            }
            this.sb.append("\n    nodeLogs: ");
        }
    }

    public boolean terminateRecord() {
        boolean logged;
        boolean bl = logged = !this.firstProp;
        if (this.sourceId != null) {
            this.sb.append("}");
        }
        this.sb.append("\n    endTime: ").append(this.clock.getWallClockTime());
        this.firstProp = true;
        this.sourceId = null;
        return logged;
    }

    public String toString() {
        return this.asCharSequence().toString();
    }
}

