/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.callback;

import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.callback.DirtyStateMonitor;
import com.fluxtion.runtime.callback.EventDispatcher;
import com.fluxtion.runtime.callback.InstanceCallbackEvent;
import com.fluxtion.runtime.node.EventHandlerNode;
import com.fluxtion.runtime.node.SingleNamedNode;

public abstract class CallBackNode
extends SingleNamedNode
implements EventHandlerNode {
    private Object event;
    @Inject
    private EventDispatcher dispatcher;
    @Inject
    private DirtyStateMonitor dirtyStateMonitor;

    public CallBackNode(String name) {
        super(name);
        if (EventProcessorBuilderService.service().buildTime()) {
            Class<?> cbClass = InstanceCallbackEvent.cbClassList.remove(0);
            this.event = cbClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    public boolean onEvent(Object e) {
        return true;
    }

    public final Class<?> eventClass() {
        return this.event.getClass();
    }

    protected final void triggerGraphCycle() {
        this.dispatcher.processAsNewEventCycle(this.event);
    }

    protected final void markDirty() {
        this.dirtyStateMonitor.markDirty(this);
    }

    public Object getEvent() {
        return this.event;
    }

    public EventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public DirtyStateMonitor getDirtyStateMonitor() {
        return this.dirtyStateMonitor;
    }

    public void setEvent(Object event) {
        this.event = event;
    }

    public void setDispatcher(EventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void setDirtyStateMonitor(DirtyStateMonitor dirtyStateMonitor) {
        this.dirtyStateMonitor = dirtyStateMonitor;
    }
}

