/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.aggregate.function;

import com.fluxtion.runtime.dataflow.aggregate.AggregateFlowFunction;
import java.util.ArrayList;
import java.util.List;

public class AggregateToListFlowFunction<T>
implements AggregateFlowFunction<T, List<T>, AggregateToListFlowFunction<T>> {
    private final transient List<T> list = new ArrayList<T>();
    private final int maxElementCount;

    public AggregateToListFlowFunction() {
        this(-1);
    }

    public AggregateToListFlowFunction(int maxElementCount) {
        this.maxElementCount = maxElementCount;
    }

    @Override
    public List<T> reset() {
        this.list.clear();
        return this.list;
    }

    @Override
    public void combine(AggregateToListFlowFunction<T> add) {
        this.list.addAll(add.list);
        while (this.maxElementCount > 0 & this.list.size() > this.maxElementCount) {
            this.list.remove(0);
        }
    }

    @Override
    public void deduct(AggregateToListFlowFunction<T> add) {
        this.list.removeAll(add.list);
    }

    @Override
    public List<T> get() {
        return this.list;
    }

    @Override
    public List<T> aggregate(T input) {
        this.list.add(input);
        if (this.maxElementCount > 0 & this.list.size() > this.maxElementCount) {
            this.list.remove(0);
        }
        return this.list;
    }

    public static class AggregateToListFactory {
        private final int maxElementCount;

        public AggregateToListFactory(int maxElementCount) {
            this.maxElementCount = maxElementCount;
        }

        public <T> AggregateToListFlowFunction<T> newList() {
            return new AggregateToListFlowFunction(this.maxElementCount);
        }
    }
}

