/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.aggregate.function;

import com.fluxtion.runtime.dataflow.Stateful;
import com.fluxtion.runtime.dataflow.aggregate.AggregateDoubleFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateIntFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateLongFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class BucketedSlidingWindow<T, R, F extends AggregateFlowFunction<T, R, F>> {
    private final Supplier<F> windowFunctionSupplier;
    protected final F aggregatedFunction;
    protected final F currentFunction;
    private final List<F> buckets;
    private int writePointer;
    private boolean allBucketsFilled = false;
    private final boolean deductSupported;

    public BucketedSlidingWindow(Supplier<F> windowFunctionSupplier, int numberOfBuckets) {
        this.windowFunctionSupplier = windowFunctionSupplier;
        this.aggregatedFunction = (AggregateFlowFunction)windowFunctionSupplier.get();
        this.currentFunction = (AggregateFlowFunction)windowFunctionSupplier.get();
        this.deductSupported = this.currentFunction.deductSupported();
        this.buckets = new ArrayList<F>(numberOfBuckets);
        for (int i = 0; i < numberOfBuckets; ++i) {
            this.buckets.add(windowFunctionSupplier.get());
        }
    }

    public void init() {
        this.aggregatedFunction.reset();
        this.currentFunction.reset();
        this.buckets.forEach(Stateful::reset);
    }

    public final void aggregate(T input) {
        this.currentFunction.aggregate(input);
    }

    public void roll() {
        this.roll(1);
    }

    public void roll(int windowsToRoll) {
        if (this.deductSupported) {
            for (int i = 0; i < windowsToRoll; ++i) {
                AggregateFlowFunction oldFunction = (AggregateFlowFunction)this.buckets.get(this.writePointer);
                this.aggregatedFunction.combine(this.currentFunction);
                this.aggregatedFunction.deduct((AggregateFlowFunction)oldFunction);
                oldFunction.reset();
                oldFunction.combine(this.currentFunction);
                this.currentFunction.reset();
                ++this.writePointer;
                this.allBucketsFilled |= this.writePointer == this.buckets.size();
                this.writePointer %= this.buckets.size();
            }
        } else {
            int i;
            this.aggregatedFunction.reset();
            for (i = 0; i < windowsToRoll; ++i) {
                AggregateFlowFunction oldFunction = (AggregateFlowFunction)this.buckets.get(this.writePointer);
                oldFunction.reset();
                oldFunction.combine(this.currentFunction);
                this.currentFunction.reset();
                ++this.writePointer;
                this.allBucketsFilled |= this.writePointer == this.buckets.size();
                this.writePointer %= this.buckets.size();
            }
            for (i = 0; i < this.buckets.size(); ++i) {
                this.aggregatedFunction.combine((AggregateFlowFunction)((AggregateFlowFunction)this.buckets.get(i)));
            }
        }
    }

    public boolean isAllBucketsFilled() {
        return this.allBucketsFilled;
    }

    public R get() {
        return this.aggregatedFunction.get();
    }

    public static class BucketedSlidingWindowedLongFunction<F extends AggregateLongFlowFunction<F>>
    extends BucketedSlidingWindow<Long, Long, F> {
        public BucketedSlidingWindowedLongFunction(LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int numberOfBuckets) {
            super(windowFunctionSupplier, numberOfBuckets);
        }

        public void aggregateLong(long input) {
            ((AggregateLongFlowFunction)this.currentFunction).aggregateLong(input);
        }

        public long getAsLong() {
            return ((AggregateLongFlowFunction)this.aggregatedFunction).getAsLong();
        }
    }

    public static class BucketedSlidingWindowedDoubleFunction<F extends AggregateDoubleFlowFunction<F>>
    extends BucketedSlidingWindow<Double, Double, F> {
        public BucketedSlidingWindowedDoubleFunction(LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int numberOfBuckets) {
            super(windowFunctionSupplier, numberOfBuckets);
        }

        public void aggregateDouble(double input) {
            ((AggregateDoubleFlowFunction)this.currentFunction).aggregateDouble(input);
        }

        public double getAsDouble() {
            return ((AggregateDoubleFlowFunction)this.aggregatedFunction).getAsDouble();
        }
    }

    public static class BucketedSlidingWindowedIntFunction<F extends AggregateIntFlowFunction<F>>
    extends BucketedSlidingWindow<Integer, Integer, F> {
        public BucketedSlidingWindowedIntFunction(LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, int numberOfBuckets) {
            super(windowFunctionSupplier, numberOfBuckets);
        }

        public void aggregateInt(int input) {
            ((AggregateIntFlowFunction)this.currentFunction).aggregateInt(input);
        }

        public int getAsInt() {
            return ((AggregateIntFlowFunction)this.aggregatedFunction).getAsInt();
        }
    }
}

