/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.aggregate.function.primitive;

import com.fluxtion.runtime.dataflow.aggregate.function.primitive.AbstractDoubleFlowFunction;

public class DoubleAverageFlowFunction
extends AbstractDoubleFlowFunction<DoubleAverageFlowFunction> {
    private int count;
    private double sum;

    @Override
    public double aggregateDouble(double input) {
        this.sum += input;
        ++this.count;
        this.value = this.sum / (double)this.count;
        return this.getAsDouble();
    }

    @Override
    public void combine(DoubleAverageFlowFunction combine) {
        this.sum += combine.sum;
        this.count += combine.count;
        this.value = this.sum / (double)this.count;
    }

    @Override
    public void deduct(DoubleAverageFlowFunction deduct) {
        this.sum -= deduct.sum;
        this.count -= deduct.count;
        this.value = this.sum / (double)this.count;
    }

    @Override
    public double resetDouble() {
        this.value = 0.0;
        this.sum = 0.0;
        this.count = 0;
        return 0.0;
    }
}

