/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.EventProcessorContext;
import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.audit.EventLogNode;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.FlowSupplier;
import com.fluxtion.runtime.dataflow.Stateful;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.function.BooleanSupplier;

public abstract class AbstractFlowFunction<T, R, S extends FlowFunction<T>>
extends EventLogNode
implements TriggeredFlowFunction<R>,
FlowSupplier<R> {
    private final S inputEventStream;
    @NoTriggerReference
    private final transient LambdaReflection.MethodReferenceReflection streamFunction;
    @Inject
    private EventProcessorContext eventProcessorContext;
    private final transient boolean statefulFunction;
    protected transient boolean overrideUpdateTrigger;
    protected transient boolean overridePublishTrigger;
    protected transient boolean inputStreamTriggered;
    protected transient boolean inputStreamTriggered_1;
    protected transient boolean overrideTriggered;
    protected transient boolean publishTriggered;
    protected transient boolean publishOverrideTriggered;
    protected transient boolean resetTriggered;
    @NoTriggerReference
    protected transient Stateful<R> resetFunction;
    private Object updateTriggerNode;
    private Object publishTriggerNode;
    private Object publishTriggerOverrideNode;
    private Object resetTriggerNode;
    private BooleanSupplier dirtySupplier;
    private transient boolean parallelCandidate = false;

    public AbstractFlowFunction(@AssignToField(value="inputEventStream") S inputEventStream, LambdaReflection.MethodReferenceReflection methodReferenceReflection) {
        this.inputEventStream = inputEventStream;
        this.streamFunction = methodReferenceReflection;
        if (methodReferenceReflection != null && methodReferenceReflection.captured().length > 0 && !methodReferenceReflection.isDefaultConstructor()) {
            Object streamFunctionInstance = EventProcessorBuilderService.service().addOrReuse(methodReferenceReflection.captured()[0]);
            this.statefulFunction = Stateful.class.isAssignableFrom(streamFunctionInstance.getClass());
            if (this.statefulFunction) {
                this.resetFunction = (Stateful)methodReferenceReflection.captured()[0];
            }
        } else {
            this.statefulFunction = false;
        }
    }

    protected boolean fireEventUpdateNotification() {
        boolean fireNotification = (!this.overridePublishTrigger && !this.overrideUpdateTrigger && this.inputStreamTriggered) | (!this.overridePublishTrigger && this.overrideTriggered) | this.publishOverrideTriggered | this.publishTriggered | this.resetTriggered;
        this.overrideTriggered = false;
        this.publishTriggered = false;
        this.publishOverrideTriggered = false;
        this.resetTriggered = false;
        this.inputStreamTriggered = false;
        this.auditLog.info("fireNotification", fireNotification);
        return fireNotification && this.get() != null;
    }

    protected boolean executeUpdate() {
        return (!this.overrideUpdateTrigger && this.inputStreamTriggered) | this.overrideTriggered;
    }

    protected final boolean reset() {
        return this.resetTriggered && this.statefulFunction;
    }

    @Override
    public void parallel() {
        this.parallelCandidate = true;
    }

    @Override
    public boolean parallelCandidate() {
        return this.parallelCandidate;
    }

    @Override
    public boolean hasChanged() {
        return this.dirtySupplier.getAsBoolean();
    }

    @OnParentUpdate(value="inputEventStream")
    public void inputUpdated(S inputEventStream) {
        this.inputStreamTriggered_1 = !this.resetTriggered;
        this.inputStreamTriggered = !this.resetTriggered;
    }

    @OnParentUpdate(value="updateTriggerNode")
    public void updateTriggerNodeUpdated(Object triggerNode) {
        this.overrideTriggered = true;
    }

    @OnParentUpdate(value="publishTriggerNode")
    public final void publishTriggerNodeUpdated(Object triggerNode) {
        this.publishTriggered = true;
    }

    @OnParentUpdate(value="publishTriggerOverrideNode")
    public final void publishTriggerOverrideNodeUpdated(Object triggerNode) {
        this.publishOverrideTriggered = true;
    }

    @OnParentUpdate(value="resetTriggerNode")
    public final void resetTriggerNodeUpdated(Object triggerNode) {
        this.resetTriggered = true;
        this.inputStreamTriggered = false;
        this.inputStreamTriggered_1 = false;
        if (this.isStatefulFunction()) {
            this.resetOperation();
        }
    }

    @Initialise
    public final void initialiseEventStream() {
        this.overrideUpdateTrigger = this.updateTriggerNode != null;
        this.overridePublishTrigger = this.publishTriggerOverrideNode != null;
        this.dirtySupplier = this.eventProcessorContext.getDirtyStateMonitor().dirtySupplier(this);
        this.initialise();
    }

    protected void initialise() {
    }

    protected void resetOperation() {
    }

    public Object getUpdateTriggerNode() {
        return this.updateTriggerNode;
    }

    @Override
    public void setUpdateTriggerNode(Object updateTriggerNode) {
        this.updateTriggerNode = updateTriggerNode;
    }

    public Object getPublishTriggerNode() {
        return this.publishTriggerNode;
    }

    @Override
    public void setPublishTriggerNode(Object publishTriggerNode) {
        this.publishTriggerNode = publishTriggerNode;
    }

    public Object getPublishTriggerOverrideNode() {
        return this.publishTriggerOverrideNode;
    }

    @Override
    public void setPublishTriggerOverrideNode(Object publishTriggerOverrideNode) {
        this.publishTriggerOverrideNode = publishTriggerOverrideNode;
    }

    public Object getResetTriggerNode() {
        return this.resetTriggerNode;
    }

    @Override
    public void setResetTriggerNode(Object resetTriggerNode) {
        this.resetTriggerNode = resetTriggerNode;
    }

    public S getInputEventStream() {
        return this.inputEventStream;
    }

    public boolean isOverrideTriggered() {
        return this.overrideTriggered;
    }

    public boolean isPublishTriggered() {
        return this.publishTriggered;
    }

    public LambdaReflection.MethodReferenceReflection getStreamFunction() {
        return this.streamFunction;
    }

    public boolean isStatefulFunction() {
        return this.statefulFunction;
    }

    public EventProcessorContext getEventProcessorContext() {
        return this.eventProcessorContext;
    }

    public void setEventProcessorContext(EventProcessorContext eventProcessorContext) {
        this.eventProcessorContext = eventProcessorContext;
    }

    public String toString() {
        return "AbstractFlowFunction(inputEventStream=" + this.getInputEventStream() + ", streamFunction=" + this.getStreamFunction() + ", eventProcessorContext=" + this.getEventProcessorContext() + ", statefulFunction=" + this.isStatefulFunction() + ", overrideUpdateTrigger=" + this.overrideUpdateTrigger + ", overridePublishTrigger=" + this.overridePublishTrigger + ", inputStreamTriggered=" + this.inputStreamTriggered + ", inputStreamTriggered_1=" + this.inputStreamTriggered_1 + ", overrideTriggered=" + this.isOverrideTriggered() + ", publishTriggered=" + this.isPublishTriggered() + ", publishOverrideTriggered=" + this.publishOverrideTriggered + ", resetTriggered=" + this.resetTriggered + ", resetFunction=" + this.resetFunction + ", updateTriggerNode=" + this.getUpdateTriggerNode() + ", publishTriggerNode=" + this.getPublishTriggerNode() + ", publishTriggerOverrideNode=" + this.getPublishTriggerOverrideNode() + ", resetTriggerNode=" + this.getResetTriggerNode() + ", dirtySupplier=" + this.dirtySupplier + ", parallelCandidate=" + this.parallelCandidate + ")";
    }

    public static abstract class AbstractBinaryEventStream<R, Q, T, S extends FlowFunction<R>, U extends FlowFunction<Q>>
    extends AbstractFlowFunction<R, T, S> {
        private final U inputEventStream_2;
        protected boolean inputStreamTriggered_2;

        public AbstractBinaryEventStream(S inputEventStream, @AssignToField(value="inputEventStream_2") U inputEventStream_2, LambdaReflection.MethodReferenceReflection methodReferenceReflection) {
            super(inputEventStream, methodReferenceReflection);
            this.inputEventStream_2 = inputEventStream_2;
        }

        @Override
        protected boolean executeUpdate() {
            return (!this.overrideUpdateTrigger && this.inputStreamTriggered_1 && this.inputStreamTriggered_2) | this.overrideTriggered;
        }

        @Override
        protected boolean fireEventUpdateNotification() {
            boolean fireNotification = (!this.overridePublishTrigger && !this.overrideUpdateTrigger && this.inputStreamTriggered_1 && this.inputStreamTriggered_2) | (!this.overridePublishTrigger && this.overrideTriggered) | this.publishOverrideTriggered | this.publishTriggered | this.resetTriggered;
            this.overrideTriggered = false;
            this.publishTriggered = false;
            this.publishOverrideTriggered = false;
            this.resetTriggered = false;
            this.inputStreamTriggered = false;
            this.auditLog.info("fireNotification", fireNotification);
            return fireNotification && this.get() != null;
        }

        public S getInputEventStream_1() {
            return this.getInputEventStream();
        }

        public U getInputEventStream_2() {
            return this.inputEventStream_2;
        }

        @OnParentUpdate(value="inputEventStream_2")
        public final void input2Updated(Object inputEventStream) {
            this.inputStreamTriggered_2 = !this.resetTriggered;
            this.inputStreamTriggered = !this.resetTriggered;
        }

        @Override
        protected void initialise() {
            this.inputStreamTriggered_1 = this.getInputEventStream_1().hasDefaultValue();
            this.inputStreamTriggered_2 = this.getInputEventStream_2().hasDefaultValue();
        }
    }
}

