/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;

public class FilterByPropertyFlowFunction<T, P, S extends FlowFunction<T>>
extends AbstractFlowFunction<T, T, S> {
    final LambdaReflection.SerializableFunction<P, Boolean> filterFunction;
    final LambdaReflection.SerializableFunction<T, P> propertyAccessor;
    final transient String auditInfo;

    public FilterByPropertyFlowFunction(S inputEventStream, @AssignToField(value="propertyAccessor") LambdaReflection.SerializableFunction<T, P> propertyAccessor, @AssignToField(value="filterFunction") LambdaReflection.SerializableFunction<P, Boolean> filterFunction) {
        super(inputEventStream, filterFunction);
        this.propertyAccessor = propertyAccessor;
        this.filterFunction = filterFunction;
        this.auditInfo = filterFunction.method().getDeclaringClass().getSimpleName() + "->" + filterFunction.method().getName();
    }

    @OnTrigger
    public boolean filter() {
        boolean filter = this.isPublishTriggered() || (Boolean)this.filterFunction.apply(this.propertyAccessor.apply(this.getInputEventStream().get())) != false;
        boolean fireNotification = filter & this.fireEventUpdateNotification();
        this.auditLog.info("filterFunction", this.auditInfo);
        this.auditLog.info("filterPass", filter);
        this.auditLog.info("publishToChild", fireNotification);
        return fireNotification;
    }

    @Override
    public T get() {
        return this.getInputEventStream().get();
    }
}

